# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ScraperDestinationArgs',
    'ScraperDestinationArgsDict',
    'ScraperDestinationAmpArgs',
    'ScraperDestinationAmpArgsDict',
    'ScraperSourceArgs',
    'ScraperSourceArgsDict',
    'ScraperSourceEksArgs',
    'ScraperSourceEksArgsDict',
    'ScraperTimeoutsArgs',
    'ScraperTimeoutsArgsDict',
    'WorkspaceLoggingConfigurationArgs',
    'WorkspaceLoggingConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class ScraperDestinationArgsDict(TypedDict):
        amp: NotRequired[pulumi.Input['ScraperDestinationAmpArgsDict']]
        """
        Configuration block for an Amazon Managed Prometheus workspace destination. See `amp`.
        """
elif False:
    ScraperDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScraperDestinationArgs:
    def __init__(__self__, *,
                 amp: Optional[pulumi.Input['ScraperDestinationAmpArgs']] = None):
        """
        :param pulumi.Input['ScraperDestinationAmpArgs'] amp: Configuration block for an Amazon Managed Prometheus workspace destination. See `amp`.
        """
        if amp is not None:
            pulumi.set(__self__, "amp", amp)

    @property
    @pulumi.getter
    def amp(self) -> Optional[pulumi.Input['ScraperDestinationAmpArgs']]:
        """
        Configuration block for an Amazon Managed Prometheus workspace destination. See `amp`.
        """
        return pulumi.get(self, "amp")

    @amp.setter
    def amp(self, value: Optional[pulumi.Input['ScraperDestinationAmpArgs']]):
        pulumi.set(self, "amp", value)


if not MYPY:
    class ScraperDestinationAmpArgsDict(TypedDict):
        workspace_arn: pulumi.Input[str]
        """
        The Amazon Resource Name (ARN) of the prometheus workspace.
        """
elif False:
    ScraperDestinationAmpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScraperDestinationAmpArgs:
    def __init__(__self__, *,
                 workspace_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] workspace_arn: The Amazon Resource Name (ARN) of the prometheus workspace.
        """
        pulumi.set(__self__, "workspace_arn", workspace_arn)

    @property
    @pulumi.getter(name="workspaceArn")
    def workspace_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the prometheus workspace.
        """
        return pulumi.get(self, "workspace_arn")

    @workspace_arn.setter
    def workspace_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_arn", value)


if not MYPY:
    class ScraperSourceArgsDict(TypedDict):
        eks: NotRequired[pulumi.Input['ScraperSourceEksArgsDict']]
        """
        Configuration block for an EKS cluster source. See `eks`.
        """
elif False:
    ScraperSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScraperSourceArgs:
    def __init__(__self__, *,
                 eks: Optional[pulumi.Input['ScraperSourceEksArgs']] = None):
        """
        :param pulumi.Input['ScraperSourceEksArgs'] eks: Configuration block for an EKS cluster source. See `eks`.
        """
        if eks is not None:
            pulumi.set(__self__, "eks", eks)

    @property
    @pulumi.getter
    def eks(self) -> Optional[pulumi.Input['ScraperSourceEksArgs']]:
        """
        Configuration block for an EKS cluster source. See `eks`.
        """
        return pulumi.get(self, "eks")

    @eks.setter
    def eks(self, value: Optional[pulumi.Input['ScraperSourceEksArgs']]):
        pulumi.set(self, "eks", value)


if not MYPY:
    class ScraperSourceEksArgsDict(TypedDict):
        cluster_arn: pulumi.Input[str]
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        List of subnet IDs. Must be in at least two different availability zones.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        List of the security group IDs for the Amazon EKS cluster VPC configuration.
        """
elif False:
    ScraperSourceEksArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScraperSourceEksArgs:
    def __init__(__self__, *,
                 cluster_arn: pulumi.Input[str],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet IDs. Must be in at least two different availability zones.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of the security group IDs for the Amazon EKS cluster VPC configuration.
        """
        pulumi.set(__self__, "cluster_arn", cluster_arn)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cluster_arn")

    @cluster_arn.setter
    def cluster_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_arn", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of subnet IDs. Must be in at least two different availability zones.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the security group IDs for the Amazon EKS cluster VPC configuration.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)


if not MYPY:
    class ScraperTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
elif False:
    ScraperTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScraperTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[str]] = None,
                 delete: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete", value)


if not MYPY:
    class WorkspaceLoggingConfigurationArgsDict(TypedDict):
        log_group_arn: pulumi.Input[str]
        """
        The ARN of the CloudWatch log group to which the vended log data will be published. This log group must exist.
        """
elif False:
    WorkspaceLoggingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkspaceLoggingConfigurationArgs:
    def __init__(__self__, *,
                 log_group_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] log_group_arn: The ARN of the CloudWatch log group to which the vended log data will be published. This log group must exist.
        """
        pulumi.set(__self__, "log_group_arn", log_group_arn)

    @property
    @pulumi.getter(name="logGroupArn")
    def log_group_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the CloudWatch log group to which the vended log data will be published. This log group must exist.
        """
        return pulumi.get(self, "log_group_arn")

    @log_group_arn.setter
    def log_group_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_group_arn", value)


