# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccountThrottleSettingArgs',
    'AccountThrottleSettingArgsDict',
    'DeploymentCanarySettingsArgs',
    'DeploymentCanarySettingsArgsDict',
    'DocumentationPartLocationArgs',
    'DocumentationPartLocationArgsDict',
    'DomainNameEndpointConfigurationArgs',
    'DomainNameEndpointConfigurationArgsDict',
    'DomainNameMutualTlsAuthenticationArgs',
    'DomainNameMutualTlsAuthenticationArgsDict',
    'IntegrationTlsConfigArgs',
    'IntegrationTlsConfigArgsDict',
    'MethodSettingsSettingsArgs',
    'MethodSettingsSettingsArgsDict',
    'RestApiEndpointConfigurationArgs',
    'RestApiEndpointConfigurationArgsDict',
    'StageAccessLogSettingsArgs',
    'StageAccessLogSettingsArgsDict',
    'StageCanarySettingsArgs',
    'StageCanarySettingsArgsDict',
    'UsagePlanApiStageArgs',
    'UsagePlanApiStageArgsDict',
    'UsagePlanApiStageThrottleArgs',
    'UsagePlanApiStageThrottleArgsDict',
    'UsagePlanQuotaSettingsArgs',
    'UsagePlanQuotaSettingsArgsDict',
    'UsagePlanThrottleSettingsArgs',
    'UsagePlanThrottleSettingsArgsDict',
]

MYPY = False

if not MYPY:
    class AccountThrottleSettingArgsDict(TypedDict):
        burst_limit: pulumi.Input[float]
        """
        Absolute maximum number of times API Gateway allows the API to be called per second (RPS).
        """
        rate_limit: pulumi.Input[float]
        """
        Number of times API Gateway allows the API to be called per second on average (RPS).
        """
elif False:
    AccountThrottleSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountThrottleSettingArgs:
    def __init__(__self__, *,
                 burst_limit: pulumi.Input[float],
                 rate_limit: pulumi.Input[float]):
        """
        :param pulumi.Input[float] burst_limit: Absolute maximum number of times API Gateway allows the API to be called per second (RPS).
        :param pulumi.Input[float] rate_limit: Number of times API Gateway allows the API to be called per second on average (RPS).
        """
        pulumi.set(__self__, "burst_limit", burst_limit)
        pulumi.set(__self__, "rate_limit", rate_limit)

    @property
    @pulumi.getter(name="burstLimit")
    def burst_limit(self) -> pulumi.Input[float]:
        """
        Absolute maximum number of times API Gateway allows the API to be called per second (RPS).
        """
        return pulumi.get(self, "burst_limit")

    @burst_limit.setter
    def burst_limit(self, value: pulumi.Input[float]):
        pulumi.set(self, "burst_limit", value)

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> pulumi.Input[float]:
        """
        Number of times API Gateway allows the API to be called per second on average (RPS).
        """
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: pulumi.Input[float]):
        pulumi.set(self, "rate_limit", value)


if not MYPY:
    class DeploymentCanarySettingsArgsDict(TypedDict):
        percent_traffic: NotRequired[pulumi.Input[float]]
        """
        Percentage (0.0-100.0) of traffic routed to the canary deployment.
        """
        stage_variable_overrides: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
        """
        use_stage_cache: NotRequired[pulumi.Input[bool]]
        """
        Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
        """
elif False:
    DeploymentCanarySettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentCanarySettingsArgs:
    def __init__(__self__, *,
                 percent_traffic: Optional[pulumi.Input[float]] = None,
                 stage_variable_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 use_stage_cache: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[float] percent_traffic: Percentage (0.0-100.0) of traffic routed to the canary deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] stage_variable_overrides: Stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
        :param pulumi.Input[bool] use_stage_cache: Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
        """
        if percent_traffic is not None:
            pulumi.set(__self__, "percent_traffic", percent_traffic)
        if stage_variable_overrides is not None:
            pulumi.set(__self__, "stage_variable_overrides", stage_variable_overrides)
        if use_stage_cache is not None:
            pulumi.set(__self__, "use_stage_cache", use_stage_cache)

    @property
    @pulumi.getter(name="percentTraffic")
    def percent_traffic(self) -> Optional[pulumi.Input[float]]:
        """
        Percentage (0.0-100.0) of traffic routed to the canary deployment.
        """
        return pulumi.get(self, "percent_traffic")

    @percent_traffic.setter
    def percent_traffic(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "percent_traffic", value)

    @property
    @pulumi.getter(name="stageVariableOverrides")
    def stage_variable_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
        """
        return pulumi.get(self, "stage_variable_overrides")

    @stage_variable_overrides.setter
    def stage_variable_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "stage_variable_overrides", value)

    @property
    @pulumi.getter(name="useStageCache")
    def use_stage_cache(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
        """
        return pulumi.get(self, "use_stage_cache")

    @use_stage_cache.setter
    def use_stage_cache(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_stage_cache", value)


if not MYPY:
    class DocumentationPartLocationArgsDict(TypedDict):
        type: pulumi.Input[str]
        """
        Type of API entity to which the documentation content appliesE.g., `API`, `METHOD` or `REQUEST_BODY`
        """
        method: NotRequired[pulumi.Input[str]]
        """
        HTTP verb of a method. The default value is `*` for any method.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        Name of the targeted API entity.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        URL path of the target. The default value is `/` for the root resource.
        """
        status_code: NotRequired[pulumi.Input[str]]
        """
        HTTP status code of a response. The default value is `*` for any status code.
        """
elif False:
    DocumentationPartLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DocumentationPartLocationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 method: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 status_code: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Type of API entity to which the documentation content appliesE.g., `API`, `METHOD` or `REQUEST_BODY`
        :param pulumi.Input[str] method: HTTP verb of a method. The default value is `*` for any method.
        :param pulumi.Input[str] name: Name of the targeted API entity.
        :param pulumi.Input[str] path: URL path of the target. The default value is `/` for the root resource.
        :param pulumi.Input[str] status_code: HTTP status code of a response. The default value is `*` for any status code.
        """
        pulumi.set(__self__, "type", type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of API entity to which the documentation content appliesE.g., `API`, `METHOD` or `REQUEST_BODY`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP verb of a method. The default value is `*` for any method.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the targeted API entity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        URL path of the target. The default value is `/` for the root resource.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP status code of a response. The default value is `*` for any status code.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_code", value)


if not MYPY:
    class DomainNameEndpointConfigurationArgsDict(TypedDict):
        types: pulumi.Input[str]
        """
        List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE` or `REGIONAL`. If unspecified, defaults to `EDGE`. Must be declared as `REGIONAL` in non-Commercial partitions. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
        """
elif False:
    DomainNameEndpointConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainNameEndpointConfigurationArgs:
    def __init__(__self__, *,
                 types: pulumi.Input[str]):
        """
        :param pulumi.Input[str] types: List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE` or `REGIONAL`. If unspecified, defaults to `EDGE`. Must be declared as `REGIONAL` in non-Commercial partitions. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
        """
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def types(self) -> pulumi.Input[str]:
        """
        List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE` or `REGIONAL`. If unspecified, defaults to `EDGE`. Must be declared as `REGIONAL` in non-Commercial partitions. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: pulumi.Input[str]):
        pulumi.set(self, "types", value)


if not MYPY:
    class DomainNameMutualTlsAuthenticationArgsDict(TypedDict):
        truststore_uri: pulumi.Input[str]
        """
        Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
        """
        truststore_version: NotRequired[pulumi.Input[str]]
        """
        Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
elif False:
    DomainNameMutualTlsAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainNameMutualTlsAuthenticationArgs:
    def __init__(__self__, *,
                 truststore_uri: pulumi.Input[str],
                 truststore_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] truststore_uri: Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
        :param pulumi.Input[str] truststore_version: Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        pulumi.set(__self__, "truststore_uri", truststore_uri)
        if truststore_version is not None:
            pulumi.set(__self__, "truststore_version", truststore_version)

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> pulumi.Input[str]:
        """
        Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
        """
        return pulumi.get(self, "truststore_uri")

    @truststore_uri.setter
    def truststore_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "truststore_uri", value)

    @property
    @pulumi.getter(name="truststoreVersion")
    def truststore_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        return pulumi.get(self, "truststore_version")

    @truststore_version.setter
    def truststore_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore_version", value)


if not MYPY:
    class IntegrationTlsConfigArgsDict(TypedDict):
        insecure_skip_verification: NotRequired[pulumi.Input[bool]]
        """
        Whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a [supported certificate authority](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html). This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for `HTTP` and `HTTP_PROXY` integrations.
        """
elif False:
    IntegrationTlsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IntegrationTlsConfigArgs:
    def __init__(__self__, *,
                 insecure_skip_verification: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] insecure_skip_verification: Whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a [supported certificate authority](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html). This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for `HTTP` and `HTTP_PROXY` integrations.
        """
        if insecure_skip_verification is not None:
            pulumi.set(__self__, "insecure_skip_verification", insecure_skip_verification)

    @property
    @pulumi.getter(name="insecureSkipVerification")
    def insecure_skip_verification(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a [supported certificate authority](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html). This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for `HTTP` and `HTTP_PROXY` integrations.
        """
        return pulumi.get(self, "insecure_skip_verification")

    @insecure_skip_verification.setter
    def insecure_skip_verification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure_skip_verification", value)


if not MYPY:
    class MethodSettingsSettingsArgsDict(TypedDict):
        cache_data_encrypted: NotRequired[pulumi.Input[bool]]
        """
        Whether the cached responses are encrypted.
        """
        cache_ttl_in_seconds: NotRequired[pulumi.Input[int]]
        """
        Time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
        """
        caching_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
        """
        data_trace_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
        """
        logging_level: NotRequired[pulumi.Input[str]]
        """
        Logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. The available levels are `OFF`, `ERROR`, and `INFO`.
        """
        metrics_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether Amazon CloudWatch metrics are enabled for this method.
        """
        require_authorization_for_cache_control: NotRequired[pulumi.Input[bool]]
        """
        Whether authorization is required for a cache invalidation request.
        """
        throttling_burst_limit: NotRequired[pulumi.Input[int]]
        """
        Throttling burst limit. Default: `-1` (throttling disabled).
        """
        throttling_rate_limit: NotRequired[pulumi.Input[float]]
        """
        Throttling rate limit. Default: `-1` (throttling disabled).
        """
        unauthorized_cache_control_header_strategy: NotRequired[pulumi.Input[str]]
        """
        How to handle unauthorized requests for cache invalidation. The available values are `FAIL_WITH_403`, `SUCCEED_WITH_RESPONSE_HEADER`, `SUCCEED_WITHOUT_RESPONSE_HEADER`.
        """
elif False:
    MethodSettingsSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MethodSettingsSettingsArgs:
    def __init__(__self__, *,
                 cache_data_encrypted: Optional[pulumi.Input[bool]] = None,
                 cache_ttl_in_seconds: Optional[pulumi.Input[int]] = None,
                 caching_enabled: Optional[pulumi.Input[bool]] = None,
                 data_trace_enabled: Optional[pulumi.Input[bool]] = None,
                 logging_level: Optional[pulumi.Input[str]] = None,
                 metrics_enabled: Optional[pulumi.Input[bool]] = None,
                 require_authorization_for_cache_control: Optional[pulumi.Input[bool]] = None,
                 throttling_burst_limit: Optional[pulumi.Input[int]] = None,
                 throttling_rate_limit: Optional[pulumi.Input[float]] = None,
                 unauthorized_cache_control_header_strategy: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] cache_data_encrypted: Whether the cached responses are encrypted.
        :param pulumi.Input[int] cache_ttl_in_seconds: Time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
        :param pulumi.Input[bool] caching_enabled: Whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
        :param pulumi.Input[bool] data_trace_enabled: Whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
        :param pulumi.Input[str] logging_level: Logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. The available levels are `OFF`, `ERROR`, and `INFO`.
        :param pulumi.Input[bool] metrics_enabled: Whether Amazon CloudWatch metrics are enabled for this method.
        :param pulumi.Input[bool] require_authorization_for_cache_control: Whether authorization is required for a cache invalidation request.
        :param pulumi.Input[int] throttling_burst_limit: Throttling burst limit. Default: `-1` (throttling disabled).
        :param pulumi.Input[float] throttling_rate_limit: Throttling rate limit. Default: `-1` (throttling disabled).
        :param pulumi.Input[str] unauthorized_cache_control_header_strategy: How to handle unauthorized requests for cache invalidation. The available values are `FAIL_WITH_403`, `SUCCEED_WITH_RESPONSE_HEADER`, `SUCCEED_WITHOUT_RESPONSE_HEADER`.
        """
        if cache_data_encrypted is not None:
            pulumi.set(__self__, "cache_data_encrypted", cache_data_encrypted)
        if cache_ttl_in_seconds is not None:
            pulumi.set(__self__, "cache_ttl_in_seconds", cache_ttl_in_seconds)
        if caching_enabled is not None:
            pulumi.set(__self__, "caching_enabled", caching_enabled)
        if data_trace_enabled is not None:
            pulumi.set(__self__, "data_trace_enabled", data_trace_enabled)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if metrics_enabled is not None:
            pulumi.set(__self__, "metrics_enabled", metrics_enabled)
        if require_authorization_for_cache_control is not None:
            pulumi.set(__self__, "require_authorization_for_cache_control", require_authorization_for_cache_control)
        if throttling_burst_limit is not None:
            pulumi.set(__self__, "throttling_burst_limit", throttling_burst_limit)
        if throttling_rate_limit is not None:
            pulumi.set(__self__, "throttling_rate_limit", throttling_rate_limit)
        if unauthorized_cache_control_header_strategy is not None:
            pulumi.set(__self__, "unauthorized_cache_control_header_strategy", unauthorized_cache_control_header_strategy)

    @property
    @pulumi.getter(name="cacheDataEncrypted")
    def cache_data_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the cached responses are encrypted.
        """
        return pulumi.get(self, "cache_data_encrypted")

    @cache_data_encrypted.setter
    def cache_data_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cache_data_encrypted", value)

    @property
    @pulumi.getter(name="cacheTtlInSeconds")
    def cache_ttl_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
        """
        return pulumi.get(self, "cache_ttl_in_seconds")

    @cache_ttl_in_seconds.setter
    def cache_ttl_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cache_ttl_in_seconds", value)

    @property
    @pulumi.getter(name="cachingEnabled")
    def caching_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
        """
        return pulumi.get(self, "caching_enabled")

    @caching_enabled.setter
    def caching_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "caching_enabled", value)

    @property
    @pulumi.getter(name="dataTraceEnabled")
    def data_trace_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
        """
        return pulumi.get(self, "data_trace_enabled")

    @data_trace_enabled.setter
    def data_trace_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_trace_enabled", value)

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[pulumi.Input[str]]:
        """
        Logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. The available levels are `OFF`, `ERROR`, and `INFO`.
        """
        return pulumi.get(self, "logging_level")

    @logging_level.setter
    def logging_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logging_level", value)

    @property
    @pulumi.getter(name="metricsEnabled")
    def metrics_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Amazon CloudWatch metrics are enabled for this method.
        """
        return pulumi.get(self, "metrics_enabled")

    @metrics_enabled.setter
    def metrics_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "metrics_enabled", value)

    @property
    @pulumi.getter(name="requireAuthorizationForCacheControl")
    def require_authorization_for_cache_control(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether authorization is required for a cache invalidation request.
        """
        return pulumi.get(self, "require_authorization_for_cache_control")

    @require_authorization_for_cache_control.setter
    def require_authorization_for_cache_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_authorization_for_cache_control", value)

    @property
    @pulumi.getter(name="throttlingBurstLimit")
    def throttling_burst_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Throttling burst limit. Default: `-1` (throttling disabled).
        """
        return pulumi.get(self, "throttling_burst_limit")

    @throttling_burst_limit.setter
    def throttling_burst_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throttling_burst_limit", value)

    @property
    @pulumi.getter(name="throttlingRateLimit")
    def throttling_rate_limit(self) -> Optional[pulumi.Input[float]]:
        """
        Throttling rate limit. Default: `-1` (throttling disabled).
        """
        return pulumi.get(self, "throttling_rate_limit")

    @throttling_rate_limit.setter
    def throttling_rate_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "throttling_rate_limit", value)

    @property
    @pulumi.getter(name="unauthorizedCacheControlHeaderStrategy")
    def unauthorized_cache_control_header_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        How to handle unauthorized requests for cache invalidation. The available values are `FAIL_WITH_403`, `SUCCEED_WITH_RESPONSE_HEADER`, `SUCCEED_WITHOUT_RESPONSE_HEADER`.
        """
        return pulumi.get(self, "unauthorized_cache_control_header_strategy")

    @unauthorized_cache_control_header_strategy.setter
    def unauthorized_cache_control_header_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unauthorized_cache_control_header_strategy", value)


if not MYPY:
    class RestApiEndpointConfigurationArgsDict(TypedDict):
        types: pulumi.Input[str]
        """
        List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE`, `REGIONAL` or `PRIVATE`. If unspecified, defaults to `EDGE`. If set to `PRIVATE` recommend to set `put_rest_api_mode` = `merge` to not cause the endpoints and associated Route53 records to be deleted. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
        """
        vpc_endpoint_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
        """
elif False:
    RestApiEndpointConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestApiEndpointConfigurationArgs:
    def __init__(__self__, *,
                 types: pulumi.Input[str],
                 vpc_endpoint_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] types: List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE`, `REGIONAL` or `PRIVATE`. If unspecified, defaults to `EDGE`. If set to `PRIVATE` recommend to set `put_rest_api_mode` = `merge` to not cause the endpoints and associated Route53 records to be deleted. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_endpoint_ids: Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
        """
        pulumi.set(__self__, "types", types)
        if vpc_endpoint_ids is not None:
            pulumi.set(__self__, "vpc_endpoint_ids", vpc_endpoint_ids)

    @property
    @pulumi.getter
    def types(self) -> pulumi.Input[str]:
        """
        List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE`, `REGIONAL` or `PRIVATE`. If unspecified, defaults to `EDGE`. If set to `PRIVATE` recommend to set `put_rest_api_mode` = `merge` to not cause the endpoints and associated Route53 records to be deleted. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: pulumi.Input[str]):
        pulumi.set(self, "types", value)

    @property
    @pulumi.getter(name="vpcEndpointIds")
    def vpc_endpoint_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
        """
        return pulumi.get(self, "vpc_endpoint_ids")

    @vpc_endpoint_ids.setter
    def vpc_endpoint_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_endpoint_ids", value)


if not MYPY:
    class StageAccessLogSettingsArgsDict(TypedDict):
        destination_arn: pulumi.Input[str]
        """
        ARN of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-`. Automatically removes trailing `:*` if present.
        """
        format: pulumi.Input[str]
        """
        Formatting and values recorded in the logs.
        For more information on configuring the log format rules visit the AWS [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html)
        """
elif False:
    StageAccessLogSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StageAccessLogSettingsArgs:
    def __init__(__self__, *,
                 destination_arn: pulumi.Input[str],
                 format: pulumi.Input[str]):
        """
        :param pulumi.Input[str] destination_arn: ARN of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-`. Automatically removes trailing `:*` if present.
        :param pulumi.Input[str] format: Formatting and values recorded in the logs.
               For more information on configuring the log format rules visit the AWS [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html)
        """
        pulumi.set(__self__, "destination_arn", destination_arn)
        pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> pulumi.Input[str]:
        """
        ARN of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-`. Automatically removes trailing `:*` if present.
        """
        return pulumi.get(self, "destination_arn")

    @destination_arn.setter
    def destination_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_arn", value)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input[str]:
        """
        Formatting and values recorded in the logs.
        For more information on configuring the log format rules visit the AWS [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html)
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[str]):
        pulumi.set(self, "format", value)


if not MYPY:
    class StageCanarySettingsArgsDict(TypedDict):
        deployment_id: pulumi.Input[str]
        """
        ID of the deployment that the canary points to.
        """
        percent_traffic: NotRequired[pulumi.Input[float]]
        """
        Percent `0.0` - `100.0` of traffic to divert to the canary deployment.
        """
        stage_variable_overrides: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Map of overridden stage `variables` (including new variables) for the canary deployment.
        """
        use_stage_cache: NotRequired[pulumi.Input[bool]]
        """
        Whether the canary deployment uses the stage cache. Defaults to false.
        """
elif False:
    StageCanarySettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StageCanarySettingsArgs:
    def __init__(__self__, *,
                 deployment_id: pulumi.Input[str],
                 percent_traffic: Optional[pulumi.Input[float]] = None,
                 stage_variable_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 use_stage_cache: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] deployment_id: ID of the deployment that the canary points to.
        :param pulumi.Input[float] percent_traffic: Percent `0.0` - `100.0` of traffic to divert to the canary deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] stage_variable_overrides: Map of overridden stage `variables` (including new variables) for the canary deployment.
        :param pulumi.Input[bool] use_stage_cache: Whether the canary deployment uses the stage cache. Defaults to false.
        """
        pulumi.set(__self__, "deployment_id", deployment_id)
        if percent_traffic is not None:
            pulumi.set(__self__, "percent_traffic", percent_traffic)
        if stage_variable_overrides is not None:
            pulumi.set(__self__, "stage_variable_overrides", stage_variable_overrides)
        if use_stage_cache is not None:
            pulumi.set(__self__, "use_stage_cache", use_stage_cache)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Input[str]:
        """
        ID of the deployment that the canary points to.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="percentTraffic")
    def percent_traffic(self) -> Optional[pulumi.Input[float]]:
        """
        Percent `0.0` - `100.0` of traffic to divert to the canary deployment.
        """
        return pulumi.get(self, "percent_traffic")

    @percent_traffic.setter
    def percent_traffic(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "percent_traffic", value)

    @property
    @pulumi.getter(name="stageVariableOverrides")
    def stage_variable_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of overridden stage `variables` (including new variables) for the canary deployment.
        """
        return pulumi.get(self, "stage_variable_overrides")

    @stage_variable_overrides.setter
    def stage_variable_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "stage_variable_overrides", value)

    @property
    @pulumi.getter(name="useStageCache")
    def use_stage_cache(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the canary deployment uses the stage cache. Defaults to false.
        """
        return pulumi.get(self, "use_stage_cache")

    @use_stage_cache.setter
    def use_stage_cache(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_stage_cache", value)


if not MYPY:
    class UsagePlanApiStageArgsDict(TypedDict):
        api_id: pulumi.Input[str]
        """
        API Id of the associated API stage in a usage plan.
        """
        stage: pulumi.Input[str]
        """
        API stage name of the associated API stage in a usage plan.
        """
        throttles: NotRequired[pulumi.Input[Sequence[pulumi.Input['UsagePlanApiStageThrottleArgsDict']]]]
        """
        The throttling limits of the usage plan.
        """
elif False:
    UsagePlanApiStageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UsagePlanApiStageArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[str],
                 stage: pulumi.Input[str],
                 throttles: Optional[pulumi.Input[Sequence[pulumi.Input['UsagePlanApiStageThrottleArgs']]]] = None):
        """
        :param pulumi.Input[str] api_id: API Id of the associated API stage in a usage plan.
        :param pulumi.Input[str] stage: API stage name of the associated API stage in a usage plan.
        :param pulumi.Input[Sequence[pulumi.Input['UsagePlanApiStageThrottleArgs']]] throttles: The throttling limits of the usage plan.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "stage", stage)
        if throttles is not None:
            pulumi.set(__self__, "throttles", throttles)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[str]:
        """
        API Id of the associated API stage in a usage plan.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def stage(self) -> pulumi.Input[str]:
        """
        API stage name of the associated API stage in a usage plan.
        """
        return pulumi.get(self, "stage")

    @stage.setter
    def stage(self, value: pulumi.Input[str]):
        pulumi.set(self, "stage", value)

    @property
    @pulumi.getter
    def throttles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsagePlanApiStageThrottleArgs']]]]:
        """
        The throttling limits of the usage plan.
        """
        return pulumi.get(self, "throttles")

    @throttles.setter
    def throttles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsagePlanApiStageThrottleArgs']]]]):
        pulumi.set(self, "throttles", value)


if not MYPY:
    class UsagePlanApiStageThrottleArgsDict(TypedDict):
        path: pulumi.Input[str]
        """
        Method to apply the throttle settings for. Specfiy the path and method, for example `/test/GET`.
        """
        burst_limit: NotRequired[pulumi.Input[int]]
        """
        The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
        """
        rate_limit: NotRequired[pulumi.Input[float]]
        """
        The API request steady-state rate limit.
        """
elif False:
    UsagePlanApiStageThrottleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UsagePlanApiStageThrottleArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 burst_limit: Optional[pulumi.Input[int]] = None,
                 rate_limit: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] path: Method to apply the throttle settings for. Specfiy the path and method, for example `/test/GET`.
        :param pulumi.Input[int] burst_limit: The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
        :param pulumi.Input[float] rate_limit: The API request steady-state rate limit.
        """
        pulumi.set(__self__, "path", path)
        if burst_limit is not None:
            pulumi.set(__self__, "burst_limit", burst_limit)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Method to apply the throttle settings for. Specfiy the path and method, for example `/test/GET`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="burstLimit")
    def burst_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
        """
        return pulumi.get(self, "burst_limit")

    @burst_limit.setter
    def burst_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "burst_limit", value)

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input[float]]:
        """
        The API request steady-state rate limit.
        """
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "rate_limit", value)


if not MYPY:
    class UsagePlanQuotaSettingsArgsDict(TypedDict):
        limit: pulumi.Input[int]
        """
        Maximum number of requests that can be made in a given time period.
        """
        period: pulumi.Input[str]
        """
        Time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
        """
        offset: NotRequired[pulumi.Input[int]]
        """
        Number of requests subtracted from the given limit in the initial time period.
        """
elif False:
    UsagePlanQuotaSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UsagePlanQuotaSettingsArgs:
    def __init__(__self__, *,
                 limit: pulumi.Input[int],
                 period: pulumi.Input[str],
                 offset: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] limit: Maximum number of requests that can be made in a given time period.
        :param pulumi.Input[str] period: Time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
        :param pulumi.Input[int] offset: Number of requests subtracted from the given limit in the initial time period.
        """
        pulumi.set(__self__, "limit", limit)
        pulumi.set(__self__, "period", period)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)

    @property
    @pulumi.getter
    def limit(self) -> pulumi.Input[int]:
        """
        Maximum number of requests that can be made in a given time period.
        """
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: pulumi.Input[int]):
        pulumi.set(self, "limit", value)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[str]:
        """
        Time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[str]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def offset(self) -> Optional[pulumi.Input[int]]:
        """
        Number of requests subtracted from the given limit in the initial time period.
        """
        return pulumi.get(self, "offset")

    @offset.setter
    def offset(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "offset", value)


if not MYPY:
    class UsagePlanThrottleSettingsArgsDict(TypedDict):
        burst_limit: NotRequired[pulumi.Input[int]]
        rate_limit: NotRequired[pulumi.Input[float]]
elif False:
    UsagePlanThrottleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UsagePlanThrottleSettingsArgs:
    def __init__(__self__, *,
                 burst_limit: Optional[pulumi.Input[int]] = None,
                 rate_limit: Optional[pulumi.Input[float]] = None):
        if burst_limit is not None:
            pulumi.set(__self__, "burst_limit", burst_limit)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)

    @property
    @pulumi.getter(name="burstLimit")
    def burst_limit(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "burst_limit")

    @burst_limit.setter
    def burst_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "burst_limit", value)

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "rate_limit", value)


