# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppAuthorizationConnectionArgs', 'AppAuthorizationConnection']

@pulumi.input_type
class AppAuthorizationConnectionArgs:
    def __init__(__self__, *,
                 app_authorization_arn: pulumi.Input[str],
                 app_bundle_arn: pulumi.Input[str],
                 auth_request: Optional[pulumi.Input['AppAuthorizationConnectionAuthRequestArgs']] = None,
                 timeouts: Optional[pulumi.Input['AppAuthorizationConnectionTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AppAuthorizationConnection resource.
        :param pulumi.Input[str] app_authorization_arn: The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
        :param pulumi.Input[str] app_bundle_arn: The Amazon Resource Name (ARN) of the app bundle to use for the request.
        :param pulumi.Input['AppAuthorizationConnectionAuthRequestArgs'] auth_request: Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
        """
        pulumi.set(__self__, "app_authorization_arn", app_authorization_arn)
        pulumi.set(__self__, "app_bundle_arn", app_bundle_arn)
        if auth_request is not None:
            pulumi.set(__self__, "auth_request", auth_request)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="appAuthorizationArn")
    def app_authorization_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
        """
        return pulumi.get(self, "app_authorization_arn")

    @app_authorization_arn.setter
    def app_authorization_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_authorization_arn", value)

    @property
    @pulumi.getter(name="appBundleArn")
    def app_bundle_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the app bundle to use for the request.
        """
        return pulumi.get(self, "app_bundle_arn")

    @app_bundle_arn.setter
    def app_bundle_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_bundle_arn", value)

    @property
    @pulumi.getter(name="authRequest")
    def auth_request(self) -> Optional[pulumi.Input['AppAuthorizationConnectionAuthRequestArgs']]:
        """
        Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
        """
        return pulumi.get(self, "auth_request")

    @auth_request.setter
    def auth_request(self, value: Optional[pulumi.Input['AppAuthorizationConnectionAuthRequestArgs']]):
        pulumi.set(self, "auth_request", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AppAuthorizationConnectionTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AppAuthorizationConnectionTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AppAuthorizationConnectionState:
    def __init__(__self__, *,
                 app: Optional[pulumi.Input[str]] = None,
                 app_authorization_arn: Optional[pulumi.Input[str]] = None,
                 app_bundle_arn: Optional[pulumi.Input[str]] = None,
                 auth_request: Optional[pulumi.Input['AppAuthorizationConnectionAuthRequestArgs']] = None,
                 tenants: Optional[pulumi.Input[Sequence[pulumi.Input['AppAuthorizationConnectionTenantArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['AppAuthorizationConnectionTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering AppAuthorizationConnection resources.
        :param pulumi.Input[str] app: The name of the application.
        :param pulumi.Input[str] app_authorization_arn: The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
        :param pulumi.Input[str] app_bundle_arn: The Amazon Resource Name (ARN) of the app bundle to use for the request.
        :param pulumi.Input['AppAuthorizationConnectionAuthRequestArgs'] auth_request: Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
        :param pulumi.Input[Sequence[pulumi.Input['AppAuthorizationConnectionTenantArgs']]] tenants: Contains information about an application tenant, such as the application display name and identifier.
        """
        if app is not None:
            pulumi.set(__self__, "app", app)
        if app_authorization_arn is not None:
            pulumi.set(__self__, "app_authorization_arn", app_authorization_arn)
        if app_bundle_arn is not None:
            pulumi.set(__self__, "app_bundle_arn", app_bundle_arn)
        if auth_request is not None:
            pulumi.set(__self__, "auth_request", auth_request)
        if tenants is not None:
            pulumi.set(__self__, "tenants", tenants)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the application.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app", value)

    @property
    @pulumi.getter(name="appAuthorizationArn")
    def app_authorization_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
        """
        return pulumi.get(self, "app_authorization_arn")

    @app_authorization_arn.setter
    def app_authorization_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_authorization_arn", value)

    @property
    @pulumi.getter(name="appBundleArn")
    def app_bundle_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the app bundle to use for the request.
        """
        return pulumi.get(self, "app_bundle_arn")

    @app_bundle_arn.setter
    def app_bundle_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_bundle_arn", value)

    @property
    @pulumi.getter(name="authRequest")
    def auth_request(self) -> Optional[pulumi.Input['AppAuthorizationConnectionAuthRequestArgs']]:
        """
        Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
        """
        return pulumi.get(self, "auth_request")

    @auth_request.setter
    def auth_request(self, value: Optional[pulumi.Input['AppAuthorizationConnectionAuthRequestArgs']]):
        pulumi.set(self, "auth_request", value)

    @property
    @pulumi.getter
    def tenants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppAuthorizationConnectionTenantArgs']]]]:
        """
        Contains information about an application tenant, such as the application display name and identifier.
        """
        return pulumi.get(self, "tenants")

    @tenants.setter
    def tenants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppAuthorizationConnectionTenantArgs']]]]):
        pulumi.set(self, "tenants", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AppAuthorizationConnectionTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AppAuthorizationConnectionTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class AppAuthorizationConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_authorization_arn: Optional[pulumi.Input[str]] = None,
                 app_bundle_arn: Optional[pulumi.Input[str]] = None,
                 auth_request: Optional[pulumi.Input[Union['AppAuthorizationConnectionAuthRequestArgs', 'AppAuthorizationConnectionAuthRequestArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['AppAuthorizationConnectionTimeoutsArgs', 'AppAuthorizationConnectionTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS AppFabric App Authorization Connection.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appfabric.AppAuthorizationConnection("example",
            app_authorization_arn=test["arn"],
            app_bundle_arn=arn)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_authorization_arn: The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
        :param pulumi.Input[str] app_bundle_arn: The Amazon Resource Name (ARN) of the app bundle to use for the request.
        :param pulumi.Input[Union['AppAuthorizationConnectionAuthRequestArgs', 'AppAuthorizationConnectionAuthRequestArgsDict']] auth_request: Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppAuthorizationConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS AppFabric App Authorization Connection.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appfabric.AppAuthorizationConnection("example",
            app_authorization_arn=test["arn"],
            app_bundle_arn=arn)
        ```

        :param str resource_name: The name of the resource.
        :param AppAuthorizationConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppAuthorizationConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_authorization_arn: Optional[pulumi.Input[str]] = None,
                 app_bundle_arn: Optional[pulumi.Input[str]] = None,
                 auth_request: Optional[pulumi.Input[Union['AppAuthorizationConnectionAuthRequestArgs', 'AppAuthorizationConnectionAuthRequestArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['AppAuthorizationConnectionTimeoutsArgs', 'AppAuthorizationConnectionTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppAuthorizationConnectionArgs.__new__(AppAuthorizationConnectionArgs)

            if app_authorization_arn is None and not opts.urn:
                raise TypeError("Missing required property 'app_authorization_arn'")
            __props__.__dict__["app_authorization_arn"] = app_authorization_arn
            if app_bundle_arn is None and not opts.urn:
                raise TypeError("Missing required property 'app_bundle_arn'")
            __props__.__dict__["app_bundle_arn"] = app_bundle_arn
            __props__.__dict__["auth_request"] = auth_request
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["app"] = None
            __props__.__dict__["tenants"] = None
        super(AppAuthorizationConnection, __self__).__init__(
            'aws:appfabric/appAuthorizationConnection:AppAuthorizationConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app: Optional[pulumi.Input[str]] = None,
            app_authorization_arn: Optional[pulumi.Input[str]] = None,
            app_bundle_arn: Optional[pulumi.Input[str]] = None,
            auth_request: Optional[pulumi.Input[Union['AppAuthorizationConnectionAuthRequestArgs', 'AppAuthorizationConnectionAuthRequestArgsDict']]] = None,
            tenants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppAuthorizationConnectionTenantArgs', 'AppAuthorizationConnectionTenantArgsDict']]]]] = None,
            timeouts: Optional[pulumi.Input[Union['AppAuthorizationConnectionTimeoutsArgs', 'AppAuthorizationConnectionTimeoutsArgsDict']]] = None) -> 'AppAuthorizationConnection':
        """
        Get an existing AppAuthorizationConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app: The name of the application.
        :param pulumi.Input[str] app_authorization_arn: The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
        :param pulumi.Input[str] app_bundle_arn: The Amazon Resource Name (ARN) of the app bundle to use for the request.
        :param pulumi.Input[Union['AppAuthorizationConnectionAuthRequestArgs', 'AppAuthorizationConnectionAuthRequestArgsDict']] auth_request: Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppAuthorizationConnectionTenantArgs', 'AppAuthorizationConnectionTenantArgsDict']]]] tenants: Contains information about an application tenant, such as the application display name and identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppAuthorizationConnectionState.__new__(_AppAuthorizationConnectionState)

        __props__.__dict__["app"] = app
        __props__.__dict__["app_authorization_arn"] = app_authorization_arn
        __props__.__dict__["app_bundle_arn"] = app_bundle_arn
        __props__.__dict__["auth_request"] = auth_request
        __props__.__dict__["tenants"] = tenants
        __props__.__dict__["timeouts"] = timeouts
        return AppAuthorizationConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def app(self) -> pulumi.Output[str]:
        """
        The name of the application.
        """
        return pulumi.get(self, "app")

    @property
    @pulumi.getter(name="appAuthorizationArn")
    def app_authorization_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
        """
        return pulumi.get(self, "app_authorization_arn")

    @property
    @pulumi.getter(name="appBundleArn")
    def app_bundle_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the app bundle to use for the request.
        """
        return pulumi.get(self, "app_bundle_arn")

    @property
    @pulumi.getter(name="authRequest")
    def auth_request(self) -> pulumi.Output[Optional['outputs.AppAuthorizationConnectionAuthRequest']]:
        """
        Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
        """
        return pulumi.get(self, "auth_request")

    @property
    @pulumi.getter
    def tenants(self) -> pulumi.Output[Sequence['outputs.AppAuthorizationConnectionTenant']]:
        """
        Contains information about an application tenant, such as the application display name and identifier.
        """
        return pulumi.get(self, "tenants")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AppAuthorizationConnectionTimeouts']]:
        return pulumi.get(self, "timeouts")

