# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRouteResult',
    'AwaitableGetRouteResult',
    'get_route',
    'get_route_output',
]

@pulumi.output_type
class GetRouteResult:
    """
    A collection of values returned by getRoute.
    """
    def __init__(__self__, arn=None, created_date=None, id=None, last_updated_date=None, mesh_name=None, mesh_owner=None, name=None, resource_owner=None, specs=None, tags=None, virtual_router_name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_date and not isinstance(last_updated_date, str):
            raise TypeError("Expected argument 'last_updated_date' to be a str")
        pulumi.set(__self__, "last_updated_date", last_updated_date)
        if mesh_name and not isinstance(mesh_name, str):
            raise TypeError("Expected argument 'mesh_name' to be a str")
        pulumi.set(__self__, "mesh_name", mesh_name)
        if mesh_owner and not isinstance(mesh_owner, str):
            raise TypeError("Expected argument 'mesh_owner' to be a str")
        pulumi.set(__self__, "mesh_owner", mesh_owner)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_owner and not isinstance(resource_owner, str):
            raise TypeError("Expected argument 'resource_owner' to be a str")
        pulumi.set(__self__, "resource_owner", resource_owner)
        if specs and not isinstance(specs, list):
            raise TypeError("Expected argument 'specs' to be a list")
        pulumi.set(__self__, "specs", specs)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if virtual_router_name and not isinstance(virtual_router_name, str):
            raise TypeError("Expected argument 'virtual_router_name' to be a str")
        pulumi.set(__self__, "virtual_router_name", virtual_router_name)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the route.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> str:
        """
        Creation date of the route.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> str:
        """
        Last update date of the route.
        """
        return pulumi.get(self, "last_updated_date")

    @property
    @pulumi.getter(name="meshName")
    def mesh_name(self) -> str:
        return pulumi.get(self, "mesh_name")

    @property
    @pulumi.getter(name="meshOwner")
    def mesh_owner(self) -> str:
        return pulumi.get(self, "mesh_owner")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceOwner")
    def resource_owner(self) -> str:
        """
        Resource owner's AWS account ID.
        """
        return pulumi.get(self, "resource_owner")

    @property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.GetRouteSpecResult']:
        """
        Route specification. See the `appmesh.Route` resource for details.
        """
        return pulumi.get(self, "specs")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Map of tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="virtualRouterName")
    def virtual_router_name(self) -> str:
        return pulumi.get(self, "virtual_router_name")


class AwaitableGetRouteResult(GetRouteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteResult(
            arn=self.arn,
            created_date=self.created_date,
            id=self.id,
            last_updated_date=self.last_updated_date,
            mesh_name=self.mesh_name,
            mesh_owner=self.mesh_owner,
            name=self.name,
            resource_owner=self.resource_owner,
            specs=self.specs,
            tags=self.tags,
            virtual_router_name=self.virtual_router_name)


def get_route(mesh_name: Optional[str] = None,
              mesh_owner: Optional[str] = None,
              name: Optional[str] = None,
              tags: Optional[Mapping[str, str]] = None,
              virtual_router_name: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteResult:
    """
    The App Mesh Route data source allows details of an App Mesh Route to be retrieved by its name, mesh_name, virtual_router_name, and optionally the mesh_owner.


    :param str mesh_name: Name of the service mesh in which the virtual router exists.
    :param str mesh_owner: AWS account ID of the service mesh's owner.
    :param str name: Name of the route.
    :param Mapping[str, str] tags: Map of tags.
    :param str virtual_router_name: Name of the virtual router in which the route exists.
    """
    __args__ = dict()
    __args__['meshName'] = mesh_name
    __args__['meshOwner'] = mesh_owner
    __args__['name'] = name
    __args__['tags'] = tags
    __args__['virtualRouterName'] = virtual_router_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:appmesh/getRoute:getRoute', __args__, opts=opts, typ=GetRouteResult).value

    return AwaitableGetRouteResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_date=pulumi.get(__ret__, 'created_date'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_date=pulumi.get(__ret__, 'last_updated_date'),
        mesh_name=pulumi.get(__ret__, 'mesh_name'),
        mesh_owner=pulumi.get(__ret__, 'mesh_owner'),
        name=pulumi.get(__ret__, 'name'),
        resource_owner=pulumi.get(__ret__, 'resource_owner'),
        specs=pulumi.get(__ret__, 'specs'),
        tags=pulumi.get(__ret__, 'tags'),
        virtual_router_name=pulumi.get(__ret__, 'virtual_router_name'))
def get_route_output(mesh_name: Optional[pulumi.Input[str]] = None,
                     mesh_owner: Optional[pulumi.Input[Optional[str]]] = None,
                     name: Optional[pulumi.Input[str]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                     virtual_router_name: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRouteResult]:
    """
    The App Mesh Route data source allows details of an App Mesh Route to be retrieved by its name, mesh_name, virtual_router_name, and optionally the mesh_owner.


    :param str mesh_name: Name of the service mesh in which the virtual router exists.
    :param str mesh_owner: AWS account ID of the service mesh's owner.
    :param str name: Name of the route.
    :param Mapping[str, str] tags: Map of tags.
    :param str virtual_router_name: Name of the virtual router in which the route exists.
    """
    __args__ = dict()
    __args__['meshName'] = mesh_name
    __args__['meshOwner'] = mesh_owner
    __args__['name'] = name
    __args__['tags'] = tags
    __args__['virtualRouterName'] = virtual_router_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:appmesh/getRoute:getRoute', __args__, opts=opts, typ=GetRouteResult)
    return __ret__.apply(lambda __response__: GetRouteResult(
        arn=pulumi.get(__response__, 'arn'),
        created_date=pulumi.get(__response__, 'created_date'),
        id=pulumi.get(__response__, 'id'),
        last_updated_date=pulumi.get(__response__, 'last_updated_date'),
        mesh_name=pulumi.get(__response__, 'mesh_name'),
        mesh_owner=pulumi.get(__response__, 'mesh_owner'),
        name=pulumi.get(__response__, 'name'),
        resource_owner=pulumi.get(__response__, 'resource_owner'),
        specs=pulumi.get(__response__, 'specs'),
        tags=pulumi.get(__response__, 'tags'),
        virtual_router_name=pulumi.get(__response__, 'virtual_router_name')))
