# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FleetStackAssociationArgs', 'FleetStackAssociation']

@pulumi.input_type
class FleetStackAssociationArgs:
    def __init__(__self__, *,
                 fleet_name: pulumi.Input[str],
                 stack_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a FleetStackAssociation resource.
        :param pulumi.Input[str] fleet_name: Name of the fleet.
        :param pulumi.Input[str] stack_name: Name of the stack.
        """
        pulumi.set(__self__, "fleet_name", fleet_name)
        pulumi.set(__self__, "stack_name", stack_name)

    @property
    @pulumi.getter(name="fleetName")
    def fleet_name(self) -> pulumi.Input[str]:
        """
        Name of the fleet.
        """
        return pulumi.get(self, "fleet_name")

    @fleet_name.setter
    def fleet_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "fleet_name", value)

    @property
    @pulumi.getter(name="stackName")
    def stack_name(self) -> pulumi.Input[str]:
        """
        Name of the stack.
        """
        return pulumi.get(self, "stack_name")

    @stack_name.setter
    def stack_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "stack_name", value)


@pulumi.input_type
class _FleetStackAssociationState:
    def __init__(__self__, *,
                 fleet_name: Optional[pulumi.Input[str]] = None,
                 stack_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FleetStackAssociation resources.
        :param pulumi.Input[str] fleet_name: Name of the fleet.
        :param pulumi.Input[str] stack_name: Name of the stack.
        """
        if fleet_name is not None:
            pulumi.set(__self__, "fleet_name", fleet_name)
        if stack_name is not None:
            pulumi.set(__self__, "stack_name", stack_name)

    @property
    @pulumi.getter(name="fleetName")
    def fleet_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the fleet.
        """
        return pulumi.get(self, "fleet_name")

    @fleet_name.setter
    def fleet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fleet_name", value)

    @property
    @pulumi.getter(name="stackName")
    def stack_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the stack.
        """
        return pulumi.get(self, "stack_name")

    @stack_name.setter
    def stack_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_name", value)


class FleetStackAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fleet_name: Optional[pulumi.Input[str]] = None,
                 stack_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an AppStream Fleet Stack association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appstream.Fleet("example",
            name="NAME",
            image_name="Amazon-AppStream2-Sample-Image-03-11-2023",
            instance_type="stream.standard.small",
            compute_capacity={
                "desired_instances": 1,
            })
        example_stack = aws.appstream.Stack("example", name="STACK NAME")
        example_fleet_stack_association = aws.appstream.FleetStackAssociation("example",
            fleet_name=example.name,
            stack_name=example_stack.name)
        ```

        ## Import

        Using `pulumi import`, import AppStream Stack Fleet Association using the `fleet_name` and `stack_name` separated by a slash (`/`). For example:

        ```sh
        $ pulumi import aws:appstream/fleetStackAssociation:FleetStackAssociation example fleetName/stackName
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fleet_name: Name of the fleet.
        :param pulumi.Input[str] stack_name: Name of the stack.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetStackAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AppStream Fleet Stack association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appstream.Fleet("example",
            name="NAME",
            image_name="Amazon-AppStream2-Sample-Image-03-11-2023",
            instance_type="stream.standard.small",
            compute_capacity={
                "desired_instances": 1,
            })
        example_stack = aws.appstream.Stack("example", name="STACK NAME")
        example_fleet_stack_association = aws.appstream.FleetStackAssociation("example",
            fleet_name=example.name,
            stack_name=example_stack.name)
        ```

        ## Import

        Using `pulumi import`, import AppStream Stack Fleet Association using the `fleet_name` and `stack_name` separated by a slash (`/`). For example:

        ```sh
        $ pulumi import aws:appstream/fleetStackAssociation:FleetStackAssociation example fleetName/stackName
        ```

        :param str resource_name: The name of the resource.
        :param FleetStackAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetStackAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fleet_name: Optional[pulumi.Input[str]] = None,
                 stack_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetStackAssociationArgs.__new__(FleetStackAssociationArgs)

            if fleet_name is None and not opts.urn:
                raise TypeError("Missing required property 'fleet_name'")
            __props__.__dict__["fleet_name"] = fleet_name
            if stack_name is None and not opts.urn:
                raise TypeError("Missing required property 'stack_name'")
            __props__.__dict__["stack_name"] = stack_name
        super(FleetStackAssociation, __self__).__init__(
            'aws:appstream/fleetStackAssociation:FleetStackAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fleet_name: Optional[pulumi.Input[str]] = None,
            stack_name: Optional[pulumi.Input[str]] = None) -> 'FleetStackAssociation':
        """
        Get an existing FleetStackAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fleet_name: Name of the fleet.
        :param pulumi.Input[str] stack_name: Name of the stack.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetStackAssociationState.__new__(_FleetStackAssociationState)

        __props__.__dict__["fleet_name"] = fleet_name
        __props__.__dict__["stack_name"] = stack_name
        return FleetStackAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="fleetName")
    def fleet_name(self) -> pulumi.Output[str]:
        """
        Name of the fleet.
        """
        return pulumi.get(self, "fleet_name")

    @property
    @pulumi.getter(name="stackName")
    def stack_name(self) -> pulumi.Output[str]:
        """
        Name of the stack.
        """
        return pulumi.get(self, "stack_name")

