# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DataSourceDynamodbConfigArgs',
    'DataSourceDynamodbConfigArgsDict',
    'DataSourceDynamodbConfigDeltaSyncConfigArgs',
    'DataSourceDynamodbConfigDeltaSyncConfigArgsDict',
    'DataSourceElasticsearchConfigArgs',
    'DataSourceElasticsearchConfigArgsDict',
    'DataSourceEventBridgeConfigArgs',
    'DataSourceEventBridgeConfigArgsDict',
    'DataSourceHttpConfigArgs',
    'DataSourceHttpConfigArgsDict',
    'DataSourceHttpConfigAuthorizationConfigArgs',
    'DataSourceHttpConfigAuthorizationConfigArgsDict',
    'DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs',
    'DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgsDict',
    'DataSourceLambdaConfigArgs',
    'DataSourceLambdaConfigArgsDict',
    'DataSourceOpensearchserviceConfigArgs',
    'DataSourceOpensearchserviceConfigArgsDict',
    'DataSourceRelationalDatabaseConfigArgs',
    'DataSourceRelationalDatabaseConfigArgsDict',
    'DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs',
    'DataSourceRelationalDatabaseConfigHttpEndpointConfigArgsDict',
    'FunctionRuntimeArgs',
    'FunctionRuntimeArgsDict',
    'FunctionSyncConfigArgs',
    'FunctionSyncConfigArgsDict',
    'FunctionSyncConfigLambdaConflictHandlerConfigArgs',
    'FunctionSyncConfigLambdaConflictHandlerConfigArgsDict',
    'GraphQLApiAdditionalAuthenticationProviderArgs',
    'GraphQLApiAdditionalAuthenticationProviderArgsDict',
    'GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs',
    'GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgsDict',
    'GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs',
    'GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgsDict',
    'GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs',
    'GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgsDict',
    'GraphQLApiEnhancedMetricsConfigArgs',
    'GraphQLApiEnhancedMetricsConfigArgsDict',
    'GraphQLApiLambdaAuthorizerConfigArgs',
    'GraphQLApiLambdaAuthorizerConfigArgsDict',
    'GraphQLApiLogConfigArgs',
    'GraphQLApiLogConfigArgsDict',
    'GraphQLApiOpenidConnectConfigArgs',
    'GraphQLApiOpenidConnectConfigArgsDict',
    'GraphQLApiUserPoolConfigArgs',
    'GraphQLApiUserPoolConfigArgsDict',
    'ResolverCachingConfigArgs',
    'ResolverCachingConfigArgsDict',
    'ResolverPipelineConfigArgs',
    'ResolverPipelineConfigArgsDict',
    'ResolverRuntimeArgs',
    'ResolverRuntimeArgsDict',
    'ResolverSyncConfigArgs',
    'ResolverSyncConfigArgsDict',
    'ResolverSyncConfigLambdaConflictHandlerConfigArgs',
    'ResolverSyncConfigLambdaConflictHandlerConfigArgsDict',
    'SourceApiAssociationSourceApiAssociationConfigArgs',
    'SourceApiAssociationSourceApiAssociationConfigArgsDict',
    'SourceApiAssociationTimeoutsArgs',
    'SourceApiAssociationTimeoutsArgsDict',
]

MYPY = False

if not MYPY:
    class DataSourceDynamodbConfigArgsDict(TypedDict):
        table_name: pulumi.Input[str]
        """
        Name of the DynamoDB table.
        """
        delta_sync_config: NotRequired[pulumi.Input['DataSourceDynamodbConfigDeltaSyncConfigArgsDict']]
        """
        The DeltaSyncConfig for a versioned data source. See `delta_sync_config` Block for details.
        """
        region: NotRequired[pulumi.Input[str]]
        """
        AWS region of the DynamoDB table. Defaults to current region.
        """
        use_caller_credentials: NotRequired[pulumi.Input[bool]]
        """
        Set to `true` to use Amazon Cognito credentials with this data source.
        """
        versioned: NotRequired[pulumi.Input[bool]]
        """
        Detects Conflict Detection and Resolution with this data source.
        """
elif False:
    DataSourceDynamodbConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceDynamodbConfigArgs:
    def __init__(__self__, *,
                 table_name: pulumi.Input[str],
                 delta_sync_config: Optional[pulumi.Input['DataSourceDynamodbConfigDeltaSyncConfigArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 use_caller_credentials: Optional[pulumi.Input[bool]] = None,
                 versioned: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] table_name: Name of the DynamoDB table.
        :param pulumi.Input['DataSourceDynamodbConfigDeltaSyncConfigArgs'] delta_sync_config: The DeltaSyncConfig for a versioned data source. See `delta_sync_config` Block for details.
        :param pulumi.Input[str] region: AWS region of the DynamoDB table. Defaults to current region.
        :param pulumi.Input[bool] use_caller_credentials: Set to `true` to use Amazon Cognito credentials with this data source.
        :param pulumi.Input[bool] versioned: Detects Conflict Detection and Resolution with this data source.
        """
        pulumi.set(__self__, "table_name", table_name)
        if delta_sync_config is not None:
            pulumi.set(__self__, "delta_sync_config", delta_sync_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if use_caller_credentials is not None:
            pulumi.set(__self__, "use_caller_credentials", use_caller_credentials)
        if versioned is not None:
            pulumi.set(__self__, "versioned", versioned)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="deltaSyncConfig")
    def delta_sync_config(self) -> Optional[pulumi.Input['DataSourceDynamodbConfigDeltaSyncConfigArgs']]:
        """
        The DeltaSyncConfig for a versioned data source. See `delta_sync_config` Block for details.
        """
        return pulumi.get(self, "delta_sync_config")

    @delta_sync_config.setter
    def delta_sync_config(self, value: Optional[pulumi.Input['DataSourceDynamodbConfigDeltaSyncConfigArgs']]):
        pulumi.set(self, "delta_sync_config", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS region of the DynamoDB table. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="useCallerCredentials")
    def use_caller_credentials(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to use Amazon Cognito credentials with this data source.
        """
        return pulumi.get(self, "use_caller_credentials")

    @use_caller_credentials.setter
    def use_caller_credentials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_caller_credentials", value)

    @property
    @pulumi.getter
    def versioned(self) -> Optional[pulumi.Input[bool]]:
        """
        Detects Conflict Detection and Resolution with this data source.
        """
        return pulumi.get(self, "versioned")

    @versioned.setter
    def versioned(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "versioned", value)


if not MYPY:
    class DataSourceDynamodbConfigDeltaSyncConfigArgsDict(TypedDict):
        delta_sync_table_name: pulumi.Input[str]
        """
        The table name.
        """
        base_table_ttl: NotRequired[pulumi.Input[int]]
        """
        The number of minutes that an Item is stored in the data source.
        """
        delta_sync_table_ttl: NotRequired[pulumi.Input[int]]
        """
        The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
elif False:
    DataSourceDynamodbConfigDeltaSyncConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceDynamodbConfigDeltaSyncConfigArgs:
    def __init__(__self__, *,
                 delta_sync_table_name: pulumi.Input[str],
                 base_table_ttl: Optional[pulumi.Input[int]] = None,
                 delta_sync_table_ttl: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] delta_sync_table_name: The table name.
        :param pulumi.Input[int] base_table_ttl: The number of minutes that an Item is stored in the data source.
        :param pulumi.Input[int] delta_sync_table_ttl: The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
        pulumi.set(__self__, "delta_sync_table_name", delta_sync_table_name)
        if base_table_ttl is not None:
            pulumi.set(__self__, "base_table_ttl", base_table_ttl)
        if delta_sync_table_ttl is not None:
            pulumi.set(__self__, "delta_sync_table_ttl", delta_sync_table_ttl)

    @property
    @pulumi.getter(name="deltaSyncTableName")
    def delta_sync_table_name(self) -> pulumi.Input[str]:
        """
        The table name.
        """
        return pulumi.get(self, "delta_sync_table_name")

    @delta_sync_table_name.setter
    def delta_sync_table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "delta_sync_table_name", value)

    @property
    @pulumi.getter(name="baseTableTtl")
    def base_table_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The number of minutes that an Item is stored in the data source.
        """
        return pulumi.get(self, "base_table_ttl")

    @base_table_ttl.setter
    def base_table_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "base_table_ttl", value)

    @property
    @pulumi.getter(name="deltaSyncTableTtl")
    def delta_sync_table_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
        return pulumi.get(self, "delta_sync_table_ttl")

    @delta_sync_table_ttl.setter
    def delta_sync_table_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delta_sync_table_ttl", value)


if not MYPY:
    class DataSourceElasticsearchConfigArgsDict(TypedDict):
        endpoint: pulumi.Input[str]
        """
        HTTP endpoint of the Elasticsearch domain.
        """
        region: NotRequired[pulumi.Input[str]]
        """
        AWS region of Elasticsearch domain. Defaults to current region.
        """
elif False:
    DataSourceElasticsearchConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceElasticsearchConfigArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] endpoint: HTTP endpoint of the Elasticsearch domain.
        :param pulumi.Input[str] region: AWS region of Elasticsearch domain. Defaults to current region.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        HTTP endpoint of the Elasticsearch domain.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS region of Elasticsearch domain. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


if not MYPY:
    class DataSourceEventBridgeConfigArgsDict(TypedDict):
        event_bus_arn: pulumi.Input[str]
        """
        ARN for the EventBridge bus.
        """
elif False:
    DataSourceEventBridgeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceEventBridgeConfigArgs:
    def __init__(__self__, *,
                 event_bus_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] event_bus_arn: ARN for the EventBridge bus.
        """
        pulumi.set(__self__, "event_bus_arn", event_bus_arn)

    @property
    @pulumi.getter(name="eventBusArn")
    def event_bus_arn(self) -> pulumi.Input[str]:
        """
        ARN for the EventBridge bus.
        """
        return pulumi.get(self, "event_bus_arn")

    @event_bus_arn.setter
    def event_bus_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_bus_arn", value)


if not MYPY:
    class DataSourceHttpConfigArgsDict(TypedDict):
        endpoint: pulumi.Input[str]
        """
        HTTP URL.
        """
        authorization_config: NotRequired[pulumi.Input['DataSourceHttpConfigAuthorizationConfigArgsDict']]
        """
        Authorization configuration in case the HTTP endpoint requires authorization. See `authorization_config` Block for details.
        """
elif False:
    DataSourceHttpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceHttpConfigArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[str],
                 authorization_config: Optional[pulumi.Input['DataSourceHttpConfigAuthorizationConfigArgs']] = None):
        """
        :param pulumi.Input[str] endpoint: HTTP URL.
        :param pulumi.Input['DataSourceHttpConfigAuthorizationConfigArgs'] authorization_config: Authorization configuration in case the HTTP endpoint requires authorization. See `authorization_config` Block for details.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        HTTP URL.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional[pulumi.Input['DataSourceHttpConfigAuthorizationConfigArgs']]:
        """
        Authorization configuration in case the HTTP endpoint requires authorization. See `authorization_config` Block for details.
        """
        return pulumi.get(self, "authorization_config")

    @authorization_config.setter
    def authorization_config(self, value: Optional[pulumi.Input['DataSourceHttpConfigAuthorizationConfigArgs']]):
        pulumi.set(self, "authorization_config", value)


if not MYPY:
    class DataSourceHttpConfigAuthorizationConfigArgsDict(TypedDict):
        authorization_type: NotRequired[pulumi.Input[str]]
        """
        Authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
        """
        aws_iam_config: NotRequired[pulumi.Input['DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgsDict']]
        """
        Identity and Access Management (IAM) settings. See `aws_iam_config` Block for details.
        """
elif False:
    DataSourceHttpConfigAuthorizationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceHttpConfigAuthorizationConfigArgs:
    def __init__(__self__, *,
                 authorization_type: Optional[pulumi.Input[str]] = None,
                 aws_iam_config: Optional[pulumi.Input['DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs']] = None):
        """
        :param pulumi.Input[str] authorization_type: Authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
        :param pulumi.Input['DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs'] aws_iam_config: Identity and Access Management (IAM) settings. See `aws_iam_config` Block for details.
        """
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if aws_iam_config is not None:
            pulumi.set(__self__, "aws_iam_config", aws_iam_config)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input[str]]:
        """
        Authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter(name="awsIamConfig")
    def aws_iam_config(self) -> Optional[pulumi.Input['DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs']]:
        """
        Identity and Access Management (IAM) settings. See `aws_iam_config` Block for details.
        """
        return pulumi.get(self, "aws_iam_config")

    @aws_iam_config.setter
    def aws_iam_config(self, value: Optional[pulumi.Input['DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs']]):
        pulumi.set(self, "aws_iam_config", value)


if not MYPY:
    class DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgsDict(TypedDict):
        signing_region: NotRequired[pulumi.Input[str]]
        """
        Signing Amazon Web Services Region for IAM authorization.
        """
        signing_service_name: NotRequired[pulumi.Input[str]]
        """
        Signing service name for IAM authorization.
        """
elif False:
    DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs:
    def __init__(__self__, *,
                 signing_region: Optional[pulumi.Input[str]] = None,
                 signing_service_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] signing_region: Signing Amazon Web Services Region for IAM authorization.
        :param pulumi.Input[str] signing_service_name: Signing service name for IAM authorization.
        """
        if signing_region is not None:
            pulumi.set(__self__, "signing_region", signing_region)
        if signing_service_name is not None:
            pulumi.set(__self__, "signing_service_name", signing_service_name)

    @property
    @pulumi.getter(name="signingRegion")
    def signing_region(self) -> Optional[pulumi.Input[str]]:
        """
        Signing Amazon Web Services Region for IAM authorization.
        """
        return pulumi.get(self, "signing_region")

    @signing_region.setter
    def signing_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_region", value)

    @property
    @pulumi.getter(name="signingServiceName")
    def signing_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Signing service name for IAM authorization.
        """
        return pulumi.get(self, "signing_service_name")

    @signing_service_name.setter
    def signing_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_service_name", value)


if not MYPY:
    class DataSourceLambdaConfigArgsDict(TypedDict):
        function_arn: pulumi.Input[str]
        """
        ARN for the Lambda function.
        """
elif False:
    DataSourceLambdaConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceLambdaConfigArgs:
    def __init__(__self__, *,
                 function_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] function_arn: ARN for the Lambda function.
        """
        pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Input[str]:
        """
        ARN for the Lambda function.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_arn", value)


if not MYPY:
    class DataSourceOpensearchserviceConfigArgsDict(TypedDict):
        endpoint: pulumi.Input[str]
        """
        HTTP endpoint of the OpenSearch domain.
        """
        region: NotRequired[pulumi.Input[str]]
        """
        AWS region of the OpenSearch domain. Defaults to current region.
        """
elif False:
    DataSourceOpensearchserviceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceOpensearchserviceConfigArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] endpoint: HTTP endpoint of the OpenSearch domain.
        :param pulumi.Input[str] region: AWS region of the OpenSearch domain. Defaults to current region.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        HTTP endpoint of the OpenSearch domain.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS region of the OpenSearch domain. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


if not MYPY:
    class DataSourceRelationalDatabaseConfigArgsDict(TypedDict):
        http_endpoint_config: NotRequired[pulumi.Input['DataSourceRelationalDatabaseConfigHttpEndpointConfigArgsDict']]
        """
        Amazon RDS HTTP endpoint configuration. See `http_endpoint_config` Block for details.
        """
        source_type: NotRequired[pulumi.Input[str]]
        """
        Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
        """
elif False:
    DataSourceRelationalDatabaseConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceRelationalDatabaseConfigArgs:
    def __init__(__self__, *,
                 http_endpoint_config: Optional[pulumi.Input['DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs']] = None,
                 source_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs'] http_endpoint_config: Amazon RDS HTTP endpoint configuration. See `http_endpoint_config` Block for details.
        :param pulumi.Input[str] source_type: Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
        """
        if http_endpoint_config is not None:
            pulumi.set(__self__, "http_endpoint_config", http_endpoint_config)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="httpEndpointConfig")
    def http_endpoint_config(self) -> Optional[pulumi.Input['DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs']]:
        """
        Amazon RDS HTTP endpoint configuration. See `http_endpoint_config` Block for details.
        """
        return pulumi.get(self, "http_endpoint_config")

    @http_endpoint_config.setter
    def http_endpoint_config(self, value: Optional[pulumi.Input['DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs']]):
        pulumi.set(self, "http_endpoint_config", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        """
        Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)


if not MYPY:
    class DataSourceRelationalDatabaseConfigHttpEndpointConfigArgsDict(TypedDict):
        aws_secret_store_arn: pulumi.Input[str]
        """
        AWS secret store ARN for database credentials.
        """
        db_cluster_identifier: pulumi.Input[str]
        """
        Amazon RDS cluster identifier.
        """
        database_name: NotRequired[pulumi.Input[str]]
        """
        Logical database name.
        """
        region: NotRequired[pulumi.Input[str]]
        """
        AWS Region for RDS HTTP endpoint. Defaults to current region.
        """
        schema: NotRequired[pulumi.Input[str]]
        """
        Logical schema name.
        """
elif False:
    DataSourceRelationalDatabaseConfigHttpEndpointConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs:
    def __init__(__self__, *,
                 aws_secret_store_arn: pulumi.Input[str],
                 db_cluster_identifier: pulumi.Input[str],
                 database_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] aws_secret_store_arn: AWS secret store ARN for database credentials.
        :param pulumi.Input[str] db_cluster_identifier: Amazon RDS cluster identifier.
        :param pulumi.Input[str] database_name: Logical database name.
        :param pulumi.Input[str] region: AWS Region for RDS HTTP endpoint. Defaults to current region.
        :param pulumi.Input[str] schema: Logical schema name.
        """
        pulumi.set(__self__, "aws_secret_store_arn", aws_secret_store_arn)
        pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="awsSecretStoreArn")
    def aws_secret_store_arn(self) -> pulumi.Input[str]:
        """
        AWS secret store ARN for database credentials.
        """
        return pulumi.get(self, "aws_secret_store_arn")

    @aws_secret_store_arn.setter
    def aws_secret_store_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "aws_secret_store_arn", value)

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> pulumi.Input[str]:
        """
        Amazon RDS cluster identifier.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @db_cluster_identifier.setter
    def db_cluster_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_cluster_identifier", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Logical database name.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS Region for RDS HTTP endpoint. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        Logical schema name.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)


if not MYPY:
    class FunctionRuntimeArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        """
        runtime_version: pulumi.Input[str]
        """
        The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
elif False:
    FunctionRuntimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionRuntimeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 runtime_version: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        :param pulumi.Input[str] runtime_version: The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[str]:
        """
        The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime_version", value)


if not MYPY:
    class FunctionSyncConfigArgsDict(TypedDict):
        conflict_detection: NotRequired[pulumi.Input[str]]
        """
        Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        """
        conflict_handler: NotRequired[pulumi.Input[str]]
        """
        Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        """
        lambda_conflict_handler_config: NotRequired[pulumi.Input['FunctionSyncConfigLambdaConflictHandlerConfigArgsDict']]
        """
        Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See `lambda_conflict_handler_config` Block for details.
        """
elif False:
    FunctionSyncConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionSyncConfigArgs:
    def __init__(__self__, *,
                 conflict_detection: Optional[pulumi.Input[str]] = None,
                 conflict_handler: Optional[pulumi.Input[str]] = None,
                 lambda_conflict_handler_config: Optional[pulumi.Input['FunctionSyncConfigLambdaConflictHandlerConfigArgs']] = None):
        """
        :param pulumi.Input[str] conflict_detection: Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        :param pulumi.Input[str] conflict_handler: Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        :param pulumi.Input['FunctionSyncConfigLambdaConflictHandlerConfigArgs'] lambda_conflict_handler_config: Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See `lambda_conflict_handler_config` Block for details.
        """
        if conflict_detection is not None:
            pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> Optional[pulumi.Input[str]]:
        """
        Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        """
        return pulumi.get(self, "conflict_detection")

    @conflict_detection.setter
    def conflict_detection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conflict_detection", value)

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[pulumi.Input[str]]:
        """
        Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        """
        return pulumi.get(self, "conflict_handler")

    @conflict_handler.setter
    def conflict_handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conflict_handler", value)

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional[pulumi.Input['FunctionSyncConfigLambdaConflictHandlerConfigArgs']]:
        """
        Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See `lambda_conflict_handler_config` Block for details.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")

    @lambda_conflict_handler_config.setter
    def lambda_conflict_handler_config(self, value: Optional[pulumi.Input['FunctionSyncConfigLambdaConflictHandlerConfigArgs']]):
        pulumi.set(self, "lambda_conflict_handler_config", value)


if not MYPY:
    class FunctionSyncConfigLambdaConflictHandlerConfigArgsDict(TypedDict):
        lambda_conflict_handler_arn: NotRequired[pulumi.Input[str]]
        """
        ARN for the Lambda function to use as the Conflict Handler.
        """
elif False:
    FunctionSyncConfigLambdaConflictHandlerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionSyncConfigLambdaConflictHandlerConfigArgs:
    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] lambda_conflict_handler_arn: ARN for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")

    @lambda_conflict_handler_arn.setter
    def lambda_conflict_handler_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_conflict_handler_arn", value)


if not MYPY:
    class GraphQLApiAdditionalAuthenticationProviderArgsDict(TypedDict):
        authentication_type: pulumi.Input[str]
        """
        Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        """
        lambda_authorizer_config: NotRequired[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgsDict']]
        """
        Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        """
        openid_connect_config: NotRequired[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgsDict']]
        """
        Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        """
        user_pool_config: NotRequired[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgsDict']]
        """
        Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        """
elif False:
    GraphQLApiAdditionalAuthenticationProviderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQLApiAdditionalAuthenticationProviderArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[str],
                 lambda_authorizer_config: Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs']] = None,
                 openid_connect_config: Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs']] = None,
                 user_pool_config: Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs']] = None):
        """
        :param pulumi.Input[str] authentication_type: Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        :param pulumi.Input['GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs'] lambda_authorizer_config: Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        :param pulumi.Input['GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs'] openid_connect_config: Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        :param pulumi.Input['GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs'] user_pool_config: Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if openid_connect_config is not None:
            pulumi.set(__self__, "openid_connect_config", openid_connect_config)
        if user_pool_config is not None:
            pulumi.set(__self__, "user_pool_config", user_pool_config)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[str]:
        """
        Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs']]:
        """
        Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @lambda_authorizer_config.setter
    def lambda_authorizer_config(self, value: Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs']]):
        pulumi.set(self, "lambda_authorizer_config", value)

    @property
    @pulumi.getter(name="openidConnectConfig")
    def openid_connect_config(self) -> Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs']]:
        """
        Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        """
        return pulumi.get(self, "openid_connect_config")

    @openid_connect_config.setter
    def openid_connect_config(self, value: Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs']]):
        pulumi.set(self, "openid_connect_config", value)

    @property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs']]:
        """
        Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        """
        return pulumi.get(self, "user_pool_config")

    @user_pool_config.setter
    def user_pool_config(self, value: Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs']]):
        pulumi.set(self, "user_pool_config", value)


if not MYPY:
    class GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgsDict(TypedDict):
        authorizer_uri: pulumi.Input[str]
        """
        ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        """
        authorizer_result_ttl_in_seconds: NotRequired[pulumi.Input[int]]
        """
        Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        """
        identity_validation_expression: NotRequired[pulumi.Input[str]]
        """
        Regular expression for validation of tokens before the Lambda function is called.
        """
elif False:
    GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs:
    def __init__(__self__, *,
                 authorizer_uri: pulumi.Input[str],
                 authorizer_result_ttl_in_seconds: Optional[pulumi.Input[int]] = None,
                 identity_validation_expression: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] authorizer_uri: ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        :param pulumi.Input[int] authorizer_result_ttl_in_seconds: Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        :param pulumi.Input[str] identity_validation_expression: Regular expression for validation of tokens before the Lambda function is called.
        """
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> pulumi.Input[str]:
        """
        ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        """
        return pulumi.get(self, "authorizer_uri")

    @authorizer_uri.setter
    def authorizer_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorizer_uri", value)

    @property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @authorizer_result_ttl_in_seconds.setter
    def authorizer_result_ttl_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "authorizer_result_ttl_in_seconds", value)

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Regular expression for validation of tokens before the Lambda function is called.
        """
        return pulumi.get(self, "identity_validation_expression")

    @identity_validation_expression.setter
    def identity_validation_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_validation_expression", value)


if not MYPY:
    class GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgsDict(TypedDict):
        issuer: pulumi.Input[str]
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        auth_ttl: NotRequired[pulumi.Input[int]]
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        client_id: NotRequired[pulumi.Input[str]]
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        iat_ttl: NotRequired[pulumi.Input[int]]
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
elif False:
    GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs:
    def __init__(__self__, *,
                 issuer: pulumi.Input[str],
                 auth_ttl: Optional[pulumi.Input[int]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 iat_ttl: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param pulumi.Input[int] auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param pulumi.Input[str] client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param pulumi.Input[int] iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[str]:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @auth_ttl.setter
    def auth_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auth_ttl", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")

    @iat_ttl.setter
    def iat_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iat_ttl", value)


if not MYPY:
    class GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgsDict(TypedDict):
        user_pool_id: pulumi.Input[str]
        """
        User pool ID.
        """
        app_id_client_regex: NotRequired[pulumi.Input[str]]
        """
        Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        aws_region: NotRequired[pulumi.Input[str]]
        """
        AWS region in which the user pool was created.
        """
elif False:
    GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs:
    def __init__(__self__, *,
                 user_pool_id: pulumi.Input[str],
                 app_id_client_regex: Optional[pulumi.Input[str]] = None,
                 aws_region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] user_pool_id: User pool ID.
        :param pulumi.Input[str] app_id_client_regex: Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param pulumi.Input[str] aws_region: AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[str]:
        """
        User pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[pulumi.Input[str]]:
        """
        Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @app_id_client_regex.setter
    def app_id_client_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id_client_regex", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_region", value)


if not MYPY:
    class GraphQLApiEnhancedMetricsConfigArgsDict(TypedDict):
        data_source_level_metrics_behavior: pulumi.Input[str]
        """
        How data source metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_DATA_SOURCE_METRICS`, `PER_DATA_SOURCE_METRICS`
        """
        operation_level_metrics_config: pulumi.Input[str]
        """
        How operation metrics will be emitted to CloudWatch. Valid values: `ENABLED`, `DISABLED`
        """
        resolver_level_metrics_behavior: pulumi.Input[str]
        """
        How resolver metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_RESOLVER_METRICS`, `PER_RESOLVER_METRICS`
        """
elif False:
    GraphQLApiEnhancedMetricsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQLApiEnhancedMetricsConfigArgs:
    def __init__(__self__, *,
                 data_source_level_metrics_behavior: pulumi.Input[str],
                 operation_level_metrics_config: pulumi.Input[str],
                 resolver_level_metrics_behavior: pulumi.Input[str]):
        """
        :param pulumi.Input[str] data_source_level_metrics_behavior: How data source metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_DATA_SOURCE_METRICS`, `PER_DATA_SOURCE_METRICS`
        :param pulumi.Input[str] operation_level_metrics_config: How operation metrics will be emitted to CloudWatch. Valid values: `ENABLED`, `DISABLED`
        :param pulumi.Input[str] resolver_level_metrics_behavior: How resolver metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_RESOLVER_METRICS`, `PER_RESOLVER_METRICS`
        """
        pulumi.set(__self__, "data_source_level_metrics_behavior", data_source_level_metrics_behavior)
        pulumi.set(__self__, "operation_level_metrics_config", operation_level_metrics_config)
        pulumi.set(__self__, "resolver_level_metrics_behavior", resolver_level_metrics_behavior)

    @property
    @pulumi.getter(name="dataSourceLevelMetricsBehavior")
    def data_source_level_metrics_behavior(self) -> pulumi.Input[str]:
        """
        How data source metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_DATA_SOURCE_METRICS`, `PER_DATA_SOURCE_METRICS`
        """
        return pulumi.get(self, "data_source_level_metrics_behavior")

    @data_source_level_metrics_behavior.setter
    def data_source_level_metrics_behavior(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_source_level_metrics_behavior", value)

    @property
    @pulumi.getter(name="operationLevelMetricsConfig")
    def operation_level_metrics_config(self) -> pulumi.Input[str]:
        """
        How operation metrics will be emitted to CloudWatch. Valid values: `ENABLED`, `DISABLED`
        """
        return pulumi.get(self, "operation_level_metrics_config")

    @operation_level_metrics_config.setter
    def operation_level_metrics_config(self, value: pulumi.Input[str]):
        pulumi.set(self, "operation_level_metrics_config", value)

    @property
    @pulumi.getter(name="resolverLevelMetricsBehavior")
    def resolver_level_metrics_behavior(self) -> pulumi.Input[str]:
        """
        How resolver metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_RESOLVER_METRICS`, `PER_RESOLVER_METRICS`
        """
        return pulumi.get(self, "resolver_level_metrics_behavior")

    @resolver_level_metrics_behavior.setter
    def resolver_level_metrics_behavior(self, value: pulumi.Input[str]):
        pulumi.set(self, "resolver_level_metrics_behavior", value)


if not MYPY:
    class GraphQLApiLambdaAuthorizerConfigArgsDict(TypedDict):
        authorizer_uri: pulumi.Input[str]
        """
        ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        """
        authorizer_result_ttl_in_seconds: NotRequired[pulumi.Input[int]]
        """
        Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        """
        identity_validation_expression: NotRequired[pulumi.Input[str]]
        """
        Regular expression for validation of tokens before the Lambda function is called.
        """
elif False:
    GraphQLApiLambdaAuthorizerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQLApiLambdaAuthorizerConfigArgs:
    def __init__(__self__, *,
                 authorizer_uri: pulumi.Input[str],
                 authorizer_result_ttl_in_seconds: Optional[pulumi.Input[int]] = None,
                 identity_validation_expression: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] authorizer_uri: ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        :param pulumi.Input[int] authorizer_result_ttl_in_seconds: Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        :param pulumi.Input[str] identity_validation_expression: Regular expression for validation of tokens before the Lambda function is called.
        """
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> pulumi.Input[str]:
        """
        ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        """
        return pulumi.get(self, "authorizer_uri")

    @authorizer_uri.setter
    def authorizer_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorizer_uri", value)

    @property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @authorizer_result_ttl_in_seconds.setter
    def authorizer_result_ttl_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "authorizer_result_ttl_in_seconds", value)

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Regular expression for validation of tokens before the Lambda function is called.
        """
        return pulumi.get(self, "identity_validation_expression")

    @identity_validation_expression.setter
    def identity_validation_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_validation_expression", value)


if not MYPY:
    class GraphQLApiLogConfigArgsDict(TypedDict):
        cloudwatch_logs_role_arn: pulumi.Input[str]
        """
        Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        """
        field_log_level: pulumi.Input[str]
        """
        Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        """
        exclude_verbose_content: NotRequired[pulumi.Input[bool]]
        """
        Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
elif False:
    GraphQLApiLogConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQLApiLogConfigArgs:
    def __init__(__self__, *,
                 cloudwatch_logs_role_arn: pulumi.Input[str],
                 field_log_level: pulumi.Input[str],
                 exclude_verbose_content: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] cloudwatch_logs_role_arn: Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        :param pulumi.Input[str] field_log_level: Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        :param pulumi.Input[bool] exclude_verbose_content: Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        pulumi.set(__self__, "cloudwatch_logs_role_arn", cloudwatch_logs_role_arn)
        pulumi.set(__self__, "field_log_level", field_log_level)
        if exclude_verbose_content is not None:
            pulumi.set(__self__, "exclude_verbose_content", exclude_verbose_content)

    @property
    @pulumi.getter(name="cloudwatchLogsRoleArn")
    def cloudwatch_logs_role_arn(self) -> pulumi.Input[str]:
        """
        Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        """
        return pulumi.get(self, "cloudwatch_logs_role_arn")

    @cloudwatch_logs_role_arn.setter
    def cloudwatch_logs_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloudwatch_logs_role_arn", value)

    @property
    @pulumi.getter(name="fieldLogLevel")
    def field_log_level(self) -> pulumi.Input[str]:
        """
        Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        """
        return pulumi.get(self, "field_log_level")

    @field_log_level.setter
    def field_log_level(self, value: pulumi.Input[str]):
        pulumi.set(self, "field_log_level", value)

    @property
    @pulumi.getter(name="excludeVerboseContent")
    def exclude_verbose_content(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        return pulumi.get(self, "exclude_verbose_content")

    @exclude_verbose_content.setter
    def exclude_verbose_content(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_verbose_content", value)


if not MYPY:
    class GraphQLApiOpenidConnectConfigArgsDict(TypedDict):
        issuer: pulumi.Input[str]
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        auth_ttl: NotRequired[pulumi.Input[int]]
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        client_id: NotRequired[pulumi.Input[str]]
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        iat_ttl: NotRequired[pulumi.Input[int]]
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
elif False:
    GraphQLApiOpenidConnectConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQLApiOpenidConnectConfigArgs:
    def __init__(__self__, *,
                 issuer: pulumi.Input[str],
                 auth_ttl: Optional[pulumi.Input[int]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 iat_ttl: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param pulumi.Input[int] auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param pulumi.Input[str] client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param pulumi.Input[int] iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[str]:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @auth_ttl.setter
    def auth_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auth_ttl", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")

    @iat_ttl.setter
    def iat_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iat_ttl", value)


if not MYPY:
    class GraphQLApiUserPoolConfigArgsDict(TypedDict):
        default_action: pulumi.Input[str]
        """
        Action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        """
        user_pool_id: pulumi.Input[str]
        """
        User pool ID.
        """
        app_id_client_regex: NotRequired[pulumi.Input[str]]
        """
        Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        aws_region: NotRequired[pulumi.Input[str]]
        """
        AWS region in which the user pool was created.
        """
elif False:
    GraphQLApiUserPoolConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GraphQLApiUserPoolConfigArgs:
    def __init__(__self__, *,
                 default_action: pulumi.Input[str],
                 user_pool_id: pulumi.Input[str],
                 app_id_client_regex: Optional[pulumi.Input[str]] = None,
                 aws_region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] default_action: Action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        :param pulumi.Input[str] user_pool_id: User pool ID.
        :param pulumi.Input[str] app_id_client_regex: Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param pulumi.Input[str] aws_region: AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "default_action", default_action)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Input[str]:
        """
        Action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[str]:
        """
        User pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[pulumi.Input[str]]:
        """
        Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @app_id_client_regex.setter
    def app_id_client_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id_client_regex", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_region", value)


if not MYPY:
    class ResolverCachingConfigArgsDict(TypedDict):
        caching_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
        """
        ttl: NotRequired[pulumi.Input[int]]
        """
        The TTL in seconds for a resolver that has caching activated. Valid values are between `1` and `3600` seconds.
        """
elif False:
    ResolverCachingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverCachingConfigArgs:
    def __init__(__self__, *,
                 caching_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] caching_keys: The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
        :param pulumi.Input[int] ttl: The TTL in seconds for a resolver that has caching activated. Valid values are between `1` and `3600` seconds.
        """
        if caching_keys is not None:
            pulumi.set(__self__, "caching_keys", caching_keys)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="cachingKeys")
    def caching_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
        """
        return pulumi.get(self, "caching_keys")

    @caching_keys.setter
    def caching_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "caching_keys", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The TTL in seconds for a resolver that has caching activated. Valid values are between `1` and `3600` seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


if not MYPY:
    class ResolverPipelineConfigArgsDict(TypedDict):
        functions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of Function objects.
        """
elif False:
    ResolverPipelineConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverPipelineConfigArgs:
    def __init__(__self__, *,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] functions: A list of Function objects.
        """
        if functions is not None:
            pulumi.set(__self__, "functions", functions)

    @property
    @pulumi.getter
    def functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Function objects.
        """
        return pulumi.get(self, "functions")

    @functions.setter
    def functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "functions", value)


if not MYPY:
    class ResolverRuntimeArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        """
        runtime_version: pulumi.Input[str]
        """
        The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
elif False:
    ResolverRuntimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverRuntimeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 runtime_version: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        :param pulumi.Input[str] runtime_version: The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[str]:
        """
        The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime_version", value)


if not MYPY:
    class ResolverSyncConfigArgsDict(TypedDict):
        conflict_detection: NotRequired[pulumi.Input[str]]
        """
        Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        """
        conflict_handler: NotRequired[pulumi.Input[str]]
        """
        Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        """
        lambda_conflict_handler_config: NotRequired[pulumi.Input['ResolverSyncConfigLambdaConflictHandlerConfigArgsDict']]
        """
        Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
        """
elif False:
    ResolverSyncConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverSyncConfigArgs:
    def __init__(__self__, *,
                 conflict_detection: Optional[pulumi.Input[str]] = None,
                 conflict_handler: Optional[pulumi.Input[str]] = None,
                 lambda_conflict_handler_config: Optional[pulumi.Input['ResolverSyncConfigLambdaConflictHandlerConfigArgs']] = None):
        """
        :param pulumi.Input[str] conflict_detection: Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        :param pulumi.Input[str] conflict_handler: Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        :param pulumi.Input['ResolverSyncConfigLambdaConflictHandlerConfigArgs'] lambda_conflict_handler_config: Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
        """
        if conflict_detection is not None:
            pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> Optional[pulumi.Input[str]]:
        """
        Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        """
        return pulumi.get(self, "conflict_detection")

    @conflict_detection.setter
    def conflict_detection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conflict_detection", value)

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[pulumi.Input[str]]:
        """
        Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        """
        return pulumi.get(self, "conflict_handler")

    @conflict_handler.setter
    def conflict_handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conflict_handler", value)

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional[pulumi.Input['ResolverSyncConfigLambdaConflictHandlerConfigArgs']]:
        """
        Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")

    @lambda_conflict_handler_config.setter
    def lambda_conflict_handler_config(self, value: Optional[pulumi.Input['ResolverSyncConfigLambdaConflictHandlerConfigArgs']]):
        pulumi.set(self, "lambda_conflict_handler_config", value)


if not MYPY:
    class ResolverSyncConfigLambdaConflictHandlerConfigArgsDict(TypedDict):
        lambda_conflict_handler_arn: NotRequired[pulumi.Input[str]]
        """
        ARN for the Lambda function to use as the Conflict Handler.
        """
elif False:
    ResolverSyncConfigLambdaConflictHandlerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverSyncConfigLambdaConflictHandlerConfigArgs:
    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] lambda_conflict_handler_arn: ARN for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")

    @lambda_conflict_handler_arn.setter
    def lambda_conflict_handler_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_conflict_handler_arn", value)


if not MYPY:
    class SourceApiAssociationSourceApiAssociationConfigArgsDict(TypedDict):
        merge_type: pulumi.Input[str]
        """
        Merge type. Valid values: `MANUAL_MERGE`, `AUTO_MERGE`
        """
elif False:
    SourceApiAssociationSourceApiAssociationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SourceApiAssociationSourceApiAssociationConfigArgs:
    def __init__(__self__, *,
                 merge_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] merge_type: Merge type. Valid values: `MANUAL_MERGE`, `AUTO_MERGE`
        """
        pulumi.set(__self__, "merge_type", merge_type)

    @property
    @pulumi.getter(name="mergeType")
    def merge_type(self) -> pulumi.Input[str]:
        """
        Merge type. Valid values: `MANUAL_MERGE`, `AUTO_MERGE`
        """
        return pulumi.get(self, "merge_type")

    @merge_type.setter
    def merge_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "merge_type", value)


if not MYPY:
    class SourceApiAssociationTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        update: NotRequired[pulumi.Input[str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    SourceApiAssociationTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SourceApiAssociationTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[str]] = None,
                 delete: Optional[pulumi.Input[str]] = None,
                 update: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update", value)


