# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SourceApiAssociationArgs', 'SourceApiAssociation']

@pulumi.input_type
class SourceApiAssociationArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 merged_api_arn: Optional[pulumi.Input[str]] = None,
                 merged_api_id: Optional[pulumi.Input[str]] = None,
                 source_api_arn: Optional[pulumi.Input[str]] = None,
                 source_api_association_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SourceApiAssociationSourceApiAssociationConfigArgs']]]] = None,
                 source_api_id: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['SourceApiAssociationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a SourceApiAssociation resource.
        :param pulumi.Input[str] description: Description of the source API being merged.
        :param pulumi.Input[str] merged_api_arn: ARN of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        :param pulumi.Input[str] merged_api_id: ID of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        :param pulumi.Input[str] source_api_arn: ARN of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        :param pulumi.Input[str] source_api_id: ID of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if merged_api_arn is not None:
            pulumi.set(__self__, "merged_api_arn", merged_api_arn)
        if merged_api_id is not None:
            pulumi.set(__self__, "merged_api_id", merged_api_id)
        if source_api_arn is not None:
            pulumi.set(__self__, "source_api_arn", source_api_arn)
        if source_api_association_configs is not None:
            pulumi.set(__self__, "source_api_association_configs", source_api_association_configs)
        if source_api_id is not None:
            pulumi.set(__self__, "source_api_id", source_api_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the source API being merged.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="mergedApiArn")
    def merged_api_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        """
        return pulumi.get(self, "merged_api_arn")

    @merged_api_arn.setter
    def merged_api_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merged_api_arn", value)

    @property
    @pulumi.getter(name="mergedApiId")
    def merged_api_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        """
        return pulumi.get(self, "merged_api_id")

    @merged_api_id.setter
    def merged_api_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merged_api_id", value)

    @property
    @pulumi.getter(name="sourceApiArn")
    def source_api_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        """
        return pulumi.get(self, "source_api_arn")

    @source_api_arn.setter
    def source_api_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_api_arn", value)

    @property
    @pulumi.getter(name="sourceApiAssociationConfigs")
    def source_api_association_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceApiAssociationSourceApiAssociationConfigArgs']]]]:
        return pulumi.get(self, "source_api_association_configs")

    @source_api_association_configs.setter
    def source_api_association_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceApiAssociationSourceApiAssociationConfigArgs']]]]):
        pulumi.set(self, "source_api_association_configs", value)

    @property
    @pulumi.getter(name="sourceApiId")
    def source_api_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        """
        return pulumi.get(self, "source_api_id")

    @source_api_id.setter
    def source_api_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_api_id", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['SourceApiAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['SourceApiAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _SourceApiAssociationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 association_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 merged_api_arn: Optional[pulumi.Input[str]] = None,
                 merged_api_id: Optional[pulumi.Input[str]] = None,
                 source_api_arn: Optional[pulumi.Input[str]] = None,
                 source_api_association_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SourceApiAssociationSourceApiAssociationConfigArgs']]]] = None,
                 source_api_id: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['SourceApiAssociationTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering SourceApiAssociation resources.
        :param pulumi.Input[str] arn: ARN of the Source Api Association.
        :param pulumi.Input[str] association_id: ID of the Source Api Association.
        :param pulumi.Input[str] description: Description of the source API being merged.
        :param pulumi.Input[str] merged_api_arn: ARN of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        :param pulumi.Input[str] merged_api_id: ID of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        :param pulumi.Input[str] source_api_arn: ARN of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        :param pulumi.Input[str] source_api_id: ID of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if association_id is not None:
            pulumi.set(__self__, "association_id", association_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if merged_api_arn is not None:
            pulumi.set(__self__, "merged_api_arn", merged_api_arn)
        if merged_api_id is not None:
            pulumi.set(__self__, "merged_api_id", merged_api_id)
        if source_api_arn is not None:
            pulumi.set(__self__, "source_api_arn", source_api_arn)
        if source_api_association_configs is not None:
            pulumi.set(__self__, "source_api_association_configs", source_api_association_configs)
        if source_api_id is not None:
            pulumi.set(__self__, "source_api_id", source_api_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Source Api Association.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Source Api Association.
        """
        return pulumi.get(self, "association_id")

    @association_id.setter
    def association_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "association_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the source API being merged.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="mergedApiArn")
    def merged_api_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        """
        return pulumi.get(self, "merged_api_arn")

    @merged_api_arn.setter
    def merged_api_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merged_api_arn", value)

    @property
    @pulumi.getter(name="mergedApiId")
    def merged_api_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        """
        return pulumi.get(self, "merged_api_id")

    @merged_api_id.setter
    def merged_api_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merged_api_id", value)

    @property
    @pulumi.getter(name="sourceApiArn")
    def source_api_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        """
        return pulumi.get(self, "source_api_arn")

    @source_api_arn.setter
    def source_api_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_api_arn", value)

    @property
    @pulumi.getter(name="sourceApiAssociationConfigs")
    def source_api_association_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceApiAssociationSourceApiAssociationConfigArgs']]]]:
        return pulumi.get(self, "source_api_association_configs")

    @source_api_association_configs.setter
    def source_api_association_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceApiAssociationSourceApiAssociationConfigArgs']]]]):
        pulumi.set(self, "source_api_association_configs", value)

    @property
    @pulumi.getter(name="sourceApiId")
    def source_api_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        """
        return pulumi.get(self, "source_api_id")

    @source_api_id.setter
    def source_api_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_api_id", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['SourceApiAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['SourceApiAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class SourceApiAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 merged_api_arn: Optional[pulumi.Input[str]] = None,
                 merged_api_id: Optional[pulumi.Input[str]] = None,
                 source_api_arn: Optional[pulumi.Input[str]] = None,
                 source_api_association_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SourceApiAssociationSourceApiAssociationConfigArgs', 'SourceApiAssociationSourceApiAssociationConfigArgsDict']]]]] = None,
                 source_api_id: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['SourceApiAssociationTimeoutsArgs', 'SourceApiAssociationTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS AppSync Source Api Association.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.appsync.SourceApiAssociation("test",
            description="My source API Merged",
            merged_api_id="gzos6bteufdunffzzifiowisoe",
            source_api_id="fzzifiowisoegzos6bteufdunf")
        ```

        ## Import

        Using `pulumi import`, import AppSync Source Api Association using the `gzos6bteufdunffzzifiowisoe,243685a0-9347-4a1a-89c1-9b57dea01e31`. For example:

        ```sh
        $ pulumi import aws:appsync/sourceApiAssociation:SourceApiAssociation example gzos6bteufdunffzzifiowisoe,243685a0-9347-4a1a-89c1-9b57dea01e31
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the source API being merged.
        :param pulumi.Input[str] merged_api_arn: ARN of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        :param pulumi.Input[str] merged_api_id: ID of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        :param pulumi.Input[str] source_api_arn: ARN of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        :param pulumi.Input[str] source_api_id: ID of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SourceApiAssociationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS AppSync Source Api Association.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.appsync.SourceApiAssociation("test",
            description="My source API Merged",
            merged_api_id="gzos6bteufdunffzzifiowisoe",
            source_api_id="fzzifiowisoegzos6bteufdunf")
        ```

        ## Import

        Using `pulumi import`, import AppSync Source Api Association using the `gzos6bteufdunffzzifiowisoe,243685a0-9347-4a1a-89c1-9b57dea01e31`. For example:

        ```sh
        $ pulumi import aws:appsync/sourceApiAssociation:SourceApiAssociation example gzos6bteufdunffzzifiowisoe,243685a0-9347-4a1a-89c1-9b57dea01e31
        ```

        :param str resource_name: The name of the resource.
        :param SourceApiAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SourceApiAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 merged_api_arn: Optional[pulumi.Input[str]] = None,
                 merged_api_id: Optional[pulumi.Input[str]] = None,
                 source_api_arn: Optional[pulumi.Input[str]] = None,
                 source_api_association_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SourceApiAssociationSourceApiAssociationConfigArgs', 'SourceApiAssociationSourceApiAssociationConfigArgsDict']]]]] = None,
                 source_api_id: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['SourceApiAssociationTimeoutsArgs', 'SourceApiAssociationTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SourceApiAssociationArgs.__new__(SourceApiAssociationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["merged_api_arn"] = merged_api_arn
            __props__.__dict__["merged_api_id"] = merged_api_id
            __props__.__dict__["source_api_arn"] = source_api_arn
            __props__.__dict__["source_api_association_configs"] = source_api_association_configs
            __props__.__dict__["source_api_id"] = source_api_id
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["association_id"] = None
        super(SourceApiAssociation, __self__).__init__(
            'aws:appsync/sourceApiAssociation:SourceApiAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            association_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            merged_api_arn: Optional[pulumi.Input[str]] = None,
            merged_api_id: Optional[pulumi.Input[str]] = None,
            source_api_arn: Optional[pulumi.Input[str]] = None,
            source_api_association_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SourceApiAssociationSourceApiAssociationConfigArgs', 'SourceApiAssociationSourceApiAssociationConfigArgsDict']]]]] = None,
            source_api_id: Optional[pulumi.Input[str]] = None,
            timeouts: Optional[pulumi.Input[Union['SourceApiAssociationTimeoutsArgs', 'SourceApiAssociationTimeoutsArgsDict']]] = None) -> 'SourceApiAssociation':
        """
        Get an existing SourceApiAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the Source Api Association.
        :param pulumi.Input[str] association_id: ID of the Source Api Association.
        :param pulumi.Input[str] description: Description of the source API being merged.
        :param pulumi.Input[str] merged_api_arn: ARN of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        :param pulumi.Input[str] merged_api_id: ID of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        :param pulumi.Input[str] source_api_arn: ARN of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        :param pulumi.Input[str] source_api_id: ID of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SourceApiAssociationState.__new__(_SourceApiAssociationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["association_id"] = association_id
        __props__.__dict__["description"] = description
        __props__.__dict__["merged_api_arn"] = merged_api_arn
        __props__.__dict__["merged_api_id"] = merged_api_id
        __props__.__dict__["source_api_arn"] = source_api_arn
        __props__.__dict__["source_api_association_configs"] = source_api_association_configs
        __props__.__dict__["source_api_id"] = source_api_id
        __props__.__dict__["timeouts"] = timeouts
        return SourceApiAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the Source Api Association.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> pulumi.Output[str]:
        """
        ID of the Source Api Association.
        """
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the source API being merged.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="mergedApiArn")
    def merged_api_arn(self) -> pulumi.Output[str]:
        """
        ARN of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        """
        return pulumi.get(self, "merged_api_arn")

    @property
    @pulumi.getter(name="mergedApiId")
    def merged_api_id(self) -> pulumi.Output[str]:
        """
        ID of the merged API. One of `merged_api_arn` or `merged_api_id` must be specified.
        """
        return pulumi.get(self, "merged_api_id")

    @property
    @pulumi.getter(name="sourceApiArn")
    def source_api_arn(self) -> pulumi.Output[str]:
        """
        ARN of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        """
        return pulumi.get(self, "source_api_arn")

    @property
    @pulumi.getter(name="sourceApiAssociationConfigs")
    def source_api_association_configs(self) -> pulumi.Output[Sequence['outputs.SourceApiAssociationSourceApiAssociationConfig']]:
        return pulumi.get(self, "source_api_association_configs")

    @property
    @pulumi.getter(name="sourceApiId")
    def source_api_id(self) -> pulumi.Output[str]:
        """
        ID of the source API. One of `source_api_arn` or `source_api_id` must be specified.
        """
        return pulumi.get(self, "source_api_id")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.SourceApiAssociationTimeouts']]:
        return pulumi.get(self, "timeouts")

