# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegionSettingsArgs', 'RegionSettings']

@pulumi.input_type
class RegionSettingsArgs:
    def __init__(__self__, *,
                 resource_type_opt_in_preference: pulumi.Input[Mapping[str, pulumi.Input[bool]]],
                 resource_type_management_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None):
        """
        The set of arguments for constructing a RegionSettings resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] resource_type_opt_in_preference: A map of services along with the opt-in preferences for the Region.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] resource_type_management_preference: A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
        """
        pulumi.set(__self__, "resource_type_opt_in_preference", resource_type_opt_in_preference)
        if resource_type_management_preference is not None:
            pulumi.set(__self__, "resource_type_management_preference", resource_type_management_preference)

    @property
    @pulumi.getter(name="resourceTypeOptInPreference")
    def resource_type_opt_in_preference(self) -> pulumi.Input[Mapping[str, pulumi.Input[bool]]]:
        """
        A map of services along with the opt-in preferences for the Region.
        """
        return pulumi.get(self, "resource_type_opt_in_preference")

    @resource_type_opt_in_preference.setter
    def resource_type_opt_in_preference(self, value: pulumi.Input[Mapping[str, pulumi.Input[bool]]]):
        pulumi.set(self, "resource_type_opt_in_preference", value)

    @property
    @pulumi.getter(name="resourceTypeManagementPreference")
    def resource_type_management_preference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]:
        """
        A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
        """
        return pulumi.get(self, "resource_type_management_preference")

    @resource_type_management_preference.setter
    def resource_type_management_preference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]):
        pulumi.set(self, "resource_type_management_preference", value)


@pulumi.input_type
class _RegionSettingsState:
    def __init__(__self__, *,
                 resource_type_management_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 resource_type_opt_in_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None):
        """
        Input properties used for looking up and filtering RegionSettings resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] resource_type_management_preference: A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] resource_type_opt_in_preference: A map of services along with the opt-in preferences for the Region.
        """
        if resource_type_management_preference is not None:
            pulumi.set(__self__, "resource_type_management_preference", resource_type_management_preference)
        if resource_type_opt_in_preference is not None:
            pulumi.set(__self__, "resource_type_opt_in_preference", resource_type_opt_in_preference)

    @property
    @pulumi.getter(name="resourceTypeManagementPreference")
    def resource_type_management_preference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]:
        """
        A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
        """
        return pulumi.get(self, "resource_type_management_preference")

    @resource_type_management_preference.setter
    def resource_type_management_preference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]):
        pulumi.set(self, "resource_type_management_preference", value)

    @property
    @pulumi.getter(name="resourceTypeOptInPreference")
    def resource_type_opt_in_preference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]:
        """
        A map of services along with the opt-in preferences for the Region.
        """
        return pulumi.get(self, "resource_type_opt_in_preference")

    @resource_type_opt_in_preference.setter
    def resource_type_opt_in_preference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]):
        pulumi.set(self, "resource_type_opt_in_preference", value)


class RegionSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_type_management_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 resource_type_opt_in_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 __props__=None):
        """
        Provides an AWS Backup Region Settings resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.backup.RegionSettings("test",
            resource_type_opt_in_preference={
                "Aurora": True,
                "DocumentDB": True,
                "DynamoDB": True,
                "EBS": True,
                "EC2": True,
                "EFS": True,
                "FSx": True,
                "Neptune": True,
                "RDS": True,
                "Storage Gateway": True,
                "VirtualMachine": True,
                "CloudFormation": True,
                "Redshift": True,
                "S3": True,
                "SAP HANA on Amazon EC2": True,
            },
            resource_type_management_preference={
                "DynamoDB": True,
                "EFS": True,
            })
        ```

        ## Import

        Using `pulumi import`, import Backup Region Settings using the `region`. For example:

        ```sh
        $ pulumi import aws:backup/regionSettings:RegionSettings test us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] resource_type_management_preference: A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] resource_type_opt_in_preference: A map of services along with the opt-in preferences for the Region.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS Backup Region Settings resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.backup.RegionSettings("test",
            resource_type_opt_in_preference={
                "Aurora": True,
                "DocumentDB": True,
                "DynamoDB": True,
                "EBS": True,
                "EC2": True,
                "EFS": True,
                "FSx": True,
                "Neptune": True,
                "RDS": True,
                "Storage Gateway": True,
                "VirtualMachine": True,
                "CloudFormation": True,
                "Redshift": True,
                "S3": True,
                "SAP HANA on Amazon EC2": True,
            },
            resource_type_management_preference={
                "DynamoDB": True,
                "EFS": True,
            })
        ```

        ## Import

        Using `pulumi import`, import Backup Region Settings using the `region`. For example:

        ```sh
        $ pulumi import aws:backup/regionSettings:RegionSettings test us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param RegionSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_type_management_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 resource_type_opt_in_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionSettingsArgs.__new__(RegionSettingsArgs)

            __props__.__dict__["resource_type_management_preference"] = resource_type_management_preference
            if resource_type_opt_in_preference is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type_opt_in_preference'")
            __props__.__dict__["resource_type_opt_in_preference"] = resource_type_opt_in_preference
        super(RegionSettings, __self__).__init__(
            'aws:backup/regionSettings:RegionSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            resource_type_management_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
            resource_type_opt_in_preference: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None) -> 'RegionSettings':
        """
        Get an existing RegionSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] resource_type_management_preference: A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] resource_type_opt_in_preference: A map of services along with the opt-in preferences for the Region.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionSettingsState.__new__(_RegionSettingsState)

        __props__.__dict__["resource_type_management_preference"] = resource_type_management_preference
        __props__.__dict__["resource_type_opt_in_preference"] = resource_type_opt_in_preference
        return RegionSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="resourceTypeManagementPreference")
    def resource_type_management_preference(self) -> pulumi.Output[Mapping[str, bool]]:
        """
        A map of services along with the management preferences for the Region. For more information, see the [AWS Documentation](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html#API_UpdateRegionSettings_RequestSyntax).
        """
        return pulumi.get(self, "resource_type_management_preference")

    @property
    @pulumi.getter(name="resourceTypeOptInPreference")
    def resource_type_opt_in_preference(self) -> pulumi.Output[Mapping[str, bool]]:
        """
        A map of services along with the opt-in preferences for the Region.
        """
        return pulumi.get(self, "resource_type_opt_in_preference")

