# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ExportExport',
    'ExportExportDataQuery',
    'ExportExportDestinationConfiguration',
    'ExportExportDestinationConfigurationS3Destination',
    'ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration',
    'ExportExportRefreshCadence',
    'ExportTimeouts',
]

@pulumi.output_type
class ExportExport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataQueries":
            suggest = "data_queries"
        elif key == "destinationConfigurations":
            suggest = "destination_configurations"
        elif key == "exportArn":
            suggest = "export_arn"
        elif key == "refreshCadences":
            suggest = "refresh_cadences"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportExport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportExport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportExport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 data_queries: Optional[Sequence['outputs.ExportExportDataQuery']] = None,
                 description: Optional[str] = None,
                 destination_configurations: Optional[Sequence['outputs.ExportExportDestinationConfiguration']] = None,
                 export_arn: Optional[str] = None,
                 refresh_cadences: Optional[Sequence['outputs.ExportExportRefreshCadence']] = None):
        """
        :param str name: Name of this specific data export.
        :param Sequence['ExportExportDataQueryArgs'] data_queries: Data query for this specific data export. See the `data_query` argument reference below.
        :param str description: Description for this specific data export.
        :param Sequence['ExportExportDestinationConfigurationArgs'] destination_configurations: Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
        :param str export_arn: Amazon Resource Name (ARN) for this export.
        :param Sequence['ExportExportRefreshCadenceArgs'] refresh_cadences: Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
        """
        pulumi.set(__self__, "name", name)
        if data_queries is not None:
            pulumi.set(__self__, "data_queries", data_queries)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_configurations is not None:
            pulumi.set(__self__, "destination_configurations", destination_configurations)
        if export_arn is not None:
            pulumi.set(__self__, "export_arn", export_arn)
        if refresh_cadences is not None:
            pulumi.set(__self__, "refresh_cadences", refresh_cadences)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of this specific data export.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dataQueries")
    def data_queries(self) -> Optional[Sequence['outputs.ExportExportDataQuery']]:
        """
        Data query for this specific data export. See the `data_query` argument reference below.
        """
        return pulumi.get(self, "data_queries")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description for this specific data export.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationConfigurations")
    def destination_configurations(self) -> Optional[Sequence['outputs.ExportExportDestinationConfiguration']]:
        """
        Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
        """
        return pulumi.get(self, "destination_configurations")

    @property
    @pulumi.getter(name="exportArn")
    def export_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) for this export.
        """
        return pulumi.get(self, "export_arn")

    @property
    @pulumi.getter(name="refreshCadences")
    def refresh_cadences(self) -> Optional[Sequence['outputs.ExportExportRefreshCadence']]:
        """
        Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
        """
        return pulumi.get(self, "refresh_cadences")


@pulumi.output_type
class ExportExportDataQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStatement":
            suggest = "query_statement"
        elif key == "tableConfigurations":
            suggest = "table_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportExportDataQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportExportDataQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportExportDataQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_statement: str,
                 table_configurations: Optional[Mapping[str, Mapping[str, str]]] = None):
        """
        :param str query_statement: Query statement.
        :param Mapping[str, Mapping[str, str]] table_configurations: Table configuration.
        """
        pulumi.set(__self__, "query_statement", query_statement)
        if table_configurations is not None:
            pulumi.set(__self__, "table_configurations", table_configurations)

    @property
    @pulumi.getter(name="queryStatement")
    def query_statement(self) -> str:
        """
        Query statement.
        """
        return pulumi.get(self, "query_statement")

    @property
    @pulumi.getter(name="tableConfigurations")
    def table_configurations(self) -> Optional[Mapping[str, Mapping[str, str]]]:
        """
        Table configuration.
        """
        return pulumi.get(self, "table_configurations")


@pulumi.output_type
class ExportExportDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Destinations":
            suggest = "s3_destinations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportExportDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportExportDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportExportDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_destinations: Optional[Sequence['outputs.ExportExportDestinationConfigurationS3Destination']] = None):
        """
        :param Sequence['ExportExportDestinationConfigurationS3DestinationArgs'] s3_destinations: Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
        """
        if s3_destinations is not None:
            pulumi.set(__self__, "s3_destinations", s3_destinations)

    @property
    @pulumi.getter(name="s3Destinations")
    def s3_destinations(self) -> Optional[Sequence['outputs.ExportExportDestinationConfigurationS3Destination']]:
        """
        Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
        """
        return pulumi.get(self, "s3_destinations")


@pulumi.output_type
class ExportExportDestinationConfigurationS3Destination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Bucket":
            suggest = "s3_bucket"
        elif key == "s3Prefix":
            suggest = "s3_prefix"
        elif key == "s3Region":
            suggest = "s3_region"
        elif key == "s3OutputConfigurations":
            suggest = "s3_output_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportExportDestinationConfigurationS3Destination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportExportDestinationConfigurationS3Destination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportExportDestinationConfigurationS3Destination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket: str,
                 s3_prefix: str,
                 s3_region: str,
                 s3_output_configurations: Optional[Sequence['outputs.ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration']] = None):
        """
        :param str s3_bucket: Name of the Amazon S3 bucket used as the destination of a data export file.
        :param str s3_prefix: S3 path prefix you want prepended to the name of your data export.
        :param str s3_region: S3 bucket region.
        :param Sequence['ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs'] s3_output_configurations: Output configuration for the data export. See the `s3_output_configurations` argument reference below.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_prefix", s3_prefix)
        pulumi.set(__self__, "s3_region", s3_region)
        if s3_output_configurations is not None:
            pulumi.set(__self__, "s3_output_configurations", s3_output_configurations)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> str:
        """
        Name of the Amazon S3 bucket used as the destination of a data export file.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> str:
        """
        S3 path prefix you want prepended to the name of your data export.
        """
        return pulumi.get(self, "s3_prefix")

    @property
    @pulumi.getter(name="s3Region")
    def s3_region(self) -> str:
        """
        S3 bucket region.
        """
        return pulumi.get(self, "s3_region")

    @property
    @pulumi.getter(name="s3OutputConfigurations")
    def s3_output_configurations(self) -> Optional[Sequence['outputs.ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration']]:
        """
        Output configuration for the data export. See the `s3_output_configurations` argument reference below.
        """
        return pulumi.get(self, "s3_output_configurations")


@pulumi.output_type
class ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputType":
            suggest = "output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compression: str,
                 format: str,
                 output_type: str,
                 overwrite: str):
        """
        :param str compression: Compression type for the data export. Valid values `GZIP`, `PARQUET`.
        :param str format: File format for the data export. Valid values `TEXT_OR_CSV` or `PARQUET`.
        :param str output_type: Output type for the data export. Valid value `CUSTOM`.
        :param str overwrite: The rule to follow when generating a version of the data export file. You have the choice to overwrite the previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time. Valid values `CREATE_NEW_REPORT` or `OVERWRITE_REPORT`.
        """
        pulumi.set(__self__, "compression", compression)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "output_type", output_type)
        pulumi.set(__self__, "overwrite", overwrite)

    @property
    @pulumi.getter
    def compression(self) -> str:
        """
        Compression type for the data export. Valid values `GZIP`, `PARQUET`.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        File format for the data export. Valid values `TEXT_OR_CSV` or `PARQUET`.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> str:
        """
        Output type for the data export. Valid value `CUSTOM`.
        """
        return pulumi.get(self, "output_type")

    @property
    @pulumi.getter
    def overwrite(self) -> str:
        """
        The rule to follow when generating a version of the data export file. You have the choice to overwrite the previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time. Valid values `CREATE_NEW_REPORT` or `OVERWRITE_REPORT`.
        """
        return pulumi.get(self, "overwrite")


@pulumi.output_type
class ExportExportRefreshCadence(dict):
    def __init__(__self__, *,
                 frequency: str):
        """
        :param str frequency: Frequency that data exports are updated. The export refreshes each time the source data updates, up to three times daily. Valid values `SYNCHRONOUS`.
        """
        pulumi.set(__self__, "frequency", frequency)

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        Frequency that data exports are updated. The export refreshes each time the source data updates, up to three times daily. Valid values `SYNCHRONOUS`.
        """
        return pulumi.get(self, "frequency")


@pulumi.output_type
class ExportTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 update: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def update(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


