# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentAgentActionGroupArgs', 'AgentAgentActionGroup']

@pulumi.input_type
class AgentAgentActionGroupArgs:
    def __init__(__self__, *,
                 action_group_name: pulumi.Input[str],
                 agent_id: pulumi.Input[str],
                 agent_version: pulumi.Input[str],
                 action_group_executor: Optional[pulumi.Input['AgentAgentActionGroupActionGroupExecutorArgs']] = None,
                 action_group_state: Optional[pulumi.Input[str]] = None,
                 api_schema: Optional[pulumi.Input['AgentAgentActionGroupApiSchemaArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 function_schema: Optional[pulumi.Input['AgentAgentActionGroupFunctionSchemaArgs']] = None,
                 parent_action_group_signature: Optional[pulumi.Input[str]] = None,
                 prepare_agent: Optional[pulumi.Input[bool]] = None,
                 skip_resource_in_use_check: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input['AgentAgentActionGroupTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AgentAgentActionGroup resource.
        :param pulumi.Input[str] action_group_name: Name of the action group.
        :param pulumi.Input[str] agent_id: The unique identifier of the agent for which to create the action group.
        :param pulumi.Input[str] agent_version: Version of the agent for which to create the action group. Valid values: `DRAFT`.
        :param pulumi.Input['AgentAgentActionGroupActionGroupExecutorArgs'] action_group_executor: ARN of the Lambda function containing the business logic that is carried out upon invoking the action or custom control method for handling the information elicited from the user. See `action_group_executor` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[str] action_group_state: Whether the action group is available for the agent to invoke or not when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request. Valid values: `ENABLED`, `DISABLED`.
        :param pulumi.Input['AgentAgentActionGroupApiSchemaArgs'] api_schema: Either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see [Action group OpenAPI schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html). See `api_schema` Block for details.
        :param pulumi.Input[str] description: Description of the action group.
        :param pulumi.Input['AgentAgentActionGroupFunctionSchemaArgs'] function_schema: Describes the function schema for the action group.
               Each function represents an action in an action group.
               See `function_schema` Block for details.
        :param pulumi.Input[str] parent_action_group_signature: To allow your agent to request the user for additional information when trying to complete a task, set this argument to `AMAZON.UserInput`. You must leave the `description`, `api_schema`, and `action_group_executor` arguments blank for this action group. Valid values: `AMAZON.UserInput`.
        :param pulumi.Input[bool] prepare_agent: Whether or not to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[bool] skip_resource_in_use_check: Whether the in-use check is skipped when deleting the action group.
        """
        pulumi.set(__self__, "action_group_name", action_group_name)
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "agent_version", agent_version)
        if action_group_executor is not None:
            pulumi.set(__self__, "action_group_executor", action_group_executor)
        if action_group_state is not None:
            pulumi.set(__self__, "action_group_state", action_group_state)
        if api_schema is not None:
            pulumi.set(__self__, "api_schema", api_schema)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if function_schema is not None:
            pulumi.set(__self__, "function_schema", function_schema)
        if parent_action_group_signature is not None:
            pulumi.set(__self__, "parent_action_group_signature", parent_action_group_signature)
        if prepare_agent is not None:
            pulumi.set(__self__, "prepare_agent", prepare_agent)
        if skip_resource_in_use_check is not None:
            pulumi.set(__self__, "skip_resource_in_use_check", skip_resource_in_use_check)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="actionGroupName")
    def action_group_name(self) -> pulumi.Input[str]:
        """
        Name of the action group.
        """
        return pulumi.get(self, "action_group_name")

    @action_group_name.setter
    def action_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_group_name", value)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[str]:
        """
        The unique identifier of the agent for which to create the action group.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Input[str]:
        """
        Version of the agent for which to create the action group. Valid values: `DRAFT`.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "agent_version", value)

    @property
    @pulumi.getter(name="actionGroupExecutor")
    def action_group_executor(self) -> Optional[pulumi.Input['AgentAgentActionGroupActionGroupExecutorArgs']]:
        """
        ARN of the Lambda function containing the business logic that is carried out upon invoking the action or custom control method for handling the information elicited from the user. See `action_group_executor` Block for details.

        The following arguments are optional:
        """
        return pulumi.get(self, "action_group_executor")

    @action_group_executor.setter
    def action_group_executor(self, value: Optional[pulumi.Input['AgentAgentActionGroupActionGroupExecutorArgs']]):
        pulumi.set(self, "action_group_executor", value)

    @property
    @pulumi.getter(name="actionGroupState")
    def action_group_state(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the action group is available for the agent to invoke or not when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "action_group_state")

    @action_group_state.setter
    def action_group_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_group_state", value)

    @property
    @pulumi.getter(name="apiSchema")
    def api_schema(self) -> Optional[pulumi.Input['AgentAgentActionGroupApiSchemaArgs']]:
        """
        Either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see [Action group OpenAPI schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html). See `api_schema` Block for details.
        """
        return pulumi.get(self, "api_schema")

    @api_schema.setter
    def api_schema(self, value: Optional[pulumi.Input['AgentAgentActionGroupApiSchemaArgs']]):
        pulumi.set(self, "api_schema", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the action group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="functionSchema")
    def function_schema(self) -> Optional[pulumi.Input['AgentAgentActionGroupFunctionSchemaArgs']]:
        """
        Describes the function schema for the action group.
        Each function represents an action in an action group.
        See `function_schema` Block for details.
        """
        return pulumi.get(self, "function_schema")

    @function_schema.setter
    def function_schema(self, value: Optional[pulumi.Input['AgentAgentActionGroupFunctionSchemaArgs']]):
        pulumi.set(self, "function_schema", value)

    @property
    @pulumi.getter(name="parentActionGroupSignature")
    def parent_action_group_signature(self) -> Optional[pulumi.Input[str]]:
        """
        To allow your agent to request the user for additional information when trying to complete a task, set this argument to `AMAZON.UserInput`. You must leave the `description`, `api_schema`, and `action_group_executor` arguments blank for this action group. Valid values: `AMAZON.UserInput`.
        """
        return pulumi.get(self, "parent_action_group_signature")

    @parent_action_group_signature.setter
    def parent_action_group_signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_action_group_signature", value)

    @property
    @pulumi.getter(name="prepareAgent")
    def prepare_agent(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to prepare the agent after creation or modification. Defaults to `true`.
        """
        return pulumi.get(self, "prepare_agent")

    @prepare_agent.setter
    def prepare_agent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prepare_agent", value)

    @property
    @pulumi.getter(name="skipResourceInUseCheck")
    def skip_resource_in_use_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the in-use check is skipped when deleting the action group.
        """
        return pulumi.get(self, "skip_resource_in_use_check")

    @skip_resource_in_use_check.setter
    def skip_resource_in_use_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_resource_in_use_check", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentAgentActionGroupTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentAgentActionGroupTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AgentAgentActionGroupState:
    def __init__(__self__, *,
                 action_group_executor: Optional[pulumi.Input['AgentAgentActionGroupActionGroupExecutorArgs']] = None,
                 action_group_id: Optional[pulumi.Input[str]] = None,
                 action_group_name: Optional[pulumi.Input[str]] = None,
                 action_group_state: Optional[pulumi.Input[str]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 api_schema: Optional[pulumi.Input['AgentAgentActionGroupApiSchemaArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 function_schema: Optional[pulumi.Input['AgentAgentActionGroupFunctionSchemaArgs']] = None,
                 parent_action_group_signature: Optional[pulumi.Input[str]] = None,
                 prepare_agent: Optional[pulumi.Input[bool]] = None,
                 skip_resource_in_use_check: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input['AgentAgentActionGroupTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering AgentAgentActionGroup resources.
        :param pulumi.Input['AgentAgentActionGroupActionGroupExecutorArgs'] action_group_executor: ARN of the Lambda function containing the business logic that is carried out upon invoking the action or custom control method for handling the information elicited from the user. See `action_group_executor` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[str] action_group_id: Unique identifier of the action group.
        :param pulumi.Input[str] action_group_name: Name of the action group.
        :param pulumi.Input[str] action_group_state: Whether the action group is available for the agent to invoke or not when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request. Valid values: `ENABLED`, `DISABLED`.
        :param pulumi.Input[str] agent_id: The unique identifier of the agent for which to create the action group.
        :param pulumi.Input[str] agent_version: Version of the agent for which to create the action group. Valid values: `DRAFT`.
        :param pulumi.Input['AgentAgentActionGroupApiSchemaArgs'] api_schema: Either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see [Action group OpenAPI schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html). See `api_schema` Block for details.
        :param pulumi.Input[str] description: Description of the action group.
        :param pulumi.Input['AgentAgentActionGroupFunctionSchemaArgs'] function_schema: Describes the function schema for the action group.
               Each function represents an action in an action group.
               See `function_schema` Block for details.
        :param pulumi.Input[str] parent_action_group_signature: To allow your agent to request the user for additional information when trying to complete a task, set this argument to `AMAZON.UserInput`. You must leave the `description`, `api_schema`, and `action_group_executor` arguments blank for this action group. Valid values: `AMAZON.UserInput`.
        :param pulumi.Input[bool] prepare_agent: Whether or not to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[bool] skip_resource_in_use_check: Whether the in-use check is skipped when deleting the action group.
        """
        if action_group_executor is not None:
            pulumi.set(__self__, "action_group_executor", action_group_executor)
        if action_group_id is not None:
            pulumi.set(__self__, "action_group_id", action_group_id)
        if action_group_name is not None:
            pulumi.set(__self__, "action_group_name", action_group_name)
        if action_group_state is not None:
            pulumi.set(__self__, "action_group_state", action_group_state)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if api_schema is not None:
            pulumi.set(__self__, "api_schema", api_schema)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if function_schema is not None:
            pulumi.set(__self__, "function_schema", function_schema)
        if parent_action_group_signature is not None:
            pulumi.set(__self__, "parent_action_group_signature", parent_action_group_signature)
        if prepare_agent is not None:
            pulumi.set(__self__, "prepare_agent", prepare_agent)
        if skip_resource_in_use_check is not None:
            pulumi.set(__self__, "skip_resource_in_use_check", skip_resource_in_use_check)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="actionGroupExecutor")
    def action_group_executor(self) -> Optional[pulumi.Input['AgentAgentActionGroupActionGroupExecutorArgs']]:
        """
        ARN of the Lambda function containing the business logic that is carried out upon invoking the action or custom control method for handling the information elicited from the user. See `action_group_executor` Block for details.

        The following arguments are optional:
        """
        return pulumi.get(self, "action_group_executor")

    @action_group_executor.setter
    def action_group_executor(self, value: Optional[pulumi.Input['AgentAgentActionGroupActionGroupExecutorArgs']]):
        pulumi.set(self, "action_group_executor", value)

    @property
    @pulumi.getter(name="actionGroupId")
    def action_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the action group.
        """
        return pulumi.get(self, "action_group_id")

    @action_group_id.setter
    def action_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_group_id", value)

    @property
    @pulumi.getter(name="actionGroupName")
    def action_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the action group.
        """
        return pulumi.get(self, "action_group_name")

    @action_group_name.setter
    def action_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_group_name", value)

    @property
    @pulumi.getter(name="actionGroupState")
    def action_group_state(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the action group is available for the agent to invoke or not when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "action_group_state")

    @action_group_state.setter
    def action_group_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_group_state", value)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the agent for which to create the action group.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the agent for which to create the action group. Valid values: `DRAFT`.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_version", value)

    @property
    @pulumi.getter(name="apiSchema")
    def api_schema(self) -> Optional[pulumi.Input['AgentAgentActionGroupApiSchemaArgs']]:
        """
        Either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see [Action group OpenAPI schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html). See `api_schema` Block for details.
        """
        return pulumi.get(self, "api_schema")

    @api_schema.setter
    def api_schema(self, value: Optional[pulumi.Input['AgentAgentActionGroupApiSchemaArgs']]):
        pulumi.set(self, "api_schema", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the action group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="functionSchema")
    def function_schema(self) -> Optional[pulumi.Input['AgentAgentActionGroupFunctionSchemaArgs']]:
        """
        Describes the function schema for the action group.
        Each function represents an action in an action group.
        See `function_schema` Block for details.
        """
        return pulumi.get(self, "function_schema")

    @function_schema.setter
    def function_schema(self, value: Optional[pulumi.Input['AgentAgentActionGroupFunctionSchemaArgs']]):
        pulumi.set(self, "function_schema", value)

    @property
    @pulumi.getter(name="parentActionGroupSignature")
    def parent_action_group_signature(self) -> Optional[pulumi.Input[str]]:
        """
        To allow your agent to request the user for additional information when trying to complete a task, set this argument to `AMAZON.UserInput`. You must leave the `description`, `api_schema`, and `action_group_executor` arguments blank for this action group. Valid values: `AMAZON.UserInput`.
        """
        return pulumi.get(self, "parent_action_group_signature")

    @parent_action_group_signature.setter
    def parent_action_group_signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_action_group_signature", value)

    @property
    @pulumi.getter(name="prepareAgent")
    def prepare_agent(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to prepare the agent after creation or modification. Defaults to `true`.
        """
        return pulumi.get(self, "prepare_agent")

    @prepare_agent.setter
    def prepare_agent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prepare_agent", value)

    @property
    @pulumi.getter(name="skipResourceInUseCheck")
    def skip_resource_in_use_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the in-use check is skipped when deleting the action group.
        """
        return pulumi.get(self, "skip_resource_in_use_check")

    @skip_resource_in_use_check.setter
    def skip_resource_in_use_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_resource_in_use_check", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentAgentActionGroupTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentAgentActionGroupTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class AgentAgentActionGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_group_executor: Optional[pulumi.Input[Union['AgentAgentActionGroupActionGroupExecutorArgs', 'AgentAgentActionGroupActionGroupExecutorArgsDict']]] = None,
                 action_group_name: Optional[pulumi.Input[str]] = None,
                 action_group_state: Optional[pulumi.Input[str]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 api_schema: Optional[pulumi.Input[Union['AgentAgentActionGroupApiSchemaArgs', 'AgentAgentActionGroupApiSchemaArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 function_schema: Optional[pulumi.Input[Union['AgentAgentActionGroupFunctionSchemaArgs', 'AgentAgentActionGroupFunctionSchemaArgsDict']]] = None,
                 parent_action_group_signature: Optional[pulumi.Input[str]] = None,
                 prepare_agent: Optional[pulumi.Input[bool]] = None,
                 skip_resource_in_use_check: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentAgentActionGroupTimeoutsArgs', 'AgentAgentActionGroupTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Agents for Amazon Bedrock Agent Action Group.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.bedrock.AgentAgentActionGroup("example",
            action_group_name="example",
            agent_id="GGRRAED6JP",
            agent_version="DRAFT",
            skip_resource_in_use_check=True,
            action_group_executor={
                "lambda_": "arn:aws:lambda:us-west-2:123456789012:function:example-function",
            },
            api_schema={
                "payload": std.file(input="path/to/schema.yaml").result,
            })
        ```

        ### API Schema in S3 Bucket

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentAgentActionGroup("example",
            action_group_name="example",
            agent_id="GGRRAED6JP",
            agent_version="DRAFT",
            skip_resource_in_use_check=True,
            action_group_executor={
                "lambda_": "arn:aws:lambda:us-west-2:123456789012:function:example-function",
            },
            api_schema={
                "s3": {
                    "s3_bucket_name": "example-bucket",
                    "s3_object_key": "path/to/schema.json",
                },
            })
        ```

        ### Function Schema (Simplified Schema)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentAgentActionGroup("example",
            action_group_name="example",
            agent_id="GGRRAED6JP",
            agent_version="DRAFT",
            skip_resource_in_use_check=True,
            action_group_executor={
                "lambda_": "arn:aws:lambda:us-west-2:123456789012:function:example-function",
            },
            function_schema={
                "member_functions": {
                    "functions": [{
                        "name": "example-function",
                        "description": "Example function",
                        "parameters": [
                            {
                                "map_block_key": "param1",
                                "type": "string",
                                "description": "The first parameter",
                                "required": True,
                            },
                            {
                                "map_block_key": "param2",
                                "type": "integer",
                                "description": "The second parameter",
                                "required": False,
                            },
                        ],
                    }],
                },
            })
        ```

        ### Return of Control

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.bedrock.AgentAgentActionGroup("example",
            action_group_name="example",
            agent_id="GGRRAED6JP",
            agent_version="DRAFT",
            skip_resource_in_use_check=True,
            action_group_executor={
                "custom_control": "RETURN_CONTROL",
            },
            api_schema={
                "payload": std.file(input="path/to/schema.yaml").result,
            })
        ```

        ## Import

        Using `pulumi import`, import Agents for Amazon Bedrock Agent Action Group the action group ID, the agent ID, and the agent version separated by `,`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentAgentActionGroup:AgentAgentActionGroup example MMAUDBZTH4,GGRRAED6JP,DRAFT
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AgentAgentActionGroupActionGroupExecutorArgs', 'AgentAgentActionGroupActionGroupExecutorArgsDict']] action_group_executor: ARN of the Lambda function containing the business logic that is carried out upon invoking the action or custom control method for handling the information elicited from the user. See `action_group_executor` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[str] action_group_name: Name of the action group.
        :param pulumi.Input[str] action_group_state: Whether the action group is available for the agent to invoke or not when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request. Valid values: `ENABLED`, `DISABLED`.
        :param pulumi.Input[str] agent_id: The unique identifier of the agent for which to create the action group.
        :param pulumi.Input[str] agent_version: Version of the agent for which to create the action group. Valid values: `DRAFT`.
        :param pulumi.Input[Union['AgentAgentActionGroupApiSchemaArgs', 'AgentAgentActionGroupApiSchemaArgsDict']] api_schema: Either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see [Action group OpenAPI schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html). See `api_schema` Block for details.
        :param pulumi.Input[str] description: Description of the action group.
        :param pulumi.Input[Union['AgentAgentActionGroupFunctionSchemaArgs', 'AgentAgentActionGroupFunctionSchemaArgsDict']] function_schema: Describes the function schema for the action group.
               Each function represents an action in an action group.
               See `function_schema` Block for details.
        :param pulumi.Input[str] parent_action_group_signature: To allow your agent to request the user for additional information when trying to complete a task, set this argument to `AMAZON.UserInput`. You must leave the `description`, `api_schema`, and `action_group_executor` arguments blank for this action group. Valid values: `AMAZON.UserInput`.
        :param pulumi.Input[bool] prepare_agent: Whether or not to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[bool] skip_resource_in_use_check: Whether the in-use check is skipped when deleting the action group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentAgentActionGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Agents for Amazon Bedrock Agent Action Group.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.bedrock.AgentAgentActionGroup("example",
            action_group_name="example",
            agent_id="GGRRAED6JP",
            agent_version="DRAFT",
            skip_resource_in_use_check=True,
            action_group_executor={
                "lambda_": "arn:aws:lambda:us-west-2:123456789012:function:example-function",
            },
            api_schema={
                "payload": std.file(input="path/to/schema.yaml").result,
            })
        ```

        ### API Schema in S3 Bucket

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentAgentActionGroup("example",
            action_group_name="example",
            agent_id="GGRRAED6JP",
            agent_version="DRAFT",
            skip_resource_in_use_check=True,
            action_group_executor={
                "lambda_": "arn:aws:lambda:us-west-2:123456789012:function:example-function",
            },
            api_schema={
                "s3": {
                    "s3_bucket_name": "example-bucket",
                    "s3_object_key": "path/to/schema.json",
                },
            })
        ```

        ### Function Schema (Simplified Schema)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentAgentActionGroup("example",
            action_group_name="example",
            agent_id="GGRRAED6JP",
            agent_version="DRAFT",
            skip_resource_in_use_check=True,
            action_group_executor={
                "lambda_": "arn:aws:lambda:us-west-2:123456789012:function:example-function",
            },
            function_schema={
                "member_functions": {
                    "functions": [{
                        "name": "example-function",
                        "description": "Example function",
                        "parameters": [
                            {
                                "map_block_key": "param1",
                                "type": "string",
                                "description": "The first parameter",
                                "required": True,
                            },
                            {
                                "map_block_key": "param2",
                                "type": "integer",
                                "description": "The second parameter",
                                "required": False,
                            },
                        ],
                    }],
                },
            })
        ```

        ### Return of Control

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.bedrock.AgentAgentActionGroup("example",
            action_group_name="example",
            agent_id="GGRRAED6JP",
            agent_version="DRAFT",
            skip_resource_in_use_check=True,
            action_group_executor={
                "custom_control": "RETURN_CONTROL",
            },
            api_schema={
                "payload": std.file(input="path/to/schema.yaml").result,
            })
        ```

        ## Import

        Using `pulumi import`, import Agents for Amazon Bedrock Agent Action Group the action group ID, the agent ID, and the agent version separated by `,`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentAgentActionGroup:AgentAgentActionGroup example MMAUDBZTH4,GGRRAED6JP,DRAFT
        ```

        :param str resource_name: The name of the resource.
        :param AgentAgentActionGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentAgentActionGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_group_executor: Optional[pulumi.Input[Union['AgentAgentActionGroupActionGroupExecutorArgs', 'AgentAgentActionGroupActionGroupExecutorArgsDict']]] = None,
                 action_group_name: Optional[pulumi.Input[str]] = None,
                 action_group_state: Optional[pulumi.Input[str]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 api_schema: Optional[pulumi.Input[Union['AgentAgentActionGroupApiSchemaArgs', 'AgentAgentActionGroupApiSchemaArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 function_schema: Optional[pulumi.Input[Union['AgentAgentActionGroupFunctionSchemaArgs', 'AgentAgentActionGroupFunctionSchemaArgsDict']]] = None,
                 parent_action_group_signature: Optional[pulumi.Input[str]] = None,
                 prepare_agent: Optional[pulumi.Input[bool]] = None,
                 skip_resource_in_use_check: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentAgentActionGroupTimeoutsArgs', 'AgentAgentActionGroupTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentAgentActionGroupArgs.__new__(AgentAgentActionGroupArgs)

            __props__.__dict__["action_group_executor"] = action_group_executor
            if action_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'action_group_name'")
            __props__.__dict__["action_group_name"] = action_group_name
            __props__.__dict__["action_group_state"] = action_group_state
            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            if agent_version is None and not opts.urn:
                raise TypeError("Missing required property 'agent_version'")
            __props__.__dict__["agent_version"] = agent_version
            __props__.__dict__["api_schema"] = api_schema
            __props__.__dict__["description"] = description
            __props__.__dict__["function_schema"] = function_schema
            __props__.__dict__["parent_action_group_signature"] = parent_action_group_signature
            __props__.__dict__["prepare_agent"] = prepare_agent
            __props__.__dict__["skip_resource_in_use_check"] = skip_resource_in_use_check
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["action_group_id"] = None
        super(AgentAgentActionGroup, __self__).__init__(
            'aws:bedrock/agentAgentActionGroup:AgentAgentActionGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_group_executor: Optional[pulumi.Input[Union['AgentAgentActionGroupActionGroupExecutorArgs', 'AgentAgentActionGroupActionGroupExecutorArgsDict']]] = None,
            action_group_id: Optional[pulumi.Input[str]] = None,
            action_group_name: Optional[pulumi.Input[str]] = None,
            action_group_state: Optional[pulumi.Input[str]] = None,
            agent_id: Optional[pulumi.Input[str]] = None,
            agent_version: Optional[pulumi.Input[str]] = None,
            api_schema: Optional[pulumi.Input[Union['AgentAgentActionGroupApiSchemaArgs', 'AgentAgentActionGroupApiSchemaArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            function_schema: Optional[pulumi.Input[Union['AgentAgentActionGroupFunctionSchemaArgs', 'AgentAgentActionGroupFunctionSchemaArgsDict']]] = None,
            parent_action_group_signature: Optional[pulumi.Input[str]] = None,
            prepare_agent: Optional[pulumi.Input[bool]] = None,
            skip_resource_in_use_check: Optional[pulumi.Input[bool]] = None,
            timeouts: Optional[pulumi.Input[Union['AgentAgentActionGroupTimeoutsArgs', 'AgentAgentActionGroupTimeoutsArgsDict']]] = None) -> 'AgentAgentActionGroup':
        """
        Get an existing AgentAgentActionGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AgentAgentActionGroupActionGroupExecutorArgs', 'AgentAgentActionGroupActionGroupExecutorArgsDict']] action_group_executor: ARN of the Lambda function containing the business logic that is carried out upon invoking the action or custom control method for handling the information elicited from the user. See `action_group_executor` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[str] action_group_id: Unique identifier of the action group.
        :param pulumi.Input[str] action_group_name: Name of the action group.
        :param pulumi.Input[str] action_group_state: Whether the action group is available for the agent to invoke or not when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request. Valid values: `ENABLED`, `DISABLED`.
        :param pulumi.Input[str] agent_id: The unique identifier of the agent for which to create the action group.
        :param pulumi.Input[str] agent_version: Version of the agent for which to create the action group. Valid values: `DRAFT`.
        :param pulumi.Input[Union['AgentAgentActionGroupApiSchemaArgs', 'AgentAgentActionGroupApiSchemaArgsDict']] api_schema: Either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see [Action group OpenAPI schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html). See `api_schema` Block for details.
        :param pulumi.Input[str] description: Description of the action group.
        :param pulumi.Input[Union['AgentAgentActionGroupFunctionSchemaArgs', 'AgentAgentActionGroupFunctionSchemaArgsDict']] function_schema: Describes the function schema for the action group.
               Each function represents an action in an action group.
               See `function_schema` Block for details.
        :param pulumi.Input[str] parent_action_group_signature: To allow your agent to request the user for additional information when trying to complete a task, set this argument to `AMAZON.UserInput`. You must leave the `description`, `api_schema`, and `action_group_executor` arguments blank for this action group. Valid values: `AMAZON.UserInput`.
        :param pulumi.Input[bool] prepare_agent: Whether or not to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[bool] skip_resource_in_use_check: Whether the in-use check is skipped when deleting the action group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentAgentActionGroupState.__new__(_AgentAgentActionGroupState)

        __props__.__dict__["action_group_executor"] = action_group_executor
        __props__.__dict__["action_group_id"] = action_group_id
        __props__.__dict__["action_group_name"] = action_group_name
        __props__.__dict__["action_group_state"] = action_group_state
        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["agent_version"] = agent_version
        __props__.__dict__["api_schema"] = api_schema
        __props__.__dict__["description"] = description
        __props__.__dict__["function_schema"] = function_schema
        __props__.__dict__["parent_action_group_signature"] = parent_action_group_signature
        __props__.__dict__["prepare_agent"] = prepare_agent
        __props__.__dict__["skip_resource_in_use_check"] = skip_resource_in_use_check
        __props__.__dict__["timeouts"] = timeouts
        return AgentAgentActionGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionGroupExecutor")
    def action_group_executor(self) -> pulumi.Output[Optional['outputs.AgentAgentActionGroupActionGroupExecutor']]:
        """
        ARN of the Lambda function containing the business logic that is carried out upon invoking the action or custom control method for handling the information elicited from the user. See `action_group_executor` Block for details.

        The following arguments are optional:
        """
        return pulumi.get(self, "action_group_executor")

    @property
    @pulumi.getter(name="actionGroupId")
    def action_group_id(self) -> pulumi.Output[str]:
        """
        Unique identifier of the action group.
        """
        return pulumi.get(self, "action_group_id")

    @property
    @pulumi.getter(name="actionGroupName")
    def action_group_name(self) -> pulumi.Output[str]:
        """
        Name of the action group.
        """
        return pulumi.get(self, "action_group_name")

    @property
    @pulumi.getter(name="actionGroupState")
    def action_group_state(self) -> pulumi.Output[str]:
        """
        Whether the action group is available for the agent to invoke or not when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "action_group_state")

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[str]:
        """
        The unique identifier of the agent for which to create the action group.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[str]:
        """
        Version of the agent for which to create the action group. Valid values: `DRAFT`.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="apiSchema")
    def api_schema(self) -> pulumi.Output[Optional['outputs.AgentAgentActionGroupApiSchema']]:
        """
        Either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see [Action group OpenAPI schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html). See `api_schema` Block for details.
        """
        return pulumi.get(self, "api_schema")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the action group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="functionSchema")
    def function_schema(self) -> pulumi.Output[Optional['outputs.AgentAgentActionGroupFunctionSchema']]:
        """
        Describes the function schema for the action group.
        Each function represents an action in an action group.
        See `function_schema` Block for details.
        """
        return pulumi.get(self, "function_schema")

    @property
    @pulumi.getter(name="parentActionGroupSignature")
    def parent_action_group_signature(self) -> pulumi.Output[Optional[str]]:
        """
        To allow your agent to request the user for additional information when trying to complete a task, set this argument to `AMAZON.UserInput`. You must leave the `description`, `api_schema`, and `action_group_executor` arguments blank for this action group. Valid values: `AMAZON.UserInput`.
        """
        return pulumi.get(self, "parent_action_group_signature")

    @property
    @pulumi.getter(name="prepareAgent")
    def prepare_agent(self) -> pulumi.Output[bool]:
        """
        Whether or not to prepare the agent after creation or modification. Defaults to `true`.
        """
        return pulumi.get(self, "prepare_agent")

    @property
    @pulumi.getter(name="skipResourceInUseCheck")
    def skip_resource_in_use_check(self) -> pulumi.Output[bool]:
        """
        Whether the in-use check is skipped when deleting the action group.
        """
        return pulumi.get(self, "skip_resource_in_use_check")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AgentAgentActionGroupTimeouts']]:
        return pulumi.get(self, "timeouts")

