# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GuardrailVersionArgs', 'GuardrailVersion']

@pulumi.input_type
class GuardrailVersionArgs:
    def __init__(__self__, *,
                 guardrail_arn: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 skip_destroy: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input['GuardrailVersionTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a GuardrailVersion resource.
        :param pulumi.Input[str] guardrail_arn: Guardrail ARN.
               
               The following arguments are optional:
        :param pulumi.Input[str] description: Description of the Guardrail version.
        :param pulumi.Input[bool] skip_destroy: Whether to retain the old version of a previously deployed Guardrail. Default is `false`
        """
        pulumi.set(__self__, "guardrail_arn", guardrail_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="guardrailArn")
    def guardrail_arn(self) -> pulumi.Input[str]:
        """
        Guardrail ARN.

        The following arguments are optional:
        """
        return pulumi.get(self, "guardrail_arn")

    @guardrail_arn.setter
    def guardrail_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "guardrail_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Guardrail version.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to retain the old version of a previously deployed Guardrail. Default is `false`
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_destroy", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['GuardrailVersionTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['GuardrailVersionTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _GuardrailVersionState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 guardrail_arn: Optional[pulumi.Input[str]] = None,
                 skip_destroy: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input['GuardrailVersionTimeoutsArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GuardrailVersion resources.
        :param pulumi.Input[str] description: Description of the Guardrail version.
        :param pulumi.Input[str] guardrail_arn: Guardrail ARN.
               
               The following arguments are optional:
        :param pulumi.Input[bool] skip_destroy: Whether to retain the old version of a previously deployed Guardrail. Default is `false`
        :param pulumi.Input[str] version: Guardrail version.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if guardrail_arn is not None:
            pulumi.set(__self__, "guardrail_arn", guardrail_arn)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Guardrail version.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="guardrailArn")
    def guardrail_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Guardrail ARN.

        The following arguments are optional:
        """
        return pulumi.get(self, "guardrail_arn")

    @guardrail_arn.setter
    def guardrail_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guardrail_arn", value)

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to retain the old version of a previously deployed Guardrail. Default is `false`
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_destroy", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['GuardrailVersionTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['GuardrailVersionTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Guardrail version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class GuardrailVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 guardrail_arn: Optional[pulumi.Input[str]] = None,
                 skip_destroy: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['GuardrailVersionTimeoutsArgs', 'GuardrailVersionTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Bedrock Guardrail Version.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.GuardrailVersion("example",
            description="example",
            guardrail_arn=test["guardrailArn"],
            skip_destroy=True)
        ```

        ## Import

        Using `pulumi import`, import Amazon Bedrock Guardrail Version using using a comma-delimited string of `guardrail_arn` and `version`. For example:

        ```sh
        $ pulumi import aws:bedrock/guardrailVersion:GuardrailVersion example arn:aws:bedrock:us-west-2:123456789012:guardrail-id-12345678,1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the Guardrail version.
        :param pulumi.Input[str] guardrail_arn: Guardrail ARN.
               
               The following arguments are optional:
        :param pulumi.Input[bool] skip_destroy: Whether to retain the old version of a previously deployed Guardrail. Default is `false`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GuardrailVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Bedrock Guardrail Version.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.GuardrailVersion("example",
            description="example",
            guardrail_arn=test["guardrailArn"],
            skip_destroy=True)
        ```

        ## Import

        Using `pulumi import`, import Amazon Bedrock Guardrail Version using using a comma-delimited string of `guardrail_arn` and `version`. For example:

        ```sh
        $ pulumi import aws:bedrock/guardrailVersion:GuardrailVersion example arn:aws:bedrock:us-west-2:123456789012:guardrail-id-12345678,1
        ```

        :param str resource_name: The name of the resource.
        :param GuardrailVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GuardrailVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 guardrail_arn: Optional[pulumi.Input[str]] = None,
                 skip_destroy: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['GuardrailVersionTimeoutsArgs', 'GuardrailVersionTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GuardrailVersionArgs.__new__(GuardrailVersionArgs)

            __props__.__dict__["description"] = description
            if guardrail_arn is None and not opts.urn:
                raise TypeError("Missing required property 'guardrail_arn'")
            __props__.__dict__["guardrail_arn"] = guardrail_arn
            __props__.__dict__["skip_destroy"] = skip_destroy
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["version"] = None
        super(GuardrailVersion, __self__).__init__(
            'aws:bedrock/guardrailVersion:GuardrailVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            guardrail_arn: Optional[pulumi.Input[str]] = None,
            skip_destroy: Optional[pulumi.Input[bool]] = None,
            timeouts: Optional[pulumi.Input[Union['GuardrailVersionTimeoutsArgs', 'GuardrailVersionTimeoutsArgsDict']]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'GuardrailVersion':
        """
        Get an existing GuardrailVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the Guardrail version.
        :param pulumi.Input[str] guardrail_arn: Guardrail ARN.
               
               The following arguments are optional:
        :param pulumi.Input[bool] skip_destroy: Whether to retain the old version of a previously deployed Guardrail. Default is `false`
        :param pulumi.Input[str] version: Guardrail version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GuardrailVersionState.__new__(_GuardrailVersionState)

        __props__.__dict__["description"] = description
        __props__.__dict__["guardrail_arn"] = guardrail_arn
        __props__.__dict__["skip_destroy"] = skip_destroy
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["version"] = version
        return GuardrailVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the Guardrail version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="guardrailArn")
    def guardrail_arn(self) -> pulumi.Output[str]:
        """
        Guardrail ARN.

        The following arguments are optional:
        """
        return pulumi.get(self, "guardrail_arn")

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to retain the old version of a previously deployed Guardrail. Default is `false`
        """
        return pulumi.get(self, "skip_destroy")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.GuardrailVersionTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Guardrail version.
        """
        return pulumi.get(self, "version")

