# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BudgetActionArgs', 'BudgetAction']

@pulumi.input_type
class BudgetActionArgs:
    def __init__(__self__, *,
                 action_threshold: pulumi.Input['BudgetActionActionThresholdArgs'],
                 action_type: pulumi.Input[str],
                 approval_model: pulumi.Input[str],
                 budget_name: pulumi.Input[str],
                 definition: pulumi.Input['BudgetActionDefinitionArgs'],
                 execution_role_arn: pulumi.Input[str],
                 notification_type: pulumi.Input[str],
                 subscribers: pulumi.Input[Sequence[pulumi.Input['BudgetActionSubscriberArgs']]],
                 account_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a BudgetAction resource.
        :param pulumi.Input['BudgetActionActionThresholdArgs'] action_threshold: The trigger threshold of the action. See Action Threshold.
        :param pulumi.Input[str] action_type: The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
        :param pulumi.Input[str] approval_model: This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
        :param pulumi.Input[str] budget_name: The name of a budget.
        :param pulumi.Input['BudgetActionDefinitionArgs'] definition: Specifies all of the type-specific parameters. See Definition.
        :param pulumi.Input[str] execution_role_arn: The role passed for action execution and reversion. Roles and actions must be in the same account.
        :param pulumi.Input[str] notification_type: The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetActionSubscriberArgs']]] subscribers: A list of subscribers. See Subscriber.
        :param pulumi.Input[str] account_id: The ID of the target account for budget. Will use current user's account_id by default if omitted.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "action_threshold", action_threshold)
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "approval_model", approval_model)
        pulumi.set(__self__, "budget_name", budget_name)
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        pulumi.set(__self__, "notification_type", notification_type)
        pulumi.set(__self__, "subscribers", subscribers)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="actionThreshold")
    def action_threshold(self) -> pulumi.Input['BudgetActionActionThresholdArgs']:
        """
        The trigger threshold of the action. See Action Threshold.
        """
        return pulumi.get(self, "action_threshold")

    @action_threshold.setter
    def action_threshold(self, value: pulumi.Input['BudgetActionActionThresholdArgs']):
        pulumi.set(self, "action_threshold", value)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """
        The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="approvalModel")
    def approval_model(self) -> pulumi.Input[str]:
        """
        This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
        """
        return pulumi.get(self, "approval_model")

    @approval_model.setter
    def approval_model(self, value: pulumi.Input[str]):
        pulumi.set(self, "approval_model", value)

    @property
    @pulumi.getter(name="budgetName")
    def budget_name(self) -> pulumi.Input[str]:
        """
        The name of a budget.
        """
        return pulumi.get(self, "budget_name")

    @budget_name.setter
    def budget_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "budget_name", value)

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Input['BudgetActionDefinitionArgs']:
        """
        Specifies all of the type-specific parameters. See Definition.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: pulumi.Input['BudgetActionDefinitionArgs']):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Input[str]:
        """
        The role passed for action execution and reversion. Roles and actions must be in the same account.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> pulumi.Input[str]:
        """
        The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
        """
        return pulumi.get(self, "notification_type")

    @notification_type.setter
    def notification_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "notification_type", value)

    @property
    @pulumi.getter
    def subscribers(self) -> pulumi.Input[Sequence[pulumi.Input['BudgetActionSubscriberArgs']]]:
        """
        A list of subscribers. See Subscriber.
        """
        return pulumi.get(self, "subscribers")

    @subscribers.setter
    def subscribers(self, value: pulumi.Input[Sequence[pulumi.Input['BudgetActionSubscriberArgs']]]):
        pulumi.set(self, "subscribers", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the target account for budget. Will use current user's account_id by default if omitted.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _BudgetActionState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 action_id: Optional[pulumi.Input[str]] = None,
                 action_threshold: Optional[pulumi.Input['BudgetActionActionThresholdArgs']] = None,
                 action_type: Optional[pulumi.Input[str]] = None,
                 approval_model: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 budget_name: Optional[pulumi.Input[str]] = None,
                 definition: Optional[pulumi.Input['BudgetActionDefinitionArgs']] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 notification_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subscribers: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetActionSubscriberArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering BudgetAction resources.
        :param pulumi.Input[str] account_id: The ID of the target account for budget. Will use current user's account_id by default if omitted.
        :param pulumi.Input[str] action_id: The id of the budget action.
        :param pulumi.Input['BudgetActionActionThresholdArgs'] action_threshold: The trigger threshold of the action. See Action Threshold.
        :param pulumi.Input[str] action_type: The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
        :param pulumi.Input[str] approval_model: This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
        :param pulumi.Input[str] arn: The ARN of the budget action.
        :param pulumi.Input[str] budget_name: The name of a budget.
        :param pulumi.Input['BudgetActionDefinitionArgs'] definition: Specifies all of the type-specific parameters. See Definition.
        :param pulumi.Input[str] execution_role_arn: The role passed for action execution and reversion. Roles and actions must be in the same account.
        :param pulumi.Input[str] notification_type: The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
        :param pulumi.Input[str] status: The status of the budget action.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetActionSubscriberArgs']]] subscribers: A list of subscribers. See Subscriber.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if action_id is not None:
            pulumi.set(__self__, "action_id", action_id)
        if action_threshold is not None:
            pulumi.set(__self__, "action_threshold", action_threshold)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if approval_model is not None:
            pulumi.set(__self__, "approval_model", approval_model)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if budget_name is not None:
            pulumi.set(__self__, "budget_name", budget_name)
        if definition is not None:
            pulumi.set(__self__, "definition", definition)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if notification_type is not None:
            pulumi.set(__self__, "notification_type", notification_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscribers is not None:
            pulumi.set(__self__, "subscribers", subscribers)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the target account for budget. Will use current user's account_id by default if omitted.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="actionId")
    def action_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the budget action.
        """
        return pulumi.get(self, "action_id")

    @action_id.setter
    def action_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_id", value)

    @property
    @pulumi.getter(name="actionThreshold")
    def action_threshold(self) -> Optional[pulumi.Input['BudgetActionActionThresholdArgs']]:
        """
        The trigger threshold of the action. See Action Threshold.
        """
        return pulumi.get(self, "action_threshold")

    @action_threshold.setter
    def action_threshold(self, value: Optional[pulumi.Input['BudgetActionActionThresholdArgs']]):
        pulumi.set(self, "action_threshold", value)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="approvalModel")
    def approval_model(self) -> Optional[pulumi.Input[str]]:
        """
        This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
        """
        return pulumi.get(self, "approval_model")

    @approval_model.setter
    def approval_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "approval_model", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the budget action.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="budgetName")
    def budget_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a budget.
        """
        return pulumi.get(self, "budget_name")

    @budget_name.setter
    def budget_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "budget_name", value)

    @property
    @pulumi.getter
    def definition(self) -> Optional[pulumi.Input['BudgetActionDefinitionArgs']]:
        """
        Specifies all of the type-specific parameters. See Definition.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: Optional[pulumi.Input['BudgetActionDefinitionArgs']]):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The role passed for action execution and reversion. Roles and actions must be in the same account.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
        """
        return pulumi.get(self, "notification_type")

    @notification_type.setter
    def notification_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the budget action.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def subscribers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BudgetActionSubscriberArgs']]]]:
        """
        A list of subscribers. See Subscriber.
        """
        return pulumi.get(self, "subscribers")

    @subscribers.setter
    def subscribers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetActionSubscriberArgs']]]]):
        pulumi.set(self, "subscribers", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class BudgetAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 action_threshold: Optional[pulumi.Input[Union['BudgetActionActionThresholdArgs', 'BudgetActionActionThresholdArgsDict']]] = None,
                 action_type: Optional[pulumi.Input[str]] = None,
                 approval_model: Optional[pulumi.Input[str]] = None,
                 budget_name: Optional[pulumi.Input[str]] = None,
                 definition: Optional[pulumi.Input[Union['BudgetActionDefinitionArgs', 'BudgetActionDefinitionArgsDict']]] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 notification_type: Optional[pulumi.Input[str]] = None,
                 subscribers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BudgetActionSubscriberArgs', 'BudgetActionSubscriberArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a budget action resource. Budget actions are cost savings controls that run either automatically on your behalf or by using a workflow approval process.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["ec2:Describe*"],
            "resources": ["*"],
        }])
        example_policy = aws.iam.Policy("example",
            name="example",
            description="My example policy",
            policy=example.json)
        current = aws.get_partition()
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": [f"budgets.{current.dns_suffix}"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=assume_role.json)
        example_budget = aws.budgets.Budget("example",
            name="example",
            budget_type="USAGE",
            limit_amount="10.0",
            limit_unit="dollars",
            time_period_start="2006-01-02_15:04",
            time_unit="MONTHLY")
        example_budget_action = aws.budgets.BudgetAction("example",
            budget_name=example_budget.name,
            action_type="APPLY_IAM_POLICY",
            approval_model="AUTOMATIC",
            notification_type="ACTUAL",
            execution_role_arn=example_role.arn,
            action_threshold={
                "action_threshold_type": "ABSOLUTE_VALUE",
                "action_threshold_value": 100,
            },
            definition={
                "iam_action_definition": {
                    "policy_arn": example_policy.arn,
                    "roles": [example_role.name],
                },
            },
            subscribers=[{
                "address": "example@example.example",
                "subscription_type": "EMAIL",
            }],
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ## Import

        Using `pulumi import`, import budget actions using `AccountID:ActionID:BudgetName`. For example:

        ```sh
        $ pulumi import aws:budgets/budgetAction:BudgetAction myBudget 123456789012:some-id:myBudget
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The ID of the target account for budget. Will use current user's account_id by default if omitted.
        :param pulumi.Input[Union['BudgetActionActionThresholdArgs', 'BudgetActionActionThresholdArgsDict']] action_threshold: The trigger threshold of the action. See Action Threshold.
        :param pulumi.Input[str] action_type: The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
        :param pulumi.Input[str] approval_model: This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
        :param pulumi.Input[str] budget_name: The name of a budget.
        :param pulumi.Input[Union['BudgetActionDefinitionArgs', 'BudgetActionDefinitionArgsDict']] definition: Specifies all of the type-specific parameters. See Definition.
        :param pulumi.Input[str] execution_role_arn: The role passed for action execution and reversion. Roles and actions must be in the same account.
        :param pulumi.Input[str] notification_type: The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BudgetActionSubscriberArgs', 'BudgetActionSubscriberArgsDict']]]] subscribers: A list of subscribers. See Subscriber.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BudgetActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a budget action resource. Budget actions are cost savings controls that run either automatically on your behalf or by using a workflow approval process.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["ec2:Describe*"],
            "resources": ["*"],
        }])
        example_policy = aws.iam.Policy("example",
            name="example",
            description="My example policy",
            policy=example.json)
        current = aws.get_partition()
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": [f"budgets.{current.dns_suffix}"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=assume_role.json)
        example_budget = aws.budgets.Budget("example",
            name="example",
            budget_type="USAGE",
            limit_amount="10.0",
            limit_unit="dollars",
            time_period_start="2006-01-02_15:04",
            time_unit="MONTHLY")
        example_budget_action = aws.budgets.BudgetAction("example",
            budget_name=example_budget.name,
            action_type="APPLY_IAM_POLICY",
            approval_model="AUTOMATIC",
            notification_type="ACTUAL",
            execution_role_arn=example_role.arn,
            action_threshold={
                "action_threshold_type": "ABSOLUTE_VALUE",
                "action_threshold_value": 100,
            },
            definition={
                "iam_action_definition": {
                    "policy_arn": example_policy.arn,
                    "roles": [example_role.name],
                },
            },
            subscribers=[{
                "address": "example@example.example",
                "subscription_type": "EMAIL",
            }],
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ## Import

        Using `pulumi import`, import budget actions using `AccountID:ActionID:BudgetName`. For example:

        ```sh
        $ pulumi import aws:budgets/budgetAction:BudgetAction myBudget 123456789012:some-id:myBudget
        ```

        :param str resource_name: The name of the resource.
        :param BudgetActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BudgetActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 action_threshold: Optional[pulumi.Input[Union['BudgetActionActionThresholdArgs', 'BudgetActionActionThresholdArgsDict']]] = None,
                 action_type: Optional[pulumi.Input[str]] = None,
                 approval_model: Optional[pulumi.Input[str]] = None,
                 budget_name: Optional[pulumi.Input[str]] = None,
                 definition: Optional[pulumi.Input[Union['BudgetActionDefinitionArgs', 'BudgetActionDefinitionArgsDict']]] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 notification_type: Optional[pulumi.Input[str]] = None,
                 subscribers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BudgetActionSubscriberArgs', 'BudgetActionSubscriberArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BudgetActionArgs.__new__(BudgetActionArgs)

            __props__.__dict__["account_id"] = account_id
            if action_threshold is None and not opts.urn:
                raise TypeError("Missing required property 'action_threshold'")
            __props__.__dict__["action_threshold"] = action_threshold
            if action_type is None and not opts.urn:
                raise TypeError("Missing required property 'action_type'")
            __props__.__dict__["action_type"] = action_type
            if approval_model is None and not opts.urn:
                raise TypeError("Missing required property 'approval_model'")
            __props__.__dict__["approval_model"] = approval_model
            if budget_name is None and not opts.urn:
                raise TypeError("Missing required property 'budget_name'")
            __props__.__dict__["budget_name"] = budget_name
            if definition is None and not opts.urn:
                raise TypeError("Missing required property 'definition'")
            __props__.__dict__["definition"] = definition
            if execution_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'execution_role_arn'")
            __props__.__dict__["execution_role_arn"] = execution_role_arn
            if notification_type is None and not opts.urn:
                raise TypeError("Missing required property 'notification_type'")
            __props__.__dict__["notification_type"] = notification_type
            if subscribers is None and not opts.urn:
                raise TypeError("Missing required property 'subscribers'")
            __props__.__dict__["subscribers"] = subscribers
            __props__.__dict__["tags"] = tags
            __props__.__dict__["action_id"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(BudgetAction, __self__).__init__(
            'aws:budgets/budgetAction:BudgetAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            action_id: Optional[pulumi.Input[str]] = None,
            action_threshold: Optional[pulumi.Input[Union['BudgetActionActionThresholdArgs', 'BudgetActionActionThresholdArgsDict']]] = None,
            action_type: Optional[pulumi.Input[str]] = None,
            approval_model: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            budget_name: Optional[pulumi.Input[str]] = None,
            definition: Optional[pulumi.Input[Union['BudgetActionDefinitionArgs', 'BudgetActionDefinitionArgsDict']]] = None,
            execution_role_arn: Optional[pulumi.Input[str]] = None,
            notification_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subscribers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BudgetActionSubscriberArgs', 'BudgetActionSubscriberArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'BudgetAction':
        """
        Get an existing BudgetAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The ID of the target account for budget. Will use current user's account_id by default if omitted.
        :param pulumi.Input[str] action_id: The id of the budget action.
        :param pulumi.Input[Union['BudgetActionActionThresholdArgs', 'BudgetActionActionThresholdArgsDict']] action_threshold: The trigger threshold of the action. See Action Threshold.
        :param pulumi.Input[str] action_type: The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
        :param pulumi.Input[str] approval_model: This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
        :param pulumi.Input[str] arn: The ARN of the budget action.
        :param pulumi.Input[str] budget_name: The name of a budget.
        :param pulumi.Input[Union['BudgetActionDefinitionArgs', 'BudgetActionDefinitionArgsDict']] definition: Specifies all of the type-specific parameters. See Definition.
        :param pulumi.Input[str] execution_role_arn: The role passed for action execution and reversion. Roles and actions must be in the same account.
        :param pulumi.Input[str] notification_type: The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
        :param pulumi.Input[str] status: The status of the budget action.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BudgetActionSubscriberArgs', 'BudgetActionSubscriberArgsDict']]]] subscribers: A list of subscribers. See Subscriber.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BudgetActionState.__new__(_BudgetActionState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["action_id"] = action_id
        __props__.__dict__["action_threshold"] = action_threshold
        __props__.__dict__["action_type"] = action_type
        __props__.__dict__["approval_model"] = approval_model
        __props__.__dict__["arn"] = arn
        __props__.__dict__["budget_name"] = budget_name
        __props__.__dict__["definition"] = definition
        __props__.__dict__["execution_role_arn"] = execution_role_arn
        __props__.__dict__["notification_type"] = notification_type
        __props__.__dict__["status"] = status
        __props__.__dict__["subscribers"] = subscribers
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return BudgetAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The ID of the target account for budget. Will use current user's account_id by default if omitted.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="actionId")
    def action_id(self) -> pulumi.Output[str]:
        """
        The id of the budget action.
        """
        return pulumi.get(self, "action_id")

    @property
    @pulumi.getter(name="actionThreshold")
    def action_threshold(self) -> pulumi.Output['outputs.BudgetActionActionThreshold']:
        """
        The trigger threshold of the action. See Action Threshold.
        """
        return pulumi.get(self, "action_threshold")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Output[str]:
        """
        The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="approvalModel")
    def approval_model(self) -> pulumi.Output[str]:
        """
        This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
        """
        return pulumi.get(self, "approval_model")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the budget action.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="budgetName")
    def budget_name(self) -> pulumi.Output[str]:
        """
        The name of a budget.
        """
        return pulumi.get(self, "budget_name")

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Output['outputs.BudgetActionDefinition']:
        """
        Specifies all of the type-specific parameters. See Definition.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[str]:
        """
        The role passed for action execution and reversion. Roles and actions must be in the same account.
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> pulumi.Output[str]:
        """
        The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
        """
        return pulumi.get(self, "notification_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the budget action.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subscribers(self) -> pulumi.Output[Sequence['outputs.BudgetActionSubscriber']]:
        """
        A list of subscribers. See Subscriber.
        """
        return pulumi.get(self, "subscribers")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

