# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['RuleSourceArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_modes: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEvaluationModeArgs']]]] = None,
                 input_parameters: Optional[pulumi.Input[str]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input['RuleScopeArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input['RuleSourceArgs'] source: Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Source Below.
        :param pulumi.Input[str] description: Description of the rule
        :param pulumi.Input[Sequence[pulumi.Input['RuleEvaluationModeArgs']]] evaluation_modes: The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
        :param pulumi.Input[str] input_parameters: A string in JSON format that is passed to the AWS Config rule Lambda function.
        :param pulumi.Input[str] maximum_execution_frequency: The maximum frequency with which AWS Config runs evaluations for a rule.
        :param pulumi.Input[str] name: The name of the rule
        :param pulumi.Input['RuleScopeArgs'] scope: Scope defines which resources can trigger an evaluation for the rule. See Scope Below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "source", source)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if evaluation_modes is not None:
            pulumi.set(__self__, "evaluation_modes", evaluation_modes)
        if input_parameters is not None:
            pulumi.set(__self__, "input_parameters", input_parameters)
        if maximum_execution_frequency is not None:
            pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['RuleSourceArgs']:
        """
        Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Source Below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['RuleSourceArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="evaluationModes")
    def evaluation_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleEvaluationModeArgs']]]]:
        """
        The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
        """
        return pulumi.get(self, "evaluation_modes")

    @evaluation_modes.setter
    def evaluation_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEvaluationModeArgs']]]]):
        pulumi.set(self, "evaluation_modes", value)

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Optional[pulumi.Input[str]]:
        """
        A string in JSON format that is passed to the AWS Config rule Lambda function.
        """
        return pulumi.get(self, "input_parameters")

    @input_parameters.setter
    def input_parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_parameters", value)

    @property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum frequency with which AWS Config runs evaluations for a rule.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @maximum_execution_frequency.setter
    def maximum_execution_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_execution_frequency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['RuleScopeArgs']]:
        """
        Scope defines which resources can trigger an evaluation for the rule. See Scope Below.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['RuleScopeArgs']]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_modes: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEvaluationModeArgs']]]] = None,
                 input_parameters: Optional[pulumi.Input[str]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input['RuleScopeArgs']] = None,
                 source: Optional[pulumi.Input['RuleSourceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[str] arn: The ARN of the config rule
        :param pulumi.Input[str] description: Description of the rule
        :param pulumi.Input[Sequence[pulumi.Input['RuleEvaluationModeArgs']]] evaluation_modes: The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
        :param pulumi.Input[str] input_parameters: A string in JSON format that is passed to the AWS Config rule Lambda function.
        :param pulumi.Input[str] maximum_execution_frequency: The maximum frequency with which AWS Config runs evaluations for a rule.
        :param pulumi.Input[str] name: The name of the rule
        :param pulumi.Input[str] rule_id: The ID of the config rule
        :param pulumi.Input['RuleScopeArgs'] scope: Scope defines which resources can trigger an evaluation for the rule. See Scope Below.
        :param pulumi.Input['RuleSourceArgs'] source: Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Source Below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if evaluation_modes is not None:
            pulumi.set(__self__, "evaluation_modes", evaluation_modes)
        if input_parameters is not None:
            pulumi.set(__self__, "input_parameters", input_parameters)
        if maximum_execution_frequency is not None:
            pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the config rule
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="evaluationModes")
    def evaluation_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleEvaluationModeArgs']]]]:
        """
        The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
        """
        return pulumi.get(self, "evaluation_modes")

    @evaluation_modes.setter
    def evaluation_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEvaluationModeArgs']]]]):
        pulumi.set(self, "evaluation_modes", value)

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Optional[pulumi.Input[str]]:
        """
        A string in JSON format that is passed to the AWS Config rule Lambda function.
        """
        return pulumi.get(self, "input_parameters")

    @input_parameters.setter
    def input_parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_parameters", value)

    @property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum frequency with which AWS Config runs evaluations for a rule.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @maximum_execution_frequency.setter
    def maximum_execution_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_execution_frequency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the config rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['RuleScopeArgs']]:
        """
        Scope defines which resources can trigger an evaluation for the rule. See Scope Below.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['RuleScopeArgs']]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['RuleSourceArgs']]:
        """
        Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Source Below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['RuleSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_modes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleEvaluationModeArgs', 'RuleEvaluationModeArgsDict']]]]] = None,
                 input_parameters: Optional[pulumi.Input[str]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[Union['RuleScopeArgs', 'RuleScopeArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['RuleSourceArgs', 'RuleSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides an AWS Config Rule.

        > **Note:** Config Rule requires an existing Configuration Recorder to be present. Use of `depends_on` is recommended (as shown below) to avoid race conditions.

        ## Example Usage

        ### AWS Managed Rules

        AWS managed rules can be used by setting the source owner to `AWS` and the source identifier to the name of the managed rule. More information about AWS managed rules can be found in the [AWS Config Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["config.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        r_role = aws.iam.Role("r",
            name="my-awsconfig-role",
            assume_role_policy=assume_role.json)
        foo = aws.cfg.Recorder("foo",
            name="example",
            role_arn=r_role.arn)
        r = aws.cfg.Rule("r",
            name="example",
            source={
                "owner": "AWS",
                "source_identifier": "S3_BUCKET_VERSIONING_ENABLED",
            },
            opts = pulumi.ResourceOptions(depends_on=[foo]))
        p = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["config:Put*"],
            "resources": ["*"],
        }])
        p_role_policy = aws.iam.RolePolicy("p",
            name="my-awsconfig-policy",
            role=r_role.id,
            policy=p.json)
        ```

        ### Custom Rules

        Custom rules can be used by setting the source owner to `CUSTOM_LAMBDA` and the source identifier to the Amazon Resource Name (ARN) of the Lambda Function. The AWS Config service must have permissions to invoke the Lambda Function, e.g., via the `lambda.Permission` resource. More information about custom rules can be found in the [AWS Config Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cfg.Recorder("example")
        example_function = aws.lambda_.Function("example")
        example_permission = aws.lambda_.Permission("example",
            action="lambda:InvokeFunction",
            function=example_function.arn,
            principal="config.amazonaws.com",
            statement_id="AllowExecutionFromConfig")
        example_rule = aws.cfg.Rule("example", source={
            "owner": "CUSTOM_LAMBDA",
            "source_identifier": example_function.arn,
        },
        opts = pulumi.ResourceOptions(depends_on=[
                example,
                example_permission,
            ]))
        ```

        ### Custom Policies

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cfg.Rule("example",
            name="example",
            source={
                "owner": "CUSTOM_POLICY",
                "source_details": [{
                    "message_type": "ConfigurationItemChangeNotification",
                }],
                "custom_policy_details": {
                    "policy_runtime": "guard-2.x.x",
                    "policy_text": \"\"\"\\x09  rule tableisactive when
        \\x09\\x09  resourceType == "AWS::DynamoDB::Table" {
        \\x09\\x09  configuration.tableStatus == ['ACTIVE']
        \\x09  }
        \\x09  
        \\x09  rule checkcompliance when
        \\x09\\x09  resourceType == "AWS::DynamoDB::Table"
        \\x09\\x09  tableisactive {
        \\x09\\x09\\x09  supplementaryConfiguration.ContinuousBackupsDescription.pointInTimeRecoveryDescription.pointInTimeRecoveryStatus == "ENABLED"
        \\x09  }
        \"\"\",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Config Rule using the name. For example:

        ```sh
        $ pulumi import aws:cfg/rule:Rule foo example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the rule
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleEvaluationModeArgs', 'RuleEvaluationModeArgsDict']]]] evaluation_modes: The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
        :param pulumi.Input[str] input_parameters: A string in JSON format that is passed to the AWS Config rule Lambda function.
        :param pulumi.Input[str] maximum_execution_frequency: The maximum frequency with which AWS Config runs evaluations for a rule.
        :param pulumi.Input[str] name: The name of the rule
        :param pulumi.Input[Union['RuleScopeArgs', 'RuleScopeArgsDict']] scope: Scope defines which resources can trigger an evaluation for the rule. See Scope Below.
        :param pulumi.Input[Union['RuleSourceArgs', 'RuleSourceArgsDict']] source: Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Source Below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS Config Rule.

        > **Note:** Config Rule requires an existing Configuration Recorder to be present. Use of `depends_on` is recommended (as shown below) to avoid race conditions.

        ## Example Usage

        ### AWS Managed Rules

        AWS managed rules can be used by setting the source owner to `AWS` and the source identifier to the name of the managed rule. More information about AWS managed rules can be found in the [AWS Config Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["config.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        r_role = aws.iam.Role("r",
            name="my-awsconfig-role",
            assume_role_policy=assume_role.json)
        foo = aws.cfg.Recorder("foo",
            name="example",
            role_arn=r_role.arn)
        r = aws.cfg.Rule("r",
            name="example",
            source={
                "owner": "AWS",
                "source_identifier": "S3_BUCKET_VERSIONING_ENABLED",
            },
            opts = pulumi.ResourceOptions(depends_on=[foo]))
        p = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["config:Put*"],
            "resources": ["*"],
        }])
        p_role_policy = aws.iam.RolePolicy("p",
            name="my-awsconfig-policy",
            role=r_role.id,
            policy=p.json)
        ```

        ### Custom Rules

        Custom rules can be used by setting the source owner to `CUSTOM_LAMBDA` and the source identifier to the Amazon Resource Name (ARN) of the Lambda Function. The AWS Config service must have permissions to invoke the Lambda Function, e.g., via the `lambda.Permission` resource. More information about custom rules can be found in the [AWS Config Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cfg.Recorder("example")
        example_function = aws.lambda_.Function("example")
        example_permission = aws.lambda_.Permission("example",
            action="lambda:InvokeFunction",
            function=example_function.arn,
            principal="config.amazonaws.com",
            statement_id="AllowExecutionFromConfig")
        example_rule = aws.cfg.Rule("example", source={
            "owner": "CUSTOM_LAMBDA",
            "source_identifier": example_function.arn,
        },
        opts = pulumi.ResourceOptions(depends_on=[
                example,
                example_permission,
            ]))
        ```

        ### Custom Policies

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cfg.Rule("example",
            name="example",
            source={
                "owner": "CUSTOM_POLICY",
                "source_details": [{
                    "message_type": "ConfigurationItemChangeNotification",
                }],
                "custom_policy_details": {
                    "policy_runtime": "guard-2.x.x",
                    "policy_text": \"\"\"\\x09  rule tableisactive when
        \\x09\\x09  resourceType == "AWS::DynamoDB::Table" {
        \\x09\\x09  configuration.tableStatus == ['ACTIVE']
        \\x09  }
        \\x09  
        \\x09  rule checkcompliance when
        \\x09\\x09  resourceType == "AWS::DynamoDB::Table"
        \\x09\\x09  tableisactive {
        \\x09\\x09\\x09  supplementaryConfiguration.ContinuousBackupsDescription.pointInTimeRecoveryDescription.pointInTimeRecoveryStatus == "ENABLED"
        \\x09  }
        \"\"\",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Config Rule using the name. For example:

        ```sh
        $ pulumi import aws:cfg/rule:Rule foo example
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_modes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleEvaluationModeArgs', 'RuleEvaluationModeArgsDict']]]]] = None,
                 input_parameters: Optional[pulumi.Input[str]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[Union['RuleScopeArgs', 'RuleScopeArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['RuleSourceArgs', 'RuleSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["evaluation_modes"] = evaluation_modes
            __props__.__dict__["input_parameters"] = input_parameters
            __props__.__dict__["maximum_execution_frequency"] = maximum_execution_frequency
            __props__.__dict__["name"] = name
            __props__.__dict__["scope"] = scope
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["rule_id"] = None
            __props__.__dict__["tags_all"] = None
        super(Rule, __self__).__init__(
            'aws:cfg/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            evaluation_modes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleEvaluationModeArgs', 'RuleEvaluationModeArgsDict']]]]] = None,
            input_parameters: Optional[pulumi.Input[str]] = None,
            maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            rule_id: Optional[pulumi.Input[str]] = None,
            scope: Optional[pulumi.Input[Union['RuleScopeArgs', 'RuleScopeArgsDict']]] = None,
            source: Optional[pulumi.Input[Union['RuleSourceArgs', 'RuleSourceArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the config rule
        :param pulumi.Input[str] description: Description of the rule
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleEvaluationModeArgs', 'RuleEvaluationModeArgsDict']]]] evaluation_modes: The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
        :param pulumi.Input[str] input_parameters: A string in JSON format that is passed to the AWS Config rule Lambda function.
        :param pulumi.Input[str] maximum_execution_frequency: The maximum frequency with which AWS Config runs evaluations for a rule.
        :param pulumi.Input[str] name: The name of the rule
        :param pulumi.Input[str] rule_id: The ID of the config rule
        :param pulumi.Input[Union['RuleScopeArgs', 'RuleScopeArgsDict']] scope: Scope defines which resources can trigger an evaluation for the rule. See Scope Below.
        :param pulumi.Input[Union['RuleSourceArgs', 'RuleSourceArgsDict']] source: Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Source Below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["evaluation_modes"] = evaluation_modes
        __props__.__dict__["input_parameters"] = input_parameters
        __props__.__dict__["maximum_execution_frequency"] = maximum_execution_frequency
        __props__.__dict__["name"] = name
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["scope"] = scope
        __props__.__dict__["source"] = source
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the config rule
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the rule
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="evaluationModes")
    def evaluation_modes(self) -> pulumi.Output[Sequence['outputs.RuleEvaluationMode']]:
        """
        The modes the Config rule can be evaluated in. See Evaluation Mode for more details.
        """
        return pulumi.get(self, "evaluation_modes")

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> pulumi.Output[Optional[str]]:
        """
        A string in JSON format that is passed to the AWS Config rule Lambda function.
        """
        return pulumi.get(self, "input_parameters")

    @property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> pulumi.Output[Optional[str]]:
        """
        The maximum frequency with which AWS Config runs evaluations for a rule.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[str]:
        """
        The ID of the config rule
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional['outputs.RuleScope']]:
        """
        Scope defines which resources can trigger an evaluation for the rule. See Scope Below.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.RuleSource']:
        """
        Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Source Below.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

