# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MediaInsightsPipelineConfigurationArgs', 'MediaInsightsPipelineConfiguration']

@pulumi.input_type
class MediaInsightsPipelineConfigurationArgs:
    def __init__(__self__, *,
                 elements: pulumi.Input[Sequence[pulumi.Input['MediaInsightsPipelineConfigurationElementArgs']]],
                 resource_access_role_arn: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 real_time_alert_configuration: Optional[pulumi.Input['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a MediaInsightsPipelineConfiguration resource.
        :param pulumi.Input[Sequence[pulumi.Input['MediaInsightsPipelineConfigurationElementArgs']]] elements: Collection of processors and sinks to transform media and deliver data.
        :param pulumi.Input[str] resource_access_role_arn: ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
        :param pulumi.Input[str] name: Configuration name.
        :param pulumi.Input['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs'] real_time_alert_configuration: Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of tags for the resource.
        """
        pulumi.set(__self__, "elements", elements)
        pulumi.set(__self__, "resource_access_role_arn", resource_access_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if real_time_alert_configuration is not None:
            pulumi.set(__self__, "real_time_alert_configuration", real_time_alert_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def elements(self) -> pulumi.Input[Sequence[pulumi.Input['MediaInsightsPipelineConfigurationElementArgs']]]:
        """
        Collection of processors and sinks to transform media and deliver data.
        """
        return pulumi.get(self, "elements")

    @elements.setter
    def elements(self, value: pulumi.Input[Sequence[pulumi.Input['MediaInsightsPipelineConfigurationElementArgs']]]):
        pulumi.set(self, "elements", value)

    @property
    @pulumi.getter(name="resourceAccessRoleArn")
    def resource_access_role_arn(self) -> pulumi.Input[str]:
        """
        ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
        """
        return pulumi.get(self, "resource_access_role_arn")

    @resource_access_role_arn.setter
    def resource_access_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_access_role_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="realTimeAlertConfiguration")
    def real_time_alert_configuration(self) -> Optional[pulumi.Input['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs']]:
        """
        Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
        """
        return pulumi.get(self, "real_time_alert_configuration")

    @real_time_alert_configuration.setter
    def real_time_alert_configuration(self, value: Optional[pulumi.Input['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs']]):
        pulumi.set(self, "real_time_alert_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of tags for the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _MediaInsightsPipelineConfigurationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 elements: Optional[pulumi.Input[Sequence[pulumi.Input['MediaInsightsPipelineConfigurationElementArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 real_time_alert_configuration: Optional[pulumi.Input['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs']] = None,
                 resource_access_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering MediaInsightsPipelineConfiguration resources.
        :param pulumi.Input[str] arn: ARN of the Media Insights Pipeline Configuration.
        :param pulumi.Input[Sequence[pulumi.Input['MediaInsightsPipelineConfigurationElementArgs']]] elements: Collection of processors and sinks to transform media and deliver data.
        :param pulumi.Input[str] name: Configuration name.
        :param pulumi.Input['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs'] real_time_alert_configuration: Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
        :param pulumi.Input[str] resource_access_role_arn: ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of tags for the resource.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if elements is not None:
            pulumi.set(__self__, "elements", elements)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if real_time_alert_configuration is not None:
            pulumi.set(__self__, "real_time_alert_configuration", real_time_alert_configuration)
        if resource_access_role_arn is not None:
            pulumi.set(__self__, "resource_access_role_arn", resource_access_role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Media Insights Pipeline Configuration.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def elements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MediaInsightsPipelineConfigurationElementArgs']]]]:
        """
        Collection of processors and sinks to transform media and deliver data.
        """
        return pulumi.get(self, "elements")

    @elements.setter
    def elements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MediaInsightsPipelineConfigurationElementArgs']]]]):
        pulumi.set(self, "elements", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="realTimeAlertConfiguration")
    def real_time_alert_configuration(self) -> Optional[pulumi.Input['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs']]:
        """
        Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
        """
        return pulumi.get(self, "real_time_alert_configuration")

    @real_time_alert_configuration.setter
    def real_time_alert_configuration(self, value: Optional[pulumi.Input['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs']]):
        pulumi.set(self, "real_time_alert_configuration", value)

    @property
    @pulumi.getter(name="resourceAccessRoleArn")
    def resource_access_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
        """
        return pulumi.get(self, "resource_access_role_arn")

    @resource_access_role_arn.setter
    def resource_access_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_access_role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of tags for the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class MediaInsightsPipelineConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaInsightsPipelineConfigurationElementArgs', 'MediaInsightsPipelineConfigurationElementArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 real_time_alert_configuration: Optional[pulumi.Input[Union['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs', 'MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgsDict']]] = None,
                 resource_access_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Chime SDK Media Pipelines Media Insights Pipeline Configuration.
        Consult the [Call analytics developer guide](https://docs.aws.amazon.com/chime-sdk/latest/dg/call-analytics.html) for more detailed information about usage.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kinesis.Stream("example",
            name="example",
            shard_count=2)
        media_pipelines_assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["mediapipelines.chime.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        call_analytics_role = aws.iam.Role("call_analytics_role",
            name="CallAnalyticsRole",
            assume_role_policy=media_pipelines_assume_role.json)
        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyBasicConfiguration",
            resource_access_role_arn=call_analytics_role.arn,
            elements=[
                {
                    "type": "AmazonTranscribeCallAnalyticsProcessor",
                    "amazon_transcribe_call_analytics_processor_configuration": {
                        "language_code": "en-US",
                    },
                },
                {
                    "type": "KinesisDataStreamSink",
                    "kinesis_data_stream_sink_configuration": {
                        "insights_target": example.arn,
                    },
                },
            ],
            tags={
                "Key1": "Value1",
                "Key2": "Value2",
            })
        ```

        - The required policies on `call_analytics_role` will vary based on the selected processors. See [Call analytics resource access role](https://docs.aws.amazon.com/chime-sdk/latest/dg/ca-resource-access-role.html) for directions on choosing appropriate policies.

        ### Transcribe Call Analytics processor usage

        ```python
        import pulumi
        import pulumi_aws as aws

        transcribe_assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["transcribe.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        post_call_role = aws.iam.Role("post_call_role",
            name="PostCallAccessRole",
            assume_role_policy=transcribe_assume_role.json)
        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyCallAnalyticsConfiguration",
            resource_access_role_arn=example_aws_iam_role["arn"],
            elements=[
                {
                    "type": "AmazonTranscribeCallAnalyticsProcessor",
                    "amazon_transcribe_call_analytics_processor_configuration": {
                        "call_analytics_stream_categories": [
                            "category_1",
                            "category_2",
                        ],
                        "content_redaction_type": "PII",
                        "enable_partial_results_stabilization": True,
                        "filter_partial_results": True,
                        "language_code": "en-US",
                        "language_model_name": "MyLanguageModel",
                        "partial_results_stability": "high",
                        "pii_entity_types": "ADDRESS,BANK_ACCOUNT_NUMBER",
                        "post_call_analytics_settings": {
                            "content_redaction_output": "redacted",
                            "data_access_role_arn": post_call_role.arn,
                            "output_encryption_kms_key_id": "MyKmsKeyId",
                            "output_location": "s3://MyBucket",
                        },
                        "vocabulary_filter_method": "mask",
                        "vocabulary_filter_name": "MyVocabularyFilter",
                        "vocabulary_name": "MyVocabulary",
                    },
                },
                {
                    "type": "KinesisDataStreamSink",
                    "kinesis_data_stream_sink_configuration": {
                        "insights_target": example["arn"],
                    },
                },
            ])
        ```

        ### Real time alerts usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyRealTimeAlertConfiguration",
            resource_access_role_arn=call_analytics_role["arn"],
            elements=[
                {
                    "type": "AmazonTranscribeCallAnalyticsProcessor",
                    "amazon_transcribe_call_analytics_processor_configuration": {
                        "language_code": "en-US",
                    },
                },
                {
                    "type": "KinesisDataStreamSink",
                    "kinesis_data_stream_sink_configuration": {
                        "insights_target": example["arn"],
                    },
                },
            ],
            real_time_alert_configuration={
                "disabled": False,
                "rules": [
                    {
                        "type": "IssueDetection",
                        "issue_detection_configuration": {
                            "rule_name": "MyIssueDetectionRule",
                        },
                    },
                    {
                        "type": "KeywordMatch",
                        "keyword_match_configuration": {
                            "keywords": [
                                "keyword1",
                                "keyword2",
                            ],
                            "negate": False,
                            "rule_name": "MyKeywordMatchRule",
                        },
                    },
                    {
                        "type": "Sentiment",
                        "sentiment_configuration": {
                            "rule_name": "MySentimentRule",
                            "sentiment_type": "NEGATIVE",
                            "time_period": 60,
                        },
                    },
                ],
            })
        ```

        ### Transcribe processor usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyTranscribeConfiguration",
            resource_access_role_arn=example_aws_iam_role["arn"],
            elements=[
                {
                    "type": "AmazonTranscribeProcessor",
                    "amazon_transcribe_processor_configuration": {
                        "content_identification_type": "PII",
                        "enable_partial_results_stabilization": True,
                        "filter_partial_results": True,
                        "language_code": "en-US",
                        "language_model_name": "MyLanguageModel",
                        "partial_results_stability": "high",
                        "pii_entity_types": "ADDRESS,BANK_ACCOUNT_NUMBER",
                        "show_speaker_label": True,
                        "vocabulary_filter_method": "mask",
                        "vocabulary_filter_name": "MyVocabularyFilter",
                        "vocabulary_name": "MyVocabulary",
                    },
                },
                {
                    "type": "KinesisDataStreamSink",
                    "kinesis_data_stream_sink_configuration": {
                        "insights_target": example["arn"],
                    },
                },
            ])
        ```

        ### Voice analytics processor usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyVoiceAnalyticsConfiguration",
            resource_access_role_arn=example["arn"],
            elements=[
                {
                    "type": "VoiceAnalyticsProcessor",
                    "voice_analytics_processor_configuration": {
                        "speaker_search_status": "Enabled",
                        "voice_tone_analysis_status": "Enabled",
                    },
                },
                {
                    "type": "LambdaFunctionSink",
                    "lambda_function_sink_configuration": {
                        "insights_target": "arn:aws:lambda:us-west-2:1111111111:function:MyFunction",
                    },
                },
                {
                    "type": "SnsTopicSink",
                    "sns_topic_sink_configuration": {
                        "insights_target": "arn:aws:sns:us-west-2:1111111111:topic/MyTopic",
                    },
                },
                {
                    "type": "SqsQueueSink",
                    "sqs_queue_sink_configuration": {
                        "insights_target": "arn:aws:sqs:us-west-2:1111111111:queue/MyQueue",
                    },
                },
                {
                    "type": "KinesisDataStreamSink",
                    "kinesis_data_stream_sink_configuration": {
                        "insights_target": test["arn"],
                    },
                },
            ])
        ```

        ### S3 Recording sink usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyS3RecordingConfiguration",
            resource_access_role_arn=example["arn"],
            elements=[{
                "type": "S3RecordingSink",
                "s3_recording_sink_configuration": {
                    "destination": "arn:aws:s3:::MyBucket",
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import Chime SDK Media Pipelines Media Insights Pipeline Configuration using the `id`. For example:

        ```sh
        $ pulumi import aws:chimesdkmediapipelines/mediaInsightsPipelineConfiguration:MediaInsightsPipelineConfiguration example abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MediaInsightsPipelineConfigurationElementArgs', 'MediaInsightsPipelineConfigurationElementArgsDict']]]] elements: Collection of processors and sinks to transform media and deliver data.
        :param pulumi.Input[str] name: Configuration name.
        :param pulumi.Input[Union['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs', 'MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgsDict']] real_time_alert_configuration: Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
        :param pulumi.Input[str] resource_access_role_arn: ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of tags for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MediaInsightsPipelineConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Chime SDK Media Pipelines Media Insights Pipeline Configuration.
        Consult the [Call analytics developer guide](https://docs.aws.amazon.com/chime-sdk/latest/dg/call-analytics.html) for more detailed information about usage.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kinesis.Stream("example",
            name="example",
            shard_count=2)
        media_pipelines_assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["mediapipelines.chime.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        call_analytics_role = aws.iam.Role("call_analytics_role",
            name="CallAnalyticsRole",
            assume_role_policy=media_pipelines_assume_role.json)
        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyBasicConfiguration",
            resource_access_role_arn=call_analytics_role.arn,
            elements=[
                {
                    "type": "AmazonTranscribeCallAnalyticsProcessor",
                    "amazon_transcribe_call_analytics_processor_configuration": {
                        "language_code": "en-US",
                    },
                },
                {
                    "type": "KinesisDataStreamSink",
                    "kinesis_data_stream_sink_configuration": {
                        "insights_target": example.arn,
                    },
                },
            ],
            tags={
                "Key1": "Value1",
                "Key2": "Value2",
            })
        ```

        - The required policies on `call_analytics_role` will vary based on the selected processors. See [Call analytics resource access role](https://docs.aws.amazon.com/chime-sdk/latest/dg/ca-resource-access-role.html) for directions on choosing appropriate policies.

        ### Transcribe Call Analytics processor usage

        ```python
        import pulumi
        import pulumi_aws as aws

        transcribe_assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["transcribe.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        post_call_role = aws.iam.Role("post_call_role",
            name="PostCallAccessRole",
            assume_role_policy=transcribe_assume_role.json)
        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyCallAnalyticsConfiguration",
            resource_access_role_arn=example_aws_iam_role["arn"],
            elements=[
                {
                    "type": "AmazonTranscribeCallAnalyticsProcessor",
                    "amazon_transcribe_call_analytics_processor_configuration": {
                        "call_analytics_stream_categories": [
                            "category_1",
                            "category_2",
                        ],
                        "content_redaction_type": "PII",
                        "enable_partial_results_stabilization": True,
                        "filter_partial_results": True,
                        "language_code": "en-US",
                        "language_model_name": "MyLanguageModel",
                        "partial_results_stability": "high",
                        "pii_entity_types": "ADDRESS,BANK_ACCOUNT_NUMBER",
                        "post_call_analytics_settings": {
                            "content_redaction_output": "redacted",
                            "data_access_role_arn": post_call_role.arn,
                            "output_encryption_kms_key_id": "MyKmsKeyId",
                            "output_location": "s3://MyBucket",
                        },
                        "vocabulary_filter_method": "mask",
                        "vocabulary_filter_name": "MyVocabularyFilter",
                        "vocabulary_name": "MyVocabulary",
                    },
                },
                {
                    "type": "KinesisDataStreamSink",
                    "kinesis_data_stream_sink_configuration": {
                        "insights_target": example["arn"],
                    },
                },
            ])
        ```

        ### Real time alerts usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyRealTimeAlertConfiguration",
            resource_access_role_arn=call_analytics_role["arn"],
            elements=[
                {
                    "type": "AmazonTranscribeCallAnalyticsProcessor",
                    "amazon_transcribe_call_analytics_processor_configuration": {
                        "language_code": "en-US",
                    },
                },
                {
                    "type": "KinesisDataStreamSink",
                    "kinesis_data_stream_sink_configuration": {
                        "insights_target": example["arn"],
                    },
                },
            ],
            real_time_alert_configuration={
                "disabled": False,
                "rules": [
                    {
                        "type": "IssueDetection",
                        "issue_detection_configuration": {
                            "rule_name": "MyIssueDetectionRule",
                        },
                    },
                    {
                        "type": "KeywordMatch",
                        "keyword_match_configuration": {
                            "keywords": [
                                "keyword1",
                                "keyword2",
                            ],
                            "negate": False,
                            "rule_name": "MyKeywordMatchRule",
                        },
                    },
                    {
                        "type": "Sentiment",
                        "sentiment_configuration": {
                            "rule_name": "MySentimentRule",
                            "sentiment_type": "NEGATIVE",
                            "time_period": 60,
                        },
                    },
                ],
            })
        ```

        ### Transcribe processor usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyTranscribeConfiguration",
            resource_access_role_arn=example_aws_iam_role["arn"],
            elements=[
                {
                    "type": "AmazonTranscribeProcessor",
                    "amazon_transcribe_processor_configuration": {
                        "content_identification_type": "PII",
                        "enable_partial_results_stabilization": True,
                        "filter_partial_results": True,
                        "language_code": "en-US",
                        "language_model_name": "MyLanguageModel",
                        "partial_results_stability": "high",
                        "pii_entity_types": "ADDRESS,BANK_ACCOUNT_NUMBER",
                        "show_speaker_label": True,
                        "vocabulary_filter_method": "mask",
                        "vocabulary_filter_name": "MyVocabularyFilter",
                        "vocabulary_name": "MyVocabulary",
                    },
                },
                {
                    "type": "KinesisDataStreamSink",
                    "kinesis_data_stream_sink_configuration": {
                        "insights_target": example["arn"],
                    },
                },
            ])
        ```

        ### Voice analytics processor usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyVoiceAnalyticsConfiguration",
            resource_access_role_arn=example["arn"],
            elements=[
                {
                    "type": "VoiceAnalyticsProcessor",
                    "voice_analytics_processor_configuration": {
                        "speaker_search_status": "Enabled",
                        "voice_tone_analysis_status": "Enabled",
                    },
                },
                {
                    "type": "LambdaFunctionSink",
                    "lambda_function_sink_configuration": {
                        "insights_target": "arn:aws:lambda:us-west-2:1111111111:function:MyFunction",
                    },
                },
                {
                    "type": "SnsTopicSink",
                    "sns_topic_sink_configuration": {
                        "insights_target": "arn:aws:sns:us-west-2:1111111111:topic/MyTopic",
                    },
                },
                {
                    "type": "SqsQueueSink",
                    "sqs_queue_sink_configuration": {
                        "insights_target": "arn:aws:sqs:us-west-2:1111111111:queue/MyQueue",
                    },
                },
                {
                    "type": "KinesisDataStreamSink",
                    "kinesis_data_stream_sink_configuration": {
                        "insights_target": test["arn"],
                    },
                },
            ])
        ```

        ### S3 Recording sink usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_configuration = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("my_configuration",
            name="MyS3RecordingConfiguration",
            resource_access_role_arn=example["arn"],
            elements=[{
                "type": "S3RecordingSink",
                "s3_recording_sink_configuration": {
                    "destination": "arn:aws:s3:::MyBucket",
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import Chime SDK Media Pipelines Media Insights Pipeline Configuration using the `id`. For example:

        ```sh
        $ pulumi import aws:chimesdkmediapipelines/mediaInsightsPipelineConfiguration:MediaInsightsPipelineConfiguration example abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param MediaInsightsPipelineConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MediaInsightsPipelineConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaInsightsPipelineConfigurationElementArgs', 'MediaInsightsPipelineConfigurationElementArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 real_time_alert_configuration: Optional[pulumi.Input[Union['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs', 'MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgsDict']]] = None,
                 resource_access_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MediaInsightsPipelineConfigurationArgs.__new__(MediaInsightsPipelineConfigurationArgs)

            if elements is None and not opts.urn:
                raise TypeError("Missing required property 'elements'")
            __props__.__dict__["elements"] = elements
            __props__.__dict__["name"] = name
            __props__.__dict__["real_time_alert_configuration"] = real_time_alert_configuration
            if resource_access_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'resource_access_role_arn'")
            __props__.__dict__["resource_access_role_arn"] = resource_access_role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(MediaInsightsPipelineConfiguration, __self__).__init__(
            'aws:chimesdkmediapipelines/mediaInsightsPipelineConfiguration:MediaInsightsPipelineConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            elements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaInsightsPipelineConfigurationElementArgs', 'MediaInsightsPipelineConfigurationElementArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            real_time_alert_configuration: Optional[pulumi.Input[Union['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs', 'MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgsDict']]] = None,
            resource_access_role_arn: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'MediaInsightsPipelineConfiguration':
        """
        Get an existing MediaInsightsPipelineConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the Media Insights Pipeline Configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MediaInsightsPipelineConfigurationElementArgs', 'MediaInsightsPipelineConfigurationElementArgsDict']]]] elements: Collection of processors and sinks to transform media and deliver data.
        :param pulumi.Input[str] name: Configuration name.
        :param pulumi.Input[Union['MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs', 'MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgsDict']] real_time_alert_configuration: Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
        :param pulumi.Input[str] resource_access_role_arn: ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of tags for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MediaInsightsPipelineConfigurationState.__new__(_MediaInsightsPipelineConfigurationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["elements"] = elements
        __props__.__dict__["name"] = name
        __props__.__dict__["real_time_alert_configuration"] = real_time_alert_configuration
        __props__.__dict__["resource_access_role_arn"] = resource_access_role_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return MediaInsightsPipelineConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the Media Insights Pipeline Configuration.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def elements(self) -> pulumi.Output[Sequence['outputs.MediaInsightsPipelineConfigurationElement']]:
        """
        Collection of processors and sinks to transform media and deliver data.
        """
        return pulumi.get(self, "elements")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="realTimeAlertConfiguration")
    def real_time_alert_configuration(self) -> pulumi.Output[Optional['outputs.MediaInsightsPipelineConfigurationRealTimeAlertConfiguration']]:
        """
        Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
        """
        return pulumi.get(self, "real_time_alert_configuration")

    @property
    @pulumi.getter(name="resourceAccessRoleArn")
    def resource_access_role_arn(self) -> pulumi.Output[str]:
        """
        ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
        """
        return pulumi.get(self, "resource_access_role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of tags for the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

