# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StackSetInstanceArgs', 'StackSetInstance']

@pulumi.input_type
class StackSetInstanceArgs:
    def __init__(__self__, *,
                 stack_set_name: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 call_as: Optional[pulumi.Input[str]] = None,
                 deployment_targets: Optional[pulumi.Input['StackSetInstanceDeploymentTargetsArgs']] = None,
                 operation_preferences: Optional[pulumi.Input['StackSetInstanceOperationPreferencesArgs']] = None,
                 parameter_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 retain_stack: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a StackSetInstance resource.
        :param pulumi.Input[str] stack_set_name: Name of the StackSet.
        :param pulumi.Input[str] account_id: Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
        :param pulumi.Input[str] call_as: Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        :param pulumi.Input['StackSetInstanceDeploymentTargetsArgs'] deployment_targets: AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
        :param pulumi.Input['StackSetInstanceOperationPreferencesArgs'] operation_preferences: Preferences for how AWS CloudFormation performs a stack set operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameter_overrides: Key-value map of input parameters to override from the StackSet for this Instance.
        :param pulumi.Input[str] region: Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
        :param pulumi.Input[bool] retain_stack: During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
        """
        pulumi.set(__self__, "stack_set_name", stack_set_name)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if call_as is not None:
            pulumi.set(__self__, "call_as", call_as)
        if deployment_targets is not None:
            pulumi.set(__self__, "deployment_targets", deployment_targets)
        if operation_preferences is not None:
            pulumi.set(__self__, "operation_preferences", operation_preferences)
        if parameter_overrides is not None:
            pulumi.set(__self__, "parameter_overrides", parameter_overrides)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retain_stack is not None:
            pulumi.set(__self__, "retain_stack", retain_stack)

    @property
    @pulumi.getter(name="stackSetName")
    def stack_set_name(self) -> pulumi.Input[str]:
        """
        Name of the StackSet.
        """
        return pulumi.get(self, "stack_set_name")

    @stack_set_name.setter
    def stack_set_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "stack_set_name", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="callAs")
    def call_as(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        """
        return pulumi.get(self, "call_as")

    @call_as.setter
    def call_as(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "call_as", value)

    @property
    @pulumi.getter(name="deploymentTargets")
    def deployment_targets(self) -> Optional[pulumi.Input['StackSetInstanceDeploymentTargetsArgs']]:
        """
        AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
        """
        return pulumi.get(self, "deployment_targets")

    @deployment_targets.setter
    def deployment_targets(self, value: Optional[pulumi.Input['StackSetInstanceDeploymentTargetsArgs']]):
        pulumi.set(self, "deployment_targets", value)

    @property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> Optional[pulumi.Input['StackSetInstanceOperationPreferencesArgs']]:
        """
        Preferences for how AWS CloudFormation performs a stack set operation.
        """
        return pulumi.get(self, "operation_preferences")

    @operation_preferences.setter
    def operation_preferences(self, value: Optional[pulumi.Input['StackSetInstanceOperationPreferencesArgs']]):
        pulumi.set(self, "operation_preferences", value)

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of input parameters to override from the StackSet for this Instance.
        """
        return pulumi.get(self, "parameter_overrides")

    @parameter_overrides.setter
    def parameter_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameter_overrides", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="retainStack")
    def retain_stack(self) -> Optional[pulumi.Input[bool]]:
        """
        During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
        """
        return pulumi.get(self, "retain_stack")

    @retain_stack.setter
    def retain_stack(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "retain_stack", value)


@pulumi.input_type
class _StackSetInstanceState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 call_as: Optional[pulumi.Input[str]] = None,
                 deployment_targets: Optional[pulumi.Input['StackSetInstanceDeploymentTargetsArgs']] = None,
                 operation_preferences: Optional[pulumi.Input['StackSetInstanceOperationPreferencesArgs']] = None,
                 organizational_unit_id: Optional[pulumi.Input[str]] = None,
                 parameter_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 retain_stack: Optional[pulumi.Input[bool]] = None,
                 stack_id: Optional[pulumi.Input[str]] = None,
                 stack_instance_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['StackSetInstanceStackInstanceSummaryArgs']]]] = None,
                 stack_set_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering StackSetInstance resources.
        :param pulumi.Input[str] account_id: Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
        :param pulumi.Input[str] call_as: Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        :param pulumi.Input['StackSetInstanceDeploymentTargetsArgs'] deployment_targets: AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
        :param pulumi.Input['StackSetInstanceOperationPreferencesArgs'] operation_preferences: Preferences for how AWS CloudFormation performs a stack set operation.
        :param pulumi.Input[str] organizational_unit_id: Organizational unit ID in which the stack is deployed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameter_overrides: Key-value map of input parameters to override from the StackSet for this Instance.
        :param pulumi.Input[str] region: Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
        :param pulumi.Input[bool] retain_stack: During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
        :param pulumi.Input[str] stack_id: Stack identifier.
        :param pulumi.Input[Sequence[pulumi.Input['StackSetInstanceStackInstanceSummaryArgs']]] stack_instance_summaries: List of stack instances created from an organizational unit deployment target. This will only be populated when `deployment_targets` is set. See `stack_instance_summaries`.
        :param pulumi.Input[str] stack_set_name: Name of the StackSet.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if call_as is not None:
            pulumi.set(__self__, "call_as", call_as)
        if deployment_targets is not None:
            pulumi.set(__self__, "deployment_targets", deployment_targets)
        if operation_preferences is not None:
            pulumi.set(__self__, "operation_preferences", operation_preferences)
        if organizational_unit_id is not None:
            pulumi.set(__self__, "organizational_unit_id", organizational_unit_id)
        if parameter_overrides is not None:
            pulumi.set(__self__, "parameter_overrides", parameter_overrides)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retain_stack is not None:
            pulumi.set(__self__, "retain_stack", retain_stack)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)
        if stack_instance_summaries is not None:
            pulumi.set(__self__, "stack_instance_summaries", stack_instance_summaries)
        if stack_set_name is not None:
            pulumi.set(__self__, "stack_set_name", stack_set_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="callAs")
    def call_as(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        """
        return pulumi.get(self, "call_as")

    @call_as.setter
    def call_as(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "call_as", value)

    @property
    @pulumi.getter(name="deploymentTargets")
    def deployment_targets(self) -> Optional[pulumi.Input['StackSetInstanceDeploymentTargetsArgs']]:
        """
        AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
        """
        return pulumi.get(self, "deployment_targets")

    @deployment_targets.setter
    def deployment_targets(self, value: Optional[pulumi.Input['StackSetInstanceDeploymentTargetsArgs']]):
        pulumi.set(self, "deployment_targets", value)

    @property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> Optional[pulumi.Input['StackSetInstanceOperationPreferencesArgs']]:
        """
        Preferences for how AWS CloudFormation performs a stack set operation.
        """
        return pulumi.get(self, "operation_preferences")

    @operation_preferences.setter
    def operation_preferences(self, value: Optional[pulumi.Input['StackSetInstanceOperationPreferencesArgs']]):
        pulumi.set(self, "operation_preferences", value)

    @property
    @pulumi.getter(name="organizationalUnitId")
    def organizational_unit_id(self) -> Optional[pulumi.Input[str]]:
        """
        Organizational unit ID in which the stack is deployed.
        """
        return pulumi.get(self, "organizational_unit_id")

    @organizational_unit_id.setter
    def organizational_unit_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_id", value)

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of input parameters to override from the StackSet for this Instance.
        """
        return pulumi.get(self, "parameter_overrides")

    @parameter_overrides.setter
    def parameter_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameter_overrides", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="retainStack")
    def retain_stack(self) -> Optional[pulumi.Input[bool]]:
        """
        During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
        """
        return pulumi.get(self, "retain_stack")

    @retain_stack.setter
    def retain_stack(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "retain_stack", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[str]]:
        """
        Stack identifier.
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_id", value)

    @property
    @pulumi.getter(name="stackInstanceSummaries")
    def stack_instance_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackSetInstanceStackInstanceSummaryArgs']]]]:
        """
        List of stack instances created from an organizational unit deployment target. This will only be populated when `deployment_targets` is set. See `stack_instance_summaries`.
        """
        return pulumi.get(self, "stack_instance_summaries")

    @stack_instance_summaries.setter
    def stack_instance_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackSetInstanceStackInstanceSummaryArgs']]]]):
        pulumi.set(self, "stack_instance_summaries", value)

    @property
    @pulumi.getter(name="stackSetName")
    def stack_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the StackSet.
        """
        return pulumi.get(self, "stack_set_name")

    @stack_set_name.setter
    def stack_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_set_name", value)


class StackSetInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 call_as: Optional[pulumi.Input[str]] = None,
                 deployment_targets: Optional[pulumi.Input[Union['StackSetInstanceDeploymentTargetsArgs', 'StackSetInstanceDeploymentTargetsArgsDict']]] = None,
                 operation_preferences: Optional[pulumi.Input[Union['StackSetInstanceOperationPreferencesArgs', 'StackSetInstanceOperationPreferencesArgsDict']]] = None,
                 parameter_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 retain_stack: Optional[pulumi.Input[bool]] = None,
                 stack_set_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a CloudFormation StackSet Instance. Instances are managed in the account and region of the StackSet after the target account permissions have been configured. Additional information about StackSets can be found in the [AWS CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html).

        > **NOTE:** All target accounts must have an IAM Role created that matches the name of the execution role configured in the StackSet (the `execution_role_name` argument in the `cloudformation.StackSet` resource) in a trust relationship with the administrative account or administration IAM Role. The execution role must have appropriate permissions to manage resources defined in the template along with those required for StackSets to operate. See the [AWS CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html) for more details.

        > **NOTE:** To retain the Stack during resource destroy, ensure `retain_stack` has been set to `true` in the state first. This must be completed _before_ a deployment that would destroy the resource.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudformation.StackSetInstance("example",
            account_id="123456789012",
            region="us-east-1",
            stack_set_name=example_aws_cloudformation_stack_set["name"])
        ```

        ### Example IAM Setup in Target Account

        ```python
        import pulumi
        import pulumi_aws as aws

        a_ws_cloud_formation_stack_set_execution_role_assume_role_policy = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "effect": "Allow",
            "principals": [{
                "identifiers": [a_ws_cloud_formation_stack_set_administration_role["arn"]],
                "type": "AWS",
            }],
        }])
        a_ws_cloud_formation_stack_set_execution_role = aws.iam.Role("AWSCloudFormationStackSetExecutionRole",
            assume_role_policy=a_ws_cloud_formation_stack_set_execution_role_assume_role_policy.json,
            name="AWSCloudFormationStackSetExecutionRole")
        # Documentation: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html
        # Additional IAM permissions necessary depend on the resources defined in the StackSet template
        a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy = aws.iam.get_policy_document(statements=[{
            "actions": [
                "cloudformation:*",
                "s3:*",
                "sns:*",
            ],
            "effect": "Allow",
            "resources": ["*"],
        }])
        a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy_role_policy = aws.iam.RolePolicy("AWSCloudFormationStackSetExecutionRole_MinimumExecutionPolicy",
            name="MinimumExecutionPolicy",
            policy=a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy.json,
            role=a_ws_cloud_formation_stack_set_execution_role.name)
        ```

        ### Example Deployment across Organizations account

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudformation.StackSetInstance("example",
            deployment_targets={
                "organizational_unit_ids": [example_aws_organizations_organization["roots"][0]["id"]],
            },
            region="us-east-1",
            stack_set_name=example_aws_cloudformation_stack_set["name"])
        ```

        ## Import

        Import CloudFormation StackSet Instances that target AWS Organizational Units using the StackSet name, a slash (`/`) separated list of organizational unit IDs, and target AWS Region separated by commas (`,`). For example:

        Import CloudFormation StackSet Instances when acting a delegated administrator in a member account using the StackSet name, target AWS account ID or slash (`/`) separated list of organizational unit IDs, target AWS Region and `call_as` value separated by commas (`,`). For example:

        Using `pulumi import`, import CloudFormation StackSet Instances that target an AWS Account ID using the StackSet name, target AWS account ID, and target AWS Region separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,123456789012,us-east-1
        ```
        Using `pulumi import`, import CloudFormation StackSet Instances that target AWS Organizational Units using the StackSet name, a slash (`/`) separated list of organizational unit IDs, and target AWS Region separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,ou-sdas-123123123/ou-sdas-789789789,us-east-1
        ```
        Using `pulumi import`, import CloudFormation StackSet Instances when acting a delegated administrator in a member account using the StackSet name, target AWS account ID or slash (`/`) separated list of organizational unit IDs, target AWS Region and `call_as` value separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,ou-sdas-123123123/ou-sdas-789789789,us-east-1,DELEGATED_ADMIN
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
        :param pulumi.Input[str] call_as: Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        :param pulumi.Input[Union['StackSetInstanceDeploymentTargetsArgs', 'StackSetInstanceDeploymentTargetsArgsDict']] deployment_targets: AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
        :param pulumi.Input[Union['StackSetInstanceOperationPreferencesArgs', 'StackSetInstanceOperationPreferencesArgsDict']] operation_preferences: Preferences for how AWS CloudFormation performs a stack set operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameter_overrides: Key-value map of input parameters to override from the StackSet for this Instance.
        :param pulumi.Input[str] region: Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
        :param pulumi.Input[bool] retain_stack: During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
        :param pulumi.Input[str] stack_set_name: Name of the StackSet.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StackSetInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CloudFormation StackSet Instance. Instances are managed in the account and region of the StackSet after the target account permissions have been configured. Additional information about StackSets can be found in the [AWS CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html).

        > **NOTE:** All target accounts must have an IAM Role created that matches the name of the execution role configured in the StackSet (the `execution_role_name` argument in the `cloudformation.StackSet` resource) in a trust relationship with the administrative account or administration IAM Role. The execution role must have appropriate permissions to manage resources defined in the template along with those required for StackSets to operate. See the [AWS CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html) for more details.

        > **NOTE:** To retain the Stack during resource destroy, ensure `retain_stack` has been set to `true` in the state first. This must be completed _before_ a deployment that would destroy the resource.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudformation.StackSetInstance("example",
            account_id="123456789012",
            region="us-east-1",
            stack_set_name=example_aws_cloudformation_stack_set["name"])
        ```

        ### Example IAM Setup in Target Account

        ```python
        import pulumi
        import pulumi_aws as aws

        a_ws_cloud_formation_stack_set_execution_role_assume_role_policy = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "effect": "Allow",
            "principals": [{
                "identifiers": [a_ws_cloud_formation_stack_set_administration_role["arn"]],
                "type": "AWS",
            }],
        }])
        a_ws_cloud_formation_stack_set_execution_role = aws.iam.Role("AWSCloudFormationStackSetExecutionRole",
            assume_role_policy=a_ws_cloud_formation_stack_set_execution_role_assume_role_policy.json,
            name="AWSCloudFormationStackSetExecutionRole")
        # Documentation: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html
        # Additional IAM permissions necessary depend on the resources defined in the StackSet template
        a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy = aws.iam.get_policy_document(statements=[{
            "actions": [
                "cloudformation:*",
                "s3:*",
                "sns:*",
            ],
            "effect": "Allow",
            "resources": ["*"],
        }])
        a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy_role_policy = aws.iam.RolePolicy("AWSCloudFormationStackSetExecutionRole_MinimumExecutionPolicy",
            name="MinimumExecutionPolicy",
            policy=a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy.json,
            role=a_ws_cloud_formation_stack_set_execution_role.name)
        ```

        ### Example Deployment across Organizations account

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudformation.StackSetInstance("example",
            deployment_targets={
                "organizational_unit_ids": [example_aws_organizations_organization["roots"][0]["id"]],
            },
            region="us-east-1",
            stack_set_name=example_aws_cloudformation_stack_set["name"])
        ```

        ## Import

        Import CloudFormation StackSet Instances that target AWS Organizational Units using the StackSet name, a slash (`/`) separated list of organizational unit IDs, and target AWS Region separated by commas (`,`). For example:

        Import CloudFormation StackSet Instances when acting a delegated administrator in a member account using the StackSet name, target AWS account ID or slash (`/`) separated list of organizational unit IDs, target AWS Region and `call_as` value separated by commas (`,`). For example:

        Using `pulumi import`, import CloudFormation StackSet Instances that target an AWS Account ID using the StackSet name, target AWS account ID, and target AWS Region separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,123456789012,us-east-1
        ```
        Using `pulumi import`, import CloudFormation StackSet Instances that target AWS Organizational Units using the StackSet name, a slash (`/`) separated list of organizational unit IDs, and target AWS Region separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,ou-sdas-123123123/ou-sdas-789789789,us-east-1
        ```
        Using `pulumi import`, import CloudFormation StackSet Instances when acting a delegated administrator in a member account using the StackSet name, target AWS account ID or slash (`/`) separated list of organizational unit IDs, target AWS Region and `call_as` value separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,ou-sdas-123123123/ou-sdas-789789789,us-east-1,DELEGATED_ADMIN
        ```

        :param str resource_name: The name of the resource.
        :param StackSetInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackSetInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 call_as: Optional[pulumi.Input[str]] = None,
                 deployment_targets: Optional[pulumi.Input[Union['StackSetInstanceDeploymentTargetsArgs', 'StackSetInstanceDeploymentTargetsArgsDict']]] = None,
                 operation_preferences: Optional[pulumi.Input[Union['StackSetInstanceOperationPreferencesArgs', 'StackSetInstanceOperationPreferencesArgsDict']]] = None,
                 parameter_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 retain_stack: Optional[pulumi.Input[bool]] = None,
                 stack_set_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackSetInstanceArgs.__new__(StackSetInstanceArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["call_as"] = call_as
            __props__.__dict__["deployment_targets"] = deployment_targets
            __props__.__dict__["operation_preferences"] = operation_preferences
            __props__.__dict__["parameter_overrides"] = parameter_overrides
            __props__.__dict__["region"] = region
            __props__.__dict__["retain_stack"] = retain_stack
            if stack_set_name is None and not opts.urn:
                raise TypeError("Missing required property 'stack_set_name'")
            __props__.__dict__["stack_set_name"] = stack_set_name
            __props__.__dict__["organizational_unit_id"] = None
            __props__.__dict__["stack_id"] = None
            __props__.__dict__["stack_instance_summaries"] = None
        super(StackSetInstance, __self__).__init__(
            'aws:cloudformation/stackSetInstance:StackSetInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            call_as: Optional[pulumi.Input[str]] = None,
            deployment_targets: Optional[pulumi.Input[Union['StackSetInstanceDeploymentTargetsArgs', 'StackSetInstanceDeploymentTargetsArgsDict']]] = None,
            operation_preferences: Optional[pulumi.Input[Union['StackSetInstanceOperationPreferencesArgs', 'StackSetInstanceOperationPreferencesArgsDict']]] = None,
            organizational_unit_id: Optional[pulumi.Input[str]] = None,
            parameter_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            retain_stack: Optional[pulumi.Input[bool]] = None,
            stack_id: Optional[pulumi.Input[str]] = None,
            stack_instance_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackSetInstanceStackInstanceSummaryArgs', 'StackSetInstanceStackInstanceSummaryArgsDict']]]]] = None,
            stack_set_name: Optional[pulumi.Input[str]] = None) -> 'StackSetInstance':
        """
        Get an existing StackSetInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
        :param pulumi.Input[str] call_as: Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        :param pulumi.Input[Union['StackSetInstanceDeploymentTargetsArgs', 'StackSetInstanceDeploymentTargetsArgsDict']] deployment_targets: AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
        :param pulumi.Input[Union['StackSetInstanceOperationPreferencesArgs', 'StackSetInstanceOperationPreferencesArgsDict']] operation_preferences: Preferences for how AWS CloudFormation performs a stack set operation.
        :param pulumi.Input[str] organizational_unit_id: Organizational unit ID in which the stack is deployed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameter_overrides: Key-value map of input parameters to override from the StackSet for this Instance.
        :param pulumi.Input[str] region: Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
        :param pulumi.Input[bool] retain_stack: During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
        :param pulumi.Input[str] stack_id: Stack identifier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackSetInstanceStackInstanceSummaryArgs', 'StackSetInstanceStackInstanceSummaryArgsDict']]]] stack_instance_summaries: List of stack instances created from an organizational unit deployment target. This will only be populated when `deployment_targets` is set. See `stack_instance_summaries`.
        :param pulumi.Input[str] stack_set_name: Name of the StackSet.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StackSetInstanceState.__new__(_StackSetInstanceState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["call_as"] = call_as
        __props__.__dict__["deployment_targets"] = deployment_targets
        __props__.__dict__["operation_preferences"] = operation_preferences
        __props__.__dict__["organizational_unit_id"] = organizational_unit_id
        __props__.__dict__["parameter_overrides"] = parameter_overrides
        __props__.__dict__["region"] = region
        __props__.__dict__["retain_stack"] = retain_stack
        __props__.__dict__["stack_id"] = stack_id
        __props__.__dict__["stack_instance_summaries"] = stack_instance_summaries
        __props__.__dict__["stack_set_name"] = stack_set_name
        return StackSetInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="callAs")
    def call_as(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        """
        return pulumi.get(self, "call_as")

    @property
    @pulumi.getter(name="deploymentTargets")
    def deployment_targets(self) -> pulumi.Output[Optional['outputs.StackSetInstanceDeploymentTargets']]:
        """
        AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
        """
        return pulumi.get(self, "deployment_targets")

    @property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> pulumi.Output[Optional['outputs.StackSetInstanceOperationPreferences']]:
        """
        Preferences for how AWS CloudFormation performs a stack set operation.
        """
        return pulumi.get(self, "operation_preferences")

    @property
    @pulumi.getter(name="organizationalUnitId")
    def organizational_unit_id(self) -> pulumi.Output[str]:
        """
        Organizational unit ID in which the stack is deployed.
        """
        return pulumi.get(self, "organizational_unit_id")

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of input parameters to override from the StackSet for this Instance.
        """
        return pulumi.get(self, "parameter_overrides")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="retainStack")
    def retain_stack(self) -> pulumi.Output[Optional[bool]]:
        """
        During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
        """
        return pulumi.get(self, "retain_stack")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[str]:
        """
        Stack identifier.
        """
        return pulumi.get(self, "stack_id")

    @property
    @pulumi.getter(name="stackInstanceSummaries")
    def stack_instance_summaries(self) -> pulumi.Output[Sequence['outputs.StackSetInstanceStackInstanceSummary']]:
        """
        List of stack instances created from an organizational unit deployment target. This will only be populated when `deployment_targets` is set. See `stack_instance_summaries`.
        """
        return pulumi.get(self, "stack_instance_summaries")

    @property
    @pulumi.getter(name="stackSetName")
    def stack_set_name(self) -> pulumi.Output[str]:
        """
        Name of the StackSet.
        """
        return pulumi.get(self, "stack_set_name")

