# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEventSourceResult',
    'AwaitableGetEventSourceResult',
    'get_event_source',
    'get_event_source_output',
]

@pulumi.output_type
class GetEventSourceResult:
    """
    A collection of values returned by getEventSource.
    """
    def __init__(__self__, arn=None, created_by=None, id=None, name=None, name_prefix=None, state=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_prefix and not isinstance(name_prefix, str):
            raise TypeError("Expected argument 'name_prefix' to be a str")
        pulumi.set(__self__, "name_prefix", name_prefix)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the partner event source
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        Name of the SaaS partner that created the event source
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the event source
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[str]:
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the event source (`ACTIVE` or `PENDING`)
        """
        return pulumi.get(self, "state")


class AwaitableGetEventSourceResult(GetEventSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventSourceResult(
            arn=self.arn,
            created_by=self.created_by,
            id=self.id,
            name=self.name,
            name_prefix=self.name_prefix,
            state=self.state)


def get_event_source(name_prefix: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventSourceResult:
    """
    Use this data source to get information about an EventBridge Partner Event Source. This data source will only return one partner event source. An error will be returned if multiple sources match the same name prefix.

    > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    examplepartner = aws.cloudwatch.get_event_source(name_prefix="aws.partner/examplepartner.com")
    ```


    :param str name_prefix: Specifying this limits the results to only those partner event sources with names that start with the specified prefix
    """
    __args__ = dict()
    __args__['namePrefix'] = name_prefix
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cloudwatch/getEventSource:getEventSource', __args__, opts=opts, typ=GetEventSourceResult).value

    return AwaitableGetEventSourceResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_by=pulumi.get(__ret__, 'created_by'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        name_prefix=pulumi.get(__ret__, 'name_prefix'),
        state=pulumi.get(__ret__, 'state'))
def get_event_source_output(name_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEventSourceResult]:
    """
    Use this data source to get information about an EventBridge Partner Event Source. This data source will only return one partner event source. An error will be returned if multiple sources match the same name prefix.

    > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    examplepartner = aws.cloudwatch.get_event_source(name_prefix="aws.partner/examplepartner.com")
    ```


    :param str name_prefix: Specifying this limits the results to only those partner event sources with names that start with the specified prefix
    """
    __args__ = dict()
    __args__['namePrefix'] = name_prefix
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cloudwatch/getEventSource:getEventSource', __args__, opts=opts, typ=GetEventSourceResult)
    return __ret__.apply(lambda __response__: GetEventSourceResult(
        arn=pulumi.get(__response__, 'arn'),
        created_by=pulumi.get(__response__, 'created_by'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        name_prefix=pulumi.get(__response__, 'name_prefix'),
        state=pulumi.get(__response__, 'state')))
