# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LogAccountPolicyArgs', 'LogAccountPolicy']

@pulumi.input_type
class LogAccountPolicyArgs:
    def __init__(__self__, *,
                 policy_document: pulumi.Input[str],
                 policy_name: pulumi.Input[str],
                 policy_type: pulumi.Input[str],
                 scope: Optional[pulumi.Input[str]] = None,
                 selection_criteria: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LogAccountPolicy resource.
        :param pulumi.Input[str] policy_document: Text of the account policy. Refer to the [AWS docs](https://docs.aws.amazon.com/cli/latest/reference/logs/put-account-policy.html) for more information.
        :param pulumi.Input[str] policy_name: Name of the account policy.
        :param pulumi.Input[str] policy_type: Type of account policy. Either `DATA_PROTECTION_POLICY` or `SUBSCRIPTION_FILTER_POLICY`. You can have one account policy per type in an account.
        :param pulumi.Input[str] scope: Currently defaults to and only accepts the value: `ALL`.
        :param pulumi.Input[str] selection_criteria: Criteria for applying a subscription filter policy to a selection of log groups. The only allowable criteria selector is `LogGroupName NOT IN []`.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "policy_type", policy_type)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if selection_criteria is not None:
            pulumi.set(__self__, "selection_criteria", selection_criteria)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Input[str]:
        """
        Text of the account policy. Refer to the [AWS docs](https://docs.aws.amazon.com/cli/latest/reference/logs/put-account-policy.html) for more information.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[str]:
        """
        Name of the account policy.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_name", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[str]:
        """
        Type of account policy. Either `DATA_PROTECTION_POLICY` or `SUBSCRIPTION_FILTER_POLICY`. You can have one account policy per type in an account.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        Currently defaults to and only accepts the value: `ALL`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="selectionCriteria")
    def selection_criteria(self) -> Optional[pulumi.Input[str]]:
        """
        Criteria for applying a subscription filter policy to a selection of log groups. The only allowable criteria selector is `LogGroupName NOT IN []`.
        """
        return pulumi.get(self, "selection_criteria")

    @selection_criteria.setter
    def selection_criteria(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selection_criteria", value)


@pulumi.input_type
class _LogAccountPolicyState:
    def __init__(__self__, *,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 selection_criteria: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LogAccountPolicy resources.
        :param pulumi.Input[str] policy_document: Text of the account policy. Refer to the [AWS docs](https://docs.aws.amazon.com/cli/latest/reference/logs/put-account-policy.html) for more information.
        :param pulumi.Input[str] policy_name: Name of the account policy.
        :param pulumi.Input[str] policy_type: Type of account policy. Either `DATA_PROTECTION_POLICY` or `SUBSCRIPTION_FILTER_POLICY`. You can have one account policy per type in an account.
        :param pulumi.Input[str] scope: Currently defaults to and only accepts the value: `ALL`.
        :param pulumi.Input[str] selection_criteria: Criteria for applying a subscription filter policy to a selection of log groups. The only allowable criteria selector is `LogGroupName NOT IN []`.
        """
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if selection_criteria is not None:
            pulumi.set(__self__, "selection_criteria", selection_criteria)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[str]]:
        """
        Text of the account policy. Refer to the [AWS docs](https://docs.aws.amazon.com/cli/latest/reference/logs/put-account-policy.html) for more information.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the account policy.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of account policy. Either `DATA_PROTECTION_POLICY` or `SUBSCRIPTION_FILTER_POLICY`. You can have one account policy per type in an account.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        Currently defaults to and only accepts the value: `ALL`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="selectionCriteria")
    def selection_criteria(self) -> Optional[pulumi.Input[str]]:
        """
        Criteria for applying a subscription filter policy to a selection of log groups. The only allowable criteria selector is `LogGroupName NOT IN []`.
        """
        return pulumi.get(self, "selection_criteria")

    @selection_criteria.setter
    def selection_criteria(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selection_criteria", value)


class LogAccountPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 selection_criteria: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a CloudWatch Log Account Policy resource.

        ## Example Usage

        ### Account Data Protection Policy

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        data_protection = aws.cloudwatch.LogAccountPolicy("data_protection",
            policy_name="data-protection",
            policy_type="DATA_PROTECTION_POLICY",
            policy_document=json.dumps({
                "Name": "DataProtection",
                "Version": "2021-06-01",
                "Statement": [
                    {
                        "Sid": "Audit",
                        "DataIdentifier": ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
                        "Operation": {
                            "Audit": {
                                "FindingsDestination": {},
                            },
                        },
                    },
                    {
                        "Sid": "Redact",
                        "DataIdentifier": ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
                        "Operation": {
                            "Deidentify": {
                                "MaskConfig": {},
                            },
                        },
                    },
                ],
            }))
        ```

        ### Subscription Filter Policy

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        subscription_filter = aws.cloudwatch.LogAccountPolicy("subscription_filter",
            policy_name="subscription-filter",
            policy_type="SUBSCRIPTION_FILTER_POLICY",
            policy_document=json.dumps({
                "DestinationArn": test["arn"],
                "FilterPattern": "test",
            }),
            selection_criteria="LogGroupName NOT IN [\\"excluded_log_group_name\\"]")
        ```

        ## Import

        Using `pulumi import`, import this resource using the `policy_name` and `policy_type` separated by `:`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/logAccountPolicy:LogAccountPolicy example "my-account-policy:SUBSCRIPTION_FILTER_POLICY"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] policy_document: Text of the account policy. Refer to the [AWS docs](https://docs.aws.amazon.com/cli/latest/reference/logs/put-account-policy.html) for more information.
        :param pulumi.Input[str] policy_name: Name of the account policy.
        :param pulumi.Input[str] policy_type: Type of account policy. Either `DATA_PROTECTION_POLICY` or `SUBSCRIPTION_FILTER_POLICY`. You can have one account policy per type in an account.
        :param pulumi.Input[str] scope: Currently defaults to and only accepts the value: `ALL`.
        :param pulumi.Input[str] selection_criteria: Criteria for applying a subscription filter policy to a selection of log groups. The only allowable criteria selector is `LogGroupName NOT IN []`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogAccountPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CloudWatch Log Account Policy resource.

        ## Example Usage

        ### Account Data Protection Policy

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        data_protection = aws.cloudwatch.LogAccountPolicy("data_protection",
            policy_name="data-protection",
            policy_type="DATA_PROTECTION_POLICY",
            policy_document=json.dumps({
                "Name": "DataProtection",
                "Version": "2021-06-01",
                "Statement": [
                    {
                        "Sid": "Audit",
                        "DataIdentifier": ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
                        "Operation": {
                            "Audit": {
                                "FindingsDestination": {},
                            },
                        },
                    },
                    {
                        "Sid": "Redact",
                        "DataIdentifier": ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
                        "Operation": {
                            "Deidentify": {
                                "MaskConfig": {},
                            },
                        },
                    },
                ],
            }))
        ```

        ### Subscription Filter Policy

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        subscription_filter = aws.cloudwatch.LogAccountPolicy("subscription_filter",
            policy_name="subscription-filter",
            policy_type="SUBSCRIPTION_FILTER_POLICY",
            policy_document=json.dumps({
                "DestinationArn": test["arn"],
                "FilterPattern": "test",
            }),
            selection_criteria="LogGroupName NOT IN [\\"excluded_log_group_name\\"]")
        ```

        ## Import

        Using `pulumi import`, import this resource using the `policy_name` and `policy_type` separated by `:`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/logAccountPolicy:LogAccountPolicy example "my-account-policy:SUBSCRIPTION_FILTER_POLICY"
        ```

        :param str resource_name: The name of the resource.
        :param LogAccountPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogAccountPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 selection_criteria: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogAccountPolicyArgs.__new__(LogAccountPolicyArgs)

            if policy_document is None and not opts.urn:
                raise TypeError("Missing required property 'policy_document'")
            __props__.__dict__["policy_document"] = policy_document
            if policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'policy_name'")
            __props__.__dict__["policy_name"] = policy_name
            if policy_type is None and not opts.urn:
                raise TypeError("Missing required property 'policy_type'")
            __props__.__dict__["policy_type"] = policy_type
            __props__.__dict__["scope"] = scope
            __props__.__dict__["selection_criteria"] = selection_criteria
        super(LogAccountPolicy, __self__).__init__(
            'aws:cloudwatch/logAccountPolicy:LogAccountPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            policy_document: Optional[pulumi.Input[str]] = None,
            policy_name: Optional[pulumi.Input[str]] = None,
            policy_type: Optional[pulumi.Input[str]] = None,
            scope: Optional[pulumi.Input[str]] = None,
            selection_criteria: Optional[pulumi.Input[str]] = None) -> 'LogAccountPolicy':
        """
        Get an existing LogAccountPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] policy_document: Text of the account policy. Refer to the [AWS docs](https://docs.aws.amazon.com/cli/latest/reference/logs/put-account-policy.html) for more information.
        :param pulumi.Input[str] policy_name: Name of the account policy.
        :param pulumi.Input[str] policy_type: Type of account policy. Either `DATA_PROTECTION_POLICY` or `SUBSCRIPTION_FILTER_POLICY`. You can have one account policy per type in an account.
        :param pulumi.Input[str] scope: Currently defaults to and only accepts the value: `ALL`.
        :param pulumi.Input[str] selection_criteria: Criteria for applying a subscription filter policy to a selection of log groups. The only allowable criteria selector is `LogGroupName NOT IN []`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogAccountPolicyState.__new__(_LogAccountPolicyState)

        __props__.__dict__["policy_document"] = policy_document
        __props__.__dict__["policy_name"] = policy_name
        __props__.__dict__["policy_type"] = policy_type
        __props__.__dict__["scope"] = scope
        __props__.__dict__["selection_criteria"] = selection_criteria
        return LogAccountPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[str]:
        """
        Text of the account policy. Refer to the [AWS docs](https://docs.aws.amazon.com/cli/latest/reference/logs/put-account-policy.html) for more information.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[str]:
        """
        Name of the account policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Output[str]:
        """
        Type of account policy. Either `DATA_PROTECTION_POLICY` or `SUBSCRIPTION_FILTER_POLICY`. You can have one account policy per type in an account.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[str]]:
        """
        Currently defaults to and only accepts the value: `ALL`.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="selectionCriteria")
    def selection_criteria(self) -> pulumi.Output[Optional[str]]:
        """
        Criteria for applying a subscription filter policy to a selection of log groups. The only allowable criteria selector is `LogGroupName NOT IN []`.
        """
        return pulumi.get(self, "selection_criteria")

