# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 base_capacity: pulumi.Input[int],
                 compute_type: pulumi.Input[str],
                 environment_type: pulumi.Input[str],
                 fleet_service_role: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 overflow_behavior: Optional[pulumi.Input[str]] = None,
                 scaling_configuration: Optional[pulumi.Input['FleetScalingConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]] = None):
        """
        The set of arguments for constructing a Fleet resource.
        :param pulumi.Input[int] base_capacity: Number of machines allocated to the ﬂeet.
        :param pulumi.Input[str] compute_type: Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        :param pulumi.Input[str] environment_type: Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
               
               The following arguments are optional:
        :param pulumi.Input[str] fleet_service_role: The service role associated with the compute fleet.
        :param pulumi.Input[str] image_id: The Amazon Machine Image (AMI) of the compute fleet.
        :param pulumi.Input[str] name: Fleet name.
        :param pulumi.Input[str] overflow_behavior: Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        :param pulumi.Input['FleetScalingConfigurationArgs'] scaling_configuration: Configuration block. Detailed below. This option is only valid when your overflow behavior is `QUEUE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]] vpc_configs: Configuration block. Detailed below.
        """
        pulumi.set(__self__, "base_capacity", base_capacity)
        pulumi.set(__self__, "compute_type", compute_type)
        pulumi.set(__self__, "environment_type", environment_type)
        if fleet_service_role is not None:
            pulumi.set(__self__, "fleet_service_role", fleet_service_role)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overflow_behavior is not None:
            pulumi.set(__self__, "overflow_behavior", overflow_behavior)
        if scaling_configuration is not None:
            pulumi.set(__self__, "scaling_configuration", scaling_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_configs is not None:
            pulumi.set(__self__, "vpc_configs", vpc_configs)

    @property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> pulumi.Input[int]:
        """
        Number of machines allocated to the ﬂeet.
        """
        return pulumi.get(self, "base_capacity")

    @base_capacity.setter
    def base_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "base_capacity", value)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> pulumi.Input[str]:
        """
        Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.

        The following arguments are optional:
        """
        return pulumi.get(self, "environment_type")

    @environment_type.setter
    def environment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_type", value)

    @property
    @pulumi.getter(name="fleetServiceRole")
    def fleet_service_role(self) -> Optional[pulumi.Input[str]]:
        """
        The service role associated with the compute fleet.
        """
        return pulumi.get(self, "fleet_service_role")

    @fleet_service_role.setter
    def fleet_service_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fleet_service_role", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Machine Image (AMI) of the compute fleet.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Fleet name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overflowBehavior")
    def overflow_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        """
        return pulumi.get(self, "overflow_behavior")

    @overflow_behavior.setter
    def overflow_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overflow_behavior", value)

    @property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> Optional[pulumi.Input['FleetScalingConfigurationArgs']]:
        """
        Configuration block. Detailed below. This option is only valid when your overflow behavior is `QUEUE`.
        """
        return pulumi.get(self, "scaling_configuration")

    @scaling_configuration.setter
    def scaling_configuration(self, value: Optional[pulumi.Input['FleetScalingConfigurationArgs']]):
        pulumi.set(self, "scaling_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcConfigs")
    def vpc_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_configs")

    @vpc_configs.setter
    def vpc_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]]):
        pulumi.set(self, "vpc_configs", value)


@pulumi.input_type
class _FleetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 base_capacity: Optional[pulumi.Input[int]] = None,
                 compute_type: Optional[pulumi.Input[str]] = None,
                 created: Optional[pulumi.Input[str]] = None,
                 environment_type: Optional[pulumi.Input[str]] = None,
                 fleet_service_role: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 last_modified: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 overflow_behavior: Optional[pulumi.Input[str]] = None,
                 scaling_configuration: Optional[pulumi.Input['FleetScalingConfigurationArgs']] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['FleetStatusArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering Fleet resources.
        :param pulumi.Input[str] arn: ARN of the Fleet.
        :param pulumi.Input[int] base_capacity: Number of machines allocated to the ﬂeet.
        :param pulumi.Input[str] compute_type: Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        :param pulumi.Input[str] created: Creation time of the fleet.
        :param pulumi.Input[str] environment_type: Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
               
               The following arguments are optional:
        :param pulumi.Input[str] fleet_service_role: The service role associated with the compute fleet.
        :param pulumi.Input[str] image_id: The Amazon Machine Image (AMI) of the compute fleet.
        :param pulumi.Input[str] last_modified: Last modification time of the fleet.
        :param pulumi.Input[str] name: Fleet name.
        :param pulumi.Input[str] overflow_behavior: Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        :param pulumi.Input['FleetScalingConfigurationArgs'] scaling_configuration: Configuration block. Detailed below. This option is only valid when your overflow behavior is `QUEUE`.
        :param pulumi.Input[Sequence[pulumi.Input['FleetStatusArgs']]] statuses: Nested attribute containing information about the current status of the fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]] vpc_configs: Configuration block. Detailed below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if base_capacity is not None:
            pulumi.set(__self__, "base_capacity", base_capacity)
        if compute_type is not None:
            pulumi.set(__self__, "compute_type", compute_type)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if environment_type is not None:
            pulumi.set(__self__, "environment_type", environment_type)
        if fleet_service_role is not None:
            pulumi.set(__self__, "fleet_service_role", fleet_service_role)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overflow_behavior is not None:
            pulumi.set(__self__, "overflow_behavior", overflow_behavior)
        if scaling_configuration is not None:
            pulumi.set(__self__, "scaling_configuration", scaling_configuration)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_configs is not None:
            pulumi.set(__self__, "vpc_configs", vpc_configs)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Fleet.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Number of machines allocated to the ﬂeet.
        """
        return pulumi.get(self, "base_capacity")

    @base_capacity.setter
    def base_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "base_capacity", value)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> Optional[pulumi.Input[str]]:
        """
        Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time of the fleet.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.

        The following arguments are optional:
        """
        return pulumi.get(self, "environment_type")

    @environment_type.setter
    def environment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_type", value)

    @property
    @pulumi.getter(name="fleetServiceRole")
    def fleet_service_role(self) -> Optional[pulumi.Input[str]]:
        """
        The service role associated with the compute fleet.
        """
        return pulumi.get(self, "fleet_service_role")

    @fleet_service_role.setter
    def fleet_service_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fleet_service_role", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Machine Image (AMI) of the compute fleet.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[str]]:
        """
        Last modification time of the fleet.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Fleet name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overflowBehavior")
    def overflow_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        """
        return pulumi.get(self, "overflow_behavior")

    @overflow_behavior.setter
    def overflow_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overflow_behavior", value)

    @property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> Optional[pulumi.Input['FleetScalingConfigurationArgs']]:
        """
        Configuration block. Detailed below. This option is only valid when your overflow behavior is `QUEUE`.
        """
        return pulumi.get(self, "scaling_configuration")

    @scaling_configuration.setter
    def scaling_configuration(self, value: Optional[pulumi.Input['FleetScalingConfigurationArgs']]):
        pulumi.set(self, "scaling_configuration", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetStatusArgs']]]]:
        """
        Nested attribute containing information about the current status of the fleet.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="vpcConfigs")
    def vpc_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_configs")

    @vpc_configs.setter
    def vpc_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetVpcConfigArgs']]]]):
        pulumi.set(self, "vpc_configs", value)


class Fleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_capacity: Optional[pulumi.Input[int]] = None,
                 compute_type: Optional[pulumi.Input[str]] = None,
                 environment_type: Optional[pulumi.Input[str]] = None,
                 fleet_service_role: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 overflow_behavior: Optional[pulumi.Input[str]] = None,
                 scaling_configuration: Optional[pulumi.Input[Union['FleetScalingConfigurationArgs', 'FleetScalingConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a CodeBuild Fleet Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.codebuild.Fleet("test",
            base_capacity=2,
            compute_type="BUILD_GENERAL1_SMALL",
            environment_type="LINUX_CONTAINER",
            name="full-example-codebuild-fleet",
            overflow_behavior="QUEUE",
            scaling_configuration={
                "max_capacity": 5,
                "scaling_type": "TARGET_TRACKING_SCALING",
                "target_tracking_scaling_configs": [{
                    "metric_type": "FLEET_UTILIZATION_RATE",
                    "target_value": 97.5,
                }],
            })
        ```

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codebuild.Fleet("example", name="example-codebuild-fleet")
        ```

        ## Import

        Using `pulumi import`, import CodeBuild Fleet using the `name`. For example:

        ```sh
        $ pulumi import aws:codebuild/fleet:Fleet name fleet-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] base_capacity: Number of machines allocated to the ﬂeet.
        :param pulumi.Input[str] compute_type: Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        :param pulumi.Input[str] environment_type: Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
               
               The following arguments are optional:
        :param pulumi.Input[str] fleet_service_role: The service role associated with the compute fleet.
        :param pulumi.Input[str] image_id: The Amazon Machine Image (AMI) of the compute fleet.
        :param pulumi.Input[str] name: Fleet name.
        :param pulumi.Input[str] overflow_behavior: Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        :param pulumi.Input[Union['FleetScalingConfigurationArgs', 'FleetScalingConfigurationArgsDict']] scaling_configuration: Configuration block. Detailed below. This option is only valid when your overflow behavior is `QUEUE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]]] vpc_configs: Configuration block. Detailed below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CodeBuild Fleet Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.codebuild.Fleet("test",
            base_capacity=2,
            compute_type="BUILD_GENERAL1_SMALL",
            environment_type="LINUX_CONTAINER",
            name="full-example-codebuild-fleet",
            overflow_behavior="QUEUE",
            scaling_configuration={
                "max_capacity": 5,
                "scaling_type": "TARGET_TRACKING_SCALING",
                "target_tracking_scaling_configs": [{
                    "metric_type": "FLEET_UTILIZATION_RATE",
                    "target_value": 97.5,
                }],
            })
        ```

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codebuild.Fleet("example", name="example-codebuild-fleet")
        ```

        ## Import

        Using `pulumi import`, import CodeBuild Fleet using the `name`. For example:

        ```sh
        $ pulumi import aws:codebuild/fleet:Fleet name fleet-name
        ```

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_capacity: Optional[pulumi.Input[int]] = None,
                 compute_type: Optional[pulumi.Input[str]] = None,
                 environment_type: Optional[pulumi.Input[str]] = None,
                 fleet_service_role: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 overflow_behavior: Optional[pulumi.Input[str]] = None,
                 scaling_configuration: Optional[pulumi.Input[Union['FleetScalingConfigurationArgs', 'FleetScalingConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            if base_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'base_capacity'")
            __props__.__dict__["base_capacity"] = base_capacity
            if compute_type is None and not opts.urn:
                raise TypeError("Missing required property 'compute_type'")
            __props__.__dict__["compute_type"] = compute_type
            if environment_type is None and not opts.urn:
                raise TypeError("Missing required property 'environment_type'")
            __props__.__dict__["environment_type"] = environment_type
            __props__.__dict__["fleet_service_role"] = fleet_service_role
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["name"] = name
            __props__.__dict__["overflow_behavior"] = overflow_behavior
            __props__.__dict__["scaling_configuration"] = scaling_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_configs"] = vpc_configs
            __props__.__dict__["arn"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["tags_all"] = None
        super(Fleet, __self__).__init__(
            'aws:codebuild/fleet:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            base_capacity: Optional[pulumi.Input[int]] = None,
            compute_type: Optional[pulumi.Input[str]] = None,
            created: Optional[pulumi.Input[str]] = None,
            environment_type: Optional[pulumi.Input[str]] = None,
            fleet_service_role: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            last_modified: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            overflow_behavior: Optional[pulumi.Input[str]] = None,
            scaling_configuration: Optional[pulumi.Input[Union['FleetScalingConfigurationArgs', 'FleetScalingConfigurationArgsDict']]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetStatusArgs', 'FleetStatusArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]]]] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the Fleet.
        :param pulumi.Input[int] base_capacity: Number of machines allocated to the ﬂeet.
        :param pulumi.Input[str] compute_type: Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        :param pulumi.Input[str] created: Creation time of the fleet.
        :param pulumi.Input[str] environment_type: Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
               
               The following arguments are optional:
        :param pulumi.Input[str] fleet_service_role: The service role associated with the compute fleet.
        :param pulumi.Input[str] image_id: The Amazon Machine Image (AMI) of the compute fleet.
        :param pulumi.Input[str] last_modified: Last modification time of the fleet.
        :param pulumi.Input[str] name: Fleet name.
        :param pulumi.Input[str] overflow_behavior: Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        :param pulumi.Input[Union['FleetScalingConfigurationArgs', 'FleetScalingConfigurationArgsDict']] scaling_configuration: Configuration block. Detailed below. This option is only valid when your overflow behavior is `QUEUE`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetStatusArgs', 'FleetStatusArgsDict']]]] statuses: Nested attribute containing information about the current status of the fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]]] vpc_configs: Configuration block. Detailed below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetState.__new__(_FleetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["base_capacity"] = base_capacity
        __props__.__dict__["compute_type"] = compute_type
        __props__.__dict__["created"] = created
        __props__.__dict__["environment_type"] = environment_type
        __props__.__dict__["fleet_service_role"] = fleet_service_role
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["name"] = name
        __props__.__dict__["overflow_behavior"] = overflow_behavior
        __props__.__dict__["scaling_configuration"] = scaling_configuration
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_configs"] = vpc_configs
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the Fleet.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> pulumi.Output[int]:
        """
        Number of machines allocated to the ﬂeet.
        """
        return pulumi.get(self, "base_capacity")

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Output[str]:
        """
        Compute resources the compute fleet uses. See [compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        Creation time of the fleet.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> pulumi.Output[str]:
        """
        Environment type of the compute fleet. See [environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) for more information and valid values.

        The following arguments are optional:
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter(name="fleetServiceRole")
    def fleet_service_role(self) -> pulumi.Output[Optional[str]]:
        """
        The service role associated with the compute fleet.
        """
        return pulumi.get(self, "fleet_service_role")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Machine Image (AMI) of the compute fleet.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[str]:
        """
        Last modification time of the fleet.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Fleet name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overflowBehavior")
    def overflow_behavior(self) -> pulumi.Output[str]:
        """
        Overflow behavior for compute fleet. Valid values: `ON_DEMAND`, `QUEUE`.
        """
        return pulumi.get(self, "overflow_behavior")

    @property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> pulumi.Output[Optional['outputs.FleetScalingConfiguration']]:
        """
        Configuration block. Detailed below. This option is only valid when your overflow behavior is `QUEUE`.
        """
        return pulumi.get(self, "scaling_configuration")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.FleetStatus']]:
        """
        Nested attribute containing information about the current status of the fleet.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="vpcConfigs")
    def vpc_configs(self) -> pulumi.Output[Optional[Sequence['outputs.FleetVpcConfig']]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_configs")

