# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DevEnvironmentIdesArgs',
    'DevEnvironmentIdesArgsDict',
    'DevEnvironmentPersistentStorageArgs',
    'DevEnvironmentPersistentStorageArgsDict',
    'DevEnvironmentRepositoryArgs',
    'DevEnvironmentRepositoryArgsDict',
    'GetDevEnvironmentRepositoryArgs',
    'GetDevEnvironmentRepositoryArgsDict',
]

MYPY = False

if not MYPY:
    class DevEnvironmentIdesArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
        """
        runtime: NotRequired[pulumi.Input[str]]
        """
        A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
        """
elif False:
    DevEnvironmentIdesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DevEnvironmentIdesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
        :param pulumi.Input[str] runtime: A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)


if not MYPY:
    class DevEnvironmentPersistentStorageArgsDict(TypedDict):
        size: pulumi.Input[int]
        """
        The size of the persistent storage in gigabytes (specifically GiB). Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
        """
elif False:
    DevEnvironmentPersistentStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DevEnvironmentPersistentStorageArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int]):
        """
        :param pulumi.Input[int] size: The size of the persistent storage in gigabytes (specifically GiB). Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
        """
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the persistent storage in gigabytes (specifically GiB). Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)


if not MYPY:
    class DevEnvironmentRepositoryArgsDict(TypedDict):
        repository_name: pulumi.Input[str]
        """
        The name of the source repository.
        """
        branch_name: NotRequired[pulumi.Input[str]]
        """
        The name of the branch in a source repository.

        persistent storage (` persistent_storage`) supports the following:
        """
elif False:
    DevEnvironmentRepositoryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DevEnvironmentRepositoryArgs:
    def __init__(__self__, *,
                 repository_name: pulumi.Input[str],
                 branch_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] repository_name: The name of the source repository.
        :param pulumi.Input[str] branch_name: The name of the branch in a source repository.
               
               persistent storage (` persistent_storage`) supports the following:
        """
        pulumi.set(__self__, "repository_name", repository_name)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> pulumi.Input[str]:
        """
        The name of the source repository.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch in a source repository.

        persistent storage (` persistent_storage`) supports the following:
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name", value)


if not MYPY:
    class GetDevEnvironmentRepositoryArgsDict(TypedDict):
        branch_name: str
        repository_name: str
elif False:
    GetDevEnvironmentRepositoryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDevEnvironmentRepositoryArgs:
    def __init__(__self__, *,
                 branch_name: str,
                 repository_name: str):
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "repository_name", repository_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> str:
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: str):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> str:
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: str):
        pulumi.set(self, "repository_name", value)


