# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CustomActionTypeConfigurationProperty',
    'CustomActionTypeInputArtifactDetails',
    'CustomActionTypeOutputArtifactDetails',
    'CustomActionTypeSettings',
    'PipelineArtifactStore',
    'PipelineArtifactStoreEncryptionKey',
    'PipelineStage',
    'PipelineStageAction',
    'PipelineTrigger',
    'PipelineTriggerGitConfiguration',
    'PipelineTriggerGitConfigurationPullRequest',
    'PipelineTriggerGitConfigurationPullRequestBranches',
    'PipelineTriggerGitConfigurationPullRequestFilePaths',
    'PipelineTriggerGitConfigurationPush',
    'PipelineTriggerGitConfigurationPushBranches',
    'PipelineTriggerGitConfigurationPushFilePaths',
    'PipelineTriggerGitConfigurationPushTags',
    'PipelineVariable',
    'WebhookAuthenticationConfiguration',
    'WebhookFilter',
]

@pulumi.output_type
class CustomActionTypeConfigurationProperty(dict):
    def __init__(__self__, *,
                 key: bool,
                 name: str,
                 required: bool,
                 secret: bool,
                 description: Optional[str] = None,
                 queryable: Optional[bool] = None,
                 type: Optional[str] = None):
        """
        :param bool key: Whether the configuration property is a key.
        :param str name: The name of the action configuration property.
        :param bool required: Whether the configuration property is a required value.
        :param bool secret: Whether the configuration property is secret.
        :param str description: The description of the action configuration property.
        :param bool queryable: Indicates that the property will be used in conjunction with PollForJobs.
        :param str type: The type of the configuration property. Valid values: `String`, `Number`, `Boolean`
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "secret", secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if queryable is not None:
            pulumi.set(__self__, "queryable", queryable)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def key(self) -> bool:
        """
        Whether the configuration property is a key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action configuration property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> bool:
        """
        Whether the configuration property is a required value.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def secret(self) -> bool:
        """
        Whether the configuration property is secret.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the action configuration property.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def queryable(self) -> Optional[bool]:
        """
        Indicates that the property will be used in conjunction with PollForJobs.
        """
        return pulumi.get(self, "queryable")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the configuration property. Valid values: `String`, `Number`, `Boolean`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomActionTypeInputArtifactDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumCount":
            suggest = "maximum_count"
        elif key == "minimumCount":
            suggest = "minimum_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomActionTypeInputArtifactDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomActionTypeInputArtifactDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomActionTypeInputArtifactDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_count: int,
                 minimum_count: int):
        """
        :param int maximum_count: The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        :param int minimum_count: The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        pulumi.set(__self__, "maximum_count", maximum_count)
        pulumi.set(__self__, "minimum_count", minimum_count)

    @property
    @pulumi.getter(name="maximumCount")
    def maximum_count(self) -> int:
        """
        The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "maximum_count")

    @property
    @pulumi.getter(name="minimumCount")
    def minimum_count(self) -> int:
        """
        The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "minimum_count")


@pulumi.output_type
class CustomActionTypeOutputArtifactDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumCount":
            suggest = "maximum_count"
        elif key == "minimumCount":
            suggest = "minimum_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomActionTypeOutputArtifactDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomActionTypeOutputArtifactDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomActionTypeOutputArtifactDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_count: int,
                 minimum_count: int):
        """
        :param int maximum_count: The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        :param int minimum_count: The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        pulumi.set(__self__, "maximum_count", maximum_count)
        pulumi.set(__self__, "minimum_count", minimum_count)

    @property
    @pulumi.getter(name="maximumCount")
    def maximum_count(self) -> int:
        """
        The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "maximum_count")

    @property
    @pulumi.getter(name="minimumCount")
    def minimum_count(self) -> int:
        """
        The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "minimum_count")


@pulumi.output_type
class CustomActionTypeSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityUrlTemplate":
            suggest = "entity_url_template"
        elif key == "executionUrlTemplate":
            suggest = "execution_url_template"
        elif key == "revisionUrlTemplate":
            suggest = "revision_url_template"
        elif key == "thirdPartyConfigurationUrl":
            suggest = "third_party_configuration_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomActionTypeSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomActionTypeSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomActionTypeSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_url_template: Optional[str] = None,
                 execution_url_template: Optional[str] = None,
                 revision_url_template: Optional[str] = None,
                 third_party_configuration_url: Optional[str] = None):
        """
        :param str entity_url_template: The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system.
        :param str execution_url_template: The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system.
        :param str revision_url_template: The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
        :param str third_party_configuration_url: The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
        """
        if entity_url_template is not None:
            pulumi.set(__self__, "entity_url_template", entity_url_template)
        if execution_url_template is not None:
            pulumi.set(__self__, "execution_url_template", execution_url_template)
        if revision_url_template is not None:
            pulumi.set(__self__, "revision_url_template", revision_url_template)
        if third_party_configuration_url is not None:
            pulumi.set(__self__, "third_party_configuration_url", third_party_configuration_url)

    @property
    @pulumi.getter(name="entityUrlTemplate")
    def entity_url_template(self) -> Optional[str]:
        """
        The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system.
        """
        return pulumi.get(self, "entity_url_template")

    @property
    @pulumi.getter(name="executionUrlTemplate")
    def execution_url_template(self) -> Optional[str]:
        """
        The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system.
        """
        return pulumi.get(self, "execution_url_template")

    @property
    @pulumi.getter(name="revisionUrlTemplate")
    def revision_url_template(self) -> Optional[str]:
        """
        The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
        """
        return pulumi.get(self, "revision_url_template")

    @property
    @pulumi.getter(name="thirdPartyConfigurationUrl")
    def third_party_configuration_url(self) -> Optional[str]:
        """
        The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
        """
        return pulumi.get(self, "third_party_configuration_url")


@pulumi.output_type
class PipelineArtifactStore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineArtifactStore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineArtifactStore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineArtifactStore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 type: str,
                 encryption_key: Optional['outputs.PipelineArtifactStoreEncryptionKey'] = None,
                 region: Optional[str] = None):
        """
        :param str location: The location where AWS CodePipeline stores artifacts for a pipeline; currently only `S3` is supported.
        :param str type: The type of the artifact store, such as Amazon S3
        :param 'PipelineArtifactStoreEncryptionKeyArgs' encryption_key: The encryption key block AWS CodePipeline uses to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If you don't specify a key, AWS CodePipeline uses the default key for Amazon Simple Storage Service (Amazon S3). An `encryption_key` block is documented below.
        :param str region: The region where the artifact store is located. Required for a cross-region CodePipeline, do not provide for a single-region CodePipeline.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "type", type)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location where AWS CodePipeline stores artifacts for a pipeline; currently only `S3` is supported.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the artifact store, such as Amazon S3
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional['outputs.PipelineArtifactStoreEncryptionKey']:
        """
        The encryption key block AWS CodePipeline uses to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If you don't specify a key, AWS CodePipeline uses the default key for Amazon Simple Storage Service (Amazon S3). An `encryption_key` block is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region where the artifact store is located. Required for a cross-region CodePipeline, do not provide for a single-region CodePipeline.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class PipelineArtifactStoreEncryptionKey(dict):
    def __init__(__self__, *,
                 id: str,
                 type: str):
        """
        :param str id: The KMS key ARN or ID
        :param str type: The type of key; currently only `KMS` is supported
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The KMS key ARN or ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of key; currently only `KMS` is supported
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PipelineStage(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.PipelineStageAction'],
                 name: str):
        """
        :param Sequence['PipelineStageActionArgs'] actions: The action(s) to include in the stage. Defined as an `action` block below
        :param str name: The name of the stage.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.PipelineStageAction']:
        """
        The action(s) to include in the stage. Defined as an `action` block below
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the stage.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PipelineStageAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputArtifacts":
            suggest = "input_artifacts"
        elif key == "outputArtifacts":
            suggest = "output_artifacts"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "runOrder":
            suggest = "run_order"
        elif key == "timeoutInMinutes":
            suggest = "timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineStageAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineStageAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineStageAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: str,
                 name: str,
                 owner: str,
                 provider: str,
                 version: str,
                 configuration: Optional[Mapping[str, str]] = None,
                 input_artifacts: Optional[Sequence[str]] = None,
                 namespace: Optional[str] = None,
                 output_artifacts: Optional[Sequence[str]] = None,
                 region: Optional[str] = None,
                 role_arn: Optional[str] = None,
                 run_order: Optional[int] = None,
                 timeout_in_minutes: Optional[int] = None):
        """
        :param str category: A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
        :param str name: The action declaration's name.
        :param str owner: The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
        :param str provider: The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
        :param str version: A string that identifies the action type.
        :param Mapping[str, str] configuration: A map of the action declaration's configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation. Note: The `DetectChanges` parameter (optional, default value is true) in the `configuration` section causes CodePipeline to automatically start your pipeline upon new commits. Please refer to AWS Documentation for more details: https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config.
        :param Sequence[str] input_artifacts: A list of artifact names to be worked on.
        :param str namespace: The namespace all output variables will be accessed from.
        :param Sequence[str] output_artifacts: A list of artifact names to output. Output artifact names must be unique within a pipeline.
        :param str region: The region in which to run the action.
        :param str role_arn: The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
        :param int run_order: The order in which actions are run.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "version", version)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if input_artifacts is not None:
            pulumi.set(__self__, "input_artifacts", input_artifacts)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if output_artifacts is not None:
            pulumi.set(__self__, "output_artifacts", output_artifacts)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if run_order is not None:
            pulumi.set(__self__, "run_order", run_order)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The action declaration's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def provider(self) -> str:
        """
        The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        A string that identifies the action type.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Mapping[str, str]]:
        """
        A map of the action declaration's configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation. Note: The `DetectChanges` parameter (optional, default value is true) in the `configuration` section causes CodePipeline to automatically start your pipeline upon new commits. Please refer to AWS Documentation for more details: https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="inputArtifacts")
    def input_artifacts(self) -> Optional[Sequence[str]]:
        """
        A list of artifact names to be worked on.
        """
        return pulumi.get(self, "input_artifacts")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace all output variables will be accessed from.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="outputArtifacts")
    def output_artifacts(self) -> Optional[Sequence[str]]:
        """
        A list of artifact names to output. Output artifact names must be unique within a pipeline.
        """
        return pulumi.get(self, "output_artifacts")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region in which to run the action.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="runOrder")
    def run_order(self) -> Optional[int]:
        """
        The order in which actions are run.
        """
        return pulumi.get(self, "run_order")

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[int]:
        return pulumi.get(self, "timeout_in_minutes")


@pulumi.output_type
class PipelineTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gitConfiguration":
            suggest = "git_configuration"
        elif key == "providerType":
            suggest = "provider_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 git_configuration: 'outputs.PipelineTriggerGitConfiguration',
                 provider_type: str):
        """
        :param 'PipelineTriggerGitConfigurationArgs' git_configuration: Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
        :param str provider_type: The source provider for the event. Possible value is `CodeStarSourceConnection`.
        """
        pulumi.set(__self__, "git_configuration", git_configuration)
        pulumi.set(__self__, "provider_type", provider_type)

    @property
    @pulumi.getter(name="gitConfiguration")
    def git_configuration(self) -> 'outputs.PipelineTriggerGitConfiguration':
        """
        Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
        """
        return pulumi.get(self, "git_configuration")

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The source provider for the event. Possible value is `CodeStarSourceConnection`.
        """
        return pulumi.get(self, "provider_type")


@pulumi.output_type
class PipelineTriggerGitConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceActionName":
            suggest = "source_action_name"
        elif key == "pullRequests":
            suggest = "pull_requests"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTriggerGitConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTriggerGitConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTriggerGitConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_action_name: str,
                 pull_requests: Optional[Sequence['outputs.PipelineTriggerGitConfigurationPullRequest']] = None,
                 pushes: Optional[Sequence['outputs.PipelineTriggerGitConfigurationPush']] = None):
        """
        :param str source_action_name: The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
        :param Sequence['PipelineTriggerGitConfigurationPullRequestArgs'] pull_requests: The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
        :param Sequence['PipelineTriggerGitConfigurationPushArgs'] pushes: The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
        """
        pulumi.set(__self__, "source_action_name", source_action_name)
        if pull_requests is not None:
            pulumi.set(__self__, "pull_requests", pull_requests)
        if pushes is not None:
            pulumi.set(__self__, "pushes", pushes)

    @property
    @pulumi.getter(name="sourceActionName")
    def source_action_name(self) -> str:
        """
        The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
        """
        return pulumi.get(self, "source_action_name")

    @property
    @pulumi.getter(name="pullRequests")
    def pull_requests(self) -> Optional[Sequence['outputs.PipelineTriggerGitConfigurationPullRequest']]:
        """
        The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
        """
        return pulumi.get(self, "pull_requests")

    @property
    @pulumi.getter
    def pushes(self) -> Optional[Sequence['outputs.PipelineTriggerGitConfigurationPush']]:
        """
        The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
        """
        return pulumi.get(self, "pushes")


@pulumi.output_type
class PipelineTriggerGitConfigurationPullRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePaths":
            suggest = "file_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTriggerGitConfigurationPullRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTriggerGitConfigurationPullRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTriggerGitConfigurationPullRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branches: Optional['outputs.PipelineTriggerGitConfigurationPullRequestBranches'] = None,
                 events: Optional[Sequence[str]] = None,
                 file_paths: Optional['outputs.PipelineTriggerGitConfigurationPullRequestFilePaths'] = None):
        """
        :param 'PipelineTriggerGitConfigurationPullRequestBranchesArgs' branches: The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
        :param Sequence[str] events: A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
        :param 'PipelineTriggerGitConfigurationPullRequestFilePathsArgs' file_paths: The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)

    @property
    @pulumi.getter
    def branches(self) -> Optional['outputs.PipelineTriggerGitConfigurationPullRequestBranches']:
        """
        The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence[str]]:
        """
        A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional['outputs.PipelineTriggerGitConfigurationPullRequestFilePaths']:
        """
        The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
        """
        return pulumi.get(self, "file_paths")


@pulumi.output_type
class PipelineTriggerGitConfigurationPullRequestBranches(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] excludes: A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[str] includes: A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerGitConfigurationPullRequestFilePaths(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] excludes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[str] includes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerGitConfigurationPush(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePaths":
            suggest = "file_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTriggerGitConfigurationPush. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTriggerGitConfigurationPush.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTriggerGitConfigurationPush.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branches: Optional['outputs.PipelineTriggerGitConfigurationPushBranches'] = None,
                 file_paths: Optional['outputs.PipelineTriggerGitConfigurationPushFilePaths'] = None,
                 tags: Optional['outputs.PipelineTriggerGitConfigurationPushTags'] = None):
        """
        :param 'PipelineTriggerGitConfigurationPushBranchesArgs' branches: The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
        :param 'PipelineTriggerGitConfigurationPushFilePathsArgs' file_paths: The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
        :param 'PipelineTriggerGitConfigurationPushTagsArgs' tags: The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def branches(self) -> Optional['outputs.PipelineTriggerGitConfigurationPushBranches']:
        """
        The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional['outputs.PipelineTriggerGitConfigurationPushFilePaths']:
        """
        The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
        """
        return pulumi.get(self, "file_paths")

    @property
    @pulumi.getter
    def tags(self) -> Optional['outputs.PipelineTriggerGitConfigurationPushTags']:
        """
        The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class PipelineTriggerGitConfigurationPushBranches(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] excludes: A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[str] includes: A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerGitConfigurationPushFilePaths(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] excludes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[str] includes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerGitConfigurationPushTags(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] excludes: A list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        :param Sequence[str] includes: A list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        A list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        A list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 default_value: Optional[str] = None,
                 description: Optional[str] = None):
        """
        :param str name: The name of a pipeline-level variable.
        :param str default_value: The default value of a pipeline-level variable.
        :param str description: The description of a pipeline-level variable.
               
               > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
        """
        pulumi.set(__self__, "name", name)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of a pipeline-level variable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        """
        The default value of a pipeline-level variable.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of a pipeline-level variable.

        > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class WebhookAuthenticationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedIpRange":
            suggest = "allowed_ip_range"
        elif key == "secretToken":
            suggest = "secret_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookAuthenticationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookAuthenticationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookAuthenticationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_ip_range: Optional[str] = None,
                 secret_token: Optional[str] = None):
        """
        :param str allowed_ip_range: A valid CIDR block for `IP` filtering. Required for `IP`.
        :param str secret_token: The shared secret for the GitHub repository webhook. Set this as `secret` in your `github_repository_webhook`'s `configuration` block. Required for `GITHUB_HMAC`.
        """
        if allowed_ip_range is not None:
            pulumi.set(__self__, "allowed_ip_range", allowed_ip_range)
        if secret_token is not None:
            pulumi.set(__self__, "secret_token", secret_token)

    @property
    @pulumi.getter(name="allowedIpRange")
    def allowed_ip_range(self) -> Optional[str]:
        """
        A valid CIDR block for `IP` filtering. Required for `IP`.
        """
        return pulumi.get(self, "allowed_ip_range")

    @property
    @pulumi.getter(name="secretToken")
    def secret_token(self) -> Optional[str]:
        """
        The shared secret for the GitHub repository webhook. Set this as `secret` in your `github_repository_webhook`'s `configuration` block. Required for `GITHUB_HMAC`.
        """
        return pulumi.get(self, "secret_token")


@pulumi.output_type
class WebhookFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPath":
            suggest = "json_path"
        elif key == "matchEquals":
            suggest = "match_equals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_path: str,
                 match_equals: str):
        """
        :param str json_path: The [JSON path](https://github.com/json-path/JsonPath) to filter on.
        :param str match_equals: The value to match on (e.g., `refs/heads/{Branch}`). See [AWS docs](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_WebhookFilterRule.html) for details.
        """
        pulumi.set(__self__, "json_path", json_path)
        pulumi.set(__self__, "match_equals", match_equals)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> str:
        """
        The [JSON path](https://github.com/json-path/JsonPath) to filter on.
        """
        return pulumi.get(self, "json_path")

    @property
    @pulumi.getter(name="matchEquals")
    def match_equals(self) -> str:
        """
        The value to match on (e.g., `refs/heads/{Branch}`). See [AWS docs](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_WebhookFilterRule.html) for details.
        """
        return pulumi.get(self, "match_equals")


