# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUserHierarchyStructureResult',
    'AwaitableGetUserHierarchyStructureResult',
    'get_user_hierarchy_structure',
    'get_user_hierarchy_structure_output',
]

@pulumi.output_type
class GetUserHierarchyStructureResult:
    """
    A collection of values returned by getUserHierarchyStructure.
    """
    def __init__(__self__, hierarchy_structures=None, id=None, instance_id=None):
        if hierarchy_structures and not isinstance(hierarchy_structures, list):
            raise TypeError("Expected argument 'hierarchy_structures' to be a list")
        pulumi.set(__self__, "hierarchy_structures", hierarchy_structures)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="hierarchyStructures")
    def hierarchy_structures(self) -> Sequence['outputs.GetUserHierarchyStructureHierarchyStructureResult']:
        """
        Block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
        """
        return pulumi.get(self, "hierarchy_structures")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")


class AwaitableGetUserHierarchyStructureResult(GetUserHierarchyStructureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserHierarchyStructureResult(
            hierarchy_structures=self.hierarchy_structures,
            id=self.id,
            instance_id=self.instance_id)


def get_user_hierarchy_structure(instance_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserHierarchyStructureResult:
    """
    Provides details about a specific Amazon Connect User Hierarchy Structure

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.connect.get_user_hierarchy_structure(instance_id=test_aws_connect_instance["id"])
    ```


    :param str instance_id: Reference to the hosting Amazon Connect Instance
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getUserHierarchyStructure:getUserHierarchyStructure', __args__, opts=opts, typ=GetUserHierarchyStructureResult).value

    return AwaitableGetUserHierarchyStructureResult(
        hierarchy_structures=pulumi.get(__ret__, 'hierarchy_structures'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'))
def get_user_hierarchy_structure_output(instance_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserHierarchyStructureResult]:
    """
    Provides details about a specific Amazon Connect User Hierarchy Structure

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.connect.get_user_hierarchy_structure(instance_id=test_aws_connect_instance["id"])
    ```


    :param str instance_id: Reference to the hosting Amazon Connect Instance
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:connect/getUserHierarchyStructure:getUserHierarchyStructure', __args__, opts=opts, typ=GetUserHierarchyStructureResult)
    return __ret__.apply(lambda __response__: GetUserHierarchyStructureResult(
        hierarchy_structures=pulumi.get(__response__, 'hierarchy_structures'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id')))
