# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ControlTowerControlArgs', 'ControlTowerControl']

@pulumi.input_type
class ControlTowerControlArgs:
    def __init__(__self__, *,
                 control_identifier: pulumi.Input[str],
                 target_identifier: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ControlTowerControlParameterArgs']]]] = None):
        """
        The set of arguments for constructing a ControlTowerControl resource.
        :param pulumi.Input[str] control_identifier: The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
        :param pulumi.Input[str] target_identifier: The ARN of the organizational unit.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['ControlTowerControlParameterArgs']]] parameters: Parameter values which are specified to configure the control when you enable it. See Parameters for more details.
        """
        pulumi.set(__self__, "control_identifier", control_identifier)
        pulumi.set(__self__, "target_identifier", target_identifier)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="controlIdentifier")
    def control_identifier(self) -> pulumi.Input[str]:
        """
        The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
        """
        return pulumi.get(self, "control_identifier")

    @control_identifier.setter
    def control_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "control_identifier", value)

    @property
    @pulumi.getter(name="targetIdentifier")
    def target_identifier(self) -> pulumi.Input[str]:
        """
        The ARN of the organizational unit.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_identifier")

    @target_identifier.setter
    def target_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_identifier", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ControlTowerControlParameterArgs']]]]:
        """
        Parameter values which are specified to configure the control when you enable it. See Parameters for more details.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ControlTowerControlParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class _ControlTowerControlState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 control_identifier: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ControlTowerControlParameterArgs']]]] = None,
                 target_identifier: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ControlTowerControl resources.
        :param pulumi.Input[str] arn: The ARN of the EnabledControl resource.
        :param pulumi.Input[str] control_identifier: The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
        :param pulumi.Input[Sequence[pulumi.Input['ControlTowerControlParameterArgs']]] parameters: Parameter values which are specified to configure the control when you enable it. See Parameters for more details.
        :param pulumi.Input[str] target_identifier: The ARN of the organizational unit.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if control_identifier is not None:
            pulumi.set(__self__, "control_identifier", control_identifier)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if target_identifier is not None:
            pulumi.set(__self__, "target_identifier", target_identifier)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the EnabledControl resource.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="controlIdentifier")
    def control_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
        """
        return pulumi.get(self, "control_identifier")

    @control_identifier.setter
    def control_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control_identifier", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ControlTowerControlParameterArgs']]]]:
        """
        Parameter values which are specified to configure the control when you enable it. See Parameters for more details.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ControlTowerControlParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="targetIdentifier")
    def target_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the organizational unit.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_identifier")

    @target_identifier.setter
    def target_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_identifier", value)


class ControlTowerControl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 control_identifier: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ControlTowerControlParameterArgs', 'ControlTowerControlParameterArgsDict']]]]] = None,
                 target_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Allows the application of pre-defined controls to organizational units. For more information on usage, please see the
        [AWS Control Tower User Guide](https://docs.aws.amazon.com/controltower/latest/userguide/enable-guardrails.html).

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_region()
        example = aws.organizations.get_organization()
        example_get_organizational_units = aws.organizations.get_organizational_units(parent_id=example.roots[0].id)
        example_control_tower_control = aws.controltower.ControlTowerControl("example",
            control_identifier=f"arn:aws:controltower:{current.name}::control/AWS-GR_EC2_VOLUME_INUSE_CHECK",
            target_identifier=[x.arn for x in example_get_organizational_units.children if x.name == "Infrastructure"][0],
            parameters=[{
                "key": "AllowedRegions",
                "value": json.dumps(["us-east-1"]),
            }])
        ```

        ## Import

        Using `pulumi import`, import Control Tower Controls using their `organizational_unit_arn/control_identifier`. For example:

        ```sh
        $ pulumi import aws:controltower/controlTowerControl:ControlTowerControl example arn:aws:organizations::123456789101:ou/o-qqaejywet/ou-qg5o-ufbhdtv3,arn:aws:controltower:us-east-1::control/WTDSMKDKDNLE
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] control_identifier: The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ControlTowerControlParameterArgs', 'ControlTowerControlParameterArgsDict']]]] parameters: Parameter values which are specified to configure the control when you enable it. See Parameters for more details.
        :param pulumi.Input[str] target_identifier: The ARN of the organizational unit.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ControlTowerControlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows the application of pre-defined controls to organizational units. For more information on usage, please see the
        [AWS Control Tower User Guide](https://docs.aws.amazon.com/controltower/latest/userguide/enable-guardrails.html).

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_region()
        example = aws.organizations.get_organization()
        example_get_organizational_units = aws.organizations.get_organizational_units(parent_id=example.roots[0].id)
        example_control_tower_control = aws.controltower.ControlTowerControl("example",
            control_identifier=f"arn:aws:controltower:{current.name}::control/AWS-GR_EC2_VOLUME_INUSE_CHECK",
            target_identifier=[x.arn for x in example_get_organizational_units.children if x.name == "Infrastructure"][0],
            parameters=[{
                "key": "AllowedRegions",
                "value": json.dumps(["us-east-1"]),
            }])
        ```

        ## Import

        Using `pulumi import`, import Control Tower Controls using their `organizational_unit_arn/control_identifier`. For example:

        ```sh
        $ pulumi import aws:controltower/controlTowerControl:ControlTowerControl example arn:aws:organizations::123456789101:ou/o-qqaejywet/ou-qg5o-ufbhdtv3,arn:aws:controltower:us-east-1::control/WTDSMKDKDNLE
        ```

        :param str resource_name: The name of the resource.
        :param ControlTowerControlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ControlTowerControlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 control_identifier: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ControlTowerControlParameterArgs', 'ControlTowerControlParameterArgsDict']]]]] = None,
                 target_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ControlTowerControlArgs.__new__(ControlTowerControlArgs)

            if control_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'control_identifier'")
            __props__.__dict__["control_identifier"] = control_identifier
            __props__.__dict__["parameters"] = parameters
            if target_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'target_identifier'")
            __props__.__dict__["target_identifier"] = target_identifier
            __props__.__dict__["arn"] = None
        super(ControlTowerControl, __self__).__init__(
            'aws:controltower/controlTowerControl:ControlTowerControl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            control_identifier: Optional[pulumi.Input[str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ControlTowerControlParameterArgs', 'ControlTowerControlParameterArgsDict']]]]] = None,
            target_identifier: Optional[pulumi.Input[str]] = None) -> 'ControlTowerControl':
        """
        Get an existing ControlTowerControl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the EnabledControl resource.
        :param pulumi.Input[str] control_identifier: The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ControlTowerControlParameterArgs', 'ControlTowerControlParameterArgsDict']]]] parameters: Parameter values which are specified to configure the control when you enable it. See Parameters for more details.
        :param pulumi.Input[str] target_identifier: The ARN of the organizational unit.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ControlTowerControlState.__new__(_ControlTowerControlState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["control_identifier"] = control_identifier
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["target_identifier"] = target_identifier
        return ControlTowerControl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the EnabledControl resource.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="controlIdentifier")
    def control_identifier(self) -> pulumi.Output[str]:
        """
        The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
        """
        return pulumi.get(self, "control_identifier")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.ControlTowerControlParameter']]]:
        """
        Parameter values which are specified to configure the control when you enable it. See Parameters for more details.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="targetIdentifier")
    def target_identifier(self) -> pulumi.Output[str]:
        """
        The ARN of the organizational unit.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_identifier")

