# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTagsResult',
    'AwaitableGetTagsResult',
    'get_tags',
    'get_tags_output',
]

@pulumi.output_type
class GetTagsResult:
    """
    A collection of values returned by getTags.
    """
    def __init__(__self__, filter=None, id=None, search_string=None, sort_bies=None, tag_key=None, tags=None, time_period=None):
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if search_string and not isinstance(search_string, str):
            raise TypeError("Expected argument 'search_string' to be a str")
        pulumi.set(__self__, "search_string", search_string)
        if sort_bies and not isinstance(sort_bies, list):
            raise TypeError("Expected argument 'sort_bies' to be a list")
        pulumi.set(__self__, "sort_bies", sort_bies)
        if tag_key and not isinstance(tag_key, str):
            raise TypeError("Expected argument 'tag_key' to be a str")
        pulumi.set(__self__, "tag_key", tag_key)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if time_period and not isinstance(time_period, dict):
            raise TypeError("Expected argument 'time_period' to be a dict")
        pulumi.set(__self__, "time_period", time_period)

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetTagsFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="searchString")
    def search_string(self) -> Optional[str]:
        return pulumi.get(self, "search_string")

    @property
    @pulumi.getter(name="sortBies")
    def sort_bies(self) -> Optional[Sequence['outputs.GetTagsSortByResult']]:
        return pulumi.get(self, "sort_bies")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[str]:
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Tags that match your request.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> 'outputs.GetTagsTimePeriodResult':
        return pulumi.get(self, "time_period")


class AwaitableGetTagsResult(GetTagsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagsResult(
            filter=self.filter,
            id=self.id,
            search_string=self.search_string,
            sort_bies=self.sort_bies,
            tag_key=self.tag_key,
            tags=self.tags,
            time_period=self.time_period)


def get_tags(filter: Optional[Union['GetTagsFilterArgs', 'GetTagsFilterArgsDict']] = None,
             search_string: Optional[str] = None,
             sort_bies: Optional[Sequence[Union['GetTagsSortByArgs', 'GetTagsSortByArgsDict']]] = None,
             tag_key: Optional[str] = None,
             time_period: Optional[Union['GetTagsTimePeriodArgs', 'GetTagsTimePeriodArgsDict']] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagsResult:
    """
    Provides the available cost allocation tag keys and tag values for a specified period.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.costexplorer.get_tags(time_period={
        "start": "2021-01-01",
        "end": "2022-12-01",
    })
    ```


    :param Union['GetTagsFilterArgs', 'GetTagsFilterArgsDict'] filter: Configuration block for the `Expression` object used to categorize costs. See `filter` block below for details.
    :param str search_string: Value that you want to search for.
    :param Sequence[Union['GetTagsSortByArgs', 'GetTagsSortByArgsDict']] sort_bies: Configuration block for the value by which you want to sort the data. `sort_by` block below for details.
    :param str tag_key: Key of the tag that you want to return values for.
    :param Union['GetTagsTimePeriodArgs', 'GetTagsTimePeriodArgsDict'] time_period: Configuration block for the start and end dates for retrieving the dimension values. See `time_period` block below for details.
           
           The following arguments are optional:
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['searchString'] = search_string
    __args__['sortBies'] = sort_bies
    __args__['tagKey'] = tag_key
    __args__['timePeriod'] = time_period
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:costexplorer/getTags:getTags', __args__, opts=opts, typ=GetTagsResult).value

    return AwaitableGetTagsResult(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        search_string=pulumi.get(__ret__, 'search_string'),
        sort_bies=pulumi.get(__ret__, 'sort_bies'),
        tag_key=pulumi.get(__ret__, 'tag_key'),
        tags=pulumi.get(__ret__, 'tags'),
        time_period=pulumi.get(__ret__, 'time_period'))
def get_tags_output(filter: Optional[pulumi.Input[Optional[Union['GetTagsFilterArgs', 'GetTagsFilterArgsDict']]]] = None,
                    search_string: Optional[pulumi.Input[Optional[str]]] = None,
                    sort_bies: Optional[pulumi.Input[Optional[Sequence[Union['GetTagsSortByArgs', 'GetTagsSortByArgsDict']]]]] = None,
                    tag_key: Optional[pulumi.Input[Optional[str]]] = None,
                    time_period: Optional[pulumi.Input[Union['GetTagsTimePeriodArgs', 'GetTagsTimePeriodArgsDict']]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTagsResult]:
    """
    Provides the available cost allocation tag keys and tag values for a specified period.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.costexplorer.get_tags(time_period={
        "start": "2021-01-01",
        "end": "2022-12-01",
    })
    ```


    :param Union['GetTagsFilterArgs', 'GetTagsFilterArgsDict'] filter: Configuration block for the `Expression` object used to categorize costs. See `filter` block below for details.
    :param str search_string: Value that you want to search for.
    :param Sequence[Union['GetTagsSortByArgs', 'GetTagsSortByArgsDict']] sort_bies: Configuration block for the value by which you want to sort the data. `sort_by` block below for details.
    :param str tag_key: Key of the tag that you want to return values for.
    :param Union['GetTagsTimePeriodArgs', 'GetTagsTimePeriodArgsDict'] time_period: Configuration block for the start and end dates for retrieving the dimension values. See `time_period` block below for details.
           
           The following arguments are optional:
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['searchString'] = search_string
    __args__['sortBies'] = sort_bies
    __args__['tagKey'] = tag_key
    __args__['timePeriod'] = time_period
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:costexplorer/getTags:getTags', __args__, opts=opts, typ=GetTagsResult)
    return __ret__.apply(lambda __response__: GetTagsResult(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        search_string=pulumi.get(__response__, 'search_string'),
        sort_bies=pulumi.get(__response__, 'sort_bies'),
        tag_key=pulumi.get(__response__, 'tag_key'),
        tags=pulumi.get(__response__, 'tags'),
        time_period=pulumi.get(__response__, 'time_period')))
