# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FormTypeArgs', 'FormType']

@pulumi.input_type
class FormTypeArgs:
    def __init__(__self__, *,
                 domain_identifier: pulumi.Input[str],
                 owning_project_identifier: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 model: Optional[pulumi.Input['FormTypeModelArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['FormTypeTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a FormType resource.
        :param pulumi.Input[str] domain_identifier: Identifier of the domain.
        :param pulumi.Input[str] owning_project_identifier: Identifier of project that owns the form type. Must follow regex of ^[a-zA-Z0-9_-]{1,36}.
        :param pulumi.Input[str] description: Description of form type. Must have a length of between 1 and 2048 characters.
        :param pulumi.Input['FormTypeModelArgs'] model: Object of the model of the form type that contains the following attributes.
        :param pulumi.Input[str] name: Name of the form type. Must be the name of the structure in smithy document.
        """
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "owning_project_identifier", owning_project_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[str]:
        """
        Identifier of the domain.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="owningProjectIdentifier")
    def owning_project_identifier(self) -> pulumi.Input[str]:
        """
        Identifier of project that owns the form type. Must follow regex of ^[a-zA-Z0-9_-]{1,36}.
        """
        return pulumi.get(self, "owning_project_identifier")

    @owning_project_identifier.setter
    def owning_project_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "owning_project_identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of form type. Must have a length of between 1 and 2048 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input['FormTypeModelArgs']]:
        """
        Object of the model of the form type that contains the following attributes.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input['FormTypeModelArgs']]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the form type. Must be the name of the structure in smithy document.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['FormTypeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['FormTypeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _FormTypeState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_identifier: Optional[pulumi.Input[str]] = None,
                 imports: Optional[pulumi.Input[Sequence[pulumi.Input['FormTypeImportArgs']]]] = None,
                 model: Optional[pulumi.Input['FormTypeModelArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 origin_domain_id: Optional[pulumi.Input[str]] = None,
                 origin_project_id: Optional[pulumi.Input[str]] = None,
                 owning_project_identifier: Optional[pulumi.Input[str]] = None,
                 revision: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['FormTypeTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering FormType resources.
        :param pulumi.Input[str] created_at: Creation time of the Form Type.
        :param pulumi.Input[str] created_by: Creator of the Form Type.
        :param pulumi.Input[str] description: Description of form type. Must have a length of between 1 and 2048 characters.
        :param pulumi.Input[str] domain_identifier: Identifier of the domain.
        :param pulumi.Input['FormTypeModelArgs'] model: Object of the model of the form type that contains the following attributes.
        :param pulumi.Input[str] name: Name of the form type. Must be the name of the structure in smithy document.
        :param pulumi.Input[str] origin_domain_id: Origin domain id of the Form Type.
        :param pulumi.Input[str] origin_project_id: Origin project id of the Form Type.
        :param pulumi.Input[str] owning_project_identifier: Identifier of project that owns the form type. Must follow regex of ^[a-zA-Z0-9_-]{1,36}.
        :param pulumi.Input[str] revision: Revision of the Form Type.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_identifier is not None:
            pulumi.set(__self__, "domain_identifier", domain_identifier)
        if imports is not None:
            pulumi.set(__self__, "imports", imports)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin_domain_id is not None:
            pulumi.set(__self__, "origin_domain_id", origin_domain_id)
        if origin_project_id is not None:
            pulumi.set(__self__, "origin_project_id", origin_project_id)
        if owning_project_identifier is not None:
            pulumi.set(__self__, "owning_project_identifier", owning_project_identifier)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time of the Form Type.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        Creator of the Form Type.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of form type. Must have a length of between 1 and 2048 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the domain.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter
    def imports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FormTypeImportArgs']]]]:
        return pulumi.get(self, "imports")

    @imports.setter
    def imports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FormTypeImportArgs']]]]):
        pulumi.set(self, "imports", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input['FormTypeModelArgs']]:
        """
        Object of the model of the form type that contains the following attributes.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input['FormTypeModelArgs']]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the form type. Must be the name of the structure in smithy document.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="originDomainId")
    def origin_domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        Origin domain id of the Form Type.
        """
        return pulumi.get(self, "origin_domain_id")

    @origin_domain_id.setter
    def origin_domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_domain_id", value)

    @property
    @pulumi.getter(name="originProjectId")
    def origin_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Origin project id of the Form Type.
        """
        return pulumi.get(self, "origin_project_id")

    @origin_project_id.setter
    def origin_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_project_id", value)

    @property
    @pulumi.getter(name="owningProjectIdentifier")
    def owning_project_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of project that owns the form type. Must follow regex of ^[a-zA-Z0-9_-]{1,36}.
        """
        return pulumi.get(self, "owning_project_identifier")

    @owning_project_identifier.setter
    def owning_project_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owning_project_identifier", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[str]]:
        """
        Revision of the Form Type.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['FormTypeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['FormTypeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class FormType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_identifier: Optional[pulumi.Input[str]] = None,
                 model: Optional[pulumi.Input[Union['FormTypeModelArgs', 'FormTypeModelArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owning_project_identifier: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['FormTypeTimeoutsArgs', 'FormTypeTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS DataZone Form Type.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        domain_execution_role = aws.iam.Role("domain_execution_role",
            name="example-role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "datazone.amazonaws.com",
                        },
                    },
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "cloudformation.amazonaws.com",
                        },
                    },
                ],
            }),
            inline_policies=[{
                "name": "example-policy",
                "policy": json.dumps({
                    "Version": "2012-10-17",
                    "Statement": [{
                        "Action": [
                            "datazone:*",
                            "ram:*",
                            "sso:*",
                            "kms:*",
                        ],
                        "Effect": "Allow",
                        "Resource": "*",
                    }],
                }),
            }])
        test = aws.datazone.Domain("test",
            name="example",
            domain_execution_role=domain_execution_role.arn)
        test_security_group = aws.ec2.SecurityGroup("test", name="example")
        test_project = aws.datazone.Project("test",
            domain_identifier=test.id,
            glossary_terms=["2N8w6XJCwZf"],
            name="example name",
            description="desc",
            skip_deletion_check=True)
        test_form_type = aws.datazone.FormType("test",
            description="desc",
            name="SageMakerModelFormType",
            domain_identifier=test.id,
            owning_project_identifier=test_project.id,
            status="DISABLED",
            model={
                "smithy": \"\"\"\\x09structure SageMakerModelFormType {
        \\x09\\x09\\x09@required
        \\x09\\x09\\x09@amazon.datazone#searchable
        \\x09\\x09\\x09modelName: String

        \\x09\\x09\\x09@required
        \\x09\\x09\\x09modelArn: String

        \\x09\\x09\\x09@required
        \\x09\\x09\\x09creationTime: String
        \\x09\\x09\\x09}
        \"\"\",
            })
        ```

        ## Import

        Using `pulumi import`, import DataZone Form Type using a comma separated value of `domain_identifier`,`name`,`revision`. For example:

        ```sh
        $ pulumi import aws:datazone/formType:FormType example domain_identifier,name,revision
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of form type. Must have a length of between 1 and 2048 characters.
        :param pulumi.Input[str] domain_identifier: Identifier of the domain.
        :param pulumi.Input[Union['FormTypeModelArgs', 'FormTypeModelArgsDict']] model: Object of the model of the form type that contains the following attributes.
        :param pulumi.Input[str] name: Name of the form type. Must be the name of the structure in smithy document.
        :param pulumi.Input[str] owning_project_identifier: Identifier of project that owns the form type. Must follow regex of ^[a-zA-Z0-9_-]{1,36}.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FormTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS DataZone Form Type.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        domain_execution_role = aws.iam.Role("domain_execution_role",
            name="example-role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "datazone.amazonaws.com",
                        },
                    },
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "cloudformation.amazonaws.com",
                        },
                    },
                ],
            }),
            inline_policies=[{
                "name": "example-policy",
                "policy": json.dumps({
                    "Version": "2012-10-17",
                    "Statement": [{
                        "Action": [
                            "datazone:*",
                            "ram:*",
                            "sso:*",
                            "kms:*",
                        ],
                        "Effect": "Allow",
                        "Resource": "*",
                    }],
                }),
            }])
        test = aws.datazone.Domain("test",
            name="example",
            domain_execution_role=domain_execution_role.arn)
        test_security_group = aws.ec2.SecurityGroup("test", name="example")
        test_project = aws.datazone.Project("test",
            domain_identifier=test.id,
            glossary_terms=["2N8w6XJCwZf"],
            name="example name",
            description="desc",
            skip_deletion_check=True)
        test_form_type = aws.datazone.FormType("test",
            description="desc",
            name="SageMakerModelFormType",
            domain_identifier=test.id,
            owning_project_identifier=test_project.id,
            status="DISABLED",
            model={
                "smithy": \"\"\"\\x09structure SageMakerModelFormType {
        \\x09\\x09\\x09@required
        \\x09\\x09\\x09@amazon.datazone#searchable
        \\x09\\x09\\x09modelName: String

        \\x09\\x09\\x09@required
        \\x09\\x09\\x09modelArn: String

        \\x09\\x09\\x09@required
        \\x09\\x09\\x09creationTime: String
        \\x09\\x09\\x09}
        \"\"\",
            })
        ```

        ## Import

        Using `pulumi import`, import DataZone Form Type using a comma separated value of `domain_identifier`,`name`,`revision`. For example:

        ```sh
        $ pulumi import aws:datazone/formType:FormType example domain_identifier,name,revision
        ```

        :param str resource_name: The name of the resource.
        :param FormTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FormTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_identifier: Optional[pulumi.Input[str]] = None,
                 model: Optional[pulumi.Input[Union['FormTypeModelArgs', 'FormTypeModelArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owning_project_identifier: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['FormTypeTimeoutsArgs', 'FormTypeTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FormTypeArgs.__new__(FormTypeArgs)

            __props__.__dict__["description"] = description
            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            __props__.__dict__["model"] = model
            __props__.__dict__["name"] = name
            if owning_project_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'owning_project_identifier'")
            __props__.__dict__["owning_project_identifier"] = owning_project_identifier
            __props__.__dict__["status"] = status
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["imports"] = None
            __props__.__dict__["origin_domain_id"] = None
            __props__.__dict__["origin_project_id"] = None
            __props__.__dict__["revision"] = None
        super(FormType, __self__).__init__(
            'aws:datazone/formType:FormType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain_identifier: Optional[pulumi.Input[str]] = None,
            imports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FormTypeImportArgs', 'FormTypeImportArgsDict']]]]] = None,
            model: Optional[pulumi.Input[Union['FormTypeModelArgs', 'FormTypeModelArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            origin_domain_id: Optional[pulumi.Input[str]] = None,
            origin_project_id: Optional[pulumi.Input[str]] = None,
            owning_project_identifier: Optional[pulumi.Input[str]] = None,
            revision: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            timeouts: Optional[pulumi.Input[Union['FormTypeTimeoutsArgs', 'FormTypeTimeoutsArgsDict']]] = None) -> 'FormType':
        """
        Get an existing FormType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: Creation time of the Form Type.
        :param pulumi.Input[str] created_by: Creator of the Form Type.
        :param pulumi.Input[str] description: Description of form type. Must have a length of between 1 and 2048 characters.
        :param pulumi.Input[str] domain_identifier: Identifier of the domain.
        :param pulumi.Input[Union['FormTypeModelArgs', 'FormTypeModelArgsDict']] model: Object of the model of the form type that contains the following attributes.
        :param pulumi.Input[str] name: Name of the form type. Must be the name of the structure in smithy document.
        :param pulumi.Input[str] origin_domain_id: Origin domain id of the Form Type.
        :param pulumi.Input[str] origin_project_id: Origin project id of the Form Type.
        :param pulumi.Input[str] owning_project_identifier: Identifier of project that owns the form type. Must follow regex of ^[a-zA-Z0-9_-]{1,36}.
        :param pulumi.Input[str] revision: Revision of the Form Type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FormTypeState.__new__(_FormTypeState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_identifier"] = domain_identifier
        __props__.__dict__["imports"] = imports
        __props__.__dict__["model"] = model
        __props__.__dict__["name"] = name
        __props__.__dict__["origin_domain_id"] = origin_domain_id
        __props__.__dict__["origin_project_id"] = origin_project_id
        __props__.__dict__["owning_project_identifier"] = owning_project_identifier
        __props__.__dict__["revision"] = revision
        __props__.__dict__["status"] = status
        __props__.__dict__["timeouts"] = timeouts
        return FormType(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation time of the Form Type.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        Creator of the Form Type.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of form type. Must have a length of between 1 and 2048 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[str]:
        """
        Identifier of the domain.
        """
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter
    def imports(self) -> pulumi.Output[Sequence['outputs.FormTypeImport']]:
        return pulumi.get(self, "imports")

    @property
    @pulumi.getter
    def model(self) -> pulumi.Output[Optional['outputs.FormTypeModel']]:
        """
        Object of the model of the form type that contains the following attributes.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the form type. Must be the name of the structure in smithy document.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="originDomainId")
    def origin_domain_id(self) -> pulumi.Output[str]:
        """
        Origin domain id of the Form Type.
        """
        return pulumi.get(self, "origin_domain_id")

    @property
    @pulumi.getter(name="originProjectId")
    def origin_project_id(self) -> pulumi.Output[str]:
        """
        Origin project id of the Form Type.
        """
        return pulumi.get(self, "origin_project_id")

    @property
    @pulumi.getter(name="owningProjectIdentifier")
    def owning_project_identifier(self) -> pulumi.Output[str]:
        """
        Identifier of project that owns the form type. Must follow regex of ^[a-zA-Z0-9_-]{1,36}.
        """
        return pulumi.get(self, "owning_project_identifier")

    @property
    @pulumi.getter
    def revision(self) -> pulumi.Output[str]:
        """
        Revision of the Form Type.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.FormTypeTimeouts']]:
        return pulumi.get(self, "timeouts")

