# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEnvironmentBlueprintResult',
    'AwaitableGetEnvironmentBlueprintResult',
    'get_environment_blueprint',
    'get_environment_blueprint_output',
]

@pulumi.output_type
class GetEnvironmentBlueprintResult:
    """
    A collection of values returned by getEnvironmentBlueprint.
    """
    def __init__(__self__, blueprint_provider=None, description=None, domain_id=None, id=None, managed=None, name=None):
        if blueprint_provider and not isinstance(blueprint_provider, str):
            raise TypeError("Expected argument 'blueprint_provider' to be a str")
        pulumi.set(__self__, "blueprint_provider", blueprint_provider)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed and not isinstance(managed, bool):
            raise TypeError("Expected argument 'managed' to be a bool")
        pulumi.set(__self__, "managed", managed)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="blueprintProvider")
    def blueprint_provider(self) -> str:
        """
        Provider of the blueprint
        """
        return pulumi.get(self, "blueprint_provider")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the blueprint
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the environment blueprint
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def managed(self) -> bool:
        return pulumi.get(self, "managed")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


class AwaitableGetEnvironmentBlueprintResult(GetEnvironmentBlueprintResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentBlueprintResult(
            blueprint_provider=self.blueprint_provider,
            description=self.description,
            domain_id=self.domain_id,
            id=self.id,
            managed=self.managed,
            name=self.name)


def get_environment_blueprint(domain_id: Optional[str] = None,
                              managed: Optional[bool] = None,
                              name: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentBlueprintResult:
    """
    Data source for managing an AWS DataZone Environment Blueprint.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example_domain = aws.datazone.Domain("example",
        name="example_domain",
        domain_execution_role=domain_execution_role["arn"])
    example = aws.datazone.get_environment_blueprint_output(domain_id=example_domain.id,
        name="DefaultDataLake",
        managed=True)
    ```


    :param str domain_id: ID of the domain.
    :param bool managed: Whether the blueprint is managed by Amazon DataZone.
    :param str name: Name of the blueprint.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['managed'] = managed
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:datazone/getEnvironmentBlueprint:getEnvironmentBlueprint', __args__, opts=opts, typ=GetEnvironmentBlueprintResult).value

    return AwaitableGetEnvironmentBlueprintResult(
        blueprint_provider=pulumi.get(__ret__, 'blueprint_provider'),
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        id=pulumi.get(__ret__, 'id'),
        managed=pulumi.get(__ret__, 'managed'),
        name=pulumi.get(__ret__, 'name'))
def get_environment_blueprint_output(domain_id: Optional[pulumi.Input[str]] = None,
                                     managed: Optional[pulumi.Input[bool]] = None,
                                     name: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnvironmentBlueprintResult]:
    """
    Data source for managing an AWS DataZone Environment Blueprint.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example_domain = aws.datazone.Domain("example",
        name="example_domain",
        domain_execution_role=domain_execution_role["arn"])
    example = aws.datazone.get_environment_blueprint_output(domain_id=example_domain.id,
        name="DefaultDataLake",
        managed=True)
    ```


    :param str domain_id: ID of the domain.
    :param bool managed: Whether the blueprint is managed by Amazon DataZone.
    :param str name: Name of the blueprint.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['managed'] = managed
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:datazone/getEnvironmentBlueprint:getEnvironmentBlueprint', __args__, opts=opts, typ=GetEnvironmentBlueprintResult)
    return __ret__.apply(lambda __response__: GetEnvironmentBlueprintResult(
        blueprint_provider=pulumi.get(__response__, 'blueprint_provider'),
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        id=pulumi.get(__response__, 'id'),
        managed=pulumi.get(__response__, 'managed'),
        name=pulumi.get(__response__, 'name')))
