# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventSourcesConfigArgs', 'EventSourcesConfig']

@pulumi.input_type
class EventSourcesConfigArgs:
    def __init__(__self__, *,
                 event_sources: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourcesConfigEventSourceArgs']]]] = None):
        """
        The set of arguments for constructing a EventSourcesConfig resource.
        :param pulumi.Input[Sequence[pulumi.Input['EventSourcesConfigEventSourceArgs']]] event_sources: Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
        """
        if event_sources is not None:
            pulumi.set(__self__, "event_sources", event_sources)

    @property
    @pulumi.getter(name="eventSources")
    def event_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventSourcesConfigEventSourceArgs']]]]:
        """
        Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
        """
        return pulumi.get(self, "event_sources")

    @event_sources.setter
    def event_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourcesConfigEventSourceArgs']]]]):
        pulumi.set(self, "event_sources", value)


@pulumi.input_type
class _EventSourcesConfigState:
    def __init__(__self__, *,
                 event_sources: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourcesConfigEventSourceArgs']]]] = None):
        """
        Input properties used for looking up and filtering EventSourcesConfig resources.
        :param pulumi.Input[Sequence[pulumi.Input['EventSourcesConfigEventSourceArgs']]] event_sources: Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
        """
        if event_sources is not None:
            pulumi.set(__self__, "event_sources", event_sources)

    @property
    @pulumi.getter(name="eventSources")
    def event_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventSourcesConfigEventSourceArgs']]]]:
        """
        Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
        """
        return pulumi.get(self, "event_sources")

    @event_sources.setter
    def event_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourcesConfigEventSourceArgs']]]]):
        pulumi.set(self, "event_sources", value)


class EventSourcesConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventSourcesConfigEventSourceArgs', 'EventSourcesConfigEventSourceArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.devopsguru.EventSourcesConfig("example", event_sources=[{
            "amazon_code_guru_profilers": [{
                "status": "ENABLED",
            }],
        }])
        ```

        ## Import

        Using `pulumi import`, import DevOps Guru Event Sources Config using the `id`. For example:

        ```sh
        $ pulumi import aws:devopsguru/eventSourcesConfig:EventSourcesConfig example us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventSourcesConfigEventSourceArgs', 'EventSourcesConfigEventSourceArgsDict']]]] event_sources: Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EventSourcesConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.devopsguru.EventSourcesConfig("example", event_sources=[{
            "amazon_code_guru_profilers": [{
                "status": "ENABLED",
            }],
        }])
        ```

        ## Import

        Using `pulumi import`, import DevOps Guru Event Sources Config using the `id`. For example:

        ```sh
        $ pulumi import aws:devopsguru/eventSourcesConfig:EventSourcesConfig example us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param EventSourcesConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventSourcesConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventSourcesConfigEventSourceArgs', 'EventSourcesConfigEventSourceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventSourcesConfigArgs.__new__(EventSourcesConfigArgs)

            __props__.__dict__["event_sources"] = event_sources
        super(EventSourcesConfig, __self__).__init__(
            'aws:devopsguru/eventSourcesConfig:EventSourcesConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            event_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventSourcesConfigEventSourceArgs', 'EventSourcesConfigEventSourceArgsDict']]]]] = None) -> 'EventSourcesConfig':
        """
        Get an existing EventSourcesConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventSourcesConfigEventSourceArgs', 'EventSourcesConfigEventSourceArgsDict']]]] event_sources: Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventSourcesConfigState.__new__(_EventSourcesConfigState)

        __props__.__dict__["event_sources"] = event_sources
        return EventSourcesConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="eventSources")
    def event_sources(self) -> pulumi.Output[Optional[Sequence['outputs.EventSourcesConfigEventSource']]]:
        """
        Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
        """
        return pulumi.get(self, "event_sources")

