# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceIntegrationArgs', 'ServiceIntegration']

@pulumi.input_type
class ServiceIntegrationArgs:
    def __init__(__self__, *,
                 kms_server_side_encryption: Optional[pulumi.Input['ServiceIntegrationKmsServerSideEncryptionArgs']] = None,
                 logs_anomaly_detection: Optional[pulumi.Input['ServiceIntegrationLogsAnomalyDetectionArgs']] = None,
                 ops_center: Optional[pulumi.Input['ServiceIntegrationOpsCenterArgs']] = None):
        """
        The set of arguments for constructing a ServiceIntegration resource.
        :param pulumi.Input['ServiceIntegrationKmsServerSideEncryptionArgs'] kms_server_side_encryption: Information about whether DevOps Guru is configured to encrypt server-side data using KMS. See `kms_server_side_encryption` below.
        :param pulumi.Input['ServiceIntegrationLogsAnomalyDetectionArgs'] logs_anomaly_detection: Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log groups. See `logs_anomaly_detection` below.
        :param pulumi.Input['ServiceIntegrationOpsCenterArgs'] ops_center: Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight. See `ops_center` below.
        """
        if kms_server_side_encryption is not None:
            pulumi.set(__self__, "kms_server_side_encryption", kms_server_side_encryption)
        if logs_anomaly_detection is not None:
            pulumi.set(__self__, "logs_anomaly_detection", logs_anomaly_detection)
        if ops_center is not None:
            pulumi.set(__self__, "ops_center", ops_center)

    @property
    @pulumi.getter(name="kmsServerSideEncryption")
    def kms_server_side_encryption(self) -> Optional[pulumi.Input['ServiceIntegrationKmsServerSideEncryptionArgs']]:
        """
        Information about whether DevOps Guru is configured to encrypt server-side data using KMS. See `kms_server_side_encryption` below.
        """
        return pulumi.get(self, "kms_server_side_encryption")

    @kms_server_side_encryption.setter
    def kms_server_side_encryption(self, value: Optional[pulumi.Input['ServiceIntegrationKmsServerSideEncryptionArgs']]):
        pulumi.set(self, "kms_server_side_encryption", value)

    @property
    @pulumi.getter(name="logsAnomalyDetection")
    def logs_anomaly_detection(self) -> Optional[pulumi.Input['ServiceIntegrationLogsAnomalyDetectionArgs']]:
        """
        Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log groups. See `logs_anomaly_detection` below.
        """
        return pulumi.get(self, "logs_anomaly_detection")

    @logs_anomaly_detection.setter
    def logs_anomaly_detection(self, value: Optional[pulumi.Input['ServiceIntegrationLogsAnomalyDetectionArgs']]):
        pulumi.set(self, "logs_anomaly_detection", value)

    @property
    @pulumi.getter(name="opsCenter")
    def ops_center(self) -> Optional[pulumi.Input['ServiceIntegrationOpsCenterArgs']]:
        """
        Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight. See `ops_center` below.
        """
        return pulumi.get(self, "ops_center")

    @ops_center.setter
    def ops_center(self, value: Optional[pulumi.Input['ServiceIntegrationOpsCenterArgs']]):
        pulumi.set(self, "ops_center", value)


@pulumi.input_type
class _ServiceIntegrationState:
    def __init__(__self__, *,
                 kms_server_side_encryption: Optional[pulumi.Input['ServiceIntegrationKmsServerSideEncryptionArgs']] = None,
                 logs_anomaly_detection: Optional[pulumi.Input['ServiceIntegrationLogsAnomalyDetectionArgs']] = None,
                 ops_center: Optional[pulumi.Input['ServiceIntegrationOpsCenterArgs']] = None):
        """
        Input properties used for looking up and filtering ServiceIntegration resources.
        :param pulumi.Input['ServiceIntegrationKmsServerSideEncryptionArgs'] kms_server_side_encryption: Information about whether DevOps Guru is configured to encrypt server-side data using KMS. See `kms_server_side_encryption` below.
        :param pulumi.Input['ServiceIntegrationLogsAnomalyDetectionArgs'] logs_anomaly_detection: Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log groups. See `logs_anomaly_detection` below.
        :param pulumi.Input['ServiceIntegrationOpsCenterArgs'] ops_center: Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight. See `ops_center` below.
        """
        if kms_server_side_encryption is not None:
            pulumi.set(__self__, "kms_server_side_encryption", kms_server_side_encryption)
        if logs_anomaly_detection is not None:
            pulumi.set(__self__, "logs_anomaly_detection", logs_anomaly_detection)
        if ops_center is not None:
            pulumi.set(__self__, "ops_center", ops_center)

    @property
    @pulumi.getter(name="kmsServerSideEncryption")
    def kms_server_side_encryption(self) -> Optional[pulumi.Input['ServiceIntegrationKmsServerSideEncryptionArgs']]:
        """
        Information about whether DevOps Guru is configured to encrypt server-side data using KMS. See `kms_server_side_encryption` below.
        """
        return pulumi.get(self, "kms_server_side_encryption")

    @kms_server_side_encryption.setter
    def kms_server_side_encryption(self, value: Optional[pulumi.Input['ServiceIntegrationKmsServerSideEncryptionArgs']]):
        pulumi.set(self, "kms_server_side_encryption", value)

    @property
    @pulumi.getter(name="logsAnomalyDetection")
    def logs_anomaly_detection(self) -> Optional[pulumi.Input['ServiceIntegrationLogsAnomalyDetectionArgs']]:
        """
        Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log groups. See `logs_anomaly_detection` below.
        """
        return pulumi.get(self, "logs_anomaly_detection")

    @logs_anomaly_detection.setter
    def logs_anomaly_detection(self, value: Optional[pulumi.Input['ServiceIntegrationLogsAnomalyDetectionArgs']]):
        pulumi.set(self, "logs_anomaly_detection", value)

    @property
    @pulumi.getter(name="opsCenter")
    def ops_center(self) -> Optional[pulumi.Input['ServiceIntegrationOpsCenterArgs']]:
        """
        Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight. See `ops_center` below.
        """
        return pulumi.get(self, "ops_center")

    @ops_center.setter
    def ops_center(self, value: Optional[pulumi.Input['ServiceIntegrationOpsCenterArgs']]):
        pulumi.set(self, "ops_center", value)


class ServiceIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kms_server_side_encryption: Optional[pulumi.Input[Union['ServiceIntegrationKmsServerSideEncryptionArgs', 'ServiceIntegrationKmsServerSideEncryptionArgsDict']]] = None,
                 logs_anomaly_detection: Optional[pulumi.Input[Union['ServiceIntegrationLogsAnomalyDetectionArgs', 'ServiceIntegrationLogsAnomalyDetectionArgsDict']]] = None,
                 ops_center: Optional[pulumi.Input[Union['ServiceIntegrationOpsCenterArgs', 'ServiceIntegrationOpsCenterArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.devopsguru.ServiceIntegration("example",
            kms_server_side_encryption={
                "opt_in_status": "ENABLED",
                "type": "AWS_OWNED_KMS_KEY",
            },
            logs_anomaly_detection={
                "opt_in_status": "ENABLED",
            },
            ops_center={
                "opt_in_status": "ENABLED",
            })
        ```

        ### Customer Managed KMS Key

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example")
        example_service_integration = aws.devopsguru.ServiceIntegration("example",
            kms_server_side_encryption={
                "kms_key_id": test["arn"],
                "opt_in_status": "ENABLED",
                "type": "CUSTOMER_MANAGED_KEY",
            },
            logs_anomaly_detection={
                "opt_in_status": "DISABLED",
            },
            ops_center={
                "opt_in_status": "DISABLED",
            })
        ```

        ## Import

        Using `pulumi import`, import DevOps Guru Service Integration using the `id`. For example:

        ```sh
        $ pulumi import aws:devopsguru/serviceIntegration:ServiceIntegration example us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceIntegrationKmsServerSideEncryptionArgs', 'ServiceIntegrationKmsServerSideEncryptionArgsDict']] kms_server_side_encryption: Information about whether DevOps Guru is configured to encrypt server-side data using KMS. See `kms_server_side_encryption` below.
        :param pulumi.Input[Union['ServiceIntegrationLogsAnomalyDetectionArgs', 'ServiceIntegrationLogsAnomalyDetectionArgsDict']] logs_anomaly_detection: Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log groups. See `logs_anomaly_detection` below.
        :param pulumi.Input[Union['ServiceIntegrationOpsCenterArgs', 'ServiceIntegrationOpsCenterArgsDict']] ops_center: Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight. See `ops_center` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServiceIntegrationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.devopsguru.ServiceIntegration("example",
            kms_server_side_encryption={
                "opt_in_status": "ENABLED",
                "type": "AWS_OWNED_KMS_KEY",
            },
            logs_anomaly_detection={
                "opt_in_status": "ENABLED",
            },
            ops_center={
                "opt_in_status": "ENABLED",
            })
        ```

        ### Customer Managed KMS Key

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example")
        example_service_integration = aws.devopsguru.ServiceIntegration("example",
            kms_server_side_encryption={
                "kms_key_id": test["arn"],
                "opt_in_status": "ENABLED",
                "type": "CUSTOMER_MANAGED_KEY",
            },
            logs_anomaly_detection={
                "opt_in_status": "DISABLED",
            },
            ops_center={
                "opt_in_status": "DISABLED",
            })
        ```

        ## Import

        Using `pulumi import`, import DevOps Guru Service Integration using the `id`. For example:

        ```sh
        $ pulumi import aws:devopsguru/serviceIntegration:ServiceIntegration example us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param ServiceIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kms_server_side_encryption: Optional[pulumi.Input[Union['ServiceIntegrationKmsServerSideEncryptionArgs', 'ServiceIntegrationKmsServerSideEncryptionArgsDict']]] = None,
                 logs_anomaly_detection: Optional[pulumi.Input[Union['ServiceIntegrationLogsAnomalyDetectionArgs', 'ServiceIntegrationLogsAnomalyDetectionArgsDict']]] = None,
                 ops_center: Optional[pulumi.Input[Union['ServiceIntegrationOpsCenterArgs', 'ServiceIntegrationOpsCenterArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceIntegrationArgs.__new__(ServiceIntegrationArgs)

            __props__.__dict__["kms_server_side_encryption"] = kms_server_side_encryption
            __props__.__dict__["logs_anomaly_detection"] = logs_anomaly_detection
            __props__.__dict__["ops_center"] = ops_center
        super(ServiceIntegration, __self__).__init__(
            'aws:devopsguru/serviceIntegration:ServiceIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            kms_server_side_encryption: Optional[pulumi.Input[Union['ServiceIntegrationKmsServerSideEncryptionArgs', 'ServiceIntegrationKmsServerSideEncryptionArgsDict']]] = None,
            logs_anomaly_detection: Optional[pulumi.Input[Union['ServiceIntegrationLogsAnomalyDetectionArgs', 'ServiceIntegrationLogsAnomalyDetectionArgsDict']]] = None,
            ops_center: Optional[pulumi.Input[Union['ServiceIntegrationOpsCenterArgs', 'ServiceIntegrationOpsCenterArgsDict']]] = None) -> 'ServiceIntegration':
        """
        Get an existing ServiceIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceIntegrationKmsServerSideEncryptionArgs', 'ServiceIntegrationKmsServerSideEncryptionArgsDict']] kms_server_side_encryption: Information about whether DevOps Guru is configured to encrypt server-side data using KMS. See `kms_server_side_encryption` below.
        :param pulumi.Input[Union['ServiceIntegrationLogsAnomalyDetectionArgs', 'ServiceIntegrationLogsAnomalyDetectionArgsDict']] logs_anomaly_detection: Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log groups. See `logs_anomaly_detection` below.
        :param pulumi.Input[Union['ServiceIntegrationOpsCenterArgs', 'ServiceIntegrationOpsCenterArgsDict']] ops_center: Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight. See `ops_center` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceIntegrationState.__new__(_ServiceIntegrationState)

        __props__.__dict__["kms_server_side_encryption"] = kms_server_side_encryption
        __props__.__dict__["logs_anomaly_detection"] = logs_anomaly_detection
        __props__.__dict__["ops_center"] = ops_center
        return ServiceIntegration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="kmsServerSideEncryption")
    def kms_server_side_encryption(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationKmsServerSideEncryption']]:
        """
        Information about whether DevOps Guru is configured to encrypt server-side data using KMS. See `kms_server_side_encryption` below.
        """
        return pulumi.get(self, "kms_server_side_encryption")

    @property
    @pulumi.getter(name="logsAnomalyDetection")
    def logs_anomaly_detection(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationLogsAnomalyDetection']]:
        """
        Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log groups. See `logs_anomaly_detection` below.
        """
        return pulumi.get(self, "logs_anomaly_detection")

    @property
    @pulumi.getter(name="opsCenter")
    def ops_center(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationOpsCenter']]:
        """
        Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight. See `ops_center` below.
        """
        return pulumi.get(self, "ops_center")

