# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterParameterGroupParameter',
    'ClusterRestoreToPointInTime',
    'ElasticClusterTimeouts',
    'GlobalClusterGlobalClusterMember',
]

@pulumi.output_type
class ClusterParameterGroupParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyMethod":
            suggest = "apply_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterParameterGroupParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterParameterGroupParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterParameterGroupParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: str,
                 apply_method: Optional[str] = None):
        """
        :param str name: The name of the DocumentDB parameter.
        :param str value: The value of the DocumentDB parameter.
        :param str apply_method: Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the DocumentDB parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the DocumentDB parameter.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[str]:
        """
        Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
        return pulumi.get(self, "apply_method")


@pulumi.output_type
class ClusterRestoreToPointInTime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceClusterIdentifier":
            suggest = "source_cluster_identifier"
        elif key == "restoreToTime":
            suggest = "restore_to_time"
        elif key == "restoreType":
            suggest = "restore_type"
        elif key == "useLatestRestorableTime":
            suggest = "use_latest_restorable_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRestoreToPointInTime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRestoreToPointInTime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRestoreToPointInTime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_cluster_identifier: str,
                 restore_to_time: Optional[str] = None,
                 restore_type: Optional[str] = None,
                 use_latest_restorable_time: Optional[bool] = None):
        """
        :param str source_cluster_identifier: The identifier of the source DB cluster from which to restore. Must match the identifier of an existing DB cluster.
        :param str restore_to_time: The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        :param str restore_type: The type of restore to be performed. Valid values are `full-copy`, `copy-on-write`.
        :param bool use_latest_restorable_time: A boolean value that indicates whether the DB cluster is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_to_time`.
        """
        pulumi.set(__self__, "source_cluster_identifier", source_cluster_identifier)
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)

    @property
    @pulumi.getter(name="sourceClusterIdentifier")
    def source_cluster_identifier(self) -> str:
        """
        The identifier of the source DB cluster from which to restore. Must match the identifier of an existing DB cluster.
        """
        return pulumi.get(self, "source_cluster_identifier")

    @property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[str]:
        """
        The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        """
        return pulumi.get(self, "restore_to_time")

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[str]:
        """
        The type of restore to be performed. Valid values are `full-copy`, `copy-on-write`.
        """
        return pulumi.get(self, "restore_type")

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[bool]:
        """
        A boolean value that indicates whether the DB cluster is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_to_time`.
        """
        return pulumi.get(self, "use_latest_restorable_time")


@pulumi.output_type
class ElasticClusterTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None,
                 update: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class GlobalClusterGlobalClusterMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbClusterArn":
            suggest = "db_cluster_arn"
        elif key == "isWriter":
            suggest = "is_writer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalClusterGlobalClusterMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalClusterGlobalClusterMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalClusterGlobalClusterMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 db_cluster_arn: Optional[str] = None,
                 is_writer: Optional[bool] = None):
        """
        :param str db_cluster_arn: Amazon Resource Name (ARN) of member DB Cluster.
        :param bool is_writer: Whether the member is the primary DB Cluster.
        """
        if db_cluster_arn is not None:
            pulumi.set(__self__, "db_cluster_arn", db_cluster_arn)
        if is_writer is not None:
            pulumi.set(__self__, "is_writer", is_writer)

    @property
    @pulumi.getter(name="dbClusterArn")
    def db_cluster_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of member DB Cluster.
        """
        return pulumi.get(self, "db_cluster_arn")

    @property
    @pulumi.getter(name="isWriter")
    def is_writer(self) -> Optional[bool]:
        """
        Whether the member is the primary DB Cluster.
        """
        return pulumi.get(self, "is_writer")


