# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GlobalTableReplicaArgs',
    'GlobalTableReplicaArgsDict',
    'TableAttributeArgs',
    'TableAttributeArgsDict',
    'TableGlobalSecondaryIndexArgs',
    'TableGlobalSecondaryIndexArgsDict',
    'TableGlobalSecondaryIndexOnDemandThroughputArgs',
    'TableGlobalSecondaryIndexOnDemandThroughputArgsDict',
    'TableImportTableArgs',
    'TableImportTableArgsDict',
    'TableImportTableInputFormatOptionsArgs',
    'TableImportTableInputFormatOptionsArgsDict',
    'TableImportTableInputFormatOptionsCsvArgs',
    'TableImportTableInputFormatOptionsCsvArgsDict',
    'TableImportTableS3BucketSourceArgs',
    'TableImportTableS3BucketSourceArgsDict',
    'TableLocalSecondaryIndexArgs',
    'TableLocalSecondaryIndexArgsDict',
    'TableOnDemandThroughputArgs',
    'TableOnDemandThroughputArgsDict',
    'TablePointInTimeRecoveryArgs',
    'TablePointInTimeRecoveryArgsDict',
    'TableReplicaArgs',
    'TableReplicaArgsDict',
    'TableServerSideEncryptionArgs',
    'TableServerSideEncryptionArgsDict',
    'TableTtlArgs',
    'TableTtlArgsDict',
    'GetTableServerSideEncryptionArgs',
    'GetTableServerSideEncryptionArgsDict',
]

MYPY = False

if not MYPY:
    class GlobalTableReplicaArgsDict(TypedDict):
        region_name: pulumi.Input[str]
        """
        AWS region name of replica DynamoDB TableE.g., `us-east-1`
        """
elif False:
    GlobalTableReplicaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalTableReplicaArgs:
    def __init__(__self__, *,
                 region_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] region_name: AWS region name of replica DynamoDB TableE.g., `us-east-1`
        """
        pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Input[str]:
        """
        AWS region name of replica DynamoDB TableE.g., `us-east-1`
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "region_name", value)


if not MYPY:
    class TableAttributeArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        Name of the attribute
        """
        type: pulumi.Input[str]
        """
        Attribute type. Valid values are `S` (string), `N` (number), `B` (binary).
        """
elif False:
    TableAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableAttributeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Name of the attribute
        :param pulumi.Input[str] type: Attribute type. Valid values are `S` (string), `N` (number), `B` (binary).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the attribute
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Attribute type. Valid values are `S` (string), `N` (number), `B` (binary).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class TableGlobalSecondaryIndexArgsDict(TypedDict):
        hash_key: pulumi.Input[str]
        """
        Name of the hash key in the index; must be defined as an attribute in the resource.
        """
        name: pulumi.Input[str]
        """
        Name of the index.
        """
        projection_type: pulumi.Input[str]
        """
        One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        """
        non_key_attributes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        """
        on_demand_throughput: NotRequired[pulumi.Input['TableGlobalSecondaryIndexOnDemandThroughputArgsDict']]
        """
        Sets the maximum number of read and write units for the specified on-demand table. See below.
        """
        range_key: NotRequired[pulumi.Input[str]]
        """
        Name of the range key; must be defined
        """
        read_capacity: NotRequired[pulumi.Input[int]]
        """
        Number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        write_capacity: NotRequired[pulumi.Input[int]]
        """
        Number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
elif False:
    TableGlobalSecondaryIndexArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableGlobalSecondaryIndexArgs:
    def __init__(__self__, *,
                 hash_key: pulumi.Input[str],
                 name: pulumi.Input[str],
                 projection_type: pulumi.Input[str],
                 non_key_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 on_demand_throughput: Optional[pulumi.Input['TableGlobalSecondaryIndexOnDemandThroughputArgs']] = None,
                 range_key: Optional[pulumi.Input[str]] = None,
                 read_capacity: Optional[pulumi.Input[int]] = None,
                 write_capacity: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] hash_key: Name of the hash key in the index; must be defined as an attribute in the resource.
        :param pulumi.Input[str] name: Name of the index.
        :param pulumi.Input[str] projection_type: One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] non_key_attributes: Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        :param pulumi.Input['TableGlobalSecondaryIndexOnDemandThroughputArgs'] on_demand_throughput: Sets the maximum number of read and write units for the specified on-demand table. See below.
        :param pulumi.Input[str] range_key: Name of the range key; must be defined
        :param pulumi.Input[int] read_capacity: Number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
        :param pulumi.Input[int] write_capacity: Number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        pulumi.set(__self__, "hash_key", hash_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "projection_type", projection_type)
        if non_key_attributes is not None:
            pulumi.set(__self__, "non_key_attributes", non_key_attributes)
        if on_demand_throughput is not None:
            pulumi.set(__self__, "on_demand_throughput", on_demand_throughput)
        if range_key is not None:
            pulumi.set(__self__, "range_key", range_key)
        if read_capacity is not None:
            pulumi.set(__self__, "read_capacity", read_capacity)
        if write_capacity is not None:
            pulumi.set(__self__, "write_capacity", write_capacity)

    @property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> pulumi.Input[str]:
        """
        Name of the hash key in the index; must be defined as an attribute in the resource.
        """
        return pulumi.get(self, "hash_key")

    @hash_key.setter
    def hash_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "hash_key", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the index.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> pulumi.Input[str]:
        """
        One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        """
        return pulumi.get(self, "projection_type")

    @projection_type.setter
    def projection_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "projection_type", value)

    @property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        """
        return pulumi.get(self, "non_key_attributes")

    @non_key_attributes.setter
    def non_key_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "non_key_attributes", value)

    @property
    @pulumi.getter(name="onDemandThroughput")
    def on_demand_throughput(self) -> Optional[pulumi.Input['TableGlobalSecondaryIndexOnDemandThroughputArgs']]:
        """
        Sets the maximum number of read and write units for the specified on-demand table. See below.
        """
        return pulumi.get(self, "on_demand_throughput")

    @on_demand_throughput.setter
    def on_demand_throughput(self, value: Optional[pulumi.Input['TableGlobalSecondaryIndexOnDemandThroughputArgs']]):
        pulumi.set(self, "on_demand_throughput", value)

    @property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the range key; must be defined
        """
        return pulumi.get(self, "range_key")

    @range_key.setter
    def range_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_key", value)

    @property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        return pulumi.get(self, "read_capacity")

    @read_capacity.setter
    def read_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_capacity", value)

    @property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        return pulumi.get(self, "write_capacity")

    @write_capacity.setter
    def write_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "write_capacity", value)


if not MYPY:
    class TableGlobalSecondaryIndexOnDemandThroughputArgsDict(TypedDict):
        max_read_request_units: NotRequired[pulumi.Input[int]]
        """
        Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        max_write_request_units: NotRequired[pulumi.Input[int]]
        """
        Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
elif False:
    TableGlobalSecondaryIndexOnDemandThroughputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableGlobalSecondaryIndexOnDemandThroughputArgs:
    def __init__(__self__, *,
                 max_read_request_units: Optional[pulumi.Input[int]] = None,
                 max_write_request_units: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_read_request_units: Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        :param pulumi.Input[int] max_write_request_units: Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        if max_read_request_units is not None:
            pulumi.set(__self__, "max_read_request_units", max_read_request_units)
        if max_write_request_units is not None:
            pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_read_request_units")

    @max_read_request_units.setter
    def max_read_request_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_read_request_units", value)

    @property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_write_request_units")

    @max_write_request_units.setter
    def max_write_request_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_write_request_units", value)


if not MYPY:
    class TableImportTableArgsDict(TypedDict):
        input_format: pulumi.Input[str]
        """
        The format of the source data.
        Valid values are `CSV`, `DYNAMODB_JSON`, and `ION`.
        """
        s3_bucket_source: pulumi.Input['TableImportTableS3BucketSourceArgsDict']
        """
        Values for the S3 bucket the source file is imported from.
        See below.
        """
        input_compression_type: NotRequired[pulumi.Input[str]]
        """
        Type of compression to be used on the input coming from the imported table.
        Valid values are `GZIP`, `ZSTD` and `NONE`.
        """
        input_format_options: NotRequired[pulumi.Input['TableImportTableInputFormatOptionsArgsDict']]
        """
        Describe the format options for the data that was imported into the target table.
        There is one value, `csv`.
        See below.
        """
elif False:
    TableImportTableArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableImportTableArgs:
    def __init__(__self__, *,
                 input_format: pulumi.Input[str],
                 s3_bucket_source: pulumi.Input['TableImportTableS3BucketSourceArgs'],
                 input_compression_type: Optional[pulumi.Input[str]] = None,
                 input_format_options: Optional[pulumi.Input['TableImportTableInputFormatOptionsArgs']] = None):
        """
        :param pulumi.Input[str] input_format: The format of the source data.
               Valid values are `CSV`, `DYNAMODB_JSON`, and `ION`.
        :param pulumi.Input['TableImportTableS3BucketSourceArgs'] s3_bucket_source: Values for the S3 bucket the source file is imported from.
               See below.
        :param pulumi.Input[str] input_compression_type: Type of compression to be used on the input coming from the imported table.
               Valid values are `GZIP`, `ZSTD` and `NONE`.
        :param pulumi.Input['TableImportTableInputFormatOptionsArgs'] input_format_options: Describe the format options for the data that was imported into the target table.
               There is one value, `csv`.
               See below.
        """
        pulumi.set(__self__, "input_format", input_format)
        pulumi.set(__self__, "s3_bucket_source", s3_bucket_source)
        if input_compression_type is not None:
            pulumi.set(__self__, "input_compression_type", input_compression_type)
        if input_format_options is not None:
            pulumi.set(__self__, "input_format_options", input_format_options)

    @property
    @pulumi.getter(name="inputFormat")
    def input_format(self) -> pulumi.Input[str]:
        """
        The format of the source data.
        Valid values are `CSV`, `DYNAMODB_JSON`, and `ION`.
        """
        return pulumi.get(self, "input_format")

    @input_format.setter
    def input_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_format", value)

    @property
    @pulumi.getter(name="s3BucketSource")
    def s3_bucket_source(self) -> pulumi.Input['TableImportTableS3BucketSourceArgs']:
        """
        Values for the S3 bucket the source file is imported from.
        See below.
        """
        return pulumi.get(self, "s3_bucket_source")

    @s3_bucket_source.setter
    def s3_bucket_source(self, value: pulumi.Input['TableImportTableS3BucketSourceArgs']):
        pulumi.set(self, "s3_bucket_source", value)

    @property
    @pulumi.getter(name="inputCompressionType")
    def input_compression_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of compression to be used on the input coming from the imported table.
        Valid values are `GZIP`, `ZSTD` and `NONE`.
        """
        return pulumi.get(self, "input_compression_type")

    @input_compression_type.setter
    def input_compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_compression_type", value)

    @property
    @pulumi.getter(name="inputFormatOptions")
    def input_format_options(self) -> Optional[pulumi.Input['TableImportTableInputFormatOptionsArgs']]:
        """
        Describe the format options for the data that was imported into the target table.
        There is one value, `csv`.
        See below.
        """
        return pulumi.get(self, "input_format_options")

    @input_format_options.setter
    def input_format_options(self, value: Optional[pulumi.Input['TableImportTableInputFormatOptionsArgs']]):
        pulumi.set(self, "input_format_options", value)


if not MYPY:
    class TableImportTableInputFormatOptionsArgsDict(TypedDict):
        csv: NotRequired[pulumi.Input['TableImportTableInputFormatOptionsCsvArgsDict']]
        """
        This block contains the processing options for the CSV file being imported:
        """
elif False:
    TableImportTableInputFormatOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableImportTableInputFormatOptionsArgs:
    def __init__(__self__, *,
                 csv: Optional[pulumi.Input['TableImportTableInputFormatOptionsCsvArgs']] = None):
        """
        :param pulumi.Input['TableImportTableInputFormatOptionsCsvArgs'] csv: This block contains the processing options for the CSV file being imported:
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)

    @property
    @pulumi.getter
    def csv(self) -> Optional[pulumi.Input['TableImportTableInputFormatOptionsCsvArgs']]:
        """
        This block contains the processing options for the CSV file being imported:
        """
        return pulumi.get(self, "csv")

    @csv.setter
    def csv(self, value: Optional[pulumi.Input['TableImportTableInputFormatOptionsCsvArgs']]):
        pulumi.set(self, "csv", value)


if not MYPY:
    class TableImportTableInputFormatOptionsCsvArgsDict(TypedDict):
        delimiter: NotRequired[pulumi.Input[str]]
        """
        The delimiter used for separating items in the CSV file being imported.
        """
        header_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        List of the headers used to specify a common header for all source CSV files being imported.
        """
elif False:
    TableImportTableInputFormatOptionsCsvArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableImportTableInputFormatOptionsCsvArgs:
    def __init__(__self__, *,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 header_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] delimiter: The delimiter used for separating items in the CSV file being imported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] header_lists: List of the headers used to specify a common header for all source CSV files being imported.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if header_lists is not None:
            pulumi.set(__self__, "header_lists", header_lists)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        The delimiter used for separating items in the CSV file being imported.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="headerLists")
    def header_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the headers used to specify a common header for all source CSV files being imported.
        """
        return pulumi.get(self, "header_lists")

    @header_lists.setter
    def header_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "header_lists", value)


if not MYPY:
    class TableImportTableS3BucketSourceArgsDict(TypedDict):
        bucket: pulumi.Input[str]
        """
        The S3 bucket that is being imported from.
        """
        bucket_owner: NotRequired[pulumi.Input[str]]
        """
        The account number of the S3 bucket that is being imported from.
        """
        key_prefix: NotRequired[pulumi.Input[str]]
        """
        The key prefix shared by all S3 Objects that are being imported.
        """
elif False:
    TableImportTableS3BucketSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableImportTableS3BucketSourceArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 bucket_owner: Optional[pulumi.Input[str]] = None,
                 key_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: The S3 bucket that is being imported from.
        :param pulumi.Input[str] bucket_owner: The account number of the S3 bucket that is being imported from.
        :param pulumi.Input[str] key_prefix: The key prefix shared by all S3 Objects that are being imported.
        """
        pulumi.set(__self__, "bucket", bucket)
        if bucket_owner is not None:
            pulumi.set(__self__, "bucket_owner", bucket_owner)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The S3 bucket that is being imported from.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="bucketOwner")
    def bucket_owner(self) -> Optional[pulumi.Input[str]]:
        """
        The account number of the S3 bucket that is being imported from.
        """
        return pulumi.get(self, "bucket_owner")

    @bucket_owner.setter
    def bucket_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_owner", value)

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The key prefix shared by all S3 Objects that are being imported.
        """
        return pulumi.get(self, "key_prefix")

    @key_prefix.setter
    def key_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_prefix", value)


if not MYPY:
    class TableLocalSecondaryIndexArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        Name of the index
        """
        projection_type: pulumi.Input[str]
        """
        One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        """
        range_key: pulumi.Input[str]
        """
        Name of the range key.
        """
        non_key_attributes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        """
elif False:
    TableLocalSecondaryIndexArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableLocalSecondaryIndexArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 projection_type: pulumi.Input[str],
                 range_key: pulumi.Input[str],
                 non_key_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] name: Name of the index
        :param pulumi.Input[str] projection_type: One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        :param pulumi.Input[str] range_key: Name of the range key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] non_key_attributes: Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "projection_type", projection_type)
        pulumi.set(__self__, "range_key", range_key)
        if non_key_attributes is not None:
            pulumi.set(__self__, "non_key_attributes", non_key_attributes)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the index
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> pulumi.Input[str]:
        """
        One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        """
        return pulumi.get(self, "projection_type")

    @projection_type.setter
    def projection_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "projection_type", value)

    @property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> pulumi.Input[str]:
        """
        Name of the range key.
        """
        return pulumi.get(self, "range_key")

    @range_key.setter
    def range_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "range_key", value)

    @property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        """
        return pulumi.get(self, "non_key_attributes")

    @non_key_attributes.setter
    def non_key_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "non_key_attributes", value)


if not MYPY:
    class TableOnDemandThroughputArgsDict(TypedDict):
        max_read_request_units: NotRequired[pulumi.Input[int]]
        """
        Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        max_write_request_units: NotRequired[pulumi.Input[int]]
        """
        Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
elif False:
    TableOnDemandThroughputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableOnDemandThroughputArgs:
    def __init__(__self__, *,
                 max_read_request_units: Optional[pulumi.Input[int]] = None,
                 max_write_request_units: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_read_request_units: Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        :param pulumi.Input[int] max_write_request_units: Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        if max_read_request_units is not None:
            pulumi.set(__self__, "max_read_request_units", max_read_request_units)
        if max_write_request_units is not None:
            pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_read_request_units")

    @max_read_request_units.setter
    def max_read_request_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_read_request_units", value)

    @property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_write_request_units")

    @max_write_request_units.setter
    def max_write_request_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_write_request_units", value)


if not MYPY:
    class TablePointInTimeRecoveryArgsDict(TypedDict):
        enabled: pulumi.Input[bool]
        """
        Whether to enable point-in-time recovery. It can take 10 minutes to enable for new tables. If the `point_in_time_recovery` block is not provided, this defaults to `false`.
        """
elif False:
    TablePointInTimeRecoveryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TablePointInTimeRecoveryArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enabled: Whether to enable point-in-time recovery. It can take 10 minutes to enable for new tables. If the `point_in_time_recovery` block is not provided, this defaults to `false`.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether to enable point-in-time recovery. It can take 10 minutes to enable for new tables. If the `point_in_time_recovery` block is not provided, this defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class TableReplicaArgsDict(TypedDict):
        region_name: pulumi.Input[str]
        """
        Region name of the replica.
        """
        arn: NotRequired[pulumi.Input[str]]
        """
        ARN of the table
        """
        kms_key_arn: NotRequired[pulumi.Input[str]]
        """
        ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
        point_in_time_recovery: NotRequired[pulumi.Input[bool]]
        """
        Whether to enable Point In Time Recovery for the replica. Default is `false`.
        """
        propagate_tags: NotRequired[pulumi.Input[bool]]
        """
        Whether to propagate the global table's tags to a replica. Default is `false`. Changes to tags only move in one direction: from global (source) to replica. In other words, tag drift on a replica will not trigger an update. Tag or replica changes on the global table, whether from drift or configuration changes, are propagated to replicas. Changing from `true` to `false` on a subsequent `apply` means replica tags are left as they were, unmanaged, not deleted.
        """
        stream_arn: NotRequired[pulumi.Input[str]]
        """
        ARN of the Table Stream. Only available when `stream_enabled = true`
        """
        stream_label: NotRequired[pulumi.Input[str]]
        """
        Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
        """
elif False:
    TableReplicaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableReplicaArgs:
    def __init__(__self__, *,
                 region_name: pulumi.Input[str],
                 arn: Optional[pulumi.Input[str]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 point_in_time_recovery: Optional[pulumi.Input[bool]] = None,
                 propagate_tags: Optional[pulumi.Input[bool]] = None,
                 stream_arn: Optional[pulumi.Input[str]] = None,
                 stream_label: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] region_name: Region name of the replica.
        :param pulumi.Input[str] arn: ARN of the table
        :param pulumi.Input[str] kms_key_arn: ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        :param pulumi.Input[bool] point_in_time_recovery: Whether to enable Point In Time Recovery for the replica. Default is `false`.
        :param pulumi.Input[bool] propagate_tags: Whether to propagate the global table's tags to a replica. Default is `false`. Changes to tags only move in one direction: from global (source) to replica. In other words, tag drift on a replica will not trigger an update. Tag or replica changes on the global table, whether from drift or configuration changes, are propagated to replicas. Changing from `true` to `false` on a subsequent `apply` means replica tags are left as they were, unmanaged, not deleted.
        :param pulumi.Input[str] stream_arn: ARN of the Table Stream. Only available when `stream_enabled = true`
        :param pulumi.Input[str] stream_label: Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
        """
        pulumi.set(__self__, "region_name", region_name)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if point_in_time_recovery is not None:
            pulumi.set(__self__, "point_in_time_recovery", point_in_time_recovery)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if stream_arn is not None:
            pulumi.set(__self__, "stream_arn", stream_arn)
        if stream_label is not None:
            pulumi.set(__self__, "stream_label", stream_label)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Input[str]:
        """
        Region name of the replica.
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "region_name", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the table
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="pointInTimeRecovery")
    def point_in_time_recovery(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Point In Time Recovery for the replica. Default is `false`.
        """
        return pulumi.get(self, "point_in_time_recovery")

    @point_in_time_recovery.setter
    def point_in_time_recovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "point_in_time_recovery", value)

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to propagate the global table's tags to a replica. Default is `false`. Changes to tags only move in one direction: from global (source) to replica. In other words, tag drift on a replica will not trigger an update. Tag or replica changes on the global table, whether from drift or configuration changes, are propagated to replicas. Changing from `true` to `false` on a subsequent `apply` means replica tags are left as they were, unmanaged, not deleted.
        """
        return pulumi.get(self, "propagate_tags")

    @propagate_tags.setter
    def propagate_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "propagate_tags", value)

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Table Stream. Only available when `stream_enabled = true`
        """
        return pulumi.get(self, "stream_arn")

    @stream_arn.setter
    def stream_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_arn", value)

    @property
    @pulumi.getter(name="streamLabel")
    def stream_label(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
        """
        return pulumi.get(self, "stream_label")

    @stream_label.setter
    def stream_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_label", value)


if not MYPY:
    class TableServerSideEncryptionArgsDict(TypedDict):
        enabled: pulumi.Input[bool]
        """
        Whether or not to enable encryption at rest using an AWS managed KMS customer master key (CMK). If `enabled` is `false` then server-side encryption is set to AWS-_owned_ key (shown as `DEFAULT` in the AWS console). Potentially confusingly, if `enabled` is `true` and no `kms_key_arn` is specified then server-side encryption is set to the _default_ KMS-_managed_ key (shown as `KMS` in the AWS console). The [AWS KMS documentation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html) explains the difference between AWS-_owned_ and KMS-_managed_ keys.
        """
        kms_key_arn: NotRequired[pulumi.Input[str]]
        """
        ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
elif False:
    TableServerSideEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableServerSideEncryptionArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 kms_key_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether or not to enable encryption at rest using an AWS managed KMS customer master key (CMK). If `enabled` is `false` then server-side encryption is set to AWS-_owned_ key (shown as `DEFAULT` in the AWS console). Potentially confusingly, if `enabled` is `true` and no `kms_key_arn` is specified then server-side encryption is set to the _default_ KMS-_managed_ key (shown as `KMS` in the AWS console). The [AWS KMS documentation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html) explains the difference between AWS-_owned_ and KMS-_managed_ keys.
        :param pulumi.Input[str] kms_key_arn: ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
        pulumi.set(__self__, "enabled", enabled)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether or not to enable encryption at rest using an AWS managed KMS customer master key (CMK). If `enabled` is `false` then server-side encryption is set to AWS-_owned_ key (shown as `DEFAULT` in the AWS console). Potentially confusingly, if `enabled` is `true` and no `kms_key_arn` is specified then server-side encryption is set to the _default_ KMS-_managed_ key (shown as `KMS` in the AWS console). The [AWS KMS documentation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html) explains the difference between AWS-_owned_ and KMS-_managed_ keys.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)


if not MYPY:
    class TableTtlArgsDict(TypedDict):
        attribute_name: NotRequired[pulumi.Input[str]]
        """
        Name of the table attribute to store the TTL timestamp in.
        Required if `enabled` is `true`, must not be set otherwise.
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether TTL is enabled.
        Default value is `false`.
        """
elif False:
    TableTtlArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableTtlArgs:
    def __init__(__self__, *,
                 attribute_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] attribute_name: Name of the table attribute to store the TTL timestamp in.
               Required if `enabled` is `true`, must not be set otherwise.
        :param pulumi.Input[bool] enabled: Whether TTL is enabled.
               Default value is `false`.
        """
        if attribute_name is not None:
            pulumi.set(__self__, "attribute_name", attribute_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the table attribute to store the TTL timestamp in.
        Required if `enabled` is `true`, must not be set otherwise.
        """
        return pulumi.get(self, "attribute_name")

    @attribute_name.setter
    def attribute_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attribute_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether TTL is enabled.
        Default value is `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class GetTableServerSideEncryptionArgsDict(TypedDict):
        enabled: bool
        kms_key_arn: str
elif False:
    GetTableServerSideEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetTableServerSideEncryptionArgs:
    def __init__(__self__, *,
                 enabled: bool,
                 kms_key_arn: str):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: bool):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> str:
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: str):
        pulumi.set(self, "kms_key_arn", value)


