# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FastSnapshotRestoreArgs', 'FastSnapshotRestore']

@pulumi.input_type
class FastSnapshotRestoreArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 snapshot_id: pulumi.Input[str],
                 timeouts: Optional[pulumi.Input['FastSnapshotRestoreTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a FastSnapshotRestore resource.
        :param pulumi.Input[str] availability_zone: Availability zone in which to enable fast snapshot restores.
        :param pulumi.Input[str] snapshot_id: ID of the snapshot.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Availability zone in which to enable fast snapshot restores.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Input[str]:
        """
        ID of the snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['FastSnapshotRestoreTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['FastSnapshotRestoreTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _FastSnapshotRestoreState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['FastSnapshotRestoreTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering FastSnapshotRestore resources.
        :param pulumi.Input[str] availability_zone: Availability zone in which to enable fast snapshot restores.
        :param pulumi.Input[str] snapshot_id: ID of the snapshot.
        :param pulumi.Input[str] state: State of fast snapshot restores. Valid values are `enabling`, `optimizing`, `enabled`, `disabling`, `disabled`.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Availability zone in which to enable fast snapshot restores.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of fast snapshot restores. Valid values are `enabling`, `optimizing`, `enabled`, `disabling`, `disabled`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['FastSnapshotRestoreTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['FastSnapshotRestoreTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class FastSnapshotRestore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['FastSnapshotRestoreTimeoutsArgs', 'FastSnapshotRestoreTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an EBS (Elastic Block Storage) Fast Snapshot Restore.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ebs.FastSnapshotRestore("example",
            availability_zone="us-west-2a",
            snapshot_id=example_aws_ebs_snapshot["id"])
        ```

        ## Import

        Using `pulumi import`, import EC2 (Elastic Compute Cloud) EBS Fast Snapshot Restore using the `id`. For example:

        ```sh
        $ pulumi import aws:ebs/fastSnapshotRestore:FastSnapshotRestore example us-west-2a,snap-abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Availability zone in which to enable fast snapshot restores.
        :param pulumi.Input[str] snapshot_id: ID of the snapshot.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FastSnapshotRestoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an EBS (Elastic Block Storage) Fast Snapshot Restore.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ebs.FastSnapshotRestore("example",
            availability_zone="us-west-2a",
            snapshot_id=example_aws_ebs_snapshot["id"])
        ```

        ## Import

        Using `pulumi import`, import EC2 (Elastic Compute Cloud) EBS Fast Snapshot Restore using the `id`. For example:

        ```sh
        $ pulumi import aws:ebs/fastSnapshotRestore:FastSnapshotRestore example us-west-2a,snap-abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param FastSnapshotRestoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FastSnapshotRestoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['FastSnapshotRestoreTimeoutsArgs', 'FastSnapshotRestoreTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FastSnapshotRestoreArgs.__new__(FastSnapshotRestoreArgs)

            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            if snapshot_id is None and not opts.urn:
                raise TypeError("Missing required property 'snapshot_id'")
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["state"] = None
        super(FastSnapshotRestore, __self__).__init__(
            'aws:ebs/fastSnapshotRestore:FastSnapshotRestore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            snapshot_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            timeouts: Optional[pulumi.Input[Union['FastSnapshotRestoreTimeoutsArgs', 'FastSnapshotRestoreTimeoutsArgsDict']]] = None) -> 'FastSnapshotRestore':
        """
        Get an existing FastSnapshotRestore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Availability zone in which to enable fast snapshot restores.
        :param pulumi.Input[str] snapshot_id: ID of the snapshot.
        :param pulumi.Input[str] state: State of fast snapshot restores. Valid values are `enabling`, `optimizing`, `enabled`, `disabling`, `disabled`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FastSnapshotRestoreState.__new__(_FastSnapshotRestoreState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["state"] = state
        __props__.__dict__["timeouts"] = timeouts
        return FastSnapshotRestore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Availability zone in which to enable fast snapshot restores.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[str]:
        """
        ID of the snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of fast snapshot restores. Valid values are `enabling`, `optimizing`, `enabled`, `disabling`, `disabled`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.FastSnapshotRestoreTimeouts']]:
        return pulumi.get(self, "timeouts")

