# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DefaultSubnetArgs', 'DefaultSubnet']

@pulumi.input_type
class DefaultSubnetArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 assign_ipv6_address_on_creation: Optional[pulumi.Input[bool]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[str]] = None,
                 enable_dns64: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_a_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_aaaa_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 ipv6_native: Optional[pulumi.Input[bool]] = None,
                 map_customer_owned_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 map_public_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 private_dns_hostname_type_on_launch: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a DefaultSubnet resource.
        :param pulumi.Input[str] availability_zone: is required
               * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
               * The default value for `map_public_ip_on_launch` is `true`
               
               This resource supports the following additional arguments:
        :param pulumi.Input[bool] force_destroy: Whether destroying the resource deletes the default subnet. Default: `false`
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        if assign_ipv6_address_on_creation is not None:
            pulumi.set(__self__, "assign_ipv6_address_on_creation", assign_ipv6_address_on_creation)
        if customer_owned_ipv4_pool is not None:
            pulumi.set(__self__, "customer_owned_ipv4_pool", customer_owned_ipv4_pool)
        if enable_dns64 is not None:
            pulumi.set(__self__, "enable_dns64", enable_dns64)
        if enable_resource_name_dns_a_record_on_launch is not None:
            pulumi.set(__self__, "enable_resource_name_dns_a_record_on_launch", enable_resource_name_dns_a_record_on_launch)
        if enable_resource_name_dns_aaaa_record_on_launch is not None:
            pulumi.set(__self__, "enable_resource_name_dns_aaaa_record_on_launch", enable_resource_name_dns_aaaa_record_on_launch)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if ipv6_native is not None:
            pulumi.set(__self__, "ipv6_native", ipv6_native)
        if map_customer_owned_ip_on_launch is not None:
            pulumi.set(__self__, "map_customer_owned_ip_on_launch", map_customer_owned_ip_on_launch)
        if map_public_ip_on_launch is not None:
            pulumi.set(__self__, "map_public_ip_on_launch", map_public_ip_on_launch)
        if private_dns_hostname_type_on_launch is not None:
            pulumi.set(__self__, "private_dns_hostname_type_on_launch", private_dns_hostname_type_on_launch)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        is required
        * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
        * The default value for `map_public_ip_on_launch` is `true`

        This resource supports the following additional arguments:
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="assignIpv6AddressOnCreation")
    def assign_ipv6_address_on_creation(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "assign_ipv6_address_on_creation")

    @assign_ipv6_address_on_creation.setter
    def assign_ipv6_address_on_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "assign_ipv6_address_on_creation", value)

    @property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @customer_owned_ipv4_pool.setter
    def customer_owned_ipv4_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_owned_ipv4_pool", value)

    @property
    @pulumi.getter(name="enableDns64")
    def enable_dns64(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_dns64")

    @enable_dns64.setter
    def enable_dns64(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dns64", value)

    @property
    @pulumi.getter(name="enableResourceNameDnsARecordOnLaunch")
    def enable_resource_name_dns_a_record_on_launch(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_resource_name_dns_a_record_on_launch")

    @enable_resource_name_dns_a_record_on_launch.setter
    def enable_resource_name_dns_a_record_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_resource_name_dns_a_record_on_launch", value)

    @property
    @pulumi.getter(name="enableResourceNameDnsAaaaRecordOnLaunch")
    def enable_resource_name_dns_aaaa_record_on_launch(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_resource_name_dns_aaaa_record_on_launch")

    @enable_resource_name_dns_aaaa_record_on_launch.setter
    def enable_resource_name_dns_aaaa_record_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_resource_name_dns_aaaa_record_on_launch", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether destroying the resource deletes the default subnet. Default: `false`
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ipv6_cidr_block")

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_cidr_block", value)

    @property
    @pulumi.getter(name="ipv6Native")
    def ipv6_native(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "ipv6_native")

    @ipv6_native.setter
    def ipv6_native(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_native", value)

    @property
    @pulumi.getter(name="mapCustomerOwnedIpOnLaunch")
    def map_customer_owned_ip_on_launch(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "map_customer_owned_ip_on_launch")

    @map_customer_owned_ip_on_launch.setter
    def map_customer_owned_ip_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "map_customer_owned_ip_on_launch", value)

    @property
    @pulumi.getter(name="mapPublicIpOnLaunch")
    def map_public_ip_on_launch(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "map_public_ip_on_launch")

    @map_public_ip_on_launch.setter
    def map_public_ip_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "map_public_ip_on_launch", value)

    @property
    @pulumi.getter(name="privateDnsHostnameTypeOnLaunch")
    def private_dns_hostname_type_on_launch(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "private_dns_hostname_type_on_launch")

    @private_dns_hostname_type_on_launch.setter
    def private_dns_hostname_type_on_launch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_dns_hostname_type_on_launch", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DefaultSubnetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 assign_ipv6_address_on_creation: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 availability_zone_id: Optional[pulumi.Input[str]] = None,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[str]] = None,
                 enable_dns64: Optional[pulumi.Input[bool]] = None,
                 enable_lni_at_device_index: Optional[pulumi.Input[int]] = None,
                 enable_resource_name_dns_a_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_aaaa_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 existing_default_subnet: Optional[pulumi.Input[bool]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 ipv6_cidr_block_association_id: Optional[pulumi.Input[str]] = None,
                 ipv6_native: Optional[pulumi.Input[bool]] = None,
                 map_customer_owned_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 map_public_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 outpost_arn: Optional[pulumi.Input[str]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 private_dns_hostname_type_on_launch: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DefaultSubnet resources.
        :param pulumi.Input[str] availability_zone: is required
               * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
               * The default value for `map_public_ip_on_launch` is `true`
               
               This resource supports the following additional arguments:
        :param pulumi.Input[str] availability_zone_id: The AZ ID of the subnet
        :param pulumi.Input[str] cidr_block: The IPv4 CIDR block assigned to the subnet
        :param pulumi.Input[bool] force_destroy: Whether destroying the resource deletes the default subnet. Default: `false`
        :param pulumi.Input[str] vpc_id: The ID of the VPC the subnet is in
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if assign_ipv6_address_on_creation is not None:
            pulumi.set(__self__, "assign_ipv6_address_on_creation", assign_ipv6_address_on_creation)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if customer_owned_ipv4_pool is not None:
            pulumi.set(__self__, "customer_owned_ipv4_pool", customer_owned_ipv4_pool)
        if enable_dns64 is not None:
            pulumi.set(__self__, "enable_dns64", enable_dns64)
        if enable_lni_at_device_index is not None:
            pulumi.set(__self__, "enable_lni_at_device_index", enable_lni_at_device_index)
        if enable_resource_name_dns_a_record_on_launch is not None:
            pulumi.set(__self__, "enable_resource_name_dns_a_record_on_launch", enable_resource_name_dns_a_record_on_launch)
        if enable_resource_name_dns_aaaa_record_on_launch is not None:
            pulumi.set(__self__, "enable_resource_name_dns_aaaa_record_on_launch", enable_resource_name_dns_aaaa_record_on_launch)
        if existing_default_subnet is not None:
            pulumi.set(__self__, "existing_default_subnet", existing_default_subnet)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if ipv6_cidr_block_association_id is not None:
            pulumi.set(__self__, "ipv6_cidr_block_association_id", ipv6_cidr_block_association_id)
        if ipv6_native is not None:
            pulumi.set(__self__, "ipv6_native", ipv6_native)
        if map_customer_owned_ip_on_launch is not None:
            pulumi.set(__self__, "map_customer_owned_ip_on_launch", map_customer_owned_ip_on_launch)
        if map_public_ip_on_launch is not None:
            pulumi.set(__self__, "map_public_ip_on_launch", map_public_ip_on_launch)
        if outpost_arn is not None:
            pulumi.set(__self__, "outpost_arn", outpost_arn)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if private_dns_hostname_type_on_launch is not None:
            pulumi.set(__self__, "private_dns_hostname_type_on_launch", private_dns_hostname_type_on_launch)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="assignIpv6AddressOnCreation")
    def assign_ipv6_address_on_creation(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "assign_ipv6_address_on_creation")

    @assign_ipv6_address_on_creation.setter
    def assign_ipv6_address_on_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "assign_ipv6_address_on_creation", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        is required
        * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
        * The default value for `map_public_ip_on_launch` is `true`

        This resource supports the following additional arguments:
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AZ ID of the subnet
        """
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone_id", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 CIDR block assigned to the subnet
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @customer_owned_ipv4_pool.setter
    def customer_owned_ipv4_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_owned_ipv4_pool", value)

    @property
    @pulumi.getter(name="enableDns64")
    def enable_dns64(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_dns64")

    @enable_dns64.setter
    def enable_dns64(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dns64", value)

    @property
    @pulumi.getter(name="enableLniAtDeviceIndex")
    def enable_lni_at_device_index(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "enable_lni_at_device_index")

    @enable_lni_at_device_index.setter
    def enable_lni_at_device_index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enable_lni_at_device_index", value)

    @property
    @pulumi.getter(name="enableResourceNameDnsARecordOnLaunch")
    def enable_resource_name_dns_a_record_on_launch(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_resource_name_dns_a_record_on_launch")

    @enable_resource_name_dns_a_record_on_launch.setter
    def enable_resource_name_dns_a_record_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_resource_name_dns_a_record_on_launch", value)

    @property
    @pulumi.getter(name="enableResourceNameDnsAaaaRecordOnLaunch")
    def enable_resource_name_dns_aaaa_record_on_launch(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_resource_name_dns_aaaa_record_on_launch")

    @enable_resource_name_dns_aaaa_record_on_launch.setter
    def enable_resource_name_dns_aaaa_record_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_resource_name_dns_aaaa_record_on_launch", value)

    @property
    @pulumi.getter(name="existingDefaultSubnet")
    def existing_default_subnet(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "existing_default_subnet")

    @existing_default_subnet.setter
    def existing_default_subnet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "existing_default_subnet", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether destroying the resource deletes the default subnet. Default: `false`
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ipv6_cidr_block")

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_cidr_block", value)

    @property
    @pulumi.getter(name="ipv6CidrBlockAssociationId")
    def ipv6_cidr_block_association_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ipv6_cidr_block_association_id")

    @ipv6_cidr_block_association_id.setter
    def ipv6_cidr_block_association_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_cidr_block_association_id", value)

    @property
    @pulumi.getter(name="ipv6Native")
    def ipv6_native(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "ipv6_native")

    @ipv6_native.setter
    def ipv6_native(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_native", value)

    @property
    @pulumi.getter(name="mapCustomerOwnedIpOnLaunch")
    def map_customer_owned_ip_on_launch(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "map_customer_owned_ip_on_launch")

    @map_customer_owned_ip_on_launch.setter
    def map_customer_owned_ip_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "map_customer_owned_ip_on_launch", value)

    @property
    @pulumi.getter(name="mapPublicIpOnLaunch")
    def map_public_ip_on_launch(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "map_public_ip_on_launch")

    @map_public_ip_on_launch.setter
    def map_public_ip_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "map_public_ip_on_launch", value)

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "outpost_arn")

    @outpost_arn.setter
    def outpost_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outpost_arn", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="privateDnsHostnameTypeOnLaunch")
    def private_dns_hostname_type_on_launch(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "private_dns_hostname_type_on_launch")

    @private_dns_hostname_type_on_launch.setter
    def private_dns_hostname_type_on_launch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_dns_hostname_type_on_launch", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC the subnet is in
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class DefaultSubnet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_ipv6_address_on_creation: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[str]] = None,
                 enable_dns64: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_a_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_aaaa_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 ipv6_native: Optional[pulumi.Input[bool]] = None,
                 map_customer_owned_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 map_public_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 private_dns_hostname_type_on_launch: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage a [default subnet](http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/default-vpc.html#default-vpc-basics) in the current region.

        **This is an advanced resource** and has special caveats to be aware of when using it. Please read this document in its entirety before using this resource.

        The `ec2.DefaultSubnet` resource behaves differently from normal resources in that if a default subnet exists in the specified Availability Zone, this provider does not _create_ this resource, but instead "adopts" it into management.
        If no default subnet exists, this provider creates a new default subnet.
        By default, `pulumi destroy` does not delete the default subnet but does remove the resource from the state.
        Set the `force_destroy` argument to `true` to delete the default subnet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        default_az1 = aws.ec2.DefaultSubnet("default_az1",
            availability_zone="us-west-2a",
            tags={
                "Name": "Default subnet for us-west-2a",
            })
        ```

        ## Import

        Using `pulumi import`, import subnets using the subnet `id`. For example:

        ```sh
        $ pulumi import aws:ec2/defaultSubnet:DefaultSubnet public_subnet subnet-9d4a7b6c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: is required
               * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
               * The default value for `map_public_ip_on_launch` is `true`
               
               This resource supports the following additional arguments:
        :param pulumi.Input[bool] force_destroy: Whether destroying the resource deletes the default subnet. Default: `false`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DefaultSubnetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage a [default subnet](http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/default-vpc.html#default-vpc-basics) in the current region.

        **This is an advanced resource** and has special caveats to be aware of when using it. Please read this document in its entirety before using this resource.

        The `ec2.DefaultSubnet` resource behaves differently from normal resources in that if a default subnet exists in the specified Availability Zone, this provider does not _create_ this resource, but instead "adopts" it into management.
        If no default subnet exists, this provider creates a new default subnet.
        By default, `pulumi destroy` does not delete the default subnet but does remove the resource from the state.
        Set the `force_destroy` argument to `true` to delete the default subnet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        default_az1 = aws.ec2.DefaultSubnet("default_az1",
            availability_zone="us-west-2a",
            tags={
                "Name": "Default subnet for us-west-2a",
            })
        ```

        ## Import

        Using `pulumi import`, import subnets using the subnet `id`. For example:

        ```sh
        $ pulumi import aws:ec2/defaultSubnet:DefaultSubnet public_subnet subnet-9d4a7b6c
        ```

        :param str resource_name: The name of the resource.
        :param DefaultSubnetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DefaultSubnetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_ipv6_address_on_creation: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[str]] = None,
                 enable_dns64: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_a_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_aaaa_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 ipv6_native: Optional[pulumi.Input[bool]] = None,
                 map_customer_owned_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 map_public_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 private_dns_hostname_type_on_launch: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DefaultSubnetArgs.__new__(DefaultSubnetArgs)

            __props__.__dict__["assign_ipv6_address_on_creation"] = assign_ipv6_address_on_creation
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["customer_owned_ipv4_pool"] = customer_owned_ipv4_pool
            __props__.__dict__["enable_dns64"] = enable_dns64
            __props__.__dict__["enable_resource_name_dns_a_record_on_launch"] = enable_resource_name_dns_a_record_on_launch
            __props__.__dict__["enable_resource_name_dns_aaaa_record_on_launch"] = enable_resource_name_dns_aaaa_record_on_launch
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["ipv6_cidr_block"] = ipv6_cidr_block
            __props__.__dict__["ipv6_native"] = ipv6_native
            __props__.__dict__["map_customer_owned_ip_on_launch"] = map_customer_owned_ip_on_launch
            __props__.__dict__["map_public_ip_on_launch"] = map_public_ip_on_launch
            __props__.__dict__["private_dns_hostname_type_on_launch"] = private_dns_hostname_type_on_launch
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["availability_zone_id"] = None
            __props__.__dict__["cidr_block"] = None
            __props__.__dict__["enable_lni_at_device_index"] = None
            __props__.__dict__["existing_default_subnet"] = None
            __props__.__dict__["ipv6_cidr_block_association_id"] = None
            __props__.__dict__["outpost_arn"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_id"] = None
        super(DefaultSubnet, __self__).__init__(
            'aws:ec2/defaultSubnet:DefaultSubnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            assign_ipv6_address_on_creation: Optional[pulumi.Input[bool]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            availability_zone_id: Optional[pulumi.Input[str]] = None,
            cidr_block: Optional[pulumi.Input[str]] = None,
            customer_owned_ipv4_pool: Optional[pulumi.Input[str]] = None,
            enable_dns64: Optional[pulumi.Input[bool]] = None,
            enable_lni_at_device_index: Optional[pulumi.Input[int]] = None,
            enable_resource_name_dns_a_record_on_launch: Optional[pulumi.Input[bool]] = None,
            enable_resource_name_dns_aaaa_record_on_launch: Optional[pulumi.Input[bool]] = None,
            existing_default_subnet: Optional[pulumi.Input[bool]] = None,
            force_destroy: Optional[pulumi.Input[bool]] = None,
            ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
            ipv6_cidr_block_association_id: Optional[pulumi.Input[str]] = None,
            ipv6_native: Optional[pulumi.Input[bool]] = None,
            map_customer_owned_ip_on_launch: Optional[pulumi.Input[bool]] = None,
            map_public_ip_on_launch: Optional[pulumi.Input[bool]] = None,
            outpost_arn: Optional[pulumi.Input[str]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            private_dns_hostname_type_on_launch: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'DefaultSubnet':
        """
        Get an existing DefaultSubnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: is required
               * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
               * The default value for `map_public_ip_on_launch` is `true`
               
               This resource supports the following additional arguments:
        :param pulumi.Input[str] availability_zone_id: The AZ ID of the subnet
        :param pulumi.Input[str] cidr_block: The IPv4 CIDR block assigned to the subnet
        :param pulumi.Input[bool] force_destroy: Whether destroying the resource deletes the default subnet. Default: `false`
        :param pulumi.Input[str] vpc_id: The ID of the VPC the subnet is in
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DefaultSubnetState.__new__(_DefaultSubnetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["assign_ipv6_address_on_creation"] = assign_ipv6_address_on_creation
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["availability_zone_id"] = availability_zone_id
        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["customer_owned_ipv4_pool"] = customer_owned_ipv4_pool
        __props__.__dict__["enable_dns64"] = enable_dns64
        __props__.__dict__["enable_lni_at_device_index"] = enable_lni_at_device_index
        __props__.__dict__["enable_resource_name_dns_a_record_on_launch"] = enable_resource_name_dns_a_record_on_launch
        __props__.__dict__["enable_resource_name_dns_aaaa_record_on_launch"] = enable_resource_name_dns_aaaa_record_on_launch
        __props__.__dict__["existing_default_subnet"] = existing_default_subnet
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["ipv6_cidr_block"] = ipv6_cidr_block
        __props__.__dict__["ipv6_cidr_block_association_id"] = ipv6_cidr_block_association_id
        __props__.__dict__["ipv6_native"] = ipv6_native
        __props__.__dict__["map_customer_owned_ip_on_launch"] = map_customer_owned_ip_on_launch
        __props__.__dict__["map_public_ip_on_launch"] = map_public_ip_on_launch
        __props__.__dict__["outpost_arn"] = outpost_arn
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["private_dns_hostname_type_on_launch"] = private_dns_hostname_type_on_launch
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_id"] = vpc_id
        return DefaultSubnet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="assignIpv6AddressOnCreation")
    def assign_ipv6_address_on_creation(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "assign_ipv6_address_on_creation")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        is required
        * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
        * The default value for `map_public_ip_on_launch` is `true`

        This resource supports the following additional arguments:
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> pulumi.Output[str]:
        """
        The AZ ID of the subnet
        """
        return pulumi.get(self, "availability_zone_id")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[str]:
        """
        The IPv4 CIDR block assigned to the subnet
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @property
    @pulumi.getter(name="enableDns64")
    def enable_dns64(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "enable_dns64")

    @property
    @pulumi.getter(name="enableLniAtDeviceIndex")
    def enable_lni_at_device_index(self) -> pulumi.Output[int]:
        return pulumi.get(self, "enable_lni_at_device_index")

    @property
    @pulumi.getter(name="enableResourceNameDnsARecordOnLaunch")
    def enable_resource_name_dns_a_record_on_launch(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "enable_resource_name_dns_a_record_on_launch")

    @property
    @pulumi.getter(name="enableResourceNameDnsAaaaRecordOnLaunch")
    def enable_resource_name_dns_aaaa_record_on_launch(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "enable_resource_name_dns_aaaa_record_on_launch")

    @property
    @pulumi.getter(name="existingDefaultSubnet")
    def existing_default_subnet(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "existing_default_subnet")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether destroying the resource deletes the default subnet. Default: `false`
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> pulumi.Output[str]:
        return pulumi.get(self, "ipv6_cidr_block")

    @property
    @pulumi.getter(name="ipv6CidrBlockAssociationId")
    def ipv6_cidr_block_association_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "ipv6_cidr_block_association_id")

    @property
    @pulumi.getter(name="ipv6Native")
    def ipv6_native(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "ipv6_native")

    @property
    @pulumi.getter(name="mapCustomerOwnedIpOnLaunch")
    def map_customer_owned_ip_on_launch(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "map_customer_owned_ip_on_launch")

    @property
    @pulumi.getter(name="mapPublicIpOnLaunch")
    def map_public_ip_on_launch(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "map_public_ip_on_launch")

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "outpost_arn")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="privateDnsHostnameTypeOnLaunch")
    def private_dns_hostname_type_on_launch(self) -> pulumi.Output[str]:
        return pulumi.get(self, "private_dns_hostname_type_on_launch")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC the subnet is in
        """
        return pulumi.get(self, "vpc_id")

