# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCustomerGatewayResult',
    'AwaitableGetCustomerGatewayResult',
    'get_customer_gateway',
    'get_customer_gateway_output',
]

@pulumi.output_type
class GetCustomerGatewayResult:
    """
    A collection of values returned by getCustomerGateway.
    """
    def __init__(__self__, arn=None, bgp_asn=None, bgp_asn_extended=None, certificate_arn=None, device_name=None, filters=None, id=None, ip_address=None, tags=None, type=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if bgp_asn and not isinstance(bgp_asn, int):
            raise TypeError("Expected argument 'bgp_asn' to be a int")
        pulumi.set(__self__, "bgp_asn", bgp_asn)
        if bgp_asn_extended and not isinstance(bgp_asn_extended, int):
            raise TypeError("Expected argument 'bgp_asn_extended' to be a int")
        pulumi.set(__self__, "bgp_asn_extended", bgp_asn_extended)
        if certificate_arn and not isinstance(certificate_arn, str):
            raise TypeError("Expected argument 'certificate_arn' to be a str")
        pulumi.set(__self__, "certificate_arn", certificate_arn)
        if device_name and not isinstance(device_name, str):
            raise TypeError("Expected argument 'device_name' to be a str")
        pulumi.set(__self__, "device_name", device_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the customer gateway.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="bgpAsn")
    def bgp_asn(self) -> int:
        """
        Gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
        """
        return pulumi.get(self, "bgp_asn")

    @property
    @pulumi.getter(name="bgpAsnExtended")
    def bgp_asn_extended(self) -> int:
        """
        Gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
        """
        return pulumi.get(self, "bgp_asn_extended")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> str:
        """
        ARN for the customer gateway certificate.
        """
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        Name for the customer gateway device.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCustomerGatewayFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        IP address of the gateway's Internet-routable external interface.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Map of key-value pairs assigned to the gateway.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of customer gateway. The only type AWS supports at this time is "ipsec.1".
        """
        return pulumi.get(self, "type")


class AwaitableGetCustomerGatewayResult(GetCustomerGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomerGatewayResult(
            arn=self.arn,
            bgp_asn=self.bgp_asn,
            bgp_asn_extended=self.bgp_asn_extended,
            certificate_arn=self.certificate_arn,
            device_name=self.device_name,
            filters=self.filters,
            id=self.id,
            ip_address=self.ip_address,
            tags=self.tags,
            type=self.type)


def get_customer_gateway(filters: Optional[Sequence[Union['GetCustomerGatewayFilterArgs', 'GetCustomerGatewayFilterArgsDict']]] = None,
                         id: Optional[str] = None,
                         tags: Optional[Mapping[str, str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomerGatewayResult:
    """
    Get an existing AWS Customer Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    foo = aws.ec2.get_customer_gateway(filters=[{
        "name": "tag:Name",
        "values": ["foo-prod"],
    }])
    main = aws.ec2.VpnGateway("main",
        vpc_id=main_aws_vpc["id"],
        amazon_side_asn="7224")
    transit = aws.ec2.VpnConnection("transit",
        vpn_gateway_id=main.id,
        customer_gateway_id=foo.id,
        type=foo.type,
        static_routes_only=False)
    ```


    :param Sequence[Union['GetCustomerGatewayFilterArgs', 'GetCustomerGatewayFilterArgsDict']] filters: One or more [name-value pairs][dcg-filters] to filter by.
           
           [dcg-filters]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
    :param str id: ID of the gateway.
    :param Mapping[str, str] tags: Map of key-value pairs assigned to the gateway.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getCustomerGateway:getCustomerGateway', __args__, opts=opts, typ=GetCustomerGatewayResult).value

    return AwaitableGetCustomerGatewayResult(
        arn=pulumi.get(__ret__, 'arn'),
        bgp_asn=pulumi.get(__ret__, 'bgp_asn'),
        bgp_asn_extended=pulumi.get(__ret__, 'bgp_asn_extended'),
        certificate_arn=pulumi.get(__ret__, 'certificate_arn'),
        device_name=pulumi.get(__ret__, 'device_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_customer_gateway_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCustomerGatewayFilterArgs', 'GetCustomerGatewayFilterArgsDict']]]]] = None,
                                id: Optional[pulumi.Input[Optional[str]]] = None,
                                tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomerGatewayResult]:
    """
    Get an existing AWS Customer Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    foo = aws.ec2.get_customer_gateway(filters=[{
        "name": "tag:Name",
        "values": ["foo-prod"],
    }])
    main = aws.ec2.VpnGateway("main",
        vpc_id=main_aws_vpc["id"],
        amazon_side_asn="7224")
    transit = aws.ec2.VpnConnection("transit",
        vpn_gateway_id=main.id,
        customer_gateway_id=foo.id,
        type=foo.type,
        static_routes_only=False)
    ```


    :param Sequence[Union['GetCustomerGatewayFilterArgs', 'GetCustomerGatewayFilterArgsDict']] filters: One or more [name-value pairs][dcg-filters] to filter by.
           
           [dcg-filters]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
    :param str id: ID of the gateway.
    :param Mapping[str, str] tags: Map of key-value pairs assigned to the gateway.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getCustomerGateway:getCustomerGateway', __args__, opts=opts, typ=GetCustomerGatewayResult)
    return __ret__.apply(lambda __response__: GetCustomerGatewayResult(
        arn=pulumi.get(__response__, 'arn'),
        bgp_asn=pulumi.get(__response__, 'bgp_asn'),
        bgp_asn_extended=pulumi.get(__response__, 'bgp_asn_extended'),
        certificate_arn=pulumi.get(__response__, 'certificate_arn'),
        device_name=pulumi.get(__response__, 'device_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ip_address=pulumi.get(__response__, 'ip_address'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
