# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetIpamPreviewNextCidrResult',
    'AwaitableGetIpamPreviewNextCidrResult',
    'get_ipam_preview_next_cidr',
    'get_ipam_preview_next_cidr_output',
]

@pulumi.output_type
class GetIpamPreviewNextCidrResult:
    """
    A collection of values returned by getIpamPreviewNextCidr.
    """
    def __init__(__self__, cidr=None, disallowed_cidrs=None, id=None, ipam_pool_id=None, netmask_length=None):
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if disallowed_cidrs and not isinstance(disallowed_cidrs, list):
            raise TypeError("Expected argument 'disallowed_cidrs' to be a list")
        pulumi.set(__self__, "disallowed_cidrs", disallowed_cidrs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipam_pool_id and not isinstance(ipam_pool_id, str):
            raise TypeError("Expected argument 'ipam_pool_id' to be a str")
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if netmask_length and not isinstance(netmask_length, int):
            raise TypeError("Expected argument 'netmask_length' to be a int")
        pulumi.set(__self__, "netmask_length", netmask_length)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        Previewed CIDR from the pool.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="disallowedCidrs")
    def disallowed_cidrs(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "disallowed_cidrs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> str:
        return pulumi.get(self, "ipam_pool_id")

    @property
    @pulumi.getter(name="netmaskLength")
    def netmask_length(self) -> Optional[int]:
        return pulumi.get(self, "netmask_length")


class AwaitableGetIpamPreviewNextCidrResult(GetIpamPreviewNextCidrResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpamPreviewNextCidrResult(
            cidr=self.cidr,
            disallowed_cidrs=self.disallowed_cidrs,
            id=self.id,
            ipam_pool_id=self.ipam_pool_id,
            netmask_length=self.netmask_length)


def get_ipam_preview_next_cidr(disallowed_cidrs: Optional[Sequence[str]] = None,
                               ipam_pool_id: Optional[str] = None,
                               netmask_length: Optional[int] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpamPreviewNextCidrResult:
    """
    Previews a CIDR from an IPAM address pool. Only works for private IPv4.

    > **NOTE:** This functionality is also encapsulated in a resource sharing the same name. The data source can be used when you need to use the cidr in a calculation of the same Root module, `count` for example. However, once a cidr range has been allocated that was previewed, the next refresh will find a **new** cidr and may force new resources downstream. Make sure to use `ignore_changes` if this is undesirable.

    ## Example Usage

    Basic usage:

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ec2.get_ipam_preview_next_cidr(ipam_pool_id=test_aws_vpc_ipam_pool["id"],
        netmask_length=28)
    test_vpc_ipam_pool_cidr_allocation = aws.ec2.VpcIpamPoolCidrAllocation("test",
        ipam_pool_id=test_aws_vpc_ipam_pool["id"],
        cidr=test.cidr)
    ```


    :param Sequence[str] disallowed_cidrs: Exclude a particular CIDR range from being returned by the pool.
    :param str ipam_pool_id: ID of the pool to which you want to assign a CIDR.
    :param int netmask_length: Netmask length of the CIDR you would like to preview from the IPAM pool.
    """
    __args__ = dict()
    __args__['disallowedCidrs'] = disallowed_cidrs
    __args__['ipamPoolId'] = ipam_pool_id
    __args__['netmaskLength'] = netmask_length
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getIpamPreviewNextCidr:getIpamPreviewNextCidr', __args__, opts=opts, typ=GetIpamPreviewNextCidrResult).value

    return AwaitableGetIpamPreviewNextCidrResult(
        cidr=pulumi.get(__ret__, 'cidr'),
        disallowed_cidrs=pulumi.get(__ret__, 'disallowed_cidrs'),
        id=pulumi.get(__ret__, 'id'),
        ipam_pool_id=pulumi.get(__ret__, 'ipam_pool_id'),
        netmask_length=pulumi.get(__ret__, 'netmask_length'))
def get_ipam_preview_next_cidr_output(disallowed_cidrs: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                      ipam_pool_id: Optional[pulumi.Input[str]] = None,
                                      netmask_length: Optional[pulumi.Input[Optional[int]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpamPreviewNextCidrResult]:
    """
    Previews a CIDR from an IPAM address pool. Only works for private IPv4.

    > **NOTE:** This functionality is also encapsulated in a resource sharing the same name. The data source can be used when you need to use the cidr in a calculation of the same Root module, `count` for example. However, once a cidr range has been allocated that was previewed, the next refresh will find a **new** cidr and may force new resources downstream. Make sure to use `ignore_changes` if this is undesirable.

    ## Example Usage

    Basic usage:

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ec2.get_ipam_preview_next_cidr(ipam_pool_id=test_aws_vpc_ipam_pool["id"],
        netmask_length=28)
    test_vpc_ipam_pool_cidr_allocation = aws.ec2.VpcIpamPoolCidrAllocation("test",
        ipam_pool_id=test_aws_vpc_ipam_pool["id"],
        cidr=test.cidr)
    ```


    :param Sequence[str] disallowed_cidrs: Exclude a particular CIDR range from being returned by the pool.
    :param str ipam_pool_id: ID of the pool to which you want to assign a CIDR.
    :param int netmask_length: Netmask length of the CIDR you would like to preview from the IPAM pool.
    """
    __args__ = dict()
    __args__['disallowedCidrs'] = disallowed_cidrs
    __args__['ipamPoolId'] = ipam_pool_id
    __args__['netmaskLength'] = netmask_length
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getIpamPreviewNextCidr:getIpamPreviewNextCidr', __args__, opts=opts, typ=GetIpamPreviewNextCidrResult)
    return __ret__.apply(lambda __response__: GetIpamPreviewNextCidrResult(
        cidr=pulumi.get(__response__, 'cidr'),
        disallowed_cidrs=pulumi.get(__response__, 'disallowed_cidrs'),
        id=pulumi.get(__response__, 'id'),
        ipam_pool_id=pulumi.get(__response__, 'ipam_pool_id'),
        netmask_length=pulumi.get(__response__, 'netmask_length')))
