# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSpotDatafeedSubscriptionResult',
    'AwaitableGetSpotDatafeedSubscriptionResult',
    'get_spot_datafeed_subscription',
    'get_spot_datafeed_subscription_output',
]

@pulumi.output_type
class GetSpotDatafeedSubscriptionResult:
    """
    A collection of values returned by getSpotDatafeedSubscription.
    """
    def __init__(__self__, bucket=None, id=None, prefix=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the Amazon S3 bucket where the spot instance data feed is located.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        The prefix for the data feed files.
        """
        return pulumi.get(self, "prefix")


class AwaitableGetSpotDatafeedSubscriptionResult(GetSpotDatafeedSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSpotDatafeedSubscriptionResult(
            bucket=self.bucket,
            id=self.id,
            prefix=self.prefix)


def get_spot_datafeed_subscription(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSpotDatafeedSubscriptionResult:
    """
    > There is only a single spot data feed subscription per account.

    Data source for accessing an AWS EC2 (Elastic Compute Cloud) spot data feed subscription.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    default = aws.ec2.get_spot_datafeed_subscription()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getSpotDatafeedSubscription:getSpotDatafeedSubscription', __args__, opts=opts, typ=GetSpotDatafeedSubscriptionResult).value

    return AwaitableGetSpotDatafeedSubscriptionResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        id=pulumi.get(__ret__, 'id'),
        prefix=pulumi.get(__ret__, 'prefix'))
def get_spot_datafeed_subscription_output(opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSpotDatafeedSubscriptionResult]:
    """
    > There is only a single spot data feed subscription per account.

    Data source for accessing an AWS EC2 (Elastic Compute Cloud) spot data feed subscription.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    default = aws.ec2.get_spot_datafeed_subscription()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getSpotDatafeedSubscription:getSpotDatafeedSubscription', __args__, opts=opts, typ=GetSpotDatafeedSubscriptionResult)
    return __ret__.apply(lambda __response__: GetSpotDatafeedSubscriptionResult(
        bucket=pulumi.get(__response__, 'bucket'),
        id=pulumi.get(__response__, 'id'),
        prefix=pulumi.get(__response__, 'prefix')))
