# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpcIpamPoolResult',
    'AwaitableGetVpcIpamPoolResult',
    'get_vpc_ipam_pool',
    'get_vpc_ipam_pool_output',
]

@pulumi.output_type
class GetVpcIpamPoolResult:
    """
    A collection of values returned by getVpcIpamPool.
    """
    def __init__(__self__, address_family=None, allocation_default_netmask_length=None, allocation_max_netmask_length=None, allocation_min_netmask_length=None, allocation_resource_tags=None, arn=None, auto_import=None, aws_service=None, description=None, filters=None, id=None, ipam_pool_id=None, ipam_scope_id=None, ipam_scope_type=None, locale=None, pool_depth=None, publicly_advertisable=None, source_ipam_pool_id=None, state=None, tags=None):
        if address_family and not isinstance(address_family, str):
            raise TypeError("Expected argument 'address_family' to be a str")
        pulumi.set(__self__, "address_family", address_family)
        if allocation_default_netmask_length and not isinstance(allocation_default_netmask_length, int):
            raise TypeError("Expected argument 'allocation_default_netmask_length' to be a int")
        pulumi.set(__self__, "allocation_default_netmask_length", allocation_default_netmask_length)
        if allocation_max_netmask_length and not isinstance(allocation_max_netmask_length, int):
            raise TypeError("Expected argument 'allocation_max_netmask_length' to be a int")
        pulumi.set(__self__, "allocation_max_netmask_length", allocation_max_netmask_length)
        if allocation_min_netmask_length and not isinstance(allocation_min_netmask_length, int):
            raise TypeError("Expected argument 'allocation_min_netmask_length' to be a int")
        pulumi.set(__self__, "allocation_min_netmask_length", allocation_min_netmask_length)
        if allocation_resource_tags and not isinstance(allocation_resource_tags, dict):
            raise TypeError("Expected argument 'allocation_resource_tags' to be a dict")
        pulumi.set(__self__, "allocation_resource_tags", allocation_resource_tags)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auto_import and not isinstance(auto_import, bool):
            raise TypeError("Expected argument 'auto_import' to be a bool")
        pulumi.set(__self__, "auto_import", auto_import)
        if aws_service and not isinstance(aws_service, str):
            raise TypeError("Expected argument 'aws_service' to be a str")
        pulumi.set(__self__, "aws_service", aws_service)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipam_pool_id and not isinstance(ipam_pool_id, str):
            raise TypeError("Expected argument 'ipam_pool_id' to be a str")
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if ipam_scope_id and not isinstance(ipam_scope_id, str):
            raise TypeError("Expected argument 'ipam_scope_id' to be a str")
        pulumi.set(__self__, "ipam_scope_id", ipam_scope_id)
        if ipam_scope_type and not isinstance(ipam_scope_type, str):
            raise TypeError("Expected argument 'ipam_scope_type' to be a str")
        pulumi.set(__self__, "ipam_scope_type", ipam_scope_type)
        if locale and not isinstance(locale, str):
            raise TypeError("Expected argument 'locale' to be a str")
        pulumi.set(__self__, "locale", locale)
        if pool_depth and not isinstance(pool_depth, int):
            raise TypeError("Expected argument 'pool_depth' to be a int")
        pulumi.set(__self__, "pool_depth", pool_depth)
        if publicly_advertisable and not isinstance(publicly_advertisable, bool):
            raise TypeError("Expected argument 'publicly_advertisable' to be a bool")
        pulumi.set(__self__, "publicly_advertisable", publicly_advertisable)
        if source_ipam_pool_id and not isinstance(source_ipam_pool_id, str):
            raise TypeError("Expected argument 'source_ipam_pool_id' to be a str")
        pulumi.set(__self__, "source_ipam_pool_id", source_ipam_pool_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> str:
        """
        IP protocol assigned to this pool.
        """
        return pulumi.get(self, "address_family")

    @property
    @pulumi.getter(name="allocationDefaultNetmaskLength")
    def allocation_default_netmask_length(self) -> int:
        """
        A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is `10.0.0.0/8` and you enter 16 here, new allocations will default to `10.0.0.0/16`.
        """
        return pulumi.get(self, "allocation_default_netmask_length")

    @property
    @pulumi.getter(name="allocationMaxNetmaskLength")
    def allocation_max_netmask_length(self) -> int:
        """
        The maximum netmask length that will be required for CIDR allocations in this pool.
        """
        return pulumi.get(self, "allocation_max_netmask_length")

    @property
    @pulumi.getter(name="allocationMinNetmaskLength")
    def allocation_min_netmask_length(self) -> int:
        """
        The minimum netmask length that will be required for CIDR allocations in this pool.
        """
        return pulumi.get(self, "allocation_min_netmask_length")

    @property
    @pulumi.getter(name="allocationResourceTags")
    def allocation_resource_tags(self) -> Mapping[str, str]:
        """
        Tags that are required to create resources in using this pool.
        """
        return pulumi.get(self, "allocation_resource_tags")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the pool
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoImport")
    def auto_import(self) -> bool:
        """
        If enabled, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM.
        """
        return pulumi.get(self, "auto_import")

    @property
    @pulumi.getter(name="awsService")
    def aws_service(self) -> str:
        """
        Limits which service in AWS that the pool can be used in. `ec2` for example, allows users to use space for Elastic IP addresses and VPCs.
        """
        return pulumi.get(self, "aws_service")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for the IPAM pool.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVpcIpamPoolFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the IPAM pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> Optional[str]:
        return pulumi.get(self, "ipam_pool_id")

    @property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> str:
        """
        ID of the scope the pool belongs to.
        """
        return pulumi.get(self, "ipam_scope_id")

    @property
    @pulumi.getter(name="ipamScopeType")
    def ipam_scope_type(self) -> str:
        return pulumi.get(self, "ipam_scope_type")

    @property
    @pulumi.getter
    def locale(self) -> str:
        """
        Locale is the Region where your pool is available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region.
        """
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter(name="poolDepth")
    def pool_depth(self) -> int:
        return pulumi.get(self, "pool_depth")

    @property
    @pulumi.getter(name="publiclyAdvertisable")
    def publicly_advertisable(self) -> bool:
        """
        Defines whether or not IPv6 pool space is publicly advertisable over the internet.
        """
        return pulumi.get(self, "publicly_advertisable")

    @property
    @pulumi.getter(name="sourceIpamPoolId")
    def source_ipam_pool_id(self) -> str:
        """
        ID of the source IPAM pool.
        """
        return pulumi.get(self, "source_ipam_pool_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Map of tags to assigned to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetVpcIpamPoolResult(GetVpcIpamPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcIpamPoolResult(
            address_family=self.address_family,
            allocation_default_netmask_length=self.allocation_default_netmask_length,
            allocation_max_netmask_length=self.allocation_max_netmask_length,
            allocation_min_netmask_length=self.allocation_min_netmask_length,
            allocation_resource_tags=self.allocation_resource_tags,
            arn=self.arn,
            auto_import=self.auto_import,
            aws_service=self.aws_service,
            description=self.description,
            filters=self.filters,
            id=self.id,
            ipam_pool_id=self.ipam_pool_id,
            ipam_scope_id=self.ipam_scope_id,
            ipam_scope_type=self.ipam_scope_type,
            locale=self.locale,
            pool_depth=self.pool_depth,
            publicly_advertisable=self.publicly_advertisable,
            source_ipam_pool_id=self.source_ipam_pool_id,
            state=self.state,
            tags=self.tags)


def get_vpc_ipam_pool(allocation_resource_tags: Optional[Mapping[str, str]] = None,
                      filters: Optional[Sequence[Union['GetVpcIpamPoolFilterArgs', 'GetVpcIpamPoolFilterArgsDict']]] = None,
                      id: Optional[str] = None,
                      ipam_pool_id: Optional[str] = None,
                      tags: Optional[Mapping[str, str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcIpamPoolResult:
    """
    `ec2.VpcIpamPool` provides details about an IPAM pool.

    This resource can prove useful when an ipam pool was created in another root
    module and you need the pool's id as an input variable. For example, pools
    can be shared via RAM and used to create vpcs with CIDRs from that pool.

    ## Example Usage

    The following example shows an account that has only 1 pool, perhaps shared
    via RAM, and using that pool id to create a VPC with a CIDR derived from
    AWS IPAM.

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ec2.get_vpc_ipam_pool(filters=[
        {
            "name": "description",
            "values": ["*test*"],
        },
        {
            "name": "address-family",
            "values": ["ipv4"],
        },
    ])
    test_vpc = aws.ec2.Vpc("test",
        ipv4_ipam_pool_id=test.id,
        ipv4_netmask_length=28)
    ```


    :param Mapping[str, str] allocation_resource_tags: Tags that are required to create resources in using this pool.
    :param Sequence[Union['GetVpcIpamPoolFilterArgs', 'GetVpcIpamPoolFilterArgsDict']] filters: Custom filter block as described below.
    :param str id: ID of the IPAM pool.
    :param str ipam_pool_id: ID of the IPAM pool you would like information on.
    :param Mapping[str, str] tags: Map of tags to assigned to the resource.
    """
    __args__ = dict()
    __args__['allocationResourceTags'] = allocation_resource_tags
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['ipamPoolId'] = ipam_pool_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getVpcIpamPool:getVpcIpamPool', __args__, opts=opts, typ=GetVpcIpamPoolResult).value

    return AwaitableGetVpcIpamPoolResult(
        address_family=pulumi.get(__ret__, 'address_family'),
        allocation_default_netmask_length=pulumi.get(__ret__, 'allocation_default_netmask_length'),
        allocation_max_netmask_length=pulumi.get(__ret__, 'allocation_max_netmask_length'),
        allocation_min_netmask_length=pulumi.get(__ret__, 'allocation_min_netmask_length'),
        allocation_resource_tags=pulumi.get(__ret__, 'allocation_resource_tags'),
        arn=pulumi.get(__ret__, 'arn'),
        auto_import=pulumi.get(__ret__, 'auto_import'),
        aws_service=pulumi.get(__ret__, 'aws_service'),
        description=pulumi.get(__ret__, 'description'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ipam_pool_id=pulumi.get(__ret__, 'ipam_pool_id'),
        ipam_scope_id=pulumi.get(__ret__, 'ipam_scope_id'),
        ipam_scope_type=pulumi.get(__ret__, 'ipam_scope_type'),
        locale=pulumi.get(__ret__, 'locale'),
        pool_depth=pulumi.get(__ret__, 'pool_depth'),
        publicly_advertisable=pulumi.get(__ret__, 'publicly_advertisable'),
        source_ipam_pool_id=pulumi.get(__ret__, 'source_ipam_pool_id'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'))
def get_vpc_ipam_pool_output(allocation_resource_tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcIpamPoolFilterArgs', 'GetVpcIpamPoolFilterArgsDict']]]]] = None,
                             id: Optional[pulumi.Input[Optional[str]]] = None,
                             ipam_pool_id: Optional[pulumi.Input[Optional[str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVpcIpamPoolResult]:
    """
    `ec2.VpcIpamPool` provides details about an IPAM pool.

    This resource can prove useful when an ipam pool was created in another root
    module and you need the pool's id as an input variable. For example, pools
    can be shared via RAM and used to create vpcs with CIDRs from that pool.

    ## Example Usage

    The following example shows an account that has only 1 pool, perhaps shared
    via RAM, and using that pool id to create a VPC with a CIDR derived from
    AWS IPAM.

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ec2.get_vpc_ipam_pool(filters=[
        {
            "name": "description",
            "values": ["*test*"],
        },
        {
            "name": "address-family",
            "values": ["ipv4"],
        },
    ])
    test_vpc = aws.ec2.Vpc("test",
        ipv4_ipam_pool_id=test.id,
        ipv4_netmask_length=28)
    ```


    :param Mapping[str, str] allocation_resource_tags: Tags that are required to create resources in using this pool.
    :param Sequence[Union['GetVpcIpamPoolFilterArgs', 'GetVpcIpamPoolFilterArgsDict']] filters: Custom filter block as described below.
    :param str id: ID of the IPAM pool.
    :param str ipam_pool_id: ID of the IPAM pool you would like information on.
    :param Mapping[str, str] tags: Map of tags to assigned to the resource.
    """
    __args__ = dict()
    __args__['allocationResourceTags'] = allocation_resource_tags
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['ipamPoolId'] = ipam_pool_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getVpcIpamPool:getVpcIpamPool', __args__, opts=opts, typ=GetVpcIpamPoolResult)
    return __ret__.apply(lambda __response__: GetVpcIpamPoolResult(
        address_family=pulumi.get(__response__, 'address_family'),
        allocation_default_netmask_length=pulumi.get(__response__, 'allocation_default_netmask_length'),
        allocation_max_netmask_length=pulumi.get(__response__, 'allocation_max_netmask_length'),
        allocation_min_netmask_length=pulumi.get(__response__, 'allocation_min_netmask_length'),
        allocation_resource_tags=pulumi.get(__response__, 'allocation_resource_tags'),
        arn=pulumi.get(__response__, 'arn'),
        auto_import=pulumi.get(__response__, 'auto_import'),
        aws_service=pulumi.get(__response__, 'aws_service'),
        description=pulumi.get(__response__, 'description'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ipam_pool_id=pulumi.get(__response__, 'ipam_pool_id'),
        ipam_scope_id=pulumi.get(__response__, 'ipam_scope_id'),
        ipam_scope_type=pulumi.get(__response__, 'ipam_scope_type'),
        locale=pulumi.get(__response__, 'locale'),
        pool_depth=pulumi.get(__response__, 'pool_depth'),
        publicly_advertisable=pulumi.get(__response__, 'publicly_advertisable'),
        source_ipam_pool_id=pulumi.get(__response__, 'source_ipam_pool_id'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags')))
