# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPeeringAttachmentsResult',
    'AwaitableGetPeeringAttachmentsResult',
    'get_peering_attachments',
    'get_peering_attachments_output',
]

@pulumi.output_type
class GetPeeringAttachmentsResult:
    """
    A collection of values returned by getPeeringAttachments.
    """
    def __init__(__self__, filters=None, id=None, ids=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPeeringAttachmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list of all attachments ids matching the filter. You can retrieve more information about the attachment using the [ec2transitgateway.PeeringAttachment][2] data source, searching by identifier.
        """
        return pulumi.get(self, "ids")


class AwaitableGetPeeringAttachmentsResult(GetPeeringAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPeeringAttachmentsResult(
            filters=self.filters,
            id=self.id,
            ids=self.ids)


def get_peering_attachments(filters: Optional[Sequence[Union['GetPeeringAttachmentsFilterArgs', 'GetPeeringAttachmentsFilterArgsDict']]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPeeringAttachmentsResult:
    """
    Get information on EC2 Transit Gateway Peering Attachments.

    ## Example Usage

    ### All Resources

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ec2transitgateway.get_peering_attachments()
    ```

    ### By Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    filtered = aws.ec2transitgateway.get_peering_attachments(filters=[{
        "name": "state",
        "values": ["pendingAcceptance"],
    }])
    unit = [aws.ec2transitgateway.get_peering_attachment(id=filtered.ids[__index]) for __index in range(len(filtered.ids))]
    ```


    :param Sequence[Union['GetPeeringAttachmentsFilterArgs', 'GetPeeringAttachmentsFilterArgsDict']] filters: One or more configuration blocks containing name-values filters. Detailed below.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2transitgateway/getPeeringAttachments:getPeeringAttachments', __args__, opts=opts, typ=GetPeeringAttachmentsResult).value

    return AwaitableGetPeeringAttachmentsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'))
def get_peering_attachments_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPeeringAttachmentsFilterArgs', 'GetPeeringAttachmentsFilterArgsDict']]]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPeeringAttachmentsResult]:
    """
    Get information on EC2 Transit Gateway Peering Attachments.

    ## Example Usage

    ### All Resources

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ec2transitgateway.get_peering_attachments()
    ```

    ### By Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    filtered = aws.ec2transitgateway.get_peering_attachments(filters=[{
        "name": "state",
        "values": ["pendingAcceptance"],
    }])
    unit = [aws.ec2transitgateway.get_peering_attachment(id=filtered.ids[__index]) for __index in range(len(filtered.ids))]
    ```


    :param Sequence[Union['GetPeeringAttachmentsFilterArgs', 'GetPeeringAttachmentsFilterArgsDict']] filters: One or more configuration blocks containing name-values filters. Detailed below.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2transitgateway/getPeeringAttachments:getPeeringAttachments', __args__, opts=opts, typ=GetPeeringAttachmentsResult)
    return __ret__.apply(lambda __response__: GetPeeringAttachmentsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids')))
