# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPullThroughCacheRuleResult',
    'AwaitableGetPullThroughCacheRuleResult',
    'get_pull_through_cache_rule',
    'get_pull_through_cache_rule_output',
]

@pulumi.output_type
class GetPullThroughCacheRuleResult:
    """
    A collection of values returned by getPullThroughCacheRule.
    """
    def __init__(__self__, credential_arn=None, ecr_repository_prefix=None, id=None, registry_id=None, upstream_registry_url=None):
        if credential_arn and not isinstance(credential_arn, str):
            raise TypeError("Expected argument 'credential_arn' to be a str")
        pulumi.set(__self__, "credential_arn", credential_arn)
        if ecr_repository_prefix and not isinstance(ecr_repository_prefix, str):
            raise TypeError("Expected argument 'ecr_repository_prefix' to be a str")
        pulumi.set(__self__, "ecr_repository_prefix", ecr_repository_prefix)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if upstream_registry_url and not isinstance(upstream_registry_url, str):
            raise TypeError("Expected argument 'upstream_registry_url' to be a str")
        pulumi.set(__self__, "upstream_registry_url", upstream_registry_url)

    @property
    @pulumi.getter(name="credentialArn")
    def credential_arn(self) -> str:
        """
        ARN of the Secret which will be used to authenticate against the registry.
        """
        return pulumi.get(self, "credential_arn")

    @property
    @pulumi.getter(name="ecrRepositoryPrefix")
    def ecr_repository_prefix(self) -> str:
        return pulumi.get(self, "ecr_repository_prefix")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> str:
        """
        The registry ID where the repository was created.
        """
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter(name="upstreamRegistryUrl")
    def upstream_registry_url(self) -> str:
        """
        The registry URL of the upstream public registry to use as the source.
        """
        return pulumi.get(self, "upstream_registry_url")


class AwaitableGetPullThroughCacheRuleResult(GetPullThroughCacheRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPullThroughCacheRuleResult(
            credential_arn=self.credential_arn,
            ecr_repository_prefix=self.ecr_repository_prefix,
            id=self.id,
            registry_id=self.registry_id,
            upstream_registry_url=self.upstream_registry_url)


def get_pull_through_cache_rule(ecr_repository_prefix: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPullThroughCacheRuleResult:
    """
    The ECR Pull Through Cache Rule data source allows the upstream registry URL and registry ID to be retrieved for a Pull Through Cache Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    ecr_public = aws.ecr.get_pull_through_cache_rule(ecr_repository_prefix="ecr-public")
    ```


    :param str ecr_repository_prefix: The repository name prefix to use when caching images from the source registry.
    """
    __args__ = dict()
    __args__['ecrRepositoryPrefix'] = ecr_repository_prefix
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ecr/getPullThroughCacheRule:getPullThroughCacheRule', __args__, opts=opts, typ=GetPullThroughCacheRuleResult).value

    return AwaitableGetPullThroughCacheRuleResult(
        credential_arn=pulumi.get(__ret__, 'credential_arn'),
        ecr_repository_prefix=pulumi.get(__ret__, 'ecr_repository_prefix'),
        id=pulumi.get(__ret__, 'id'),
        registry_id=pulumi.get(__ret__, 'registry_id'),
        upstream_registry_url=pulumi.get(__ret__, 'upstream_registry_url'))
def get_pull_through_cache_rule_output(ecr_repository_prefix: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPullThroughCacheRuleResult]:
    """
    The ECR Pull Through Cache Rule data source allows the upstream registry URL and registry ID to be retrieved for a Pull Through Cache Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    ecr_public = aws.ecr.get_pull_through_cache_rule(ecr_repository_prefix="ecr-public")
    ```


    :param str ecr_repository_prefix: The repository name prefix to use when caching images from the source registry.
    """
    __args__ = dict()
    __args__['ecrRepositoryPrefix'] = ecr_repository_prefix
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ecr/getPullThroughCacheRule:getPullThroughCacheRule', __args__, opts=opts, typ=GetPullThroughCacheRuleResult)
    return __ret__.apply(lambda __response__: GetPullThroughCacheRuleResult(
        credential_arn=pulumi.get(__response__, 'credential_arn'),
        ecr_repository_prefix=pulumi.get(__response__, 'ecr_repository_prefix'),
        id=pulumi.get(__response__, 'id'),
        registry_id=pulumi.get(__response__, 'registry_id'),
        upstream_registry_url=pulumi.get(__response__, 'upstream_registry_url')))
