# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'JobTemplateJobTemplateData',
    'JobTemplateJobTemplateDataConfigurationOverrides',
    'JobTemplateJobTemplateDataConfigurationOverridesApplicationConfiguration',
    'JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfiguration',
    'JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfiguration',
    'JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfiguration',
    'JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfiguration',
    'JobTemplateJobTemplateDataJobDriver',
    'JobTemplateJobTemplateDataJobDriverSparkSqlJobDriver',
    'JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriver',
    'VirtualClusterContainerProvider',
    'VirtualClusterContainerProviderInfo',
    'VirtualClusterContainerProviderInfoEksInfo',
    'GetVirtualClusterContainerProviderResult',
    'GetVirtualClusterContainerProviderInfoResult',
    'GetVirtualClusterContainerProviderInfoEksInfoResult',
]

@pulumi.output_type
class JobTemplateJobTemplateData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRoleArn":
            suggest = "execution_role_arn"
        elif key == "jobDriver":
            suggest = "job_driver"
        elif key == "releaseLabel":
            suggest = "release_label"
        elif key == "configurationOverrides":
            suggest = "configuration_overrides"
        elif key == "jobTags":
            suggest = "job_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateJobTemplateData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateJobTemplateData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateJobTemplateData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role_arn: str,
                 job_driver: 'outputs.JobTemplateJobTemplateDataJobDriver',
                 release_label: str,
                 configuration_overrides: Optional['outputs.JobTemplateJobTemplateDataConfigurationOverrides'] = None,
                 job_tags: Optional[Mapping[str, str]] = None):
        """
        :param str execution_role_arn: The execution role ARN of the job run.
        :param 'JobTemplateJobTemplateDataJobDriverArgs' job_driver: Specify the driver that the job runs on. Exactly one of the two available job drivers is required, either sparkSqlJobDriver or sparkSubmitJobDriver.
        :param str release_label: The release version of Amazon EMR.
        :param 'JobTemplateJobTemplateDataConfigurationOverridesArgs' configuration_overrides: The configuration settings that are used to override defaults configuration.
        :param Mapping[str, str] job_tags: The tags assigned to jobs started using the job template.
        """
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        pulumi.set(__self__, "job_driver", job_driver)
        pulumi.set(__self__, "release_label", release_label)
        if configuration_overrides is not None:
            pulumi.set(__self__, "configuration_overrides", configuration_overrides)
        if job_tags is not None:
            pulumi.set(__self__, "job_tags", job_tags)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> str:
        """
        The execution role ARN of the job run.
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="jobDriver")
    def job_driver(self) -> 'outputs.JobTemplateJobTemplateDataJobDriver':
        """
        Specify the driver that the job runs on. Exactly one of the two available job drivers is required, either sparkSqlJobDriver or sparkSubmitJobDriver.
        """
        return pulumi.get(self, "job_driver")

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> str:
        """
        The release version of Amazon EMR.
        """
        return pulumi.get(self, "release_label")

    @property
    @pulumi.getter(name="configurationOverrides")
    def configuration_overrides(self) -> Optional['outputs.JobTemplateJobTemplateDataConfigurationOverrides']:
        """
        The configuration settings that are used to override defaults configuration.
        """
        return pulumi.get(self, "configuration_overrides")

    @property
    @pulumi.getter(name="jobTags")
    def job_tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags assigned to jobs started using the job template.
        """
        return pulumi.get(self, "job_tags")


@pulumi.output_type
class JobTemplateJobTemplateDataConfigurationOverrides(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationConfigurations":
            suggest = "application_configurations"
        elif key == "monitoringConfiguration":
            suggest = "monitoring_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateJobTemplateDataConfigurationOverrides. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateJobTemplateDataConfigurationOverrides.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateJobTemplateDataConfigurationOverrides.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_configurations: Optional[Sequence['outputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfiguration']] = None,
                 monitoring_configuration: Optional['outputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfiguration'] = None):
        """
        :param Sequence['JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs'] application_configurations: The configurations for the application running by the job run.
        :param 'JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs' monitoring_configuration: The configurations for monitoring.
        """
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if monitoring_configuration is not None:
            pulumi.set(__self__, "monitoring_configuration", monitoring_configuration)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[Sequence['outputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfiguration']]:
        """
        The configurations for the application running by the job run.
        """
        return pulumi.get(self, "application_configurations")

    @property
    @pulumi.getter(name="monitoringConfiguration")
    def monitoring_configuration(self) -> Optional['outputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfiguration']:
        """
        The configurations for monitoring.
        """
        return pulumi.get(self, "monitoring_configuration")


@pulumi.output_type
class JobTemplateJobTemplateDataConfigurationOverridesApplicationConfiguration(dict):
    def __init__(__self__, *,
                 classification: str,
                 configurations: Optional[Sequence['outputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfiguration']] = None,
                 properties: Optional[Mapping[str, str]] = None):
        """
        :param str classification: The classification within a configuration.
        :param Sequence['JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs'] configurations: A list of additional configurations to apply within a configuration object.
        :param Mapping[str, str] properties: A set of properties specified within a configuration classification.
        """
        pulumi.set(__self__, "classification", classification)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def classification(self) -> str:
        """
        The classification within a configuration.
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfiguration']]:
        """
        A list of additional configurations to apply within a configuration object.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A set of properties specified within a configuration classification.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfiguration(dict):
    def __init__(__self__, *,
                 classification: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None):
        """
        :param str classification: The classification within a configuration.
        :param Mapping[str, str] properties: A set of properties specified within a configuration classification.
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def classification(self) -> Optional[str]:
        """
        The classification within a configuration.
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A set of properties specified within a configuration classification.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchMonitoringConfiguration":
            suggest = "cloud_watch_monitoring_configuration"
        elif key == "persistentAppUi":
            suggest = "persistent_app_ui"
        elif key == "s3MonitoringConfiguration":
            suggest = "s3_monitoring_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_monitoring_configuration: Optional['outputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfiguration'] = None,
                 persistent_app_ui: Optional[str] = None,
                 s3_monitoring_configuration: Optional['outputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfiguration'] = None):
        """
        :param 'JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs' cloud_watch_monitoring_configuration: Monitoring configurations for CloudWatch.
        :param str persistent_app_ui: Monitoring configurations for the persistent application UI.
        :param 'JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfigurationArgs' s3_monitoring_configuration: Amazon S3 configuration for monitoring log publishing.
        """
        if cloud_watch_monitoring_configuration is not None:
            pulumi.set(__self__, "cloud_watch_monitoring_configuration", cloud_watch_monitoring_configuration)
        if persistent_app_ui is not None:
            pulumi.set(__self__, "persistent_app_ui", persistent_app_ui)
        if s3_monitoring_configuration is not None:
            pulumi.set(__self__, "s3_monitoring_configuration", s3_monitoring_configuration)

    @property
    @pulumi.getter(name="cloudWatchMonitoringConfiguration")
    def cloud_watch_monitoring_configuration(self) -> Optional['outputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfiguration']:
        """
        Monitoring configurations for CloudWatch.
        """
        return pulumi.get(self, "cloud_watch_monitoring_configuration")

    @property
    @pulumi.getter(name="persistentAppUi")
    def persistent_app_ui(self) -> Optional[str]:
        """
        Monitoring configurations for the persistent application UI.
        """
        return pulumi.get(self, "persistent_app_ui")

    @property
    @pulumi.getter(name="s3MonitoringConfiguration")
    def s3_monitoring_configuration(self) -> Optional['outputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfiguration']:
        """
        Amazon S3 configuration for monitoring log publishing.
        """
        return pulumi.get(self, "s3_monitoring_configuration")


@pulumi.output_type
class JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "logStreamNamePrefix":
            suggest = "log_stream_name_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_name: str,
                 log_stream_name_prefix: Optional[str] = None):
        """
        :param str log_group_name: The name of the log group for log publishing.
        :param str log_stream_name_prefix: The specified name prefix for log streams.
        """
        pulumi.set(__self__, "log_group_name", log_group_name)
        if log_stream_name_prefix is not None:
            pulumi.set(__self__, "log_stream_name_prefix", log_stream_name_prefix)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        """
        The name of the log group for log publishing.
        """
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="logStreamNamePrefix")
    def log_stream_name_prefix(self) -> Optional[str]:
        """
        The specified name prefix for log streams.
        """
        return pulumi.get(self, "log_stream_name_prefix")


@pulumi.output_type
class JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logUri":
            suggest = "log_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_uri: str):
        """
        :param str log_uri: Amazon S3 destination URI for log publishing.
        """
        pulumi.set(__self__, "log_uri", log_uri)

    @property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> str:
        """
        Amazon S3 destination URI for log publishing.
        """
        return pulumi.get(self, "log_uri")


@pulumi.output_type
class JobTemplateJobTemplateDataJobDriver(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sparkSqlJobDriver":
            suggest = "spark_sql_job_driver"
        elif key == "sparkSubmitJobDriver":
            suggest = "spark_submit_job_driver"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateJobTemplateDataJobDriver. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateJobTemplateDataJobDriver.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateJobTemplateDataJobDriver.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spark_sql_job_driver: Optional['outputs.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriver'] = None,
                 spark_submit_job_driver: Optional['outputs.JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriver'] = None):
        """
        :param 'JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs' spark_sql_job_driver: The job driver for job type.
        :param 'JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs' spark_submit_job_driver: The job driver parameters specified for spark submit.
        """
        if spark_sql_job_driver is not None:
            pulumi.set(__self__, "spark_sql_job_driver", spark_sql_job_driver)
        if spark_submit_job_driver is not None:
            pulumi.set(__self__, "spark_submit_job_driver", spark_submit_job_driver)

    @property
    @pulumi.getter(name="sparkSqlJobDriver")
    def spark_sql_job_driver(self) -> Optional['outputs.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriver']:
        """
        The job driver for job type.
        """
        return pulumi.get(self, "spark_sql_job_driver")

    @property
    @pulumi.getter(name="sparkSubmitJobDriver")
    def spark_submit_job_driver(self) -> Optional['outputs.JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriver']:
        """
        The job driver parameters specified for spark submit.
        """
        return pulumi.get(self, "spark_submit_job_driver")


@pulumi.output_type
class JobTemplateJobTemplateDataJobDriverSparkSqlJobDriver(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryPoint":
            suggest = "entry_point"
        elif key == "sparkSqlParameters":
            suggest = "spark_sql_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateJobTemplateDataJobDriverSparkSqlJobDriver. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateJobTemplateDataJobDriverSparkSqlJobDriver.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateJobTemplateDataJobDriverSparkSqlJobDriver.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entry_point: Optional[str] = None,
                 spark_sql_parameters: Optional[str] = None):
        """
        :param str entry_point: The SQL file to be executed.
        :param str spark_sql_parameters: The Spark parameters to be included in the Spark SQL command.
        """
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if spark_sql_parameters is not None:
            pulumi.set(__self__, "spark_sql_parameters", spark_sql_parameters)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[str]:
        """
        The SQL file to be executed.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter(name="sparkSqlParameters")
    def spark_sql_parameters(self) -> Optional[str]:
        """
        The Spark parameters to be included in the Spark SQL command.
        """
        return pulumi.get(self, "spark_sql_parameters")


@pulumi.output_type
class JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriver(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryPoint":
            suggest = "entry_point"
        elif key == "entryPointArguments":
            suggest = "entry_point_arguments"
        elif key == "sparkSubmitParameters":
            suggest = "spark_submit_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriver. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriver.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriver.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entry_point: str,
                 entry_point_arguments: Optional[Sequence[str]] = None,
                 spark_submit_parameters: Optional[str] = None):
        """
        :param str entry_point: The entry point of job application.
        :param Sequence[str] entry_point_arguments: The arguments for job application.
        :param str spark_submit_parameters: The Spark submit parameters that are used for job runs.
        """
        pulumi.set(__self__, "entry_point", entry_point)
        if entry_point_arguments is not None:
            pulumi.set(__self__, "entry_point_arguments", entry_point_arguments)
        if spark_submit_parameters is not None:
            pulumi.set(__self__, "spark_submit_parameters", spark_submit_parameters)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> str:
        """
        The entry point of job application.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter(name="entryPointArguments")
    def entry_point_arguments(self) -> Optional[Sequence[str]]:
        """
        The arguments for job application.
        """
        return pulumi.get(self, "entry_point_arguments")

    @property
    @pulumi.getter(name="sparkSubmitParameters")
    def spark_submit_parameters(self) -> Optional[str]:
        """
        The Spark submit parameters that are used for job runs.
        """
        return pulumi.get(self, "spark_submit_parameters")


@pulumi.output_type
class VirtualClusterContainerProvider(dict):
    def __init__(__self__, *,
                 id: str,
                 info: 'outputs.VirtualClusterContainerProviderInfo',
                 type: str):
        """
        :param str id: The name of the container provider that is running your EMR Containers cluster
        :param 'VirtualClusterContainerProviderInfoArgs' info: Nested list containing information about the configuration of the container provider
        :param str type: The type of the container provider
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "info", info)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The name of the container provider that is running your EMR Containers cluster
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def info(self) -> 'outputs.VirtualClusterContainerProviderInfo':
        """
        Nested list containing information about the configuration of the container provider
        """
        return pulumi.get(self, "info")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the container provider
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VirtualClusterContainerProviderInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eksInfo":
            suggest = "eks_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualClusterContainerProviderInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualClusterContainerProviderInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualClusterContainerProviderInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eks_info: 'outputs.VirtualClusterContainerProviderInfoEksInfo'):
        """
        :param 'VirtualClusterContainerProviderInfoEksInfoArgs' eks_info: Nested list containing EKS-specific information about the cluster where the EMR Containers cluster is running
        """
        pulumi.set(__self__, "eks_info", eks_info)

    @property
    @pulumi.getter(name="eksInfo")
    def eks_info(self) -> 'outputs.VirtualClusterContainerProviderInfoEksInfo':
        """
        Nested list containing EKS-specific information about the cluster where the EMR Containers cluster is running
        """
        return pulumi.get(self, "eks_info")


@pulumi.output_type
class VirtualClusterContainerProviderInfoEksInfo(dict):
    def __init__(__self__, *,
                 namespace: Optional[str] = None):
        """
        :param str namespace: The namespace where the EMR Containers cluster is running
        """
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace where the EMR Containers cluster is running
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetVirtualClusterContainerProviderResult(dict):
    def __init__(__self__, *,
                 id: str,
                 infos: Sequence['outputs.GetVirtualClusterContainerProviderInfoResult'],
                 type: str):
        """
        :param str id: The name of the container provider that is running your EMR Containers cluster
        :param Sequence['GetVirtualClusterContainerProviderInfoArgs'] infos: Nested list containing information about the configuration of the container provider
        :param str type: The type of the container provider
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "infos", infos)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The name of the container provider that is running your EMR Containers cluster
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def infos(self) -> Sequence['outputs.GetVirtualClusterContainerProviderInfoResult']:
        """
        Nested list containing information about the configuration of the container provider
        """
        return pulumi.get(self, "infos")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the container provider
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetVirtualClusterContainerProviderInfoResult(dict):
    def __init__(__self__, *,
                 eks_infos: Sequence['outputs.GetVirtualClusterContainerProviderInfoEksInfoResult']):
        """
        :param Sequence['GetVirtualClusterContainerProviderInfoEksInfoArgs'] eks_infos: Nested list containing EKS-specific information about the cluster where the EMR Containers cluster is running
        """
        pulumi.set(__self__, "eks_infos", eks_infos)

    @property
    @pulumi.getter(name="eksInfos")
    def eks_infos(self) -> Sequence['outputs.GetVirtualClusterContainerProviderInfoEksInfoResult']:
        """
        Nested list containing EKS-specific information about the cluster where the EMR Containers cluster is running
        """
        return pulumi.get(self, "eks_infos")


@pulumi.output_type
class GetVirtualClusterContainerProviderInfoEksInfoResult(dict):
    def __init__(__self__, *,
                 namespace: str):
        """
        :param str namespace: The namespace where the EMR Containers cluster is running
        """
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace where the EMR Containers cluster is running
        """
        return pulumi.get(self, "namespace")


