# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FeatureArgs', 'Feature']

@pulumi.input_type
class FeatureArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 variations: pulumi.Input[Sequence[pulumi.Input['FeatureVariationArgs']]],
                 default_variation: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 evaluation_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Feature resource.
        :param pulumi.Input[str] project: The name or ARN of the project that is to contain the new feature.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureVariationArgs']]] variations: One or more blocks that contain the configuration of the feature's different variations. Detailed below
        :param pulumi.Input[str] default_variation: The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
        :param pulumi.Input[str] description: Specifies the description of the feature.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] entity_overrides: Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
        :param pulumi.Input[str] evaluation_strategy: Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
        :param pulumi.Input[str] name: The name for the new feature. Minimum length of `1`. Maximum length of `127`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "variations", variations)
        if default_variation is not None:
            pulumi.set(__self__, "default_variation", default_variation)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_overrides is not None:
            pulumi.set(__self__, "entity_overrides", entity_overrides)
        if evaluation_strategy is not None:
            pulumi.set(__self__, "evaluation_strategy", evaluation_strategy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The name or ARN of the project that is to contain the new feature.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def variations(self) -> pulumi.Input[Sequence[pulumi.Input['FeatureVariationArgs']]]:
        """
        One or more blocks that contain the configuration of the feature's different variations. Detailed below
        """
        return pulumi.get(self, "variations")

    @variations.setter
    def variations(self, value: pulumi.Input[Sequence[pulumi.Input['FeatureVariationArgs']]]):
        pulumi.set(self, "variations", value)

    @property
    @pulumi.getter(name="defaultVariation")
    def default_variation(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
        """
        return pulumi.get(self, "default_variation")

    @default_variation.setter
    def default_variation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_variation", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the feature.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entityOverrides")
    def entity_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
        """
        return pulumi.get(self, "entity_overrides")

    @entity_overrides.setter
    def entity_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "entity_overrides", value)

    @property
    @pulumi.getter(name="evaluationStrategy")
    def evaluation_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
        """
        return pulumi.get(self, "evaluation_strategy")

    @evaluation_strategy.setter
    def evaluation_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "evaluation_strategy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the new feature. Minimum length of `1`. Maximum length of `127`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FeatureState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 default_variation: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 evaluation_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureEvaluationRuleArgs']]]] = None,
                 evaluation_strategy: Optional[pulumi.Input[str]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 value_type: Optional[pulumi.Input[str]] = None,
                 variations: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureVariationArgs']]]] = None):
        """
        Input properties used for looking up and filtering Feature resources.
        :param pulumi.Input[str] arn: The ARN of the feature.
        :param pulumi.Input[str] created_time: The date and time that the feature is created.
        :param pulumi.Input[str] default_variation: The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
        :param pulumi.Input[str] description: Specifies the description of the feature.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] entity_overrides: Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureEvaluationRuleArgs']]] evaluation_rules: One or more blocks that define the evaluation rules for the feature. Detailed below
        :param pulumi.Input[str] evaluation_strategy: Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
        :param pulumi.Input[str] last_updated_time: The date and time that the feature was most recently updated.
        :param pulumi.Input[str] name: The name for the new feature. Minimum length of `1`. Maximum length of `127`.
        :param pulumi.Input[str] project: The name or ARN of the project that is to contain the new feature.
        :param pulumi.Input[str] status: The current state of the feature. Valid values are `AVAILABLE` and `UPDATING`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] value_type: Defines the type of value used to define the different feature variations. Valid Values: `STRING`, `LONG`, `DOUBLE`, `BOOLEAN`.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureVariationArgs']]] variations: One or more blocks that contain the configuration of the feature's different variations. Detailed below
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if default_variation is not None:
            pulumi.set(__self__, "default_variation", default_variation)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_overrides is not None:
            pulumi.set(__self__, "entity_overrides", entity_overrides)
        if evaluation_rules is not None:
            pulumi.set(__self__, "evaluation_rules", evaluation_rules)
        if evaluation_strategy is not None:
            pulumi.set(__self__, "evaluation_strategy", evaluation_strategy)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)
        if variations is not None:
            pulumi.set(__self__, "variations", variations)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the feature.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the feature is created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter(name="defaultVariation")
    def default_variation(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
        """
        return pulumi.get(self, "default_variation")

    @default_variation.setter
    def default_variation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_variation", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the feature.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entityOverrides")
    def entity_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
        """
        return pulumi.get(self, "entity_overrides")

    @entity_overrides.setter
    def entity_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "entity_overrides", value)

    @property
    @pulumi.getter(name="evaluationRules")
    def evaluation_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureEvaluationRuleArgs']]]]:
        """
        One or more blocks that define the evaluation rules for the feature. Detailed below
        """
        return pulumi.get(self, "evaluation_rules")

    @evaluation_rules.setter
    def evaluation_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureEvaluationRuleArgs']]]]):
        pulumi.set(self, "evaluation_rules", value)

    @property
    @pulumi.getter(name="evaluationStrategy")
    def evaluation_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
        """
        return pulumi.get(self, "evaluation_strategy")

    @evaluation_strategy.setter
    def evaluation_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "evaluation_strategy", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the feature was most recently updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the new feature. Minimum length of `1`. Maximum length of `127`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The name or ARN of the project that is to contain the new feature.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the feature. Valid values are `AVAILABLE` and `UPDATING`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the type of value used to define the different feature variations. Valid Values: `STRING`, `LONG`, `DOUBLE`, `BOOLEAN`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value_type", value)

    @property
    @pulumi.getter
    def variations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureVariationArgs']]]]:
        """
        One or more blocks that contain the configuration of the feature's different variations. Detailed below
        """
        return pulumi.get(self, "variations")

    @variations.setter
    def variations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureVariationArgs']]]]):
        pulumi.set(self, "variations", value)


class Feature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_variation: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 evaluation_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 variations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureVariationArgs', 'FeatureVariationArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a CloudWatch Evidently Feature resource.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Feature("example",
            name="example",
            project=example_aws_evidently_project["name"],
            description="example description",
            variations=[{
                "name": "Variation1",
                "value": {
                    "string_value": "example",
                },
            }],
            tags={
                "Key1": "example Feature",
            })
        ```

        ### With default variation

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Feature("example",
            name="example",
            project=example_aws_evidently_project["name"],
            default_variation="Variation2",
            variations=[
                {
                    "name": "Variation1",
                    "value": {
                        "string_value": "exampleval1",
                    },
                },
                {
                    "name": "Variation2",
                    "value": {
                        "string_value": "exampleval2",
                    },
                },
            ])
        ```

        ### With entity overrides

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Feature("example",
            name="example",
            project=example_aws_evidently_project["name"],
            entity_overrides={
                "test1": "Variation1",
            },
            variations=[
                {
                    "name": "Variation1",
                    "value": {
                        "string_value": "exampleval1",
                    },
                },
                {
                    "name": "Variation2",
                    "value": {
                        "string_value": "exampleval2",
                    },
                },
            ])
        ```

        ### With evaluation strategy

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Feature("example",
            name="example",
            project=example_aws_evidently_project["name"],
            evaluation_strategy="ALL_RULES",
            entity_overrides={
                "test1": "Variation1",
            },
            variations=[{
                "name": "Variation1",
                "value": {
                    "string_value": "exampleval1",
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Evidently Feature using the feature `name` and `name` or `arn` of the hosting CloudWatch Evidently Project separated by a `:`. For example:

        ```sh
        $ pulumi import aws:evidently/feature:Feature example exampleFeatureName:arn:aws:evidently:us-east-1:123456789012:project/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_variation: The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
        :param pulumi.Input[str] description: Specifies the description of the feature.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] entity_overrides: Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
        :param pulumi.Input[str] evaluation_strategy: Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
        :param pulumi.Input[str] name: The name for the new feature. Minimum length of `1`. Maximum length of `127`.
        :param pulumi.Input[str] project: The name or ARN of the project that is to contain the new feature.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FeatureVariationArgs', 'FeatureVariationArgsDict']]]] variations: One or more blocks that contain the configuration of the feature's different variations. Detailed below
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CloudWatch Evidently Feature resource.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Feature("example",
            name="example",
            project=example_aws_evidently_project["name"],
            description="example description",
            variations=[{
                "name": "Variation1",
                "value": {
                    "string_value": "example",
                },
            }],
            tags={
                "Key1": "example Feature",
            })
        ```

        ### With default variation

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Feature("example",
            name="example",
            project=example_aws_evidently_project["name"],
            default_variation="Variation2",
            variations=[
                {
                    "name": "Variation1",
                    "value": {
                        "string_value": "exampleval1",
                    },
                },
                {
                    "name": "Variation2",
                    "value": {
                        "string_value": "exampleval2",
                    },
                },
            ])
        ```

        ### With entity overrides

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Feature("example",
            name="example",
            project=example_aws_evidently_project["name"],
            entity_overrides={
                "test1": "Variation1",
            },
            variations=[
                {
                    "name": "Variation1",
                    "value": {
                        "string_value": "exampleval1",
                    },
                },
                {
                    "name": "Variation2",
                    "value": {
                        "string_value": "exampleval2",
                    },
                },
            ])
        ```

        ### With evaluation strategy

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.evidently.Feature("example",
            name="example",
            project=example_aws_evidently_project["name"],
            evaluation_strategy="ALL_RULES",
            entity_overrides={
                "test1": "Variation1",
            },
            variations=[{
                "name": "Variation1",
                "value": {
                    "string_value": "exampleval1",
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Evidently Feature using the feature `name` and `name` or `arn` of the hosting CloudWatch Evidently Project separated by a `:`. For example:

        ```sh
        $ pulumi import aws:evidently/feature:Feature example exampleFeatureName:arn:aws:evidently:us-east-1:123456789012:project/example
        ```

        :param str resource_name: The name of the resource.
        :param FeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_variation: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 evaluation_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 variations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureVariationArgs', 'FeatureVariationArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FeatureArgs.__new__(FeatureArgs)

            __props__.__dict__["default_variation"] = default_variation
            __props__.__dict__["description"] = description
            __props__.__dict__["entity_overrides"] = entity_overrides
            __props__.__dict__["evaluation_strategy"] = evaluation_strategy
            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["tags"] = tags
            if variations is None and not opts.urn:
                raise TypeError("Missing required property 'variations'")
            __props__.__dict__["variations"] = variations
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["evaluation_rules"] = None
            __props__.__dict__["last_updated_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["value_type"] = None
        super(Feature, __self__).__init__(
            'aws:evidently/feature:Feature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            created_time: Optional[pulumi.Input[str]] = None,
            default_variation: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            entity_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            evaluation_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureEvaluationRuleArgs', 'FeatureEvaluationRuleArgsDict']]]]] = None,
            evaluation_strategy: Optional[pulumi.Input[str]] = None,
            last_updated_time: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            value_type: Optional[pulumi.Input[str]] = None,
            variations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureVariationArgs', 'FeatureVariationArgsDict']]]]] = None) -> 'Feature':
        """
        Get an existing Feature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the feature.
        :param pulumi.Input[str] created_time: The date and time that the feature is created.
        :param pulumi.Input[str] default_variation: The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
        :param pulumi.Input[str] description: Specifies the description of the feature.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] entity_overrides: Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FeatureEvaluationRuleArgs', 'FeatureEvaluationRuleArgsDict']]]] evaluation_rules: One or more blocks that define the evaluation rules for the feature. Detailed below
        :param pulumi.Input[str] evaluation_strategy: Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
        :param pulumi.Input[str] last_updated_time: The date and time that the feature was most recently updated.
        :param pulumi.Input[str] name: The name for the new feature. Minimum length of `1`. Maximum length of `127`.
        :param pulumi.Input[str] project: The name or ARN of the project that is to contain the new feature.
        :param pulumi.Input[str] status: The current state of the feature. Valid values are `AVAILABLE` and `UPDATING`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] value_type: Defines the type of value used to define the different feature variations. Valid Values: `STRING`, `LONG`, `DOUBLE`, `BOOLEAN`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FeatureVariationArgs', 'FeatureVariationArgsDict']]]] variations: One or more blocks that contain the configuration of the feature's different variations. Detailed below
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FeatureState.__new__(_FeatureState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["default_variation"] = default_variation
        __props__.__dict__["description"] = description
        __props__.__dict__["entity_overrides"] = entity_overrides
        __props__.__dict__["evaluation_rules"] = evaluation_rules
        __props__.__dict__["evaluation_strategy"] = evaluation_strategy
        __props__.__dict__["last_updated_time"] = last_updated_time
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["value_type"] = value_type
        __props__.__dict__["variations"] = variations
        return Feature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the feature.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[str]:
        """
        The date and time that the feature is created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="defaultVariation")
    def default_variation(self) -> pulumi.Output[str]:
        """
        The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
        """
        return pulumi.get(self, "default_variation")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the feature.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entityOverrides")
    def entity_overrides(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
        """
        return pulumi.get(self, "entity_overrides")

    @property
    @pulumi.getter(name="evaluationRules")
    def evaluation_rules(self) -> pulumi.Output[Sequence['outputs.FeatureEvaluationRule']]:
        """
        One or more blocks that define the evaluation rules for the feature. Detailed below
        """
        return pulumi.get(self, "evaluation_rules")

    @property
    @pulumi.getter(name="evaluationStrategy")
    def evaluation_strategy(self) -> pulumi.Output[str]:
        """
        Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
        """
        return pulumi.get(self, "evaluation_strategy")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[str]:
        """
        The date and time that the feature was most recently updated.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name for the new feature. Minimum length of `1`. Maximum length of `127`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The name or ARN of the project that is to contain the new feature.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current state of the feature. Valid values are `AVAILABLE` and `UPDATING`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> pulumi.Output[str]:
        """
        Defines the type of value used to define the different feature variations. Valid Values: `STRING`, `LONG`, `DOUBLE`, `BOOLEAN`.
        """
        return pulumi.get(self, "value_type")

    @property
    @pulumi.getter
    def variations(self) -> pulumi.Output[Sequence['outputs.FeatureVariation']]:
        """
        One or more blocks that contain the configuration of the feature's different variations. Detailed below
        """
        return pulumi.get(self, "variations")

