# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WindowsFileSystemArgs', 'WindowsFileSystem']

@pulumi.input_type
class WindowsFileSystemArgs:
    def __init__(__self__, *,
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 throughput_capacity: pulumi.Input[int],
                 active_directory_id: Optional[pulumi.Input[str]] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_log_configuration: Optional[pulumi.Input['WindowsFileSystemAuditLogConfigurationArgs']] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input['WindowsFileSystemDiskIopsConfigurationArgs']] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 self_managed_active_directory: Optional[pulumi.Input['WindowsFileSystemSelfManagedActiveDirectoryArgs']] = None,
                 skip_final_backup: Optional[pulumi.Input[bool]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WindowsFileSystem resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
        :param pulumi.Input[int] throughput_capacity: Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
               
               The following arguments are optional:
        :param pulumi.Input[str] active_directory_id: The ID for an existing Microsoft Active Directory instance that the file system should join when it's created. Cannot be specified with `self_managed_active_directory`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
        :param pulumi.Input['WindowsFileSystemAuditLogConfigurationArgs'] audit_log_configuration: The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See `audit_log_configuration` Block for details.
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
        :param pulumi.Input[str] backup_id: The ID of the source backup to create the filesystem from.
        :param pulumi.Input[bool] copy_tags_to_backups: A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
        :param pulumi.Input[str] daily_automatic_backup_start_time: The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
        :param pulumi.Input[str] deployment_type: Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
        :param pulumi.Input['WindowsFileSystemDiskIopsConfigurationArgs'] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See `disk_iops_configuration` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] final_backup_tags: A map of tags to apply to the file system's final backup.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
        :param pulumi.Input[str] preferred_subnet_id: Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input['WindowsFileSystemSelfManagedActiveDirectoryArgs'] self_managed_active_directory: Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See `self_managed_active_directory` Block for details.
        :param pulumi.Input[bool] skip_final_backup: When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[int] storage_capacity: Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
        :param pulumi.Input[str] storage_type: Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if active_directory_id is not None:
            pulumi.set(__self__, "active_directory_id", active_directory_id)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if audit_log_configuration is not None:
            pulumi.set(__self__, "audit_log_configuration", audit_log_configuration)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if disk_iops_configuration is not None:
            pulumi.set(__self__, "disk_iops_configuration", disk_iops_configuration)
        if final_backup_tags is not None:
            pulumi.set(__self__, "final_backup_tags", final_backup_tags)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if preferred_subnet_id is not None:
            pulumi.set(__self__, "preferred_subnet_id", preferred_subnet_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if self_managed_active_directory is not None:
            pulumi.set(__self__, "self_managed_active_directory", self_managed_active_directory)
        if skip_final_backup is not None:
            pulumi.set(__self__, "skip_final_backup", skip_final_backup)
        if storage_capacity is not None:
            pulumi.set(__self__, "storage_capacity", storage_capacity)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> pulumi.Input[int]:
        """
        Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.

        The following arguments are optional:
        """
        return pulumi.get(self, "throughput_capacity")

    @throughput_capacity.setter
    def throughput_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "throughput_capacity", value)

    @property
    @pulumi.getter(name="activeDirectoryId")
    def active_directory_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for an existing Microsoft Active Directory instance that the file system should join when it's created. Cannot be specified with `self_managed_active_directory`.
        """
        return pulumi.get(self, "active_directory_id")

    @active_directory_id.setter
    def active_directory_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_directory_id", value)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter(name="auditLogConfiguration")
    def audit_log_configuration(self) -> Optional[pulumi.Input['WindowsFileSystemAuditLogConfigurationArgs']]:
        """
        The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See `audit_log_configuration` Block for details.
        """
        return pulumi.get(self, "audit_log_configuration")

    @audit_log_configuration.setter
    def audit_log_configuration(self, value: Optional[pulumi.Input['WindowsFileSystemAuditLogConfigurationArgs']]):
        pulumi.set(self, "audit_log_configuration", value)

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
        """
        return pulumi.get(self, "automatic_backup_retention_days")

    @automatic_backup_retention_days.setter
    def automatic_backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automatic_backup_retention_days", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the source backup to create the filesystem from.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
        """
        return pulumi.get(self, "copy_tags_to_backups")

    @copy_tags_to_backups.setter
    def copy_tags_to_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_backups", value)

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
        """
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @daily_automatic_backup_start_time.setter
    def daily_automatic_backup_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_automatic_backup_start_time", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> Optional[pulumi.Input['WindowsFileSystemDiskIopsConfigurationArgs']]:
        """
        The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See `disk_iops_configuration` Block for details.
        """
        return pulumi.get(self, "disk_iops_configuration")

    @disk_iops_configuration.setter
    def disk_iops_configuration(self, value: Optional[pulumi.Input['WindowsFileSystemDiskIopsConfigurationArgs']]):
        pulumi.set(self, "disk_iops_configuration", value)

    @property
    @pulumi.getter(name="finalBackupTags")
    def final_backup_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to apply to the file system's final backup.
        """
        return pulumi.get(self, "final_backup_tags")

    @final_backup_tags.setter
    def final_backup_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "final_backup_tags", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
        """
        return pulumi.get(self, "preferred_subnet_id")

    @preferred_subnet_id.setter
    def preferred_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_subnet_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="selfManagedActiveDirectory")
    def self_managed_active_directory(self) -> Optional[pulumi.Input['WindowsFileSystemSelfManagedActiveDirectoryArgs']]:
        """
        Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See `self_managed_active_directory` Block for details.
        """
        return pulumi.get(self, "self_managed_active_directory")

    @self_managed_active_directory.setter
    def self_managed_active_directory(self, value: Optional[pulumi.Input['WindowsFileSystemSelfManagedActiveDirectoryArgs']]):
        pulumi.set(self, "self_managed_active_directory", value)

    @property
    @pulumi.getter(name="skipFinalBackup")
    def skip_final_backup(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "skip_final_backup")

    @skip_final_backup.setter
    def skip_final_backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_backup", value)

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
        """
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")

    @weekly_maintenance_start_time.setter
    def weekly_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_start_time", value)


@pulumi.input_type
class _WindowsFileSystemState:
    def __init__(__self__, *,
                 active_directory_id: Optional[pulumi.Input[str]] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 audit_log_configuration: Optional[pulumi.Input['WindowsFileSystemAuditLogConfigurationArgs']] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input['WindowsFileSystemDiskIopsConfigurationArgs']] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 preferred_file_server_ip: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 remote_administration_endpoint: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 self_managed_active_directory: Optional[pulumi.Input['WindowsFileSystemSelfManagedActiveDirectoryArgs']] = None,
                 skip_final_backup: Optional[pulumi.Input[bool]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WindowsFileSystem resources.
        :param pulumi.Input[str] active_directory_id: The ID for an existing Microsoft Active Directory instance that the file system should join when it's created. Cannot be specified with `self_managed_active_directory`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
        :param pulumi.Input[str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input['WindowsFileSystemAuditLogConfigurationArgs'] audit_log_configuration: The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See `audit_log_configuration` Block for details.
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
        :param pulumi.Input[str] backup_id: The ID of the source backup to create the filesystem from.
        :param pulumi.Input[bool] copy_tags_to_backups: A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
        :param pulumi.Input[str] daily_automatic_backup_start_time: The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
        :param pulumi.Input[str] deployment_type: Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
        :param pulumi.Input['WindowsFileSystemDiskIopsConfigurationArgs'] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See `disk_iops_configuration` Block for details.
        :param pulumi.Input[str] dns_name: DNS name for the file system, e.g., `fs-12345678.corp.example.com` (domain name matching the Active Directory domain name)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] final_backup_tags: A map of tags to apply to the file system's final backup.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_ids: Set of Elastic Network Interface identifiers from which the file system is accessible.
        :param pulumi.Input[str] owner_id: AWS account identifier that created the file system.
        :param pulumi.Input[str] preferred_file_server_ip: The IP address of the primary, or preferred, file server.
        :param pulumi.Input[str] preferred_subnet_id: Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
        :param pulumi.Input[str] remote_administration_endpoint: For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell. For `SINGLE_AZ_1` deployment types, this is the DNS name of the file system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input['WindowsFileSystemSelfManagedActiveDirectoryArgs'] self_managed_active_directory: Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See `self_managed_active_directory` Block for details.
        :param pulumi.Input[bool] skip_final_backup: When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[int] storage_capacity: Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
        :param pulumi.Input[str] storage_type: Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[int] throughput_capacity: Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
               
               The following arguments are optional:
        :param pulumi.Input[str] vpc_id: Identifier of the Virtual Private Cloud for the file system.
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        if active_directory_id is not None:
            pulumi.set(__self__, "active_directory_id", active_directory_id)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if audit_log_configuration is not None:
            pulumi.set(__self__, "audit_log_configuration", audit_log_configuration)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if disk_iops_configuration is not None:
            pulumi.set(__self__, "disk_iops_configuration", disk_iops_configuration)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if final_backup_tags is not None:
            pulumi.set(__self__, "final_backup_tags", final_backup_tags)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if network_interface_ids is not None:
            pulumi.set(__self__, "network_interface_ids", network_interface_ids)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if preferred_file_server_ip is not None:
            pulumi.set(__self__, "preferred_file_server_ip", preferred_file_server_ip)
        if preferred_subnet_id is not None:
            pulumi.set(__self__, "preferred_subnet_id", preferred_subnet_id)
        if remote_administration_endpoint is not None:
            pulumi.set(__self__, "remote_administration_endpoint", remote_administration_endpoint)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if self_managed_active_directory is not None:
            pulumi.set(__self__, "self_managed_active_directory", self_managed_active_directory)
        if skip_final_backup is not None:
            pulumi.set(__self__, "skip_final_backup", skip_final_backup)
        if storage_capacity is not None:
            pulumi.set(__self__, "storage_capacity", storage_capacity)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if throughput_capacity is not None:
            pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="activeDirectoryId")
    def active_directory_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for an existing Microsoft Active Directory instance that the file system should join when it's created. Cannot be specified with `self_managed_active_directory`.
        """
        return pulumi.get(self, "active_directory_id")

    @active_directory_id.setter
    def active_directory_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_directory_id", value)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="auditLogConfiguration")
    def audit_log_configuration(self) -> Optional[pulumi.Input['WindowsFileSystemAuditLogConfigurationArgs']]:
        """
        The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See `audit_log_configuration` Block for details.
        """
        return pulumi.get(self, "audit_log_configuration")

    @audit_log_configuration.setter
    def audit_log_configuration(self, value: Optional[pulumi.Input['WindowsFileSystemAuditLogConfigurationArgs']]):
        pulumi.set(self, "audit_log_configuration", value)

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
        """
        return pulumi.get(self, "automatic_backup_retention_days")

    @automatic_backup_retention_days.setter
    def automatic_backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automatic_backup_retention_days", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the source backup to create the filesystem from.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
        """
        return pulumi.get(self, "copy_tags_to_backups")

    @copy_tags_to_backups.setter
    def copy_tags_to_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_backups", value)

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
        """
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @daily_automatic_backup_start_time.setter
    def daily_automatic_backup_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_automatic_backup_start_time", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> Optional[pulumi.Input['WindowsFileSystemDiskIopsConfigurationArgs']]:
        """
        The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See `disk_iops_configuration` Block for details.
        """
        return pulumi.get(self, "disk_iops_configuration")

    @disk_iops_configuration.setter
    def disk_iops_configuration(self, value: Optional[pulumi.Input['WindowsFileSystemDiskIopsConfigurationArgs']]):
        pulumi.set(self, "disk_iops_configuration", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        DNS name for the file system, e.g., `fs-12345678.corp.example.com` (domain name matching the Active Directory domain name)
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="finalBackupTags")
    def final_backup_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to apply to the file system's final backup.
        """
        return pulumi.get(self, "final_backup_tags")

    @final_backup_tags.setter
    def final_backup_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "final_backup_tags", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of Elastic Network Interface identifiers from which the file system is accessible.
        """
        return pulumi.get(self, "network_interface_ids")

    @network_interface_ids.setter
    def network_interface_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_interface_ids", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account identifier that created the file system.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="preferredFileServerIp")
    def preferred_file_server_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the primary, or preferred, file server.
        """
        return pulumi.get(self, "preferred_file_server_ip")

    @preferred_file_server_ip.setter
    def preferred_file_server_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_file_server_ip", value)

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
        """
        return pulumi.get(self, "preferred_subnet_id")

    @preferred_subnet_id.setter
    def preferred_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_subnet_id", value)

    @property
    @pulumi.getter(name="remoteAdministrationEndpoint")
    def remote_administration_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell. For `SINGLE_AZ_1` deployment types, this is the DNS name of the file system.
        """
        return pulumi.get(self, "remote_administration_endpoint")

    @remote_administration_endpoint.setter
    def remote_administration_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_administration_endpoint", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="selfManagedActiveDirectory")
    def self_managed_active_directory(self) -> Optional[pulumi.Input['WindowsFileSystemSelfManagedActiveDirectoryArgs']]:
        """
        Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See `self_managed_active_directory` Block for details.
        """
        return pulumi.get(self, "self_managed_active_directory")

    @self_managed_active_directory.setter
    def self_managed_active_directory(self, value: Optional[pulumi.Input['WindowsFileSystemSelfManagedActiveDirectoryArgs']]):
        pulumi.set(self, "self_managed_active_directory", value)

    @property
    @pulumi.getter(name="skipFinalBackup")
    def skip_final_backup(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "skip_final_backup")

    @skip_final_backup.setter
    def skip_final_backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_backup", value)

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
        """
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.

        The following arguments are optional:
        """
        return pulumi.get(self, "throughput_capacity")

    @throughput_capacity.setter
    def throughput_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput_capacity", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the Virtual Private Cloud for the file system.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")

    @weekly_maintenance_start_time.setter
    def weekly_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_start_time", value)


class WindowsFileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_directory_id: Optional[pulumi.Input[str]] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_log_configuration: Optional[pulumi.Input[Union['WindowsFileSystemAuditLogConfigurationArgs', 'WindowsFileSystemAuditLogConfigurationArgsDict']]] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input[Union['WindowsFileSystemDiskIopsConfigurationArgs', 'WindowsFileSystemDiskIopsConfigurationArgsDict']]] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 self_managed_active_directory: Optional[pulumi.Input[Union['WindowsFileSystemSelfManagedActiveDirectoryArgs', 'WindowsFileSystemSelfManagedActiveDirectoryArgsDict']]] = None,
                 skip_final_backup: Optional[pulumi.Input[bool]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a FSx Windows File System. See the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html) for more information.

        > **NOTE:** Either the `active_directory_id` argument or `self_managed_active_directory` configuration block must be specified.

        ## Example Usage

        ### Using AWS Directory Service

        Additional information for using AWS Directory Service with Windows File Systems can be found in the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/fsx-aws-managed-ad.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.fsx.WindowsFileSystem("example",
            active_directory_id=example_aws_directory_service_directory["id"],
            kms_key_id=example_aws_kms_key["arn"],
            storage_capacity=300,
            subnet_ids=[example_aws_subnet["id"]],
            throughput_capacity=1024)
        ```

        ### Using a Self-Managed Microsoft Active Directory

        Additional information for using AWS Directory Service with Windows File Systems can be found in the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.fsx.WindowsFileSystem("example",
            kms_key_id=example_aws_kms_key["arn"],
            storage_capacity=300,
            subnet_ids=[example_aws_subnet["id"]],
            throughput_capacity=1024,
            self_managed_active_directory={
                "dns_ips": [
                    "10.0.0.111",
                    "10.0.0.222",
                ],
                "domain_name": "corp.example.com",
                "password": "avoid-plaintext-passwords",
                "username": "Admin",
            })
        ```

        ## Import

        Using `pulumi import`, import FSx File Systems using the `id`. For example:

        ```sh
        $ pulumi import aws:fsx/windowsFileSystem:WindowsFileSystem example fs-543ab12b1ca672f33
        ```
        Certain resource arguments, like `security_group_ids` and the `self_managed_active_directory` configuation block `password`, do not have a FSx API method for reading the information after creation. If these arguments are set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] active_directory_id: The ID for an existing Microsoft Active Directory instance that the file system should join when it's created. Cannot be specified with `self_managed_active_directory`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
        :param pulumi.Input[Union['WindowsFileSystemAuditLogConfigurationArgs', 'WindowsFileSystemAuditLogConfigurationArgsDict']] audit_log_configuration: The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See `audit_log_configuration` Block for details.
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
        :param pulumi.Input[str] backup_id: The ID of the source backup to create the filesystem from.
        :param pulumi.Input[bool] copy_tags_to_backups: A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
        :param pulumi.Input[str] daily_automatic_backup_start_time: The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
        :param pulumi.Input[str] deployment_type: Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
        :param pulumi.Input[Union['WindowsFileSystemDiskIopsConfigurationArgs', 'WindowsFileSystemDiskIopsConfigurationArgsDict']] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See `disk_iops_configuration` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] final_backup_tags: A map of tags to apply to the file system's final backup.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
        :param pulumi.Input[str] preferred_subnet_id: Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input[Union['WindowsFileSystemSelfManagedActiveDirectoryArgs', 'WindowsFileSystemSelfManagedActiveDirectoryArgsDict']] self_managed_active_directory: Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See `self_managed_active_directory` Block for details.
        :param pulumi.Input[bool] skip_final_backup: When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[int] storage_capacity: Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
        :param pulumi.Input[str] storage_type: Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] throughput_capacity: Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
               
               The following arguments are optional:
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WindowsFileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a FSx Windows File System. See the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html) for more information.

        > **NOTE:** Either the `active_directory_id` argument or `self_managed_active_directory` configuration block must be specified.

        ## Example Usage

        ### Using AWS Directory Service

        Additional information for using AWS Directory Service with Windows File Systems can be found in the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/fsx-aws-managed-ad.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.fsx.WindowsFileSystem("example",
            active_directory_id=example_aws_directory_service_directory["id"],
            kms_key_id=example_aws_kms_key["arn"],
            storage_capacity=300,
            subnet_ids=[example_aws_subnet["id"]],
            throughput_capacity=1024)
        ```

        ### Using a Self-Managed Microsoft Active Directory

        Additional information for using AWS Directory Service with Windows File Systems can be found in the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.fsx.WindowsFileSystem("example",
            kms_key_id=example_aws_kms_key["arn"],
            storage_capacity=300,
            subnet_ids=[example_aws_subnet["id"]],
            throughput_capacity=1024,
            self_managed_active_directory={
                "dns_ips": [
                    "10.0.0.111",
                    "10.0.0.222",
                ],
                "domain_name": "corp.example.com",
                "password": "avoid-plaintext-passwords",
                "username": "Admin",
            })
        ```

        ## Import

        Using `pulumi import`, import FSx File Systems using the `id`. For example:

        ```sh
        $ pulumi import aws:fsx/windowsFileSystem:WindowsFileSystem example fs-543ab12b1ca672f33
        ```
        Certain resource arguments, like `security_group_ids` and the `self_managed_active_directory` configuation block `password`, do not have a FSx API method for reading the information after creation. If these arguments are set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param WindowsFileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WindowsFileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_directory_id: Optional[pulumi.Input[str]] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_log_configuration: Optional[pulumi.Input[Union['WindowsFileSystemAuditLogConfigurationArgs', 'WindowsFileSystemAuditLogConfigurationArgsDict']]] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input[Union['WindowsFileSystemDiskIopsConfigurationArgs', 'WindowsFileSystemDiskIopsConfigurationArgsDict']]] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 self_managed_active_directory: Optional[pulumi.Input[Union['WindowsFileSystemSelfManagedActiveDirectoryArgs', 'WindowsFileSystemSelfManagedActiveDirectoryArgsDict']]] = None,
                 skip_final_backup: Optional[pulumi.Input[bool]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WindowsFileSystemArgs.__new__(WindowsFileSystemArgs)

            __props__.__dict__["active_directory_id"] = active_directory_id
            __props__.__dict__["aliases"] = aliases
            __props__.__dict__["audit_log_configuration"] = audit_log_configuration
            __props__.__dict__["automatic_backup_retention_days"] = automatic_backup_retention_days
            __props__.__dict__["backup_id"] = backup_id
            __props__.__dict__["copy_tags_to_backups"] = copy_tags_to_backups
            __props__.__dict__["daily_automatic_backup_start_time"] = daily_automatic_backup_start_time
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["disk_iops_configuration"] = disk_iops_configuration
            __props__.__dict__["final_backup_tags"] = final_backup_tags
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["preferred_subnet_id"] = preferred_subnet_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["self_managed_active_directory"] = self_managed_active_directory
            __props__.__dict__["skip_final_backup"] = skip_final_backup
            __props__.__dict__["storage_capacity"] = storage_capacity
            __props__.__dict__["storage_type"] = storage_type
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            if throughput_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'throughput_capacity'")
            __props__.__dict__["throughput_capacity"] = throughput_capacity
            __props__.__dict__["weekly_maintenance_start_time"] = weekly_maintenance_start_time
            __props__.__dict__["arn"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["network_interface_ids"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["preferred_file_server_ip"] = None
            __props__.__dict__["remote_administration_endpoint"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_id"] = None
        super(WindowsFileSystem, __self__).__init__(
            'aws:fsx/windowsFileSystem:WindowsFileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_directory_id: Optional[pulumi.Input[str]] = None,
            aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            audit_log_configuration: Optional[pulumi.Input[Union['WindowsFileSystemAuditLogConfigurationArgs', 'WindowsFileSystemAuditLogConfigurationArgsDict']]] = None,
            automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
            backup_id: Optional[pulumi.Input[str]] = None,
            copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
            daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
            deployment_type: Optional[pulumi.Input[str]] = None,
            disk_iops_configuration: Optional[pulumi.Input[Union['WindowsFileSystemDiskIopsConfigurationArgs', 'WindowsFileSystemDiskIopsConfigurationArgsDict']]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            preferred_file_server_ip: Optional[pulumi.Input[str]] = None,
            preferred_subnet_id: Optional[pulumi.Input[str]] = None,
            remote_administration_endpoint: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            self_managed_active_directory: Optional[pulumi.Input[Union['WindowsFileSystemSelfManagedActiveDirectoryArgs', 'WindowsFileSystemSelfManagedActiveDirectoryArgsDict']]] = None,
            skip_final_backup: Optional[pulumi.Input[bool]] = None,
            storage_capacity: Optional[pulumi.Input[int]] = None,
            storage_type: Optional[pulumi.Input[str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            throughput_capacity: Optional[pulumi.Input[int]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None) -> 'WindowsFileSystem':
        """
        Get an existing WindowsFileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] active_directory_id: The ID for an existing Microsoft Active Directory instance that the file system should join when it's created. Cannot be specified with `self_managed_active_directory`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
        :param pulumi.Input[str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input[Union['WindowsFileSystemAuditLogConfigurationArgs', 'WindowsFileSystemAuditLogConfigurationArgsDict']] audit_log_configuration: The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See `audit_log_configuration` Block for details.
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
        :param pulumi.Input[str] backup_id: The ID of the source backup to create the filesystem from.
        :param pulumi.Input[bool] copy_tags_to_backups: A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
        :param pulumi.Input[str] daily_automatic_backup_start_time: The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
        :param pulumi.Input[str] deployment_type: Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
        :param pulumi.Input[Union['WindowsFileSystemDiskIopsConfigurationArgs', 'WindowsFileSystemDiskIopsConfigurationArgsDict']] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See `disk_iops_configuration` Block for details.
        :param pulumi.Input[str] dns_name: DNS name for the file system, e.g., `fs-12345678.corp.example.com` (domain name matching the Active Directory domain name)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] final_backup_tags: A map of tags to apply to the file system's final backup.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_ids: Set of Elastic Network Interface identifiers from which the file system is accessible.
        :param pulumi.Input[str] owner_id: AWS account identifier that created the file system.
        :param pulumi.Input[str] preferred_file_server_ip: The IP address of the primary, or preferred, file server.
        :param pulumi.Input[str] preferred_subnet_id: Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
        :param pulumi.Input[str] remote_administration_endpoint: For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell. For `SINGLE_AZ_1` deployment types, this is the DNS name of the file system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input[Union['WindowsFileSystemSelfManagedActiveDirectoryArgs', 'WindowsFileSystemSelfManagedActiveDirectoryArgsDict']] self_managed_active_directory: Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See `self_managed_active_directory` Block for details.
        :param pulumi.Input[bool] skip_final_backup: When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[int] storage_capacity: Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
        :param pulumi.Input[str] storage_type: Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[int] throughput_capacity: Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
               
               The following arguments are optional:
        :param pulumi.Input[str] vpc_id: Identifier of the Virtual Private Cloud for the file system.
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WindowsFileSystemState.__new__(_WindowsFileSystemState)

        __props__.__dict__["active_directory_id"] = active_directory_id
        __props__.__dict__["aliases"] = aliases
        __props__.__dict__["arn"] = arn
        __props__.__dict__["audit_log_configuration"] = audit_log_configuration
        __props__.__dict__["automatic_backup_retention_days"] = automatic_backup_retention_days
        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["copy_tags_to_backups"] = copy_tags_to_backups
        __props__.__dict__["daily_automatic_backup_start_time"] = daily_automatic_backup_start_time
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["disk_iops_configuration"] = disk_iops_configuration
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["final_backup_tags"] = final_backup_tags
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["network_interface_ids"] = network_interface_ids
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["preferred_file_server_ip"] = preferred_file_server_ip
        __props__.__dict__["preferred_subnet_id"] = preferred_subnet_id
        __props__.__dict__["remote_administration_endpoint"] = remote_administration_endpoint
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["self_managed_active_directory"] = self_managed_active_directory
        __props__.__dict__["skip_final_backup"] = skip_final_backup
        __props__.__dict__["storage_capacity"] = storage_capacity
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["throughput_capacity"] = throughput_capacity
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["weekly_maintenance_start_time"] = weekly_maintenance_start_time
        return WindowsFileSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeDirectoryId")
    def active_directory_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID for an existing Microsoft Active Directory instance that the file system should join when it's created. Cannot be specified with `self_managed_active_directory`.
        """
        return pulumi.get(self, "active_directory_id")

    @property
    @pulumi.getter
    def aliases(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="auditLogConfiguration")
    def audit_log_configuration(self) -> pulumi.Output['outputs.WindowsFileSystemAuditLogConfiguration']:
        """
        The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See `audit_log_configuration` Block for details.
        """
        return pulumi.get(self, "audit_log_configuration")

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> pulumi.Output[Optional[int]]:
        """
        The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
        """
        return pulumi.get(self, "automatic_backup_retention_days")

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the source backup to create the filesystem from.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
        """
        return pulumi.get(self, "copy_tags_to_backups")

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> pulumi.Output[str]:
        """
        The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
        """
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> pulumi.Output['outputs.WindowsFileSystemDiskIopsConfiguration']:
        """
        The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See `disk_iops_configuration` Block for details.
        """
        return pulumi.get(self, "disk_iops_configuration")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        DNS name for the file system, e.g., `fs-12345678.corp.example.com` (domain name matching the Active Directory domain name)
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="finalBackupTags")
    def final_backup_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to apply to the file system's final backup.
        """
        return pulumi.get(self, "final_backup_tags")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of Elastic Network Interface identifiers from which the file system is accessible.
        """
        return pulumi.get(self, "network_interface_ids")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        AWS account identifier that created the file system.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="preferredFileServerIp")
    def preferred_file_server_ip(self) -> pulumi.Output[str]:
        """
        The IP address of the primary, or preferred, file server.
        """
        return pulumi.get(self, "preferred_file_server_ip")

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
        """
        return pulumi.get(self, "preferred_subnet_id")

    @property
    @pulumi.getter(name="remoteAdministrationEndpoint")
    def remote_administration_endpoint(self) -> pulumi.Output[str]:
        """
        For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell. For `SINGLE_AZ_1` deployment types, this is the DNS name of the file system.
        """
        return pulumi.get(self, "remote_administration_endpoint")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="selfManagedActiveDirectory")
    def self_managed_active_directory(self) -> pulumi.Output[Optional['outputs.WindowsFileSystemSelfManagedActiveDirectory']]:
        """
        Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See `self_managed_active_directory` Block for details.
        """
        return pulumi.get(self, "self_managed_active_directory")

    @property
    @pulumi.getter(name="skipFinalBackup")
    def skip_final_backup(self) -> pulumi.Output[Optional[bool]]:
        """
        When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "skip_final_backup")

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> pulumi.Output[int]:
        """
        Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
        """
        return pulumi.get(self, "storage_capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> pulumi.Output[int]:
        """
        Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.

        The following arguments are optional:
        """
        return pulumi.get(self, "throughput_capacity")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Identifier of the Virtual Private Cloud for the file system.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> pulumi.Output[str]:
        """
        The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")

