# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GameServerGroupArgs', 'GameServerGroup']

@pulumi.input_type
class GameServerGroupArgs:
    def __init__(__self__, *,
                 game_server_group_name: pulumi.Input[str],
                 instance_definitions: pulumi.Input[Sequence[pulumi.Input['GameServerGroupInstanceDefinitionArgs']]],
                 launch_template: pulumi.Input['GameServerGroupLaunchTemplateArgs'],
                 max_size: pulumi.Input[int],
                 min_size: pulumi.Input[int],
                 role_arn: pulumi.Input[str],
                 auto_scaling_policy: Optional[pulumi.Input['GameServerGroupAutoScalingPolicyArgs']] = None,
                 balancing_strategy: Optional[pulumi.Input[str]] = None,
                 game_server_protection_policy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a GameServerGroup resource.
        :param pulumi.Input[str] game_server_group_name: Name of the game server group.
               This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
        :param pulumi.Input[int] max_size: The maximum number of instances allowed in the EC2 Auto Scaling group.
               During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
        :param pulumi.Input[int] min_size: The minimum number of instances allowed in the EC2 Auto Scaling group.
               During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
        :param pulumi.Input[str] role_arn: ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
        :param pulumi.Input[str] balancing_strategy: Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
               Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
        :param pulumi.Input[str] game_server_protection_policy: Indicates whether instances in the game server group are protected from early termination.
               Unprotected instances that have active game servers running might be terminated during a scale-down event,
               causing players to be dropped from the game.
               Protected instances cannot be terminated while there are active game servers running except in the event
               of a forced game server group deletion.
               Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_subnets: A list of VPC subnets to use with instances in the game server group.
               By default, all GameLift FleetIQ-supported Availability Zones are used.
        """
        pulumi.set(__self__, "game_server_group_name", game_server_group_name)
        pulumi.set(__self__, "instance_definitions", instance_definitions)
        pulumi.set(__self__, "launch_template", launch_template)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "role_arn", role_arn)
        if auto_scaling_policy is not None:
            pulumi.set(__self__, "auto_scaling_policy", auto_scaling_policy)
        if balancing_strategy is not None:
            pulumi.set(__self__, "balancing_strategy", balancing_strategy)
        if game_server_protection_policy is not None:
            pulumi.set(__self__, "game_server_protection_policy", game_server_protection_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_subnets is not None:
            pulumi.set(__self__, "vpc_subnets", vpc_subnets)

    @property
    @pulumi.getter(name="gameServerGroupName")
    def game_server_group_name(self) -> pulumi.Input[str]:
        """
        Name of the game server group.
        This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
        """
        return pulumi.get(self, "game_server_group_name")

    @game_server_group_name.setter
    def game_server_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "game_server_group_name", value)

    @property
    @pulumi.getter(name="instanceDefinitions")
    def instance_definitions(self) -> pulumi.Input[Sequence[pulumi.Input['GameServerGroupInstanceDefinitionArgs']]]:
        return pulumi.get(self, "instance_definitions")

    @instance_definitions.setter
    def instance_definitions(self, value: pulumi.Input[Sequence[pulumi.Input['GameServerGroupInstanceDefinitionArgs']]]):
        pulumi.set(self, "instance_definitions", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Input['GameServerGroupLaunchTemplateArgs']:
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: pulumi.Input['GameServerGroupLaunchTemplateArgs']):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Input[int]:
        """
        The maximum number of instances allowed in the EC2 Auto Scaling group.
        During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Input[int]:
        """
        The minimum number of instances allowed in the EC2 Auto Scaling group.
        During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="autoScalingPolicy")
    def auto_scaling_policy(self) -> Optional[pulumi.Input['GameServerGroupAutoScalingPolicyArgs']]:
        return pulumi.get(self, "auto_scaling_policy")

    @auto_scaling_policy.setter
    def auto_scaling_policy(self, value: Optional[pulumi.Input['GameServerGroupAutoScalingPolicyArgs']]):
        pulumi.set(self, "auto_scaling_policy", value)

    @property
    @pulumi.getter(name="balancingStrategy")
    def balancing_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
        Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
        """
        return pulumi.get(self, "balancing_strategy")

    @balancing_strategy.setter
    def balancing_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "balancing_strategy", value)

    @property
    @pulumi.getter(name="gameServerProtectionPolicy")
    def game_server_protection_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether instances in the game server group are protected from early termination.
        Unprotected instances that have active game servers running might be terminated during a scale-down event,
        causing players to be dropped from the game.
        Protected instances cannot be terminated while there are active game servers running except in the event
        of a forced game server group deletion.
        Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
        """
        return pulumi.get(self, "game_server_protection_policy")

    @game_server_protection_policy.setter
    def game_server_protection_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "game_server_protection_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcSubnets")
    def vpc_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of VPC subnets to use with instances in the game server group.
        By default, all GameLift FleetIQ-supported Availability Zones are used.
        """
        return pulumi.get(self, "vpc_subnets")

    @vpc_subnets.setter
    def vpc_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_subnets", value)


@pulumi.input_type
class _GameServerGroupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_scaling_group_arn: Optional[pulumi.Input[str]] = None,
                 auto_scaling_policy: Optional[pulumi.Input['GameServerGroupAutoScalingPolicyArgs']] = None,
                 balancing_strategy: Optional[pulumi.Input[str]] = None,
                 game_server_group_name: Optional[pulumi.Input[str]] = None,
                 game_server_protection_policy: Optional[pulumi.Input[str]] = None,
                 instance_definitions: Optional[pulumi.Input[Sequence[pulumi.Input['GameServerGroupInstanceDefinitionArgs']]]] = None,
                 launch_template: Optional[pulumi.Input['GameServerGroupLaunchTemplateArgs']] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering GameServerGroup resources.
        :param pulumi.Input[str] arn: The ARN of the GameLift Game Server Group.
        :param pulumi.Input[str] auto_scaling_group_arn: The ARN of the created EC2 Auto Scaling group.
        :param pulumi.Input[str] balancing_strategy: Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
               Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
        :param pulumi.Input[str] game_server_group_name: Name of the game server group.
               This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
        :param pulumi.Input[str] game_server_protection_policy: Indicates whether instances in the game server group are protected from early termination.
               Unprotected instances that have active game servers running might be terminated during a scale-down event,
               causing players to be dropped from the game.
               Protected instances cannot be terminated while there are active game servers running except in the event
               of a forced game server group deletion.
               Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
        :param pulumi.Input[int] max_size: The maximum number of instances allowed in the EC2 Auto Scaling group.
               During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
        :param pulumi.Input[int] min_size: The minimum number of instances allowed in the EC2 Auto Scaling group.
               During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
        :param pulumi.Input[str] role_arn: ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_subnets: A list of VPC subnets to use with instances in the game server group.
               By default, all GameLift FleetIQ-supported Availability Zones are used.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_scaling_group_arn is not None:
            pulumi.set(__self__, "auto_scaling_group_arn", auto_scaling_group_arn)
        if auto_scaling_policy is not None:
            pulumi.set(__self__, "auto_scaling_policy", auto_scaling_policy)
        if balancing_strategy is not None:
            pulumi.set(__self__, "balancing_strategy", balancing_strategy)
        if game_server_group_name is not None:
            pulumi.set(__self__, "game_server_group_name", game_server_group_name)
        if game_server_protection_policy is not None:
            pulumi.set(__self__, "game_server_protection_policy", game_server_protection_policy)
        if instance_definitions is not None:
            pulumi.set(__self__, "instance_definitions", instance_definitions)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_subnets is not None:
            pulumi.set(__self__, "vpc_subnets", vpc_subnets)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the GameLift Game Server Group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoScalingGroupArn")
    def auto_scaling_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the created EC2 Auto Scaling group.
        """
        return pulumi.get(self, "auto_scaling_group_arn")

    @auto_scaling_group_arn.setter
    def auto_scaling_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_scaling_group_arn", value)

    @property
    @pulumi.getter(name="autoScalingPolicy")
    def auto_scaling_policy(self) -> Optional[pulumi.Input['GameServerGroupAutoScalingPolicyArgs']]:
        return pulumi.get(self, "auto_scaling_policy")

    @auto_scaling_policy.setter
    def auto_scaling_policy(self, value: Optional[pulumi.Input['GameServerGroupAutoScalingPolicyArgs']]):
        pulumi.set(self, "auto_scaling_policy", value)

    @property
    @pulumi.getter(name="balancingStrategy")
    def balancing_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
        Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
        """
        return pulumi.get(self, "balancing_strategy")

    @balancing_strategy.setter
    def balancing_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "balancing_strategy", value)

    @property
    @pulumi.getter(name="gameServerGroupName")
    def game_server_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the game server group.
        This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
        """
        return pulumi.get(self, "game_server_group_name")

    @game_server_group_name.setter
    def game_server_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "game_server_group_name", value)

    @property
    @pulumi.getter(name="gameServerProtectionPolicy")
    def game_server_protection_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether instances in the game server group are protected from early termination.
        Unprotected instances that have active game servers running might be terminated during a scale-down event,
        causing players to be dropped from the game.
        Protected instances cannot be terminated while there are active game servers running except in the event
        of a forced game server group deletion.
        Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
        """
        return pulumi.get(self, "game_server_protection_policy")

    @game_server_protection_policy.setter
    def game_server_protection_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "game_server_protection_policy", value)

    @property
    @pulumi.getter(name="instanceDefinitions")
    def instance_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GameServerGroupInstanceDefinitionArgs']]]]:
        return pulumi.get(self, "instance_definitions")

    @instance_definitions.setter
    def instance_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GameServerGroupInstanceDefinitionArgs']]]]):
        pulumi.set(self, "instance_definitions", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['GameServerGroupLaunchTemplateArgs']]:
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['GameServerGroupLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of instances allowed in the EC2 Auto Scaling group.
        During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of instances allowed in the EC2 Auto Scaling group.
        During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="vpcSubnets")
    def vpc_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of VPC subnets to use with instances in the game server group.
        By default, all GameLift FleetIQ-supported Availability Zones are used.
        """
        return pulumi.get(self, "vpc_subnets")

    @vpc_subnets.setter
    def vpc_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_subnets", value)


class GameServerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_policy: Optional[pulumi.Input[Union['GameServerGroupAutoScalingPolicyArgs', 'GameServerGroupAutoScalingPolicyArgsDict']]] = None,
                 balancing_strategy: Optional[pulumi.Input[str]] = None,
                 game_server_group_name: Optional[pulumi.Input[str]] = None,
                 game_server_protection_policy: Optional[pulumi.Input[str]] = None,
                 instance_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GameServerGroupInstanceDefinitionArgs', 'GameServerGroupInstanceDefinitionArgsDict']]]]] = None,
                 launch_template: Optional[pulumi.Input[Union['GameServerGroupLaunchTemplateArgs', 'GameServerGroupLaunchTemplateArgsDict']]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides an GameLift Game Server Group resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.gamelift.GameServerGroup("example",
            game_server_group_name="example",
            instance_definitions=[
                {
                    "instance_type": "c5.large",
                },
                {
                    "instance_type": "c5a.large",
                },
            ],
            launch_template={
                "id": example_aws_launch_template["id"],
            },
            max_size=1,
            min_size=1,
            role_arn=example_aws_iam_role["arn"],
            opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy_attachment]))
        ```

        Full usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.gamelift.GameServerGroup("example",
            auto_scaling_policy={
                "estimated_instance_warmup": 60,
                "target_tracking_configuration": {
                    "target_value": 75,
                },
            },
            balancing_strategy="SPOT_ONLY",
            game_server_group_name="example",
            game_server_protection_policy="FULL_PROTECTION",
            instance_definitions=[
                {
                    "instance_type": "c5.large",
                    "weighted_capacity": "1",
                },
                {
                    "instance_type": "c5.2xlarge",
                    "weighted_capacity": "2",
                },
            ],
            launch_template={
                "id": example_aws_launch_template["id"],
                "version": "1",
            },
            max_size=1,
            min_size=1,
            role_arn=example_aws_iam_role["arn"],
            tags={
                "Name": "example",
            },
            vpc_subnets=[
                "subnet-12345678",
                "subnet-23456789",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy_attachment]))
        ```

        ### Example IAM Role for GameLift Game Server Group

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_partition()
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": [
                    "autoscaling.amazonaws.com",
                    "gamelift.amazonaws.com",
                ],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example = aws.iam.Role("example",
            assume_role_policy=assume_role.json,
            name="gamelift-game-server-group-example")
        example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
            policy_arn=f"arn:{current.partition}:iam::aws:policy/GameLiftGameServerGroupPolicy",
            role=example.name)
        ```

        ## Import

        Using `pulumi import`, import GameLift Game Server Group using the `name`. For example:

        ```sh
        $ pulumi import aws:gamelift/gameServerGroup:GameServerGroup example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] balancing_strategy: Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
               Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
        :param pulumi.Input[str] game_server_group_name: Name of the game server group.
               This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
        :param pulumi.Input[str] game_server_protection_policy: Indicates whether instances in the game server group are protected from early termination.
               Unprotected instances that have active game servers running might be terminated during a scale-down event,
               causing players to be dropped from the game.
               Protected instances cannot be terminated while there are active game servers running except in the event
               of a forced game server group deletion.
               Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
        :param pulumi.Input[int] max_size: The maximum number of instances allowed in the EC2 Auto Scaling group.
               During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
        :param pulumi.Input[int] min_size: The minimum number of instances allowed in the EC2 Auto Scaling group.
               During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
        :param pulumi.Input[str] role_arn: ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_subnets: A list of VPC subnets to use with instances in the game server group.
               By default, all GameLift FleetIQ-supported Availability Zones are used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GameServerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an GameLift Game Server Group resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.gamelift.GameServerGroup("example",
            game_server_group_name="example",
            instance_definitions=[
                {
                    "instance_type": "c5.large",
                },
                {
                    "instance_type": "c5a.large",
                },
            ],
            launch_template={
                "id": example_aws_launch_template["id"],
            },
            max_size=1,
            min_size=1,
            role_arn=example_aws_iam_role["arn"],
            opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy_attachment]))
        ```

        Full usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.gamelift.GameServerGroup("example",
            auto_scaling_policy={
                "estimated_instance_warmup": 60,
                "target_tracking_configuration": {
                    "target_value": 75,
                },
            },
            balancing_strategy="SPOT_ONLY",
            game_server_group_name="example",
            game_server_protection_policy="FULL_PROTECTION",
            instance_definitions=[
                {
                    "instance_type": "c5.large",
                    "weighted_capacity": "1",
                },
                {
                    "instance_type": "c5.2xlarge",
                    "weighted_capacity": "2",
                },
            ],
            launch_template={
                "id": example_aws_launch_template["id"],
                "version": "1",
            },
            max_size=1,
            min_size=1,
            role_arn=example_aws_iam_role["arn"],
            tags={
                "Name": "example",
            },
            vpc_subnets=[
                "subnet-12345678",
                "subnet-23456789",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy_attachment]))
        ```

        ### Example IAM Role for GameLift Game Server Group

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_partition()
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": [
                    "autoscaling.amazonaws.com",
                    "gamelift.amazonaws.com",
                ],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example = aws.iam.Role("example",
            assume_role_policy=assume_role.json,
            name="gamelift-game-server-group-example")
        example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
            policy_arn=f"arn:{current.partition}:iam::aws:policy/GameLiftGameServerGroupPolicy",
            role=example.name)
        ```

        ## Import

        Using `pulumi import`, import GameLift Game Server Group using the `name`. For example:

        ```sh
        $ pulumi import aws:gamelift/gameServerGroup:GameServerGroup example example
        ```

        :param str resource_name: The name of the resource.
        :param GameServerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GameServerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_policy: Optional[pulumi.Input[Union['GameServerGroupAutoScalingPolicyArgs', 'GameServerGroupAutoScalingPolicyArgsDict']]] = None,
                 balancing_strategy: Optional[pulumi.Input[str]] = None,
                 game_server_group_name: Optional[pulumi.Input[str]] = None,
                 game_server_protection_policy: Optional[pulumi.Input[str]] = None,
                 instance_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GameServerGroupInstanceDefinitionArgs', 'GameServerGroupInstanceDefinitionArgsDict']]]]] = None,
                 launch_template: Optional[pulumi.Input[Union['GameServerGroupLaunchTemplateArgs', 'GameServerGroupLaunchTemplateArgsDict']]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GameServerGroupArgs.__new__(GameServerGroupArgs)

            __props__.__dict__["auto_scaling_policy"] = auto_scaling_policy
            __props__.__dict__["balancing_strategy"] = balancing_strategy
            if game_server_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'game_server_group_name'")
            __props__.__dict__["game_server_group_name"] = game_server_group_name
            __props__.__dict__["game_server_protection_policy"] = game_server_protection_policy
            if instance_definitions is None and not opts.urn:
                raise TypeError("Missing required property 'instance_definitions'")
            __props__.__dict__["instance_definitions"] = instance_definitions
            if launch_template is None and not opts.urn:
                raise TypeError("Missing required property 'launch_template'")
            __props__.__dict__["launch_template"] = launch_template
            if max_size is None and not opts.urn:
                raise TypeError("Missing required property 'max_size'")
            __props__.__dict__["max_size"] = max_size
            if min_size is None and not opts.urn:
                raise TypeError("Missing required property 'min_size'")
            __props__.__dict__["min_size"] = min_size
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_subnets"] = vpc_subnets
            __props__.__dict__["arn"] = None
            __props__.__dict__["auto_scaling_group_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(GameServerGroup, __self__).__init__(
            'aws:gamelift/gameServerGroup:GameServerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_scaling_group_arn: Optional[pulumi.Input[str]] = None,
            auto_scaling_policy: Optional[pulumi.Input[Union['GameServerGroupAutoScalingPolicyArgs', 'GameServerGroupAutoScalingPolicyArgsDict']]] = None,
            balancing_strategy: Optional[pulumi.Input[str]] = None,
            game_server_group_name: Optional[pulumi.Input[str]] = None,
            game_server_protection_policy: Optional[pulumi.Input[str]] = None,
            instance_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GameServerGroupInstanceDefinitionArgs', 'GameServerGroupInstanceDefinitionArgsDict']]]]] = None,
            launch_template: Optional[pulumi.Input[Union['GameServerGroupLaunchTemplateArgs', 'GameServerGroupLaunchTemplateArgsDict']]] = None,
            max_size: Optional[pulumi.Input[int]] = None,
            min_size: Optional[pulumi.Input[int]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'GameServerGroup':
        """
        Get an existing GameServerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the GameLift Game Server Group.
        :param pulumi.Input[str] auto_scaling_group_arn: The ARN of the created EC2 Auto Scaling group.
        :param pulumi.Input[str] balancing_strategy: Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
               Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
        :param pulumi.Input[str] game_server_group_name: Name of the game server group.
               This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
        :param pulumi.Input[str] game_server_protection_policy: Indicates whether instances in the game server group are protected from early termination.
               Unprotected instances that have active game servers running might be terminated during a scale-down event,
               causing players to be dropped from the game.
               Protected instances cannot be terminated while there are active game servers running except in the event
               of a forced game server group deletion.
               Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
        :param pulumi.Input[int] max_size: The maximum number of instances allowed in the EC2 Auto Scaling group.
               During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
        :param pulumi.Input[int] min_size: The minimum number of instances allowed in the EC2 Auto Scaling group.
               During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
        :param pulumi.Input[str] role_arn: ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_subnets: A list of VPC subnets to use with instances in the game server group.
               By default, all GameLift FleetIQ-supported Availability Zones are used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GameServerGroupState.__new__(_GameServerGroupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_scaling_group_arn"] = auto_scaling_group_arn
        __props__.__dict__["auto_scaling_policy"] = auto_scaling_policy
        __props__.__dict__["balancing_strategy"] = balancing_strategy
        __props__.__dict__["game_server_group_name"] = game_server_group_name
        __props__.__dict__["game_server_protection_policy"] = game_server_protection_policy
        __props__.__dict__["instance_definitions"] = instance_definitions
        __props__.__dict__["launch_template"] = launch_template
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_subnets"] = vpc_subnets
        return GameServerGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the GameLift Game Server Group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoScalingGroupArn")
    def auto_scaling_group_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the created EC2 Auto Scaling group.
        """
        return pulumi.get(self, "auto_scaling_group_arn")

    @property
    @pulumi.getter(name="autoScalingPolicy")
    def auto_scaling_policy(self) -> pulumi.Output[Optional['outputs.GameServerGroupAutoScalingPolicy']]:
        return pulumi.get(self, "auto_scaling_policy")

    @property
    @pulumi.getter(name="balancingStrategy")
    def balancing_strategy(self) -> pulumi.Output[str]:
        """
        Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
        Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
        """
        return pulumi.get(self, "balancing_strategy")

    @property
    @pulumi.getter(name="gameServerGroupName")
    def game_server_group_name(self) -> pulumi.Output[str]:
        """
        Name of the game server group.
        This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
        """
        return pulumi.get(self, "game_server_group_name")

    @property
    @pulumi.getter(name="gameServerProtectionPolicy")
    def game_server_protection_policy(self) -> pulumi.Output[str]:
        """
        Indicates whether instances in the game server group are protected from early termination.
        Unprotected instances that have active game servers running might be terminated during a scale-down event,
        causing players to be dropped from the game.
        Protected instances cannot be terminated while there are active game servers running except in the event
        of a forced game server group deletion.
        Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
        """
        return pulumi.get(self, "game_server_protection_policy")

    @property
    @pulumi.getter(name="instanceDefinitions")
    def instance_definitions(self) -> pulumi.Output[Sequence['outputs.GameServerGroupInstanceDefinition']]:
        return pulumi.get(self, "instance_definitions")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Output['outputs.GameServerGroupLaunchTemplate']:
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[int]:
        """
        The maximum number of instances allowed in the EC2 Auto Scaling group.
        During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[int]:
        """
        The minimum number of instances allowed in the EC2 Auto Scaling group.
        During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="vpcSubnets")
    def vpc_subnets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of VPC subnets to use with instances in the game server group.
        By default, all GameLift FleetIQ-supported Availability Zones are used.
        """
        return pulumi.get(self, "vpc_subnets")

