# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAcceleratorResult',
    'AwaitableGetAcceleratorResult',
    'get_accelerator',
    'get_accelerator_output',
]

@pulumi.output_type
class GetAcceleratorResult:
    """
    A collection of values returned by getAccelerator.
    """
    def __init__(__self__, arn=None, attributes=None, dns_name=None, dual_stack_dns_name=None, enabled=None, hosted_zone_id=None, id=None, ip_address_type=None, ip_sets=None, name=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if attributes and not isinstance(attributes, list):
            raise TypeError("Expected argument 'attributes' to be a list")
        pulumi.set(__self__, "attributes", attributes)
        if dns_name and not isinstance(dns_name, str):
            raise TypeError("Expected argument 'dns_name' to be a str")
        pulumi.set(__self__, "dns_name", dns_name)
        if dual_stack_dns_name and not isinstance(dual_stack_dns_name, str):
            raise TypeError("Expected argument 'dual_stack_dns_name' to be a str")
        pulumi.set(__self__, "dual_stack_dns_name", dual_stack_dns_name)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if hosted_zone_id and not isinstance(hosted_zone_id, str):
            raise TypeError("Expected argument 'hosted_zone_id' to be a str")
        pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address_type and not isinstance(ip_address_type, str):
            raise TypeError("Expected argument 'ip_address_type' to be a str")
        pulumi.set(__self__, "ip_address_type", ip_address_type)
        if ip_sets and not isinstance(ip_sets, list):
            raise TypeError("Expected argument 'ip_sets' to be a list")
        pulumi.set(__self__, "ip_sets", ip_sets)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def attributes(self) -> Sequence['outputs.GetAcceleratorAttributeResult']:
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> str:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="dualStackDnsName")
    def dual_stack_dns_name(self) -> str:
        return pulumi.get(self, "dual_stack_dns_name")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> str:
        return pulumi.get(self, "hosted_zone_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> str:
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="ipSets")
    def ip_sets(self) -> Sequence['outputs.GetAcceleratorIpSetResult']:
        return pulumi.get(self, "ip_sets")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")


class AwaitableGetAcceleratorResult(GetAcceleratorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAcceleratorResult(
            arn=self.arn,
            attributes=self.attributes,
            dns_name=self.dns_name,
            dual_stack_dns_name=self.dual_stack_dns_name,
            enabled=self.enabled,
            hosted_zone_id=self.hosted_zone_id,
            id=self.id,
            ip_address_type=self.ip_address_type,
            ip_sets=self.ip_sets,
            name=self.name,
            tags=self.tags)


def get_accelerator(arn: Optional[str] = None,
                    id: Optional[str] = None,
                    name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAcceleratorResult:
    """
    Provides information about a Global Accelerator accelerator.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    accelerator_arn = config.get("acceleratorArn")
    if accelerator_arn is None:
        accelerator_arn = ""
    accelerator_name = config.get("acceleratorName")
    if accelerator_name is None:
        accelerator_name = ""
    example = aws.globalaccelerator.get_accelerator(arn=accelerator_arn,
        name=accelerator_name)
    ```


    :param str arn: Full ARN of the Global Accelerator.
    :param str name: Unique name of the Global Accelerator.
           
           > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:globalaccelerator/getAccelerator:getAccelerator', __args__, opts=opts, typ=GetAcceleratorResult).value

    return AwaitableGetAcceleratorResult(
        arn=pulumi.get(__ret__, 'arn'),
        attributes=pulumi.get(__ret__, 'attributes'),
        dns_name=pulumi.get(__ret__, 'dns_name'),
        dual_stack_dns_name=pulumi.get(__ret__, 'dual_stack_dns_name'),
        enabled=pulumi.get(__ret__, 'enabled'),
        hosted_zone_id=pulumi.get(__ret__, 'hosted_zone_id'),
        id=pulumi.get(__ret__, 'id'),
        ip_address_type=pulumi.get(__ret__, 'ip_address_type'),
        ip_sets=pulumi.get(__ret__, 'ip_sets'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_accelerator_output(arn: Optional[pulumi.Input[Optional[str]]] = None,
                           id: Optional[pulumi.Input[Optional[str]]] = None,
                           name: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAcceleratorResult]:
    """
    Provides information about a Global Accelerator accelerator.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    accelerator_arn = config.get("acceleratorArn")
    if accelerator_arn is None:
        accelerator_arn = ""
    accelerator_name = config.get("acceleratorName")
    if accelerator_name is None:
        accelerator_name = ""
    example = aws.globalaccelerator.get_accelerator(arn=accelerator_arn,
        name=accelerator_name)
    ```


    :param str arn: Full ARN of the Global Accelerator.
    :param str name: Unique name of the Global Accelerator.
           
           > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:globalaccelerator/getAccelerator:getAccelerator', __args__, opts=opts, typ=GetAcceleratorResult)
    return __ret__.apply(lambda __response__: GetAcceleratorResult(
        arn=pulumi.get(__response__, 'arn'),
        attributes=pulumi.get(__response__, 'attributes'),
        dns_name=pulumi.get(__response__, 'dns_name'),
        dual_stack_dns_name=pulumi.get(__response__, 'dual_stack_dns_name'),
        enabled=pulumi.get(__response__, 'enabled'),
        hosted_zone_id=pulumi.get(__response__, 'hosted_zone_id'),
        id=pulumi.get(__response__, 'id'),
        ip_address_type=pulumi.get(__response__, 'ip_address_type'),
        ip_sets=pulumi.get(__response__, 'ip_sets'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags')))
