# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CrawlerArgs', 'Crawler']

@pulumi.input_type
class CrawlerArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 role: pulumi.Input[str],
                 catalog_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]]] = None,
                 classifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 configuration: Optional[pulumi.Input[str]] = None,
                 delta_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodb_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDynamodbTargetArgs']]]] = None,
                 hudi_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerHudiTargetArgs']]]] = None,
                 iceberg_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]]] = None,
                 jdbc_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]]] = None,
                 lake_formation_configuration: Optional[pulumi.Input['CrawlerLakeFormationConfigurationArgs']] = None,
                 lineage_configuration: Optional[pulumi.Input['CrawlerLineageConfigurationArgs']] = None,
                 mongodb_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerMongodbTargetArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 recrawl_policy: Optional[pulumi.Input['CrawlerRecrawlPolicyArgs']] = None,
                 s3_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 schema_change_policy: Optional[pulumi.Input['CrawlerSchemaChangePolicyArgs']] = None,
                 security_configuration: Optional[pulumi.Input[str]] = None,
                 table_prefix: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Crawler resource.
        :param pulumi.Input[str] database_name: Glue database where results are written.
        :param pulumi.Input[str] role: The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]] catalog_targets: List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] classifiers: List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
        :param pulumi.Input[str] configuration: JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]] delta_targets: List of nested Delta Lake target arguments. See Delta Target below.
        :param pulumi.Input[str] description: Description of the crawler.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerDynamodbTargetArgs']]] dynamodb_targets: List of nested DynamoDB target arguments. See Dynamodb Target below.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerHudiTargetArgs']]] hudi_targets: List of nested Hudi target arguments. See Iceberg Target below.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]] iceberg_targets: List of nested Iceberg target arguments. See Iceberg Target below.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]] jdbc_targets: List of nested JDBC target arguments. See JDBC Target below.
        :param pulumi.Input['CrawlerLakeFormationConfigurationArgs'] lake_formation_configuration: Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
        :param pulumi.Input['CrawlerLineageConfigurationArgs'] lineage_configuration: Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerMongodbTargetArgs']]] mongodb_targets: List of nested MongoDB target arguments. See MongoDB Target below.
        :param pulumi.Input[str] name: Name of the crawler.
        :param pulumi.Input['CrawlerRecrawlPolicyArgs'] recrawl_policy: A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]] s3_targets: List of nested Amazon S3 target arguments. See S3 Target below.
        :param pulumi.Input[str] schedule: A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
        :param pulumi.Input['CrawlerSchemaChangePolicyArgs'] schema_change_policy: Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
        :param pulumi.Input[str] security_configuration: The name of Security Configuration to be used by the crawler
        :param pulumi.Input[str] table_prefix: The table prefix used for catalog tables that are created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "role", role)
        if catalog_targets is not None:
            pulumi.set(__self__, "catalog_targets", catalog_targets)
        if classifiers is not None:
            pulumi.set(__self__, "classifiers", classifiers)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if delta_targets is not None:
            pulumi.set(__self__, "delta_targets", delta_targets)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamodb_targets is not None:
            pulumi.set(__self__, "dynamodb_targets", dynamodb_targets)
        if hudi_targets is not None:
            pulumi.set(__self__, "hudi_targets", hudi_targets)
        if iceberg_targets is not None:
            pulumi.set(__self__, "iceberg_targets", iceberg_targets)
        if jdbc_targets is not None:
            pulumi.set(__self__, "jdbc_targets", jdbc_targets)
        if lake_formation_configuration is not None:
            pulumi.set(__self__, "lake_formation_configuration", lake_formation_configuration)
        if lineage_configuration is not None:
            pulumi.set(__self__, "lineage_configuration", lineage_configuration)
        if mongodb_targets is not None:
            pulumi.set(__self__, "mongodb_targets", mongodb_targets)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recrawl_policy is not None:
            pulumi.set(__self__, "recrawl_policy", recrawl_policy)
        if s3_targets is not None:
            pulumi.set(__self__, "s3_targets", s3_targets)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if schema_change_policy is not None:
            pulumi.set(__self__, "schema_change_policy", schema_change_policy)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if table_prefix is not None:
            pulumi.set(__self__, "table_prefix", table_prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        Glue database where results are written.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="catalogTargets")
    def catalog_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]]]:
        """
        List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
        """
        return pulumi.get(self, "catalog_targets")

    @catalog_targets.setter
    def catalog_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]]]):
        pulumi.set(self, "catalog_targets", value)

    @property
    @pulumi.getter
    def classifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
        """
        return pulumi.get(self, "classifiers")

    @classifiers.setter
    def classifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "classifiers", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[str]]:
        """
        JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="deltaTargets")
    def delta_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]]]:
        """
        List of nested Delta Lake target arguments. See Delta Target below.
        """
        return pulumi.get(self, "delta_targets")

    @delta_targets.setter
    def delta_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]]]):
        pulumi.set(self, "delta_targets", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the crawler.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dynamodbTargets")
    def dynamodb_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDynamodbTargetArgs']]]]:
        """
        List of nested DynamoDB target arguments. See Dynamodb Target below.
        """
        return pulumi.get(self, "dynamodb_targets")

    @dynamodb_targets.setter
    def dynamodb_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDynamodbTargetArgs']]]]):
        pulumi.set(self, "dynamodb_targets", value)

    @property
    @pulumi.getter(name="hudiTargets")
    def hudi_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerHudiTargetArgs']]]]:
        """
        List of nested Hudi target arguments. See Iceberg Target below.
        """
        return pulumi.get(self, "hudi_targets")

    @hudi_targets.setter
    def hudi_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerHudiTargetArgs']]]]):
        pulumi.set(self, "hudi_targets", value)

    @property
    @pulumi.getter(name="icebergTargets")
    def iceberg_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]]]:
        """
        List of nested Iceberg target arguments. See Iceberg Target below.
        """
        return pulumi.get(self, "iceberg_targets")

    @iceberg_targets.setter
    def iceberg_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]]]):
        pulumi.set(self, "iceberg_targets", value)

    @property
    @pulumi.getter(name="jdbcTargets")
    def jdbc_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]]]:
        """
        List of nested JDBC target arguments. See JDBC Target below.
        """
        return pulumi.get(self, "jdbc_targets")

    @jdbc_targets.setter
    def jdbc_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]]]):
        pulumi.set(self, "jdbc_targets", value)

    @property
    @pulumi.getter(name="lakeFormationConfiguration")
    def lake_formation_configuration(self) -> Optional[pulumi.Input['CrawlerLakeFormationConfigurationArgs']]:
        """
        Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
        """
        return pulumi.get(self, "lake_formation_configuration")

    @lake_formation_configuration.setter
    def lake_formation_configuration(self, value: Optional[pulumi.Input['CrawlerLakeFormationConfigurationArgs']]):
        pulumi.set(self, "lake_formation_configuration", value)

    @property
    @pulumi.getter(name="lineageConfiguration")
    def lineage_configuration(self) -> Optional[pulumi.Input['CrawlerLineageConfigurationArgs']]:
        """
        Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
        """
        return pulumi.get(self, "lineage_configuration")

    @lineage_configuration.setter
    def lineage_configuration(self, value: Optional[pulumi.Input['CrawlerLineageConfigurationArgs']]):
        pulumi.set(self, "lineage_configuration", value)

    @property
    @pulumi.getter(name="mongodbTargets")
    def mongodb_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerMongodbTargetArgs']]]]:
        """
        List of nested MongoDB target arguments. See MongoDB Target below.
        """
        return pulumi.get(self, "mongodb_targets")

    @mongodb_targets.setter
    def mongodb_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerMongodbTargetArgs']]]]):
        pulumi.set(self, "mongodb_targets", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the crawler.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recrawlPolicy")
    def recrawl_policy(self) -> Optional[pulumi.Input['CrawlerRecrawlPolicyArgs']]:
        """
        A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
        """
        return pulumi.get(self, "recrawl_policy")

    @recrawl_policy.setter
    def recrawl_policy(self, value: Optional[pulumi.Input['CrawlerRecrawlPolicyArgs']]):
        pulumi.set(self, "recrawl_policy", value)

    @property
    @pulumi.getter(name="s3Targets")
    def s3_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]]]:
        """
        List of nested Amazon S3 target arguments. See S3 Target below.
        """
        return pulumi.get(self, "s3_targets")

    @s3_targets.setter
    def s3_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]]]):
        pulumi.set(self, "s3_targets", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="schemaChangePolicy")
    def schema_change_policy(self) -> Optional[pulumi.Input['CrawlerSchemaChangePolicyArgs']]:
        """
        Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
        """
        return pulumi.get(self, "schema_change_policy")

    @schema_change_policy.setter
    def schema_change_policy(self, value: Optional[pulumi.Input['CrawlerSchemaChangePolicyArgs']]):
        pulumi.set(self, "schema_change_policy", value)

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        The name of Security Configuration to be used by the crawler
        """
        return pulumi.get(self, "security_configuration")

    @security_configuration.setter
    def security_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_configuration", value)

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The table prefix used for catalog tables that are created.
        """
        return pulumi.get(self, "table_prefix")

    @table_prefix.setter
    def table_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CrawlerState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 catalog_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]]] = None,
                 classifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 configuration: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 delta_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodb_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDynamodbTargetArgs']]]] = None,
                 hudi_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerHudiTargetArgs']]]] = None,
                 iceberg_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]]] = None,
                 jdbc_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]]] = None,
                 lake_formation_configuration: Optional[pulumi.Input['CrawlerLakeFormationConfigurationArgs']] = None,
                 lineage_configuration: Optional[pulumi.Input['CrawlerLineageConfigurationArgs']] = None,
                 mongodb_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerMongodbTargetArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 recrawl_policy: Optional[pulumi.Input['CrawlerRecrawlPolicyArgs']] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 s3_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 schema_change_policy: Optional[pulumi.Input['CrawlerSchemaChangePolicyArgs']] = None,
                 security_configuration: Optional[pulumi.Input[str]] = None,
                 table_prefix: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Crawler resources.
        :param pulumi.Input[str] arn: The ARN of the crawler
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]] catalog_targets: List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] classifiers: List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
        :param pulumi.Input[str] configuration: JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
        :param pulumi.Input[str] database_name: Glue database where results are written.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]] delta_targets: List of nested Delta Lake target arguments. See Delta Target below.
        :param pulumi.Input[str] description: Description of the crawler.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerDynamodbTargetArgs']]] dynamodb_targets: List of nested DynamoDB target arguments. See Dynamodb Target below.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerHudiTargetArgs']]] hudi_targets: List of nested Hudi target arguments. See Iceberg Target below.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]] iceberg_targets: List of nested Iceberg target arguments. See Iceberg Target below.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]] jdbc_targets: List of nested JDBC target arguments. See JDBC Target below.
        :param pulumi.Input['CrawlerLakeFormationConfigurationArgs'] lake_formation_configuration: Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
        :param pulumi.Input['CrawlerLineageConfigurationArgs'] lineage_configuration: Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerMongodbTargetArgs']]] mongodb_targets: List of nested MongoDB target arguments. See MongoDB Target below.
        :param pulumi.Input[str] name: Name of the crawler.
        :param pulumi.Input['CrawlerRecrawlPolicyArgs'] recrawl_policy: A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
        :param pulumi.Input[str] role: The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]] s3_targets: List of nested Amazon S3 target arguments. See S3 Target below.
        :param pulumi.Input[str] schedule: A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
        :param pulumi.Input['CrawlerSchemaChangePolicyArgs'] schema_change_policy: Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
        :param pulumi.Input[str] security_configuration: The name of Security Configuration to be used by the crawler
        :param pulumi.Input[str] table_prefix: The table prefix used for catalog tables that are created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if catalog_targets is not None:
            pulumi.set(__self__, "catalog_targets", catalog_targets)
        if classifiers is not None:
            pulumi.set(__self__, "classifiers", classifiers)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if delta_targets is not None:
            pulumi.set(__self__, "delta_targets", delta_targets)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamodb_targets is not None:
            pulumi.set(__self__, "dynamodb_targets", dynamodb_targets)
        if hudi_targets is not None:
            pulumi.set(__self__, "hudi_targets", hudi_targets)
        if iceberg_targets is not None:
            pulumi.set(__self__, "iceberg_targets", iceberg_targets)
        if jdbc_targets is not None:
            pulumi.set(__self__, "jdbc_targets", jdbc_targets)
        if lake_formation_configuration is not None:
            pulumi.set(__self__, "lake_formation_configuration", lake_formation_configuration)
        if lineage_configuration is not None:
            pulumi.set(__self__, "lineage_configuration", lineage_configuration)
        if mongodb_targets is not None:
            pulumi.set(__self__, "mongodb_targets", mongodb_targets)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recrawl_policy is not None:
            pulumi.set(__self__, "recrawl_policy", recrawl_policy)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if s3_targets is not None:
            pulumi.set(__self__, "s3_targets", s3_targets)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if schema_change_policy is not None:
            pulumi.set(__self__, "schema_change_policy", schema_change_policy)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if table_prefix is not None:
            pulumi.set(__self__, "table_prefix", table_prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the crawler
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="catalogTargets")
    def catalog_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]]]:
        """
        List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
        """
        return pulumi.get(self, "catalog_targets")

    @catalog_targets.setter
    def catalog_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]]]):
        pulumi.set(self, "catalog_targets", value)

    @property
    @pulumi.getter
    def classifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
        """
        return pulumi.get(self, "classifiers")

    @classifiers.setter
    def classifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "classifiers", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[str]]:
        """
        JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Glue database where results are written.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="deltaTargets")
    def delta_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]]]:
        """
        List of nested Delta Lake target arguments. See Delta Target below.
        """
        return pulumi.get(self, "delta_targets")

    @delta_targets.setter
    def delta_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]]]):
        pulumi.set(self, "delta_targets", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the crawler.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dynamodbTargets")
    def dynamodb_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDynamodbTargetArgs']]]]:
        """
        List of nested DynamoDB target arguments. See Dynamodb Target below.
        """
        return pulumi.get(self, "dynamodb_targets")

    @dynamodb_targets.setter
    def dynamodb_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDynamodbTargetArgs']]]]):
        pulumi.set(self, "dynamodb_targets", value)

    @property
    @pulumi.getter(name="hudiTargets")
    def hudi_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerHudiTargetArgs']]]]:
        """
        List of nested Hudi target arguments. See Iceberg Target below.
        """
        return pulumi.get(self, "hudi_targets")

    @hudi_targets.setter
    def hudi_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerHudiTargetArgs']]]]):
        pulumi.set(self, "hudi_targets", value)

    @property
    @pulumi.getter(name="icebergTargets")
    def iceberg_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]]]:
        """
        List of nested Iceberg target arguments. See Iceberg Target below.
        """
        return pulumi.get(self, "iceberg_targets")

    @iceberg_targets.setter
    def iceberg_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]]]):
        pulumi.set(self, "iceberg_targets", value)

    @property
    @pulumi.getter(name="jdbcTargets")
    def jdbc_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]]]:
        """
        List of nested JDBC target arguments. See JDBC Target below.
        """
        return pulumi.get(self, "jdbc_targets")

    @jdbc_targets.setter
    def jdbc_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]]]):
        pulumi.set(self, "jdbc_targets", value)

    @property
    @pulumi.getter(name="lakeFormationConfiguration")
    def lake_formation_configuration(self) -> Optional[pulumi.Input['CrawlerLakeFormationConfigurationArgs']]:
        """
        Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
        """
        return pulumi.get(self, "lake_formation_configuration")

    @lake_formation_configuration.setter
    def lake_formation_configuration(self, value: Optional[pulumi.Input['CrawlerLakeFormationConfigurationArgs']]):
        pulumi.set(self, "lake_formation_configuration", value)

    @property
    @pulumi.getter(name="lineageConfiguration")
    def lineage_configuration(self) -> Optional[pulumi.Input['CrawlerLineageConfigurationArgs']]:
        """
        Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
        """
        return pulumi.get(self, "lineage_configuration")

    @lineage_configuration.setter
    def lineage_configuration(self, value: Optional[pulumi.Input['CrawlerLineageConfigurationArgs']]):
        pulumi.set(self, "lineage_configuration", value)

    @property
    @pulumi.getter(name="mongodbTargets")
    def mongodb_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerMongodbTargetArgs']]]]:
        """
        List of nested MongoDB target arguments. See MongoDB Target below.
        """
        return pulumi.get(self, "mongodb_targets")

    @mongodb_targets.setter
    def mongodb_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerMongodbTargetArgs']]]]):
        pulumi.set(self, "mongodb_targets", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the crawler.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recrawlPolicy")
    def recrawl_policy(self) -> Optional[pulumi.Input['CrawlerRecrawlPolicyArgs']]:
        """
        A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
        """
        return pulumi.get(self, "recrawl_policy")

    @recrawl_policy.setter
    def recrawl_policy(self, value: Optional[pulumi.Input['CrawlerRecrawlPolicyArgs']]):
        pulumi.set(self, "recrawl_policy", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="s3Targets")
    def s3_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]]]:
        """
        List of nested Amazon S3 target arguments. See S3 Target below.
        """
        return pulumi.get(self, "s3_targets")

    @s3_targets.setter
    def s3_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]]]):
        pulumi.set(self, "s3_targets", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="schemaChangePolicy")
    def schema_change_policy(self) -> Optional[pulumi.Input['CrawlerSchemaChangePolicyArgs']]:
        """
        Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
        """
        return pulumi.get(self, "schema_change_policy")

    @schema_change_policy.setter
    def schema_change_policy(self, value: Optional[pulumi.Input['CrawlerSchemaChangePolicyArgs']]):
        pulumi.set(self, "schema_change_policy", value)

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        The name of Security Configuration to be used by the crawler
        """
        return pulumi.get(self, "security_configuration")

    @security_configuration.setter
    def security_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_configuration", value)

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The table prefix used for catalog tables that are created.
        """
        return pulumi.get(self, "table_prefix")

    @table_prefix.setter
    def table_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class Crawler(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerCatalogTargetArgs', 'CrawlerCatalogTargetArgsDict']]]]] = None,
                 classifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 configuration: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 delta_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerDeltaTargetArgs', 'CrawlerDeltaTargetArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodb_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerDynamodbTargetArgs', 'CrawlerDynamodbTargetArgsDict']]]]] = None,
                 hudi_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerHudiTargetArgs', 'CrawlerHudiTargetArgsDict']]]]] = None,
                 iceberg_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerIcebergTargetArgs', 'CrawlerIcebergTargetArgsDict']]]]] = None,
                 jdbc_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerJdbcTargetArgs', 'CrawlerJdbcTargetArgsDict']]]]] = None,
                 lake_formation_configuration: Optional[pulumi.Input[Union['CrawlerLakeFormationConfigurationArgs', 'CrawlerLakeFormationConfigurationArgsDict']]] = None,
                 lineage_configuration: Optional[pulumi.Input[Union['CrawlerLineageConfigurationArgs', 'CrawlerLineageConfigurationArgsDict']]] = None,
                 mongodb_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerMongodbTargetArgs', 'CrawlerMongodbTargetArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 recrawl_policy: Optional[pulumi.Input[Union['CrawlerRecrawlPolicyArgs', 'CrawlerRecrawlPolicyArgsDict']]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 s3_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerS3TargetArgs', 'CrawlerS3TargetArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 schema_change_policy: Optional[pulumi.Input[Union['CrawlerSchemaChangePolicyArgs', 'CrawlerSchemaChangePolicyArgsDict']]] = None,
                 security_configuration: Optional[pulumi.Input[str]] = None,
                 table_prefix: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a Glue Crawler. More information can be found in the [AWS Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html)

        ## Example Usage

        ### DynamoDB Target Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Crawler("example",
            database_name=example_aws_glue_catalog_database["name"],
            name="example",
            role=example_aws_iam_role["arn"],
            dynamodb_targets=[{
                "path": "table-name",
            }])
        ```

        ### JDBC Target Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Crawler("example",
            database_name=example_aws_glue_catalog_database["name"],
            name="example",
            role=example_aws_iam_role["arn"],
            jdbc_targets=[{
                "connection_name": example_aws_glue_connection["name"],
                "path": "database-name/%",
            }])
        ```

        ### S3 Target Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Crawler("example",
            database_name=example_aws_glue_catalog_database["name"],
            name="example",
            role=example_aws_iam_role["arn"],
            s3_targets=[{
                "path": f"s3://{example_aws_s3_bucket['bucket']}",
            }])
        ```

        ### Catalog Target Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Crawler("example",
            database_name=example_aws_glue_catalog_database["name"],
            name="example",
            role=example_aws_iam_role["arn"],
            catalog_targets=[{
                "database_name": example_aws_glue_catalog_database["name"],
                "tables": [example_aws_glue_catalog_table["name"]],
            }],
            schema_change_policy={
                "delete_behavior": "LOG",
            },
            configuration=\"\"\"{
          "Version":1.0,
          "Grouping": {
            "TableGroupingPolicy": "CombineCompatibleSchemas"
          }
        }
        \"\"\")
        ```

        ### MongoDB Target Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Crawler("example",
            database_name=example_aws_glue_catalog_database["name"],
            name="example",
            role=example_aws_iam_role["arn"],
            mongodb_targets=[{
                "connection_name": example_aws_glue_connection["name"],
                "path": "database-name/%",
            }])
        ```

        ### Configuration Settings Example

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        events_crawler = aws.glue.Crawler("events_crawler",
            database_name=glue_database["name"],
            schedule="cron(0 1 * * ? *)",
            name=f"events_crawler_{environment_name}",
            role=glue_role["arn"],
            tags=tags,
            configuration=json.dumps({
                "Grouping": {
                    "TableGroupingPolicy": "CombineCompatibleSchemas",
                },
                "CrawlerOutput": {
                    "Partitions": {
                        "AddOrUpdateBehavior": "InheritFromTable",
                    },
                },
                "Version": 1,
            }),
            s3_targets=[{
                "path": f"s3://{data_lake_bucket['bucket']}",
            }])
        ```

        ## Import

        Using `pulumi import`, import Glue Crawlers using `name`. For example:

        ```sh
        $ pulumi import aws:glue/crawler:Crawler MyJob MyJob
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerCatalogTargetArgs', 'CrawlerCatalogTargetArgsDict']]]] catalog_targets: List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] classifiers: List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
        :param pulumi.Input[str] configuration: JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
        :param pulumi.Input[str] database_name: Glue database where results are written.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerDeltaTargetArgs', 'CrawlerDeltaTargetArgsDict']]]] delta_targets: List of nested Delta Lake target arguments. See Delta Target below.
        :param pulumi.Input[str] description: Description of the crawler.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerDynamodbTargetArgs', 'CrawlerDynamodbTargetArgsDict']]]] dynamodb_targets: List of nested DynamoDB target arguments. See Dynamodb Target below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerHudiTargetArgs', 'CrawlerHudiTargetArgsDict']]]] hudi_targets: List of nested Hudi target arguments. See Iceberg Target below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerIcebergTargetArgs', 'CrawlerIcebergTargetArgsDict']]]] iceberg_targets: List of nested Iceberg target arguments. See Iceberg Target below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerJdbcTargetArgs', 'CrawlerJdbcTargetArgsDict']]]] jdbc_targets: List of nested JDBC target arguments. See JDBC Target below.
        :param pulumi.Input[Union['CrawlerLakeFormationConfigurationArgs', 'CrawlerLakeFormationConfigurationArgsDict']] lake_formation_configuration: Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
        :param pulumi.Input[Union['CrawlerLineageConfigurationArgs', 'CrawlerLineageConfigurationArgsDict']] lineage_configuration: Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerMongodbTargetArgs', 'CrawlerMongodbTargetArgsDict']]]] mongodb_targets: List of nested MongoDB target arguments. See MongoDB Target below.
        :param pulumi.Input[str] name: Name of the crawler.
        :param pulumi.Input[Union['CrawlerRecrawlPolicyArgs', 'CrawlerRecrawlPolicyArgsDict']] recrawl_policy: A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
        :param pulumi.Input[str] role: The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerS3TargetArgs', 'CrawlerS3TargetArgsDict']]]] s3_targets: List of nested Amazon S3 target arguments. See S3 Target below.
        :param pulumi.Input[str] schedule: A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
        :param pulumi.Input[Union['CrawlerSchemaChangePolicyArgs', 'CrawlerSchemaChangePolicyArgsDict']] schema_change_policy: Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
        :param pulumi.Input[str] security_configuration: The name of Security Configuration to be used by the crawler
        :param pulumi.Input[str] table_prefix: The table prefix used for catalog tables that are created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CrawlerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Glue Crawler. More information can be found in the [AWS Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html)

        ## Example Usage

        ### DynamoDB Target Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Crawler("example",
            database_name=example_aws_glue_catalog_database["name"],
            name="example",
            role=example_aws_iam_role["arn"],
            dynamodb_targets=[{
                "path": "table-name",
            }])
        ```

        ### JDBC Target Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Crawler("example",
            database_name=example_aws_glue_catalog_database["name"],
            name="example",
            role=example_aws_iam_role["arn"],
            jdbc_targets=[{
                "connection_name": example_aws_glue_connection["name"],
                "path": "database-name/%",
            }])
        ```

        ### S3 Target Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Crawler("example",
            database_name=example_aws_glue_catalog_database["name"],
            name="example",
            role=example_aws_iam_role["arn"],
            s3_targets=[{
                "path": f"s3://{example_aws_s3_bucket['bucket']}",
            }])
        ```

        ### Catalog Target Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Crawler("example",
            database_name=example_aws_glue_catalog_database["name"],
            name="example",
            role=example_aws_iam_role["arn"],
            catalog_targets=[{
                "database_name": example_aws_glue_catalog_database["name"],
                "tables": [example_aws_glue_catalog_table["name"]],
            }],
            schema_change_policy={
                "delete_behavior": "LOG",
            },
            configuration=\"\"\"{
          "Version":1.0,
          "Grouping": {
            "TableGroupingPolicy": "CombineCompatibleSchemas"
          }
        }
        \"\"\")
        ```

        ### MongoDB Target Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Crawler("example",
            database_name=example_aws_glue_catalog_database["name"],
            name="example",
            role=example_aws_iam_role["arn"],
            mongodb_targets=[{
                "connection_name": example_aws_glue_connection["name"],
                "path": "database-name/%",
            }])
        ```

        ### Configuration Settings Example

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        events_crawler = aws.glue.Crawler("events_crawler",
            database_name=glue_database["name"],
            schedule="cron(0 1 * * ? *)",
            name=f"events_crawler_{environment_name}",
            role=glue_role["arn"],
            tags=tags,
            configuration=json.dumps({
                "Grouping": {
                    "TableGroupingPolicy": "CombineCompatibleSchemas",
                },
                "CrawlerOutput": {
                    "Partitions": {
                        "AddOrUpdateBehavior": "InheritFromTable",
                    },
                },
                "Version": 1,
            }),
            s3_targets=[{
                "path": f"s3://{data_lake_bucket['bucket']}",
            }])
        ```

        ## Import

        Using `pulumi import`, import Glue Crawlers using `name`. For example:

        ```sh
        $ pulumi import aws:glue/crawler:Crawler MyJob MyJob
        ```

        :param str resource_name: The name of the resource.
        :param CrawlerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CrawlerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerCatalogTargetArgs', 'CrawlerCatalogTargetArgsDict']]]]] = None,
                 classifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 configuration: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 delta_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerDeltaTargetArgs', 'CrawlerDeltaTargetArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodb_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerDynamodbTargetArgs', 'CrawlerDynamodbTargetArgsDict']]]]] = None,
                 hudi_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerHudiTargetArgs', 'CrawlerHudiTargetArgsDict']]]]] = None,
                 iceberg_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerIcebergTargetArgs', 'CrawlerIcebergTargetArgsDict']]]]] = None,
                 jdbc_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerJdbcTargetArgs', 'CrawlerJdbcTargetArgsDict']]]]] = None,
                 lake_formation_configuration: Optional[pulumi.Input[Union['CrawlerLakeFormationConfigurationArgs', 'CrawlerLakeFormationConfigurationArgsDict']]] = None,
                 lineage_configuration: Optional[pulumi.Input[Union['CrawlerLineageConfigurationArgs', 'CrawlerLineageConfigurationArgsDict']]] = None,
                 mongodb_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerMongodbTargetArgs', 'CrawlerMongodbTargetArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 recrawl_policy: Optional[pulumi.Input[Union['CrawlerRecrawlPolicyArgs', 'CrawlerRecrawlPolicyArgsDict']]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 s3_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerS3TargetArgs', 'CrawlerS3TargetArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 schema_change_policy: Optional[pulumi.Input[Union['CrawlerSchemaChangePolicyArgs', 'CrawlerSchemaChangePolicyArgsDict']]] = None,
                 security_configuration: Optional[pulumi.Input[str]] = None,
                 table_prefix: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CrawlerArgs.__new__(CrawlerArgs)

            __props__.__dict__["catalog_targets"] = catalog_targets
            __props__.__dict__["classifiers"] = classifiers
            __props__.__dict__["configuration"] = configuration
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["delta_targets"] = delta_targets
            __props__.__dict__["description"] = description
            __props__.__dict__["dynamodb_targets"] = dynamodb_targets
            __props__.__dict__["hudi_targets"] = hudi_targets
            __props__.__dict__["iceberg_targets"] = iceberg_targets
            __props__.__dict__["jdbc_targets"] = jdbc_targets
            __props__.__dict__["lake_formation_configuration"] = lake_formation_configuration
            __props__.__dict__["lineage_configuration"] = lineage_configuration
            __props__.__dict__["mongodb_targets"] = mongodb_targets
            __props__.__dict__["name"] = name
            __props__.__dict__["recrawl_policy"] = recrawl_policy
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["s3_targets"] = s3_targets
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["schema_change_policy"] = schema_change_policy
            __props__.__dict__["security_configuration"] = security_configuration
            __props__.__dict__["table_prefix"] = table_prefix
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Crawler, __self__).__init__(
            'aws:glue/crawler:Crawler',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            catalog_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerCatalogTargetArgs', 'CrawlerCatalogTargetArgsDict']]]]] = None,
            classifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            configuration: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            delta_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerDeltaTargetArgs', 'CrawlerDeltaTargetArgsDict']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dynamodb_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerDynamodbTargetArgs', 'CrawlerDynamodbTargetArgsDict']]]]] = None,
            hudi_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerHudiTargetArgs', 'CrawlerHudiTargetArgsDict']]]]] = None,
            iceberg_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerIcebergTargetArgs', 'CrawlerIcebergTargetArgsDict']]]]] = None,
            jdbc_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerJdbcTargetArgs', 'CrawlerJdbcTargetArgsDict']]]]] = None,
            lake_formation_configuration: Optional[pulumi.Input[Union['CrawlerLakeFormationConfigurationArgs', 'CrawlerLakeFormationConfigurationArgsDict']]] = None,
            lineage_configuration: Optional[pulumi.Input[Union['CrawlerLineageConfigurationArgs', 'CrawlerLineageConfigurationArgsDict']]] = None,
            mongodb_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerMongodbTargetArgs', 'CrawlerMongodbTargetArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            recrawl_policy: Optional[pulumi.Input[Union['CrawlerRecrawlPolicyArgs', 'CrawlerRecrawlPolicyArgsDict']]] = None,
            role: Optional[pulumi.Input[str]] = None,
            s3_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CrawlerS3TargetArgs', 'CrawlerS3TargetArgsDict']]]]] = None,
            schedule: Optional[pulumi.Input[str]] = None,
            schema_change_policy: Optional[pulumi.Input[Union['CrawlerSchemaChangePolicyArgs', 'CrawlerSchemaChangePolicyArgsDict']]] = None,
            security_configuration: Optional[pulumi.Input[str]] = None,
            table_prefix: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Crawler':
        """
        Get an existing Crawler resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the crawler
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerCatalogTargetArgs', 'CrawlerCatalogTargetArgsDict']]]] catalog_targets: List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] classifiers: List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
        :param pulumi.Input[str] configuration: JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
        :param pulumi.Input[str] database_name: Glue database where results are written.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerDeltaTargetArgs', 'CrawlerDeltaTargetArgsDict']]]] delta_targets: List of nested Delta Lake target arguments. See Delta Target below.
        :param pulumi.Input[str] description: Description of the crawler.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerDynamodbTargetArgs', 'CrawlerDynamodbTargetArgsDict']]]] dynamodb_targets: List of nested DynamoDB target arguments. See Dynamodb Target below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerHudiTargetArgs', 'CrawlerHudiTargetArgsDict']]]] hudi_targets: List of nested Hudi target arguments. See Iceberg Target below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerIcebergTargetArgs', 'CrawlerIcebergTargetArgsDict']]]] iceberg_targets: List of nested Iceberg target arguments. See Iceberg Target below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerJdbcTargetArgs', 'CrawlerJdbcTargetArgsDict']]]] jdbc_targets: List of nested JDBC target arguments. See JDBC Target below.
        :param pulumi.Input[Union['CrawlerLakeFormationConfigurationArgs', 'CrawlerLakeFormationConfigurationArgsDict']] lake_formation_configuration: Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
        :param pulumi.Input[Union['CrawlerLineageConfigurationArgs', 'CrawlerLineageConfigurationArgsDict']] lineage_configuration: Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerMongodbTargetArgs', 'CrawlerMongodbTargetArgsDict']]]] mongodb_targets: List of nested MongoDB target arguments. See MongoDB Target below.
        :param pulumi.Input[str] name: Name of the crawler.
        :param pulumi.Input[Union['CrawlerRecrawlPolicyArgs', 'CrawlerRecrawlPolicyArgsDict']] recrawl_policy: A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
        :param pulumi.Input[str] role: The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CrawlerS3TargetArgs', 'CrawlerS3TargetArgsDict']]]] s3_targets: List of nested Amazon S3 target arguments. See S3 Target below.
        :param pulumi.Input[str] schedule: A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
        :param pulumi.Input[Union['CrawlerSchemaChangePolicyArgs', 'CrawlerSchemaChangePolicyArgsDict']] schema_change_policy: Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
        :param pulumi.Input[str] security_configuration: The name of Security Configuration to be used by the crawler
        :param pulumi.Input[str] table_prefix: The table prefix used for catalog tables that are created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CrawlerState.__new__(_CrawlerState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["catalog_targets"] = catalog_targets
        __props__.__dict__["classifiers"] = classifiers
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["delta_targets"] = delta_targets
        __props__.__dict__["description"] = description
        __props__.__dict__["dynamodb_targets"] = dynamodb_targets
        __props__.__dict__["hudi_targets"] = hudi_targets
        __props__.__dict__["iceberg_targets"] = iceberg_targets
        __props__.__dict__["jdbc_targets"] = jdbc_targets
        __props__.__dict__["lake_formation_configuration"] = lake_formation_configuration
        __props__.__dict__["lineage_configuration"] = lineage_configuration
        __props__.__dict__["mongodb_targets"] = mongodb_targets
        __props__.__dict__["name"] = name
        __props__.__dict__["recrawl_policy"] = recrawl_policy
        __props__.__dict__["role"] = role
        __props__.__dict__["s3_targets"] = s3_targets
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["schema_change_policy"] = schema_change_policy
        __props__.__dict__["security_configuration"] = security_configuration
        __props__.__dict__["table_prefix"] = table_prefix
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Crawler(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the crawler
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="catalogTargets")
    def catalog_targets(self) -> pulumi.Output[Optional[Sequence['outputs.CrawlerCatalogTarget']]]:
        """
        List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
        """
        return pulumi.get(self, "catalog_targets")

    @property
    @pulumi.getter
    def classifiers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
        """
        return pulumi.get(self, "classifiers")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional[str]]:
        """
        JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        Glue database where results are written.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="deltaTargets")
    def delta_targets(self) -> pulumi.Output[Optional[Sequence['outputs.CrawlerDeltaTarget']]]:
        """
        List of nested Delta Lake target arguments. See Delta Target below.
        """
        return pulumi.get(self, "delta_targets")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the crawler.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dynamodbTargets")
    def dynamodb_targets(self) -> pulumi.Output[Optional[Sequence['outputs.CrawlerDynamodbTarget']]]:
        """
        List of nested DynamoDB target arguments. See Dynamodb Target below.
        """
        return pulumi.get(self, "dynamodb_targets")

    @property
    @pulumi.getter(name="hudiTargets")
    def hudi_targets(self) -> pulumi.Output[Optional[Sequence['outputs.CrawlerHudiTarget']]]:
        """
        List of nested Hudi target arguments. See Iceberg Target below.
        """
        return pulumi.get(self, "hudi_targets")

    @property
    @pulumi.getter(name="icebergTargets")
    def iceberg_targets(self) -> pulumi.Output[Optional[Sequence['outputs.CrawlerIcebergTarget']]]:
        """
        List of nested Iceberg target arguments. See Iceberg Target below.
        """
        return pulumi.get(self, "iceberg_targets")

    @property
    @pulumi.getter(name="jdbcTargets")
    def jdbc_targets(self) -> pulumi.Output[Optional[Sequence['outputs.CrawlerJdbcTarget']]]:
        """
        List of nested JDBC target arguments. See JDBC Target below.
        """
        return pulumi.get(self, "jdbc_targets")

    @property
    @pulumi.getter(name="lakeFormationConfiguration")
    def lake_formation_configuration(self) -> pulumi.Output[Optional['outputs.CrawlerLakeFormationConfiguration']]:
        """
        Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
        """
        return pulumi.get(self, "lake_formation_configuration")

    @property
    @pulumi.getter(name="lineageConfiguration")
    def lineage_configuration(self) -> pulumi.Output[Optional['outputs.CrawlerLineageConfiguration']]:
        """
        Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
        """
        return pulumi.get(self, "lineage_configuration")

    @property
    @pulumi.getter(name="mongodbTargets")
    def mongodb_targets(self) -> pulumi.Output[Optional[Sequence['outputs.CrawlerMongodbTarget']]]:
        """
        List of nested MongoDB target arguments. See MongoDB Target below.
        """
        return pulumi.get(self, "mongodb_targets")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the crawler.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recrawlPolicy")
    def recrawl_policy(self) -> pulumi.Output[Optional['outputs.CrawlerRecrawlPolicy']]:
        """
        A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
        """
        return pulumi.get(self, "recrawl_policy")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="s3Targets")
    def s3_targets(self) -> pulumi.Output[Optional[Sequence['outputs.CrawlerS3Target']]]:
        """
        List of nested Amazon S3 target arguments. See S3 Target below.
        """
        return pulumi.get(self, "s3_targets")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional[str]]:
        """
        A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="schemaChangePolicy")
    def schema_change_policy(self) -> pulumi.Output[Optional['outputs.CrawlerSchemaChangePolicy']]:
        """
        Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
        """
        return pulumi.get(self, "schema_change_policy")

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> pulumi.Output[Optional[str]]:
        """
        The name of Security Configuration to be used by the crawler
        """
        return pulumi.get(self, "security_configuration")

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        The table prefix used for catalog tables that are created.
        """
        return pulumi.get(self, "table_prefix")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

