# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RoomArgs', 'Room']

@pulumi.input_type
class RoomArgs:
    def __init__(__self__, *,
                 logging_configuration_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 maximum_message_length: Optional[pulumi.Input[int]] = None,
                 maximum_message_rate_per_second: Optional[pulumi.Input[int]] = None,
                 message_review_handler: Optional[pulumi.Input['RoomMessageReviewHandlerArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Room resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] logging_configuration_identifiers: List of Logging Configuration
               ARNs to attach to the room.
        :param pulumi.Input[int] maximum_message_length: Maximum number of characters in a single
               message. Messages are expected to be UTF-8 encoded and this limit applies
               specifically to rune/code-point count, not number of bytes.
        :param pulumi.Input[int] maximum_message_rate_per_second: Maximum number of messages per
               second that can be sent to the room (by all clients).
        :param pulumi.Input['RoomMessageReviewHandlerArgs'] message_review_handler: Configuration information for optional
               review of messages.
        :param pulumi.Input[str] name: Room name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if logging_configuration_identifiers is not None:
            pulumi.set(__self__, "logging_configuration_identifiers", logging_configuration_identifiers)
        if maximum_message_length is not None:
            pulumi.set(__self__, "maximum_message_length", maximum_message_length)
        if maximum_message_rate_per_second is not None:
            pulumi.set(__self__, "maximum_message_rate_per_second", maximum_message_rate_per_second)
        if message_review_handler is not None:
            pulumi.set(__self__, "message_review_handler", message_review_handler)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="loggingConfigurationIdentifiers")
    def logging_configuration_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Logging Configuration
        ARNs to attach to the room.
        """
        return pulumi.get(self, "logging_configuration_identifiers")

    @logging_configuration_identifiers.setter
    def logging_configuration_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "logging_configuration_identifiers", value)

    @property
    @pulumi.getter(name="maximumMessageLength")
    def maximum_message_length(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of characters in a single
        message. Messages are expected to be UTF-8 encoded and this limit applies
        specifically to rune/code-point count, not number of bytes.
        """
        return pulumi.get(self, "maximum_message_length")

    @maximum_message_length.setter
    def maximum_message_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_message_length", value)

    @property
    @pulumi.getter(name="maximumMessageRatePerSecond")
    def maximum_message_rate_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of messages per
        second that can be sent to the room (by all clients).
        """
        return pulumi.get(self, "maximum_message_rate_per_second")

    @maximum_message_rate_per_second.setter
    def maximum_message_rate_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_message_rate_per_second", value)

    @property
    @pulumi.getter(name="messageReviewHandler")
    def message_review_handler(self) -> Optional[pulumi.Input['RoomMessageReviewHandlerArgs']]:
        """
        Configuration information for optional
        review of messages.
        """
        return pulumi.get(self, "message_review_handler")

    @message_review_handler.setter
    def message_review_handler(self, value: Optional[pulumi.Input['RoomMessageReviewHandlerArgs']]):
        pulumi.set(self, "message_review_handler", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Room name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RoomState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 logging_configuration_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 maximum_message_length: Optional[pulumi.Input[int]] = None,
                 maximum_message_rate_per_second: Optional[pulumi.Input[int]] = None,
                 message_review_handler: Optional[pulumi.Input['RoomMessageReviewHandlerArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Room resources.
        :param pulumi.Input[str] arn: ARN of the Room.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] logging_configuration_identifiers: List of Logging Configuration
               ARNs to attach to the room.
        :param pulumi.Input[int] maximum_message_length: Maximum number of characters in a single
               message. Messages are expected to be UTF-8 encoded and this limit applies
               specifically to rune/code-point count, not number of bytes.
        :param pulumi.Input[int] maximum_message_rate_per_second: Maximum number of messages per
               second that can be sent to the room (by all clients).
        :param pulumi.Input['RoomMessageReviewHandlerArgs'] message_review_handler: Configuration information for optional
               review of messages.
        :param pulumi.Input[str] name: Room name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if logging_configuration_identifiers is not None:
            pulumi.set(__self__, "logging_configuration_identifiers", logging_configuration_identifiers)
        if maximum_message_length is not None:
            pulumi.set(__self__, "maximum_message_length", maximum_message_length)
        if maximum_message_rate_per_second is not None:
            pulumi.set(__self__, "maximum_message_rate_per_second", maximum_message_rate_per_second)
        if message_review_handler is not None:
            pulumi.set(__self__, "message_review_handler", message_review_handler)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Room.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="loggingConfigurationIdentifiers")
    def logging_configuration_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Logging Configuration
        ARNs to attach to the room.
        """
        return pulumi.get(self, "logging_configuration_identifiers")

    @logging_configuration_identifiers.setter
    def logging_configuration_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "logging_configuration_identifiers", value)

    @property
    @pulumi.getter(name="maximumMessageLength")
    def maximum_message_length(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of characters in a single
        message. Messages are expected to be UTF-8 encoded and this limit applies
        specifically to rune/code-point count, not number of bytes.
        """
        return pulumi.get(self, "maximum_message_length")

    @maximum_message_length.setter
    def maximum_message_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_message_length", value)

    @property
    @pulumi.getter(name="maximumMessageRatePerSecond")
    def maximum_message_rate_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of messages per
        second that can be sent to the room (by all clients).
        """
        return pulumi.get(self, "maximum_message_rate_per_second")

    @maximum_message_rate_per_second.setter
    def maximum_message_rate_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_message_rate_per_second", value)

    @property
    @pulumi.getter(name="messageReviewHandler")
    def message_review_handler(self) -> Optional[pulumi.Input['RoomMessageReviewHandlerArgs']]:
        """
        Configuration information for optional
        review of messages.
        """
        return pulumi.get(self, "message_review_handler")

    @message_review_handler.setter
    def message_review_handler(self, value: Optional[pulumi.Input['RoomMessageReviewHandlerArgs']]):
        pulumi.set(self, "message_review_handler", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Room name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class Room(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 logging_configuration_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 maximum_message_length: Optional[pulumi.Input[int]] = None,
                 maximum_message_rate_per_second: Optional[pulumi.Input[int]] = None,
                 message_review_handler: Optional[pulumi.Input[Union['RoomMessageReviewHandlerArgs', 'RoomMessageReviewHandlerArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS IVS (Interactive Video) Chat Room.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ivschat.Room("example", name="tf-room")
        ```

        ## Import

        Using `pulumi import`, import IVS (Interactive Video) Chat Room using the ARN. For example:

        ```sh
        $ pulumi import aws:ivschat/room:Room example arn:aws:ivschat:us-west-2:326937407773:room/GoXEXyB4VwHb
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] logging_configuration_identifiers: List of Logging Configuration
               ARNs to attach to the room.
        :param pulumi.Input[int] maximum_message_length: Maximum number of characters in a single
               message. Messages are expected to be UTF-8 encoded and this limit applies
               specifically to rune/code-point count, not number of bytes.
        :param pulumi.Input[int] maximum_message_rate_per_second: Maximum number of messages per
               second that can be sent to the room (by all clients).
        :param pulumi.Input[Union['RoomMessageReviewHandlerArgs', 'RoomMessageReviewHandlerArgsDict']] message_review_handler: Configuration information for optional
               review of messages.
        :param pulumi.Input[str] name: Room name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RoomArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS IVS (Interactive Video) Chat Room.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ivschat.Room("example", name="tf-room")
        ```

        ## Import

        Using `pulumi import`, import IVS (Interactive Video) Chat Room using the ARN. For example:

        ```sh
        $ pulumi import aws:ivschat/room:Room example arn:aws:ivschat:us-west-2:326937407773:room/GoXEXyB4VwHb
        ```

        :param str resource_name: The name of the resource.
        :param RoomArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoomArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 logging_configuration_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 maximum_message_length: Optional[pulumi.Input[int]] = None,
                 maximum_message_rate_per_second: Optional[pulumi.Input[int]] = None,
                 message_review_handler: Optional[pulumi.Input[Union['RoomMessageReviewHandlerArgs', 'RoomMessageReviewHandlerArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoomArgs.__new__(RoomArgs)

            __props__.__dict__["logging_configuration_identifiers"] = logging_configuration_identifiers
            __props__.__dict__["maximum_message_length"] = maximum_message_length
            __props__.__dict__["maximum_message_rate_per_second"] = maximum_message_rate_per_second
            __props__.__dict__["message_review_handler"] = message_review_handler
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Room, __self__).__init__(
            'aws:ivschat/room:Room',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            logging_configuration_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            maximum_message_length: Optional[pulumi.Input[int]] = None,
            maximum_message_rate_per_second: Optional[pulumi.Input[int]] = None,
            message_review_handler: Optional[pulumi.Input[Union['RoomMessageReviewHandlerArgs', 'RoomMessageReviewHandlerArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Room':
        """
        Get an existing Room resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the Room.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] logging_configuration_identifiers: List of Logging Configuration
               ARNs to attach to the room.
        :param pulumi.Input[int] maximum_message_length: Maximum number of characters in a single
               message. Messages are expected to be UTF-8 encoded and this limit applies
               specifically to rune/code-point count, not number of bytes.
        :param pulumi.Input[int] maximum_message_rate_per_second: Maximum number of messages per
               second that can be sent to the room (by all clients).
        :param pulumi.Input[Union['RoomMessageReviewHandlerArgs', 'RoomMessageReviewHandlerArgsDict']] message_review_handler: Configuration information for optional
               review of messages.
        :param pulumi.Input[str] name: Room name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoomState.__new__(_RoomState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["logging_configuration_identifiers"] = logging_configuration_identifiers
        __props__.__dict__["maximum_message_length"] = maximum_message_length
        __props__.__dict__["maximum_message_rate_per_second"] = maximum_message_rate_per_second
        __props__.__dict__["message_review_handler"] = message_review_handler
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Room(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the Room.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="loggingConfigurationIdentifiers")
    def logging_configuration_identifiers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of Logging Configuration
        ARNs to attach to the room.
        """
        return pulumi.get(self, "logging_configuration_identifiers")

    @property
    @pulumi.getter(name="maximumMessageLength")
    def maximum_message_length(self) -> pulumi.Output[int]:
        """
        Maximum number of characters in a single
        message. Messages are expected to be UTF-8 encoded and this limit applies
        specifically to rune/code-point count, not number of bytes.
        """
        return pulumi.get(self, "maximum_message_length")

    @property
    @pulumi.getter(name="maximumMessageRatePerSecond")
    def maximum_message_rate_per_second(self) -> pulumi.Output[int]:
        """
        Maximum number of messages per
        second that can be sent to the room (by all clients).
        """
        return pulumi.get(self, "maximum_message_rate_per_second")

    @property
    @pulumi.getter(name="messageReviewHandler")
    def message_review_handler(self) -> pulumi.Output[Optional['outputs.RoomMessageReviewHandler']]:
        """
        Configuration information for optional
        review of messages.
        """
        return pulumi.get(self, "message_review_handler")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Room name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

