# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIndexResult',
    'AwaitableGetIndexResult',
    'get_index',
    'get_index_output',
]

@pulumi.output_type
class GetIndexResult:
    """
    A collection of values returned by getIndex.
    """
    def __init__(__self__, arn=None, capacity_units=None, created_at=None, description=None, document_metadata_configuration_updates=None, edition=None, error_message=None, id=None, index_statistics=None, name=None, role_arn=None, server_side_encryption_configurations=None, status=None, tags=None, updated_at=None, user_context_policy=None, user_group_resolution_configurations=None, user_token_configurations=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if capacity_units and not isinstance(capacity_units, list):
            raise TypeError("Expected argument 'capacity_units' to be a list")
        pulumi.set(__self__, "capacity_units", capacity_units)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if document_metadata_configuration_updates and not isinstance(document_metadata_configuration_updates, list):
            raise TypeError("Expected argument 'document_metadata_configuration_updates' to be a list")
        pulumi.set(__self__, "document_metadata_configuration_updates", document_metadata_configuration_updates)
        if edition and not isinstance(edition, str):
            raise TypeError("Expected argument 'edition' to be a str")
        pulumi.set(__self__, "edition", edition)
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        pulumi.set(__self__, "error_message", error_message)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if index_statistics and not isinstance(index_statistics, list):
            raise TypeError("Expected argument 'index_statistics' to be a list")
        pulumi.set(__self__, "index_statistics", index_statistics)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if server_side_encryption_configurations and not isinstance(server_side_encryption_configurations, list):
            raise TypeError("Expected argument 'server_side_encryption_configurations' to be a list")
        pulumi.set(__self__, "server_side_encryption_configurations", server_side_encryption_configurations)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if user_context_policy and not isinstance(user_context_policy, str):
            raise TypeError("Expected argument 'user_context_policy' to be a str")
        pulumi.set(__self__, "user_context_policy", user_context_policy)
        if user_group_resolution_configurations and not isinstance(user_group_resolution_configurations, list):
            raise TypeError("Expected argument 'user_group_resolution_configurations' to be a list")
        pulumi.set(__self__, "user_group_resolution_configurations", user_group_resolution_configurations)
        if user_token_configurations and not isinstance(user_token_configurations, list):
            raise TypeError("Expected argument 'user_token_configurations' to be a list")
        pulumi.set(__self__, "user_token_configurations", user_token_configurations)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the Index.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="capacityUnits")
    def capacity_units(self) -> Sequence['outputs.GetIndexCapacityUnitResult']:
        """
        Block that sets the number of additional document storage and query capacity units that should be used by the index. Documented below.
        """
        return pulumi.get(self, "capacity_units")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Unix datetime that the index was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Index.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="documentMetadataConfigurationUpdates")
    def document_metadata_configuration_updates(self) -> Sequence['outputs.GetIndexDocumentMetadataConfigurationUpdateResult']:
        """
        One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Documented below.
        """
        return pulumi.get(self, "document_metadata_configuration_updates")

    @property
    @pulumi.getter
    def edition(self) -> str:
        """
        Amazon Kendra edition for the index.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        When the Status field value is `FAILED`, this contains a message that explains why.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Identifier of the Index.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="indexStatistics")
    def index_statistics(self) -> Sequence['outputs.GetIndexIndexStatisticResult']:
        """
        Block that provides information about the number of FAQ questions and answers and the number of text documents indexed. Documented below.
        """
        return pulumi.get(self, "index_statistics")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the index field. Minimum length of 1. Maximum length of 30.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="serverSideEncryptionConfigurations")
    def server_side_encryption_configurations(self) -> Sequence['outputs.GetIndexServerSideEncryptionConfigurationResult']:
        """
        A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Documented below.
        """
        return pulumi.get(self, "server_side_encryption_configurations")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of the index. When the value is `ACTIVE`, the index is ready for use. If the Status field value is `FAILED`, the `error_message` field contains a message that explains why.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Metadata that helps organize the Indices you create.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Unix datetime that the index was last updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userContextPolicy")
    def user_context_policy(self) -> str:
        """
        User context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy).
        """
        return pulumi.get(self, "user_context_policy")

    @property
    @pulumi.getter(name="userGroupResolutionConfigurations")
    def user_group_resolution_configurations(self) -> Sequence['outputs.GetIndexUserGroupResolutionConfigurationResult']:
        """
        A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. Documented below.
        """
        return pulumi.get(self, "user_group_resolution_configurations")

    @property
    @pulumi.getter(name="userTokenConfigurations")
    def user_token_configurations(self) -> Sequence['outputs.GetIndexUserTokenConfigurationResult']:
        """
        A block that specifies the user token configuration. Documented below.
        """
        return pulumi.get(self, "user_token_configurations")


class AwaitableGetIndexResult(GetIndexResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIndexResult(
            arn=self.arn,
            capacity_units=self.capacity_units,
            created_at=self.created_at,
            description=self.description,
            document_metadata_configuration_updates=self.document_metadata_configuration_updates,
            edition=self.edition,
            error_message=self.error_message,
            id=self.id,
            index_statistics=self.index_statistics,
            name=self.name,
            role_arn=self.role_arn,
            server_side_encryption_configurations=self.server_side_encryption_configurations,
            status=self.status,
            tags=self.tags,
            updated_at=self.updated_at,
            user_context_policy=self.user_context_policy,
            user_group_resolution_configurations=self.user_group_resolution_configurations,
            user_token_configurations=self.user_token_configurations)


def get_index(id: Optional[str] = None,
              tags: Optional[Mapping[str, str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIndexResult:
    """
    Provides details about a specific Amazon Kendra Index.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.kendra.get_index(id="12345678-1234-1234-1234-123456789123")
    ```


    :param str id: Returns information on a specific Index by id.
    :param Mapping[str, str] tags: Metadata that helps organize the Indices you create.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:kendra/getIndex:getIndex', __args__, opts=opts, typ=GetIndexResult).value

    return AwaitableGetIndexResult(
        arn=pulumi.get(__ret__, 'arn'),
        capacity_units=pulumi.get(__ret__, 'capacity_units'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        document_metadata_configuration_updates=pulumi.get(__ret__, 'document_metadata_configuration_updates'),
        edition=pulumi.get(__ret__, 'edition'),
        error_message=pulumi.get(__ret__, 'error_message'),
        id=pulumi.get(__ret__, 'id'),
        index_statistics=pulumi.get(__ret__, 'index_statistics'),
        name=pulumi.get(__ret__, 'name'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        server_side_encryption_configurations=pulumi.get(__ret__, 'server_side_encryption_configurations'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        user_context_policy=pulumi.get(__ret__, 'user_context_policy'),
        user_group_resolution_configurations=pulumi.get(__ret__, 'user_group_resolution_configurations'),
        user_token_configurations=pulumi.get(__ret__, 'user_token_configurations'))
def get_index_output(id: Optional[pulumi.Input[str]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIndexResult]:
    """
    Provides details about a specific Amazon Kendra Index.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.kendra.get_index(id="12345678-1234-1234-1234-123456789123")
    ```


    :param str id: Returns information on a specific Index by id.
    :param Mapping[str, str] tags: Metadata that helps organize the Indices you create.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:kendra/getIndex:getIndex', __args__, opts=opts, typ=GetIndexResult)
    return __ret__.apply(lambda __response__: GetIndexResult(
        arn=pulumi.get(__response__, 'arn'),
        capacity_units=pulumi.get(__response__, 'capacity_units'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        document_metadata_configuration_updates=pulumi.get(__response__, 'document_metadata_configuration_updates'),
        edition=pulumi.get(__response__, 'edition'),
        error_message=pulumi.get(__response__, 'error_message'),
        id=pulumi.get(__response__, 'id'),
        index_statistics=pulumi.get(__response__, 'index_statistics'),
        name=pulumi.get(__response__, 'name'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        server_side_encryption_configurations=pulumi.get(__response__, 'server_side_encryption_configurations'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        user_context_policy=pulumi.get(__response__, 'user_context_policy'),
        user_group_resolution_configurations=pulumi.get(__response__, 'user_group_resolution_configurations'),
        user_token_configurations=pulumi.get(__response__, 'user_token_configurations')))
