# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPublicKeyResult',
    'AwaitableGetPublicKeyResult',
    'get_public_key',
    'get_public_key_output',
]

@pulumi.output_type
class GetPublicKeyResult:
    """
    A collection of values returned by getPublicKey.
    """
    def __init__(__self__, arn=None, customer_master_key_spec=None, encryption_algorithms=None, grant_tokens=None, id=None, key_id=None, key_usage=None, public_key=None, public_key_pem=None, signing_algorithms=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if customer_master_key_spec and not isinstance(customer_master_key_spec, str):
            raise TypeError("Expected argument 'customer_master_key_spec' to be a str")
        pulumi.set(__self__, "customer_master_key_spec", customer_master_key_spec)
        if encryption_algorithms and not isinstance(encryption_algorithms, list):
            raise TypeError("Expected argument 'encryption_algorithms' to be a list")
        pulumi.set(__self__, "encryption_algorithms", encryption_algorithms)
        if grant_tokens and not isinstance(grant_tokens, list):
            raise TypeError("Expected argument 'grant_tokens' to be a list")
        pulumi.set(__self__, "grant_tokens", grant_tokens)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if key_usage and not isinstance(key_usage, str):
            raise TypeError("Expected argument 'key_usage' to be a str")
        pulumi.set(__self__, "key_usage", key_usage)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if public_key_pem and not isinstance(public_key_pem, str):
            raise TypeError("Expected argument 'public_key_pem' to be a str")
        pulumi.set(__self__, "public_key_pem", public_key_pem)
        if signing_algorithms and not isinstance(signing_algorithms, list):
            raise TypeError("Expected argument 'signing_algorithms' to be a list")
        pulumi.set(__self__, "signing_algorithms", signing_algorithms)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Key ARN of the asymmetric CMK from which the public key was downloaded.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="customerMasterKeySpec")
    def customer_master_key_spec(self) -> str:
        """
        Type of the public key that was downloaded.
        """
        return pulumi.get(self, "customer_master_key_spec")

    @property
    @pulumi.getter(name="encryptionAlgorithms")
    def encryption_algorithms(self) -> Sequence[str]:
        """
        Encryption algorithms that AWS KMS supports for this key. Only set when the `key_usage` of the public key is `ENCRYPT_DECRYPT`.
        """
        return pulumi.get(self, "encryption_algorithms")

    @property
    @pulumi.getter(name="grantTokens")
    def grant_tokens(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "grant_tokens")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> str:
        """
        Permitted use of the public key. Valid values are `ENCRYPT_DECRYPT` or `SIGN_VERIFY`
        """
        return pulumi.get(self, "key_usage")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        Exported public key. The value is a DER-encoded X.509 public key, also known as SubjectPublicKeyInfo (SPKI), as defined in [RFC 5280](https://tools.ietf.org/html/rfc5280). The value is Base64-encoded.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="publicKeyPem")
    def public_key_pem(self) -> str:
        """
        Exported public key. The value is Privacy Enhanced Mail (PEM) encoded.
        """
        return pulumi.get(self, "public_key_pem")

    @property
    @pulumi.getter(name="signingAlgorithms")
    def signing_algorithms(self) -> Sequence[str]:
        """
        Signing algorithms that AWS KMS supports for this key. Only set when the `key_usage` of the public key is `SIGN_VERIFY`.
        """
        return pulumi.get(self, "signing_algorithms")


class AwaitableGetPublicKeyResult(GetPublicKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicKeyResult(
            arn=self.arn,
            customer_master_key_spec=self.customer_master_key_spec,
            encryption_algorithms=self.encryption_algorithms,
            grant_tokens=self.grant_tokens,
            id=self.id,
            key_id=self.key_id,
            key_usage=self.key_usage,
            public_key=self.public_key,
            public_key_pem=self.public_key_pem,
            signing_algorithms=self.signing_algorithms)


def get_public_key(grant_tokens: Optional[Sequence[str]] = None,
                   key_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicKeyResult:
    """
    Use this data source to get the public key about the specified KMS Key with flexible key id input. This can be useful to reference key alias without having to hard code the ARN as input.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    by_alias = aws.kms.get_public_key(key_id="alias/my-key")
    by_id = aws.kms.get_public_key(key_id="1234abcd-12ab-34cd-56ef-1234567890ab")
    by_alias_arn = aws.kms.get_public_key(key_id="arn:aws:kms:us-east-1:111122223333:alias/my-key")
    by_key_arn = aws.kms.get_public_key(key_id="arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab")
    ```


    :param Sequence[str] grant_tokens: List of grant tokens
    :param str key_id: Key identifier which can be one of the following format:
           * Key ID. E.g - `1234abcd-12ab-34cd-56ef-1234567890ab`
           * Key ARN. E.g. - `arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
           * Alias name. E.g. - `alias/my-key`
           * Alias ARN - E.g. - `arn:aws:kms:us-east-1:111122223333:alias/my-key`
    """
    __args__ = dict()
    __args__['grantTokens'] = grant_tokens
    __args__['keyId'] = key_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:kms/getPublicKey:getPublicKey', __args__, opts=opts, typ=GetPublicKeyResult).value

    return AwaitableGetPublicKeyResult(
        arn=pulumi.get(__ret__, 'arn'),
        customer_master_key_spec=pulumi.get(__ret__, 'customer_master_key_spec'),
        encryption_algorithms=pulumi.get(__ret__, 'encryption_algorithms'),
        grant_tokens=pulumi.get(__ret__, 'grant_tokens'),
        id=pulumi.get(__ret__, 'id'),
        key_id=pulumi.get(__ret__, 'key_id'),
        key_usage=pulumi.get(__ret__, 'key_usage'),
        public_key=pulumi.get(__ret__, 'public_key'),
        public_key_pem=pulumi.get(__ret__, 'public_key_pem'),
        signing_algorithms=pulumi.get(__ret__, 'signing_algorithms'))
def get_public_key_output(grant_tokens: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                          key_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPublicKeyResult]:
    """
    Use this data source to get the public key about the specified KMS Key with flexible key id input. This can be useful to reference key alias without having to hard code the ARN as input.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    by_alias = aws.kms.get_public_key(key_id="alias/my-key")
    by_id = aws.kms.get_public_key(key_id="1234abcd-12ab-34cd-56ef-1234567890ab")
    by_alias_arn = aws.kms.get_public_key(key_id="arn:aws:kms:us-east-1:111122223333:alias/my-key")
    by_key_arn = aws.kms.get_public_key(key_id="arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab")
    ```


    :param Sequence[str] grant_tokens: List of grant tokens
    :param str key_id: Key identifier which can be one of the following format:
           * Key ID. E.g - `1234abcd-12ab-34cd-56ef-1234567890ab`
           * Key ARN. E.g. - `arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
           * Alias name. E.g. - `alias/my-key`
           * Alias ARN - E.g. - `arn:aws:kms:us-east-1:111122223333:alias/my-key`
    """
    __args__ = dict()
    __args__['grantTokens'] = grant_tokens
    __args__['keyId'] = key_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:kms/getPublicKey:getPublicKey', __args__, opts=opts, typ=GetPublicKeyResult)
    return __ret__.apply(lambda __response__: GetPublicKeyResult(
        arn=pulumi.get(__response__, 'arn'),
        customer_master_key_spec=pulumi.get(__response__, 'customer_master_key_spec'),
        encryption_algorithms=pulumi.get(__response__, 'encryption_algorithms'),
        grant_tokens=pulumi.get(__response__, 'grant_tokens'),
        id=pulumi.get(__response__, 'id'),
        key_id=pulumi.get(__response__, 'key_id'),
        key_usage=pulumi.get(__response__, 'key_usage'),
        public_key=pulumi.get(__response__, 'public_key'),
        public_key_pem=pulumi.get(__response__, 'public_key_pem'),
        signing_algorithms=pulumi.get(__response__, 'signing_algorithms')))
