# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceLfTagsArgs', 'ResourceLfTags']

@pulumi.input_type
class ResourceLfTagsArgs:
    def __init__(__self__, *,
                 lf_tags: pulumi.Input[Sequence[pulumi.Input['ResourceLfTagsLfTagArgs']]],
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input['ResourceLfTagsDatabaseArgs']] = None,
                 table: Optional[pulumi.Input['ResourceLfTagsTableArgs']] = None,
                 table_with_columns: Optional[pulumi.Input['ResourceLfTagsTableWithColumnsArgs']] = None):
        """
        The set of arguments for constructing a ResourceLfTags resource.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceLfTagsLfTagArgs']]] lf_tags: Set of LF-tags to attach to the resource. See below.
               
               Exactly one of the following is required:
        :param pulumi.Input[str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input['ResourceLfTagsDatabaseArgs'] database: Configuration block for a database resource. See below.
        :param pulumi.Input['ResourceLfTagsTableArgs'] table: Configuration block for a table resource. See below.
        :param pulumi.Input['ResourceLfTagsTableWithColumnsArgs'] table_with_columns: Configuration block for a table with columns resource. See below.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "lf_tags", lf_tags)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if table_with_columns is not None:
            pulumi.set(__self__, "table_with_columns", table_with_columns)

    @property
    @pulumi.getter(name="lfTags")
    def lf_tags(self) -> pulumi.Input[Sequence[pulumi.Input['ResourceLfTagsLfTagArgs']]]:
        """
        Set of LF-tags to attach to the resource. See below.

        Exactly one of the following is required:
        """
        return pulumi.get(self, "lf_tags")

    @lf_tags.setter
    def lf_tags(self, value: pulumi.Input[Sequence[pulumi.Input['ResourceLfTagsLfTagArgs']]]):
        pulumi.set(self, "lf_tags", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['ResourceLfTagsDatabaseArgs']]:
        """
        Configuration block for a database resource. See below.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['ResourceLfTagsDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input['ResourceLfTagsTableArgs']]:
        """
        Configuration block for a table resource. See below.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input['ResourceLfTagsTableArgs']]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> Optional[pulumi.Input['ResourceLfTagsTableWithColumnsArgs']]:
        """
        Configuration block for a table with columns resource. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_with_columns")

    @table_with_columns.setter
    def table_with_columns(self, value: Optional[pulumi.Input['ResourceLfTagsTableWithColumnsArgs']]):
        pulumi.set(self, "table_with_columns", value)


@pulumi.input_type
class _ResourceLfTagsState:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input['ResourceLfTagsDatabaseArgs']] = None,
                 lf_tags: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceLfTagsLfTagArgs']]]] = None,
                 table: Optional[pulumi.Input['ResourceLfTagsTableArgs']] = None,
                 table_with_columns: Optional[pulumi.Input['ResourceLfTagsTableWithColumnsArgs']] = None):
        """
        Input properties used for looking up and filtering ResourceLfTags resources.
        :param pulumi.Input[str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input['ResourceLfTagsDatabaseArgs'] database: Configuration block for a database resource. See below.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceLfTagsLfTagArgs']]] lf_tags: Set of LF-tags to attach to the resource. See below.
               
               Exactly one of the following is required:
        :param pulumi.Input['ResourceLfTagsTableArgs'] table: Configuration block for a table resource. See below.
        :param pulumi.Input['ResourceLfTagsTableWithColumnsArgs'] table_with_columns: Configuration block for a table with columns resource. See below.
               
               The following arguments are optional:
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if lf_tags is not None:
            pulumi.set(__self__, "lf_tags", lf_tags)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if table_with_columns is not None:
            pulumi.set(__self__, "table_with_columns", table_with_columns)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['ResourceLfTagsDatabaseArgs']]:
        """
        Configuration block for a database resource. See below.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['ResourceLfTagsDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="lfTags")
    def lf_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceLfTagsLfTagArgs']]]]:
        """
        Set of LF-tags to attach to the resource. See below.

        Exactly one of the following is required:
        """
        return pulumi.get(self, "lf_tags")

    @lf_tags.setter
    def lf_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceLfTagsLfTagArgs']]]]):
        pulumi.set(self, "lf_tags", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input['ResourceLfTagsTableArgs']]:
        """
        Configuration block for a table resource. See below.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input['ResourceLfTagsTableArgs']]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> Optional[pulumi.Input['ResourceLfTagsTableWithColumnsArgs']]:
        """
        Configuration block for a table with columns resource. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_with_columns")

    @table_with_columns.setter
    def table_with_columns(self, value: Optional[pulumi.Input['ResourceLfTagsTableWithColumnsArgs']]):
        pulumi.set(self, "table_with_columns", value)


class ResourceLfTags(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[Union['ResourceLfTagsDatabaseArgs', 'ResourceLfTagsDatabaseArgsDict']]] = None,
                 lf_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceLfTagsLfTagArgs', 'ResourceLfTagsLfTagArgsDict']]]]] = None,
                 table: Optional[pulumi.Input[Union['ResourceLfTagsTableArgs', 'ResourceLfTagsTableArgsDict']]] = None,
                 table_with_columns: Optional[pulumi.Input[Union['ResourceLfTagsTableWithColumnsArgs', 'ResourceLfTagsTableWithColumnsArgsDict']]] = None,
                 __props__=None):
        """
        Manages an attachment between one or more existing LF-tags and an existing Lake Formation resource.

        ## Example Usage

        ### Database Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.LfTag("example",
            key="right",
            values=[
                "abbey",
                "village",
                "luffield",
                "woodcote",
                "copse",
                "chapel",
                "stowe",
                "club",
            ])
        example_resource_lf_tags = aws.lakeformation.ResourceLfTags("example",
            database={
                "name": example_aws_glue_catalog_database["name"],
            },
            lf_tags=[{
                "key": example.key,
                "value": "stowe",
            }])
        ```

        ### Multiple Tags Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.LfTag("example",
            key="right",
            values=[
                "abbey",
                "village",
                "luffield",
                "woodcote",
                "copse",
                "chapel",
                "stowe",
                "club",
            ])
        example2 = aws.lakeformation.LfTag("example2",
            key="left",
            values=[
                "farm",
                "theloop",
                "aintree",
                "brooklands",
                "maggotts",
                "becketts",
                "vale",
            ])
        example_resource_lf_tags = aws.lakeformation.ResourceLfTags("example",
            database={
                "name": example_aws_glue_catalog_database["name"],
            },
            lf_tags=[
                {
                    "key": "right",
                    "value": "luffield",
                },
                {
                    "key": "left",
                    "value": "aintree",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input[Union['ResourceLfTagsDatabaseArgs', 'ResourceLfTagsDatabaseArgsDict']] database: Configuration block for a database resource. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceLfTagsLfTagArgs', 'ResourceLfTagsLfTagArgsDict']]]] lf_tags: Set of LF-tags to attach to the resource. See below.
               
               Exactly one of the following is required:
        :param pulumi.Input[Union['ResourceLfTagsTableArgs', 'ResourceLfTagsTableArgsDict']] table: Configuration block for a table resource. See below.
        :param pulumi.Input[Union['ResourceLfTagsTableWithColumnsArgs', 'ResourceLfTagsTableWithColumnsArgsDict']] table_with_columns: Configuration block for a table with columns resource. See below.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceLfTagsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an attachment between one or more existing LF-tags and an existing Lake Formation resource.

        ## Example Usage

        ### Database Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.LfTag("example",
            key="right",
            values=[
                "abbey",
                "village",
                "luffield",
                "woodcote",
                "copse",
                "chapel",
                "stowe",
                "club",
            ])
        example_resource_lf_tags = aws.lakeformation.ResourceLfTags("example",
            database={
                "name": example_aws_glue_catalog_database["name"],
            },
            lf_tags=[{
                "key": example.key,
                "value": "stowe",
            }])
        ```

        ### Multiple Tags Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.LfTag("example",
            key="right",
            values=[
                "abbey",
                "village",
                "luffield",
                "woodcote",
                "copse",
                "chapel",
                "stowe",
                "club",
            ])
        example2 = aws.lakeformation.LfTag("example2",
            key="left",
            values=[
                "farm",
                "theloop",
                "aintree",
                "brooklands",
                "maggotts",
                "becketts",
                "vale",
            ])
        example_resource_lf_tags = aws.lakeformation.ResourceLfTags("example",
            database={
                "name": example_aws_glue_catalog_database["name"],
            },
            lf_tags=[
                {
                    "key": "right",
                    "value": "luffield",
                },
                {
                    "key": "left",
                    "value": "aintree",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param ResourceLfTagsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceLfTagsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[Union['ResourceLfTagsDatabaseArgs', 'ResourceLfTagsDatabaseArgsDict']]] = None,
                 lf_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceLfTagsLfTagArgs', 'ResourceLfTagsLfTagArgsDict']]]]] = None,
                 table: Optional[pulumi.Input[Union['ResourceLfTagsTableArgs', 'ResourceLfTagsTableArgsDict']]] = None,
                 table_with_columns: Optional[pulumi.Input[Union['ResourceLfTagsTableWithColumnsArgs', 'ResourceLfTagsTableWithColumnsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceLfTagsArgs.__new__(ResourceLfTagsArgs)

            __props__.__dict__["catalog_id"] = catalog_id
            __props__.__dict__["database"] = database
            if lf_tags is None and not opts.urn:
                raise TypeError("Missing required property 'lf_tags'")
            __props__.__dict__["lf_tags"] = lf_tags
            __props__.__dict__["table"] = table
            __props__.__dict__["table_with_columns"] = table_with_columns
        super(ResourceLfTags, __self__).__init__(
            'aws:lakeformation/resourceLfTags:ResourceLfTags',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_id: Optional[pulumi.Input[str]] = None,
            database: Optional[pulumi.Input[Union['ResourceLfTagsDatabaseArgs', 'ResourceLfTagsDatabaseArgsDict']]] = None,
            lf_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceLfTagsLfTagArgs', 'ResourceLfTagsLfTagArgsDict']]]]] = None,
            table: Optional[pulumi.Input[Union['ResourceLfTagsTableArgs', 'ResourceLfTagsTableArgsDict']]] = None,
            table_with_columns: Optional[pulumi.Input[Union['ResourceLfTagsTableWithColumnsArgs', 'ResourceLfTagsTableWithColumnsArgsDict']]] = None) -> 'ResourceLfTags':
        """
        Get an existing ResourceLfTags resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input[Union['ResourceLfTagsDatabaseArgs', 'ResourceLfTagsDatabaseArgsDict']] database: Configuration block for a database resource. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceLfTagsLfTagArgs', 'ResourceLfTagsLfTagArgsDict']]]] lf_tags: Set of LF-tags to attach to the resource. See below.
               
               Exactly one of the following is required:
        :param pulumi.Input[Union['ResourceLfTagsTableArgs', 'ResourceLfTagsTableArgsDict']] table: Configuration block for a table resource. See below.
        :param pulumi.Input[Union['ResourceLfTagsTableWithColumnsArgs', 'ResourceLfTagsTableWithColumnsArgsDict']] table_with_columns: Configuration block for a table with columns resource. See below.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceLfTagsState.__new__(_ResourceLfTagsState)

        __props__.__dict__["catalog_id"] = catalog_id
        __props__.__dict__["database"] = database
        __props__.__dict__["lf_tags"] = lf_tags
        __props__.__dict__["table"] = table
        __props__.__dict__["table_with_columns"] = table_with_columns
        return ResourceLfTags(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[str]:
        """
        Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output['outputs.ResourceLfTagsDatabase']:
        """
        Configuration block for a database resource. See below.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="lfTags")
    def lf_tags(self) -> pulumi.Output[Sequence['outputs.ResourceLfTagsLfTag']]:
        """
        Set of LF-tags to attach to the resource. See below.

        Exactly one of the following is required:
        """
        return pulumi.get(self, "lf_tags")

    @property
    @pulumi.getter
    def table(self) -> pulumi.Output['outputs.ResourceLfTagsTable']:
        """
        Configuration block for a table resource. See below.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> pulumi.Output['outputs.ResourceLfTagsTableWithColumns']:
        """
        Configuration block for a table with columns resource. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_with_columns")

