# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ListenerDefaultAction',
    'ListenerDefaultActionAuthenticateCognito',
    'ListenerDefaultActionAuthenticateOidc',
    'ListenerDefaultActionFixedResponse',
    'ListenerDefaultActionForward',
    'ListenerDefaultActionForwardStickiness',
    'ListenerDefaultActionForwardTargetGroup',
    'ListenerDefaultActionRedirect',
    'ListenerMutualAuthentication',
    'ListenerRuleAction',
    'ListenerRuleActionAuthenticateCognito',
    'ListenerRuleActionAuthenticateOidc',
    'ListenerRuleActionFixedResponse',
    'ListenerRuleActionForward',
    'ListenerRuleActionForwardStickiness',
    'ListenerRuleActionForwardTargetGroup',
    'ListenerRuleActionRedirect',
    'ListenerRuleCondition',
    'ListenerRuleConditionHostHeader',
    'ListenerRuleConditionHttpHeader',
    'ListenerRuleConditionHttpRequestMethod',
    'ListenerRuleConditionPathPattern',
    'ListenerRuleConditionQueryString',
    'ListenerRuleConditionSourceIp',
    'LoadBalancerAccessLogs',
    'LoadBalancerConnectionLogs',
    'LoadBalancerSubnetMapping',
    'TargetGroupHealthCheck',
    'TargetGroupStickiness',
    'TargetGroupTargetFailover',
    'TargetGroupTargetGroupHealth',
    'TargetGroupTargetGroupHealthDnsFailover',
    'TargetGroupTargetGroupHealthUnhealthyStateRouting',
    'TargetGroupTargetHealthState',
    'GetListenerDefaultActionResult',
    'GetListenerDefaultActionAuthenticateCognitoResult',
    'GetListenerDefaultActionAuthenticateOidcResult',
    'GetListenerDefaultActionFixedResponseResult',
    'GetListenerDefaultActionForwardResult',
    'GetListenerDefaultActionForwardStickinessResult',
    'GetListenerDefaultActionForwardTargetGroupResult',
    'GetListenerDefaultActionRedirectResult',
    'GetListenerMutualAuthenticationResult',
    'GetListenerRuleActionResult',
    'GetListenerRuleActionAuthenticateCognitoResult',
    'GetListenerRuleActionAuthenticateOidcResult',
    'GetListenerRuleActionFixedResponseResult',
    'GetListenerRuleActionForwardResult',
    'GetListenerRuleActionForwardStickinessResult',
    'GetListenerRuleActionForwardTargetGroupResult',
    'GetListenerRuleActionRedirectResult',
    'GetListenerRuleConditionResult',
    'GetListenerRuleConditionHostHeaderResult',
    'GetListenerRuleConditionHttpHeaderResult',
    'GetListenerRuleConditionHttpRequestMethodResult',
    'GetListenerRuleConditionPathPatternResult',
    'GetListenerRuleConditionQueryStringResult',
    'GetListenerRuleConditionQueryStringValueResult',
    'GetListenerRuleConditionSourceIpResult',
    'GetLoadBalancerAccessLogsResult',
    'GetLoadBalancerConnectionLogResult',
    'GetLoadBalancerSubnetMappingResult',
    'GetTargetGroupHealthCheckResult',
    'GetTargetGroupStickinessResult',
]

@pulumi.output_type
class ListenerDefaultAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticateCognito":
            suggest = "authenticate_cognito"
        elif key == "authenticateOidc":
            suggest = "authenticate_oidc"
        elif key == "fixedResponse":
            suggest = "fixed_response"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 authenticate_cognito: Optional['outputs.ListenerDefaultActionAuthenticateCognito'] = None,
                 authenticate_oidc: Optional['outputs.ListenerDefaultActionAuthenticateOidc'] = None,
                 fixed_response: Optional['outputs.ListenerDefaultActionFixedResponse'] = None,
                 forward: Optional['outputs.ListenerDefaultActionForward'] = None,
                 order: Optional[int] = None,
                 redirect: Optional['outputs.ListenerDefaultActionRedirect'] = None,
                 target_group_arn: Optional[str] = None):
        """
        :param str type: Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
               
               The following arguments are optional:
        :param 'ListenerDefaultActionAuthenticateCognitoArgs' authenticate_cognito: Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. See below.
        :param 'ListenerDefaultActionAuthenticateOidcArgs' authenticate_oidc: Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. See below.
        :param 'ListenerDefaultActionFixedResponseArgs' fixed_response: Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        :param 'ListenerDefaultActionForwardArgs' forward: Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. See below.
        :param int order: Order for the action. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`. Defaults to the position in the list of actions.
        :param 'ListenerDefaultActionRedirectArgs' redirect: Configuration block for creating a redirect action. Required if `type` is `redirect`. See below.
        :param str target_group_arn: ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead. Can be specified with `forward` but ARNs must match.
        """
        pulumi.set(__self__, "type", type)
        if authenticate_cognito is not None:
            pulumi.set(__self__, "authenticate_cognito", authenticate_cognito)
        if authenticate_oidc is not None:
            pulumi.set(__self__, "authenticate_oidc", authenticate_oidc)
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="authenticateCognito")
    def authenticate_cognito(self) -> Optional['outputs.ListenerDefaultActionAuthenticateCognito']:
        """
        Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. See below.
        """
        return pulumi.get(self, "authenticate_cognito")

    @property
    @pulumi.getter(name="authenticateOidc")
    def authenticate_oidc(self) -> Optional['outputs.ListenerDefaultActionAuthenticateOidc']:
        """
        Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. See below.
        """
        return pulumi.get(self, "authenticate_oidc")

    @property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional['outputs.ListenerDefaultActionFixedResponse']:
        """
        Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        """
        return pulumi.get(self, "fixed_response")

    @property
    @pulumi.getter
    def forward(self) -> Optional['outputs.ListenerDefaultActionForward']:
        """
        Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. See below.
        """
        return pulumi.get(self, "forward")

    @property
    @pulumi.getter
    def order(self) -> Optional[int]:
        """
        Order for the action. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`. Defaults to the position in the list of actions.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.ListenerDefaultActionRedirect']:
        """
        Configuration block for creating a redirect action. Required if `type` is `redirect`. See below.
        """
        return pulumi.get(self, "redirect")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[str]:
        """
        ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead. Can be specified with `forward` but ARNs must match.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class ListenerDefaultActionAuthenticateCognito(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userPoolArn":
            suggest = "user_pool_arn"
        elif key == "userPoolClientId":
            suggest = "user_pool_client_id"
        elif key == "userPoolDomain":
            suggest = "user_pool_domain"
        elif key == "authenticationRequestExtraParams":
            suggest = "authentication_request_extra_params"
        elif key == "onUnauthenticatedRequest":
            suggest = "on_unauthenticated_request"
        elif key == "sessionCookieName":
            suggest = "session_cookie_name"
        elif key == "sessionTimeout":
            suggest = "session_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionAuthenticateCognito. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionAuthenticateCognito.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionAuthenticateCognito.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_pool_arn: str,
                 user_pool_client_id: str,
                 user_pool_domain: str,
                 authentication_request_extra_params: Optional[Mapping[str, str]] = None,
                 on_unauthenticated_request: Optional[str] = None,
                 scope: Optional[str] = None,
                 session_cookie_name: Optional[str] = None,
                 session_timeout: Optional[int] = None):
        """
        :param str user_pool_arn: ARN of the Cognito user pool.
        :param str user_pool_client_id: ID of the Cognito user pool client.
        :param str user_pool_domain: Domain prefix or fully-qualified domain name of the Cognito user pool.
               
               The following arguments are optional:
        :param Mapping[str, str] authentication_request_extra_params: Query parameters to include in the redirect request to the authorization endpoint. Max: 10. See below.
        :param str on_unauthenticated_request: Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
        :param str scope: Set of user claims to be requested from the IdP.
        :param str session_cookie_name: Name of the cookie used to maintain session information.
        :param int session_timeout: Maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> str:
        """
        ARN of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_arn")

    @property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> str:
        """
        ID of the Cognito user pool client.
        """
        return pulumi.get(self, "user_pool_client_id")

    @property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> str:
        """
        Domain prefix or fully-qualified domain name of the Cognito user pool.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_pool_domain")

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[Mapping[str, str]]:
        """
        Query parameters to include in the redirect request to the authorization endpoint. Max: 10. See below.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[str]:
        """
        Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        Set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[str]:
        """
        Name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[int]:
        """
        Maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")


@pulumi.output_type
class ListenerDefaultActionAuthenticateOidc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"
        elif key == "authenticationRequestExtraParams":
            suggest = "authentication_request_extra_params"
        elif key == "onUnauthenticatedRequest":
            suggest = "on_unauthenticated_request"
        elif key == "sessionCookieName":
            suggest = "session_cookie_name"
        elif key == "sessionTimeout":
            suggest = "session_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionAuthenticateOidc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionAuthenticateOidc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionAuthenticateOidc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_endpoint: str,
                 client_id: str,
                 client_secret: str,
                 issuer: str,
                 token_endpoint: str,
                 user_info_endpoint: str,
                 authentication_request_extra_params: Optional[Mapping[str, str]] = None,
                 on_unauthenticated_request: Optional[str] = None,
                 scope: Optional[str] = None,
                 session_cookie_name: Optional[str] = None,
                 session_timeout: Optional[int] = None):
        """
        :param str authorization_endpoint: Authorization endpoint of the IdP.
        :param str client_id: OAuth 2.0 client identifier.
        :param str client_secret: OAuth 2.0 client secret.
        :param str issuer: OIDC issuer identifier of the IdP.
        :param str token_endpoint: Token endpoint of the IdP.
        :param str user_info_endpoint: User info endpoint of the IdP.
               
               The following arguments are optional:
        :param Mapping[str, str] authentication_request_extra_params: Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param str on_unauthenticated_request: Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param str scope: Set of user claims to be requested from the IdP.
        :param str session_cookie_name: Name of the cookie used to maintain session information.
        :param int session_timeout: Maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> str:
        """
        Authorization endpoint of the IdP.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        OAuth 2.0 client identifier.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        OAuth 2.0 client secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        OIDC issuer identifier of the IdP.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> str:
        """
        Token endpoint of the IdP.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> str:
        """
        User info endpoint of the IdP.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_info_endpoint")

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[Mapping[str, str]]:
        """
        Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[str]:
        """
        Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        Set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[str]:
        """
        Name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[int]:
        """
        Maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")


@pulumi.output_type
class ListenerDefaultActionFixedResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "messageBody":
            suggest = "message_body"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionFixedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionFixedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionFixedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: str,
                 message_body: Optional[str] = None,
                 status_code: Optional[str] = None):
        """
        :param str content_type: Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
               
               The following arguments are optional:
        :param str message_body: Message body.
        :param str status_code: HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if message_body is not None:
            pulumi.set(__self__, "message_body", message_body)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.

        The following arguments are optional:
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> Optional[str]:
        """
        Message body.
        """
        return pulumi.get(self, "message_body")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[str]:
        """
        HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ListenerDefaultActionForward(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroups":
            suggest = "target_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionForward. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionForward.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionForward.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_groups: Sequence['outputs.ListenerDefaultActionForwardTargetGroup'],
                 stickiness: Optional['outputs.ListenerDefaultActionForwardStickiness'] = None):
        """
        :param Sequence['ListenerDefaultActionForwardTargetGroupArgs'] target_groups: Set of 1-5 target group blocks. See below.
               
               The following arguments are optional:
        :param 'ListenerDefaultActionForwardStickinessArgs' stickiness: Configuration block for target group stickiness for the rule. See below.
        """
        pulumi.set(__self__, "target_groups", target_groups)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Sequence['outputs.ListenerDefaultActionForwardTargetGroup']:
        """
        Set of 1-5 target group blocks. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_groups")

    @property
    @pulumi.getter
    def stickiness(self) -> Optional['outputs.ListenerDefaultActionForwardStickiness']:
        """
        Configuration block for target group stickiness for the rule. See below.
        """
        return pulumi.get(self, "stickiness")


@pulumi.output_type
class ListenerDefaultActionForwardStickiness(dict):
    def __init__(__self__, *,
                 duration: int,
                 enabled: Optional[bool] = None):
        """
        :param int duration: Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
               
               The following arguments are optional:
        :param bool enabled: Whether target group stickiness is enabled. Default is `false`.
        """
        pulumi.set(__self__, "duration", duration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).

        The following arguments are optional:
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether target group stickiness is enabled. Default is `false`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ListenerDefaultActionForwardTargetGroup(dict):
    def __init__(__self__, *,
                 arn: str,
                 weight: Optional[int] = None):
        """
        :param str arn: ARN of the target group.
               
               The following arguments are optional:
        :param int weight: Weight. The range is 0 to 999.
        """
        pulumi.set(__self__, "arn", arn)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the target group.

        The following arguments are optional:
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        Weight. The range is 0 to 999.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ListenerDefaultActionRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: str,
                 host: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[str] = None,
                 protocol: Optional[str] = None,
                 query: Optional[str] = None):
        """
        :param str status_code: HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
               
               The following arguments are optional:
        :param str host: Hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        :param str path: Absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        :param str port: Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        :param str protocol: Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        :param str query: Query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        pulumi.set(__self__, "status_code", status_code)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> str:
        """
        HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).

        The following arguments are optional:
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        Query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class ListenerMutualAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreClientCertificateExpiry":
            suggest = "ignore_client_certificate_expiry"
        elif key == "trustStoreArn":
            suggest = "trust_store_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerMutualAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerMutualAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerMutualAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: str,
                 ignore_client_certificate_expiry: Optional[bool] = None,
                 trust_store_arn: Optional[str] = None):
        """
        :param str mode: Valid values are `off`, `verify` and `passthrough`.
        :param bool ignore_client_certificate_expiry: Whether client certificate expiry is ignored. Default is `false`.
        :param str trust_store_arn: ARN of the elbv2 Trust Store.
        """
        pulumi.set(__self__, "mode", mode)
        if ignore_client_certificate_expiry is not None:
            pulumi.set(__self__, "ignore_client_certificate_expiry", ignore_client_certificate_expiry)
        if trust_store_arn is not None:
            pulumi.set(__self__, "trust_store_arn", trust_store_arn)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Valid values are `off`, `verify` and `passthrough`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="ignoreClientCertificateExpiry")
    def ignore_client_certificate_expiry(self) -> Optional[bool]:
        """
        Whether client certificate expiry is ignored. Default is `false`.
        """
        return pulumi.get(self, "ignore_client_certificate_expiry")

    @property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> Optional[str]:
        """
        ARN of the elbv2 Trust Store.
        """
        return pulumi.get(self, "trust_store_arn")


@pulumi.output_type
class ListenerRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticateCognito":
            suggest = "authenticate_cognito"
        elif key == "authenticateOidc":
            suggest = "authenticate_oidc"
        elif key == "fixedResponse":
            suggest = "fixed_response"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 authenticate_cognito: Optional['outputs.ListenerRuleActionAuthenticateCognito'] = None,
                 authenticate_oidc: Optional['outputs.ListenerRuleActionAuthenticateOidc'] = None,
                 fixed_response: Optional['outputs.ListenerRuleActionFixedResponse'] = None,
                 forward: Optional['outputs.ListenerRuleActionForward'] = None,
                 order: Optional[int] = None,
                 redirect: Optional['outputs.ListenerRuleActionRedirect'] = None,
                 target_group_arn: Optional[str] = None):
        """
        :param str type: The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
        :param 'ListenerRuleActionAuthenticateCognitoArgs' authenticate_cognito: Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
        :param 'ListenerRuleActionAuthenticateOidcArgs' authenticate_oidc: Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
        :param 'ListenerRuleActionFixedResponseArgs' fixed_response: Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        :param 'ListenerRuleActionForwardArgs' forward: Configuration block for creating an action that distributes requests among one or more target groups.
               Specify only if `type` is `forward`.
               Cannot be specified with `target_group_arn`.
        :param int order: Order for the action.
               The action with the lowest value for order is performed first.
               Valid values are between `1` and `50000`.
               Defaults to the position in the list of actions.
        :param 'ListenerRuleActionRedirectArgs' redirect: Information for creating a redirect action. Required if `type` is `redirect`.
        :param str target_group_arn: ARN of the Target Group to which to route traffic.
               Specify only if `type` is `forward` and you want to route to a single target group.
               To route to one or more target groups, use a `forward` block instead.
               Cannot be specified with `forward`.
        """
        pulumi.set(__self__, "type", type)
        if authenticate_cognito is not None:
            pulumi.set(__self__, "authenticate_cognito", authenticate_cognito)
        if authenticate_oidc is not None:
            pulumi.set(__self__, "authenticate_oidc", authenticate_oidc)
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="authenticateCognito")
    def authenticate_cognito(self) -> Optional['outputs.ListenerRuleActionAuthenticateCognito']:
        """
        Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
        """
        return pulumi.get(self, "authenticate_cognito")

    @property
    @pulumi.getter(name="authenticateOidc")
    def authenticate_oidc(self) -> Optional['outputs.ListenerRuleActionAuthenticateOidc']:
        """
        Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
        """
        return pulumi.get(self, "authenticate_oidc")

    @property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional['outputs.ListenerRuleActionFixedResponse']:
        """
        Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        """
        return pulumi.get(self, "fixed_response")

    @property
    @pulumi.getter
    def forward(self) -> Optional['outputs.ListenerRuleActionForward']:
        """
        Configuration block for creating an action that distributes requests among one or more target groups.
        Specify only if `type` is `forward`.
        Cannot be specified with `target_group_arn`.
        """
        return pulumi.get(self, "forward")

    @property
    @pulumi.getter
    def order(self) -> Optional[int]:
        """
        Order for the action.
        The action with the lowest value for order is performed first.
        Valid values are between `1` and `50000`.
        Defaults to the position in the list of actions.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.ListenerRuleActionRedirect']:
        """
        Information for creating a redirect action. Required if `type` is `redirect`.
        """
        return pulumi.get(self, "redirect")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[str]:
        """
        ARN of the Target Group to which to route traffic.
        Specify only if `type` is `forward` and you want to route to a single target group.
        To route to one or more target groups, use a `forward` block instead.
        Cannot be specified with `forward`.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class ListenerRuleActionAuthenticateCognito(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userPoolArn":
            suggest = "user_pool_arn"
        elif key == "userPoolClientId":
            suggest = "user_pool_client_id"
        elif key == "userPoolDomain":
            suggest = "user_pool_domain"
        elif key == "authenticationRequestExtraParams":
            suggest = "authentication_request_extra_params"
        elif key == "onUnauthenticatedRequest":
            suggest = "on_unauthenticated_request"
        elif key == "sessionCookieName":
            suggest = "session_cookie_name"
        elif key == "sessionTimeout":
            suggest = "session_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionAuthenticateCognito. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionAuthenticateCognito.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionAuthenticateCognito.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_pool_arn: str,
                 user_pool_client_id: str,
                 user_pool_domain: str,
                 authentication_request_extra_params: Optional[Mapping[str, str]] = None,
                 on_unauthenticated_request: Optional[str] = None,
                 scope: Optional[str] = None,
                 session_cookie_name: Optional[str] = None,
                 session_timeout: Optional[int] = None):
        """
        :param str user_pool_arn: The ARN of the Cognito user pool.
        :param str user_pool_client_id: The ID of the Cognito user pool client.
        :param str user_pool_domain: The domain prefix or fully-qualified domain name of the Cognito user pool.
        :param Mapping[str, str] authentication_request_extra_params: The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param str on_unauthenticated_request: The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param str scope: The set of user claims to be requested from the IdP.
        :param str session_cookie_name: The name of the cookie used to maintain session information.
        :param int session_timeout: The maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> str:
        """
        The ARN of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_arn")

    @property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> str:
        """
        The ID of the Cognito user pool client.
        """
        return pulumi.get(self, "user_pool_client_id")

    @property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> str:
        """
        The domain prefix or fully-qualified domain name of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_domain")

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[Mapping[str, str]]:
        """
        The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[str]:
        """
        The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[str]:
        """
        The name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[int]:
        """
        The maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")


@pulumi.output_type
class ListenerRuleActionAuthenticateOidc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"
        elif key == "authenticationRequestExtraParams":
            suggest = "authentication_request_extra_params"
        elif key == "onUnauthenticatedRequest":
            suggest = "on_unauthenticated_request"
        elif key == "sessionCookieName":
            suggest = "session_cookie_name"
        elif key == "sessionTimeout":
            suggest = "session_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionAuthenticateOidc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionAuthenticateOidc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionAuthenticateOidc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_endpoint: str,
                 client_id: str,
                 client_secret: str,
                 issuer: str,
                 token_endpoint: str,
                 user_info_endpoint: str,
                 authentication_request_extra_params: Optional[Mapping[str, str]] = None,
                 on_unauthenticated_request: Optional[str] = None,
                 scope: Optional[str] = None,
                 session_cookie_name: Optional[str] = None,
                 session_timeout: Optional[int] = None):
        """
        :param str authorization_endpoint: The authorization endpoint of the IdP.
        :param str client_id: The OAuth 2.0 client identifier.
        :param str client_secret: The OAuth 2.0 client secret.
        :param str issuer: The OIDC issuer identifier of the IdP.
        :param str token_endpoint: The token endpoint of the IdP.
        :param str user_info_endpoint: The user info endpoint of the IdP.
        :param Mapping[str, str] authentication_request_extra_params: The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param str on_unauthenticated_request: The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param str scope: The set of user claims to be requested from the IdP.
        :param str session_cookie_name: The name of the cookie used to maintain session information.
        :param int session_timeout: The maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> str:
        """
        The authorization endpoint of the IdP.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The OAuth 2.0 client identifier.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        The OAuth 2.0 client secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        The OIDC issuer identifier of the IdP.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> str:
        """
        The token endpoint of the IdP.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> str:
        """
        The user info endpoint of the IdP.
        """
        return pulumi.get(self, "user_info_endpoint")

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[Mapping[str, str]]:
        """
        The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[str]:
        """
        The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[str]:
        """
        The name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[int]:
        """
        The maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")


@pulumi.output_type
class ListenerRuleActionFixedResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "messageBody":
            suggest = "message_body"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionFixedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionFixedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionFixedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: str,
                 message_body: Optional[str] = None,
                 status_code: Optional[str] = None):
        """
        :param str content_type: The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
        :param str message_body: The message body.
        :param str status_code: The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if message_body is not None:
            pulumi.set(__self__, "message_body", message_body)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> Optional[str]:
        """
        The message body.
        """
        return pulumi.get(self, "message_body")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[str]:
        """
        The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ListenerRuleActionForward(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroups":
            suggest = "target_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionForward. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionForward.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionForward.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_groups: Sequence['outputs.ListenerRuleActionForwardTargetGroup'],
                 stickiness: Optional['outputs.ListenerRuleActionForwardStickiness'] = None):
        """
        :param Sequence['ListenerRuleActionForwardTargetGroupArgs'] target_groups: One or more target group blocks.
        :param 'ListenerRuleActionForwardStickinessArgs' stickiness: The target group stickiness for the rule.
        """
        pulumi.set(__self__, "target_groups", target_groups)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Sequence['outputs.ListenerRuleActionForwardTargetGroup']:
        """
        One or more target group blocks.
        """
        return pulumi.get(self, "target_groups")

    @property
    @pulumi.getter
    def stickiness(self) -> Optional['outputs.ListenerRuleActionForwardStickiness']:
        """
        The target group stickiness for the rule.
        """
        return pulumi.get(self, "stickiness")


@pulumi.output_type
class ListenerRuleActionForwardStickiness(dict):
    def __init__(__self__, *,
                 duration: int,
                 enabled: Optional[bool] = None):
        """
        :param int duration: The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        :param bool enabled: Indicates whether target group stickiness is enabled.
        """
        pulumi.set(__self__, "duration", duration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Indicates whether target group stickiness is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ListenerRuleActionForwardTargetGroup(dict):
    def __init__(__self__, *,
                 arn: str,
                 weight: Optional[int] = None):
        """
        :param str arn: The Amazon Resource Name (ARN) of the target group.
        :param int weight: The weight. The range is 0 to 999.
        """
        pulumi.set(__self__, "arn", arn)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the target group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The weight. The range is 0 to 999.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ListenerRuleActionRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: str,
                 host: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[str] = None,
                 protocol: Optional[str] = None,
                 query: Optional[str] = None):
        """
        :param str status_code: The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
        :param str host: The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        :param str path: The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        :param str port: The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        :param str protocol: The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        :param str query: The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        pulumi.set(__self__, "status_code", status_code)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> str:
        """
        The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class ListenerRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostHeader":
            suggest = "host_header"
        elif key == "httpHeader":
            suggest = "http_header"
        elif key == "httpRequestMethod":
            suggest = "http_request_method"
        elif key == "pathPattern":
            suggest = "path_pattern"
        elif key == "queryStrings":
            suggest = "query_strings"
        elif key == "sourceIp":
            suggest = "source_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_header: Optional['outputs.ListenerRuleConditionHostHeader'] = None,
                 http_header: Optional['outputs.ListenerRuleConditionHttpHeader'] = None,
                 http_request_method: Optional['outputs.ListenerRuleConditionHttpRequestMethod'] = None,
                 path_pattern: Optional['outputs.ListenerRuleConditionPathPattern'] = None,
                 query_strings: Optional[Sequence['outputs.ListenerRuleConditionQueryString']] = None,
                 source_ip: Optional['outputs.ListenerRuleConditionSourceIp'] = None):
        """
        :param 'ListenerRuleConditionHostHeaderArgs' host_header: Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
        :param 'ListenerRuleConditionHttpHeaderArgs' http_header: HTTP headers to match. HTTP Header block fields documented below.
        :param 'ListenerRuleConditionHttpRequestMethodArgs' http_request_method: Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
        :param 'ListenerRuleConditionPathPatternArgs' path_pattern: Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
        :param Sequence['ListenerRuleConditionQueryStringArgs'] query_strings: Query strings to match. Query String block fields documented below.
        :param 'ListenerRuleConditionSourceIpArgs' source_ip: Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.
               
               > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
        """
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if http_header is not None:
            pulumi.set(__self__, "http_header", http_header)
        if http_request_method is not None:
            pulumi.set(__self__, "http_request_method", http_request_method)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional['outputs.ListenerRuleConditionHostHeader']:
        """
        Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> Optional['outputs.ListenerRuleConditionHttpHeader']:
        """
        HTTP headers to match. HTTP Header block fields documented below.
        """
        return pulumi.get(self, "http_header")

    @property
    @pulumi.getter(name="httpRequestMethod")
    def http_request_method(self) -> Optional['outputs.ListenerRuleConditionHttpRequestMethod']:
        """
        Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
        """
        return pulumi.get(self, "http_request_method")

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional['outputs.ListenerRuleConditionPathPattern']:
        """
        Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
        """
        return pulumi.get(self, "path_pattern")

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[Sequence['outputs.ListenerRuleConditionQueryString']]:
        """
        Query strings to match. Query String block fields documented below.
        """
        return pulumi.get(self, "query_strings")

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional['outputs.ListenerRuleConditionSourceIp']:
        """
        Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.

        > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
        """
        return pulumi.get(self, "source_ip")


@pulumi.output_type
class ListenerRuleConditionHostHeader(dict):
    def __init__(__self__, *,
                 values: Sequence[str]):
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class ListenerRuleConditionHttpHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaderName":
            suggest = "http_header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleConditionHttpHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleConditionHttpHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleConditionHttpHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_header_name: str,
                 values: Sequence[str]):
        """
        :param str http_header_name: Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
        :param Sequence[str] values: List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
        """
        pulumi.set(__self__, "http_header_name", http_header_name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="httpHeaderName")
    def http_header_name(self) -> str:
        """
        Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
        """
        return pulumi.get(self, "http_header_name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ListenerRuleConditionHttpRequestMethod(dict):
    def __init__(__self__, *,
                 values: Sequence[str]):
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class ListenerRuleConditionPathPattern(dict):
    def __init__(__self__, *,
                 values: Sequence[str]):
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class ListenerRuleConditionQueryString(dict):
    def __init__(__self__, *,
                 value: str,
                 key: Optional[str] = None):
        """
        :param str value: Query string value pattern to match.
        :param str key: Query string key pattern to match.
        """
        pulumi.set(__self__, "value", value)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Query string value pattern to match.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Query string key pattern to match.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class ListenerRuleConditionSourceIp(dict):
    def __init__(__self__, *,
                 values: Sequence[str]):
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class LoadBalancerAccessLogs(dict):
    def __init__(__self__, *,
                 bucket: str,
                 enabled: Optional[bool] = None,
                 prefix: Optional[str] = None):
        """
        :param str bucket: S3 bucket name to store the logs in.
        :param bool enabled: Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
        :param str prefix: S3 bucket prefix. Logs are stored in the root if not configured.
        """
        pulumi.set(__self__, "bucket", bucket)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        S3 bucket name to store the logs in.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        S3 bucket prefix. Logs are stored in the root if not configured.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class LoadBalancerConnectionLogs(dict):
    def __init__(__self__, *,
                 bucket: str,
                 enabled: Optional[bool] = None,
                 prefix: Optional[str] = None):
        """
        :param str bucket: S3 bucket name to store the logs in.
        :param bool enabled: Boolean to enable / disable `connection_logs`. Defaults to `false`, even when `bucket` is specified.
        :param str prefix: S3 bucket prefix. Logs are stored in the root if not configured.
        """
        pulumi.set(__self__, "bucket", bucket)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        S3 bucket name to store the logs in.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Boolean to enable / disable `connection_logs`. Defaults to `false`, even when `bucket` is specified.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        S3 bucket prefix. Logs are stored in the root if not configured.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class LoadBalancerSubnetMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "allocationId":
            suggest = "allocation_id"
        elif key == "ipv6Address":
            suggest = "ipv6_address"
        elif key == "outpostId":
            suggest = "outpost_id"
        elif key == "privateIpv4Address":
            suggest = "private_ipv4_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerSubnetMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerSubnetMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerSubnetMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: str,
                 allocation_id: Optional[str] = None,
                 ipv6_address: Optional[str] = None,
                 outpost_id: Optional[str] = None,
                 private_ipv4_address: Optional[str] = None):
        """
        :param str subnet_id: ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
        :param str allocation_id: Allocation ID of the Elastic IP address for an internet-facing load balancer.
        :param str ipv6_address: IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
        :param str private_ipv4_address: Private IPv4 address for an internal load balancer.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if outpost_id is not None:
            pulumi.set(__self__, "outpost_id", outpost_id)
        if private_ipv4_address is not None:
            pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[str]:
        """
        Allocation ID of the Elastic IP address for an internet-facing load balancer.
        """
        return pulumi.get(self, "allocation_id")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[str]:
        """
        IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="outpostId")
    def outpost_id(self) -> Optional[str]:
        return pulumi.get(self, "outpost_id")

    @property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> Optional[str]:
        """
        Private IPv4 address for an internal load balancer.
        """
        return pulumi.get(self, "private_ipv4_address")


@pulumi.output_type
class TargetGroupHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 healthy_threshold: Optional[int] = None,
                 interval: Optional[int] = None,
                 matcher: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[str] = None,
                 protocol: Optional[str] = None,
                 timeout: Optional[int] = None,
                 unhealthy_threshold: Optional[int] = None):
        """
        :param bool enabled: Whether health checks are enabled. Defaults to `true`.
        :param int healthy_threshold: Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
        :param int interval: Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
        :param str matcher: The HTTP or gRPC codes to use when checking for a successful response from a target.
               The `health_check.protocol` must be one of `HTTP` or `HTTPS` or the `target_type` must be `lambda`.
               Values can be comma-separated individual values (e.g., "200,202") or a range of values (e.g., "200-299").
               * For gRPC-based target groups (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is `GRPC`), values can be between `0` and `99`. The default is `12`.
               * When used with an Application Load Balancer (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is not `GRPC`), values can be between `200` and `499`. The default is `200`.
               * When used with a Network Load Balancer (i.e., the `protocol` is one of `TCP`, `TCP_UDP`, `UDP`, or `TLS`), values can be between `200` and `599`. The default is `200-399`.
               * When the `target_type` is `lambda`, values can be between `200` and `499`. The default is `200`.
        :param str path: Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
               * For HTTP and HTTPS health checks, the default is `/`.
               * For gRPC health checks, the default is `/AWS.ALB/healthcheck`.
        :param str port: The port the load balancer uses when performing health checks on targets.
               Valid values are either `traffic-port`, to use the same port as the target group, or a valid port number between `1` and `65536`.
               Default is `traffic-port`.
        :param str protocol: Protocol the load balancer uses when performing health checks on targets.
               Must be one of `TCP`, `HTTP`, or `HTTPS`.
               The `TCP` protocol is not supported for health checks if the protocol of the target group is `HTTP` or `HTTPS`.
               Default is `HTTP`.
               Cannot be specified when the `target_type` is `lambda`.
        :param int timeout: Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
        :param int unhealthy_threshold: Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether health checks are enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[int]:
        """
        Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def matcher(self) -> Optional[str]:
        """
        The HTTP or gRPC codes to use when checking for a successful response from a target.
        The `health_check.protocol` must be one of `HTTP` or `HTTPS` or the `target_type` must be `lambda`.
        Values can be comma-separated individual values (e.g., "200,202") or a range of values (e.g., "200-299").
        * For gRPC-based target groups (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is `GRPC`), values can be between `0` and `99`. The default is `12`.
        * When used with an Application Load Balancer (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is not `GRPC`), values can be between `200` and `499`. The default is `200`.
        * When used with a Network Load Balancer (i.e., the `protocol` is one of `TCP`, `TCP_UDP`, `UDP`, or `TLS`), values can be between `200` and `599`. The default is `200-399`.
        * When the `target_type` is `lambda`, values can be between `200` and `499`. The default is `200`.
        """
        return pulumi.get(self, "matcher")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
        * For HTTP and HTTPS health checks, the default is `/`.
        * For gRPC health checks, the default is `/AWS.ALB/healthcheck`.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The port the load balancer uses when performing health checks on targets.
        Valid values are either `traffic-port`, to use the same port as the target group, or a valid port number between `1` and `65536`.
        Default is `traffic-port`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol the load balancer uses when performing health checks on targets.
        Must be one of `TCP`, `HTTP`, or `HTTPS`.
        The `TCP` protocol is not supported for health checks if the protocol of the target group is `HTTP` or `HTTPS`.
        Default is `HTTP`.
        Cannot be specified when the `target_type` is `lambda`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[int]:
        """
        Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class TargetGroupStickiness(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieDuration":
            suggest = "cookie_duration"
        elif key == "cookieName":
            suggest = "cookie_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupStickiness. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupStickiness.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupStickiness.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 cookie_duration: Optional[int] = None,
                 cookie_name: Optional[str] = None,
                 enabled: Optional[bool] = None):
        """
        :param str type: The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
        :param int cookie_duration: Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
        :param str cookie_name: Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
        :param bool enabled: Boolean to enable / disable `stickiness`. Default is `true`.
        """
        pulumi.set(__self__, "type", type)
        if cookie_duration is not None:
            pulumi.set(__self__, "cookie_duration", cookie_duration)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="cookieDuration")
    def cookie_duration(self) -> Optional[int]:
        """
        Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
        """
        return pulumi.get(self, "cookie_duration")

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[str]:
        """
        Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
        """
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Boolean to enable / disable `stickiness`. Default is `true`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class TargetGroupTargetFailover(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDeregistration":
            suggest = "on_deregistration"
        elif key == "onUnhealthy":
            suggest = "on_unhealthy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupTargetFailover. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupTargetFailover.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupTargetFailover.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_deregistration: str,
                 on_unhealthy: str):
        """
        :param str on_deregistration: Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
        :param str on_unhealthy: Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
        """
        pulumi.set(__self__, "on_deregistration", on_deregistration)
        pulumi.set(__self__, "on_unhealthy", on_unhealthy)

    @property
    @pulumi.getter(name="onDeregistration")
    def on_deregistration(self) -> str:
        """
        Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
        """
        return pulumi.get(self, "on_deregistration")

    @property
    @pulumi.getter(name="onUnhealthy")
    def on_unhealthy(self) -> str:
        """
        Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
        """
        return pulumi.get(self, "on_unhealthy")


@pulumi.output_type
class TargetGroupTargetGroupHealth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsFailover":
            suggest = "dns_failover"
        elif key == "unhealthyStateRouting":
            suggest = "unhealthy_state_routing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupTargetGroupHealth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupTargetGroupHealth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupTargetGroupHealth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_failover: Optional['outputs.TargetGroupTargetGroupHealthDnsFailover'] = None,
                 unhealthy_state_routing: Optional['outputs.TargetGroupTargetGroupHealthUnhealthyStateRouting'] = None):
        """
        :param 'TargetGroupTargetGroupHealthDnsFailoverArgs' dns_failover: Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
        :param 'TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs' unhealthy_state_routing: Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
        """
        if dns_failover is not None:
            pulumi.set(__self__, "dns_failover", dns_failover)
        if unhealthy_state_routing is not None:
            pulumi.set(__self__, "unhealthy_state_routing", unhealthy_state_routing)

    @property
    @pulumi.getter(name="dnsFailover")
    def dns_failover(self) -> Optional['outputs.TargetGroupTargetGroupHealthDnsFailover']:
        """
        Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
        """
        return pulumi.get(self, "dns_failover")

    @property
    @pulumi.getter(name="unhealthyStateRouting")
    def unhealthy_state_routing(self) -> Optional['outputs.TargetGroupTargetGroupHealthUnhealthyStateRouting']:
        """
        Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
        """
        return pulumi.get(self, "unhealthy_state_routing")


@pulumi.output_type
class TargetGroupTargetGroupHealthDnsFailover(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minimumHealthyTargetsCount":
            suggest = "minimum_healthy_targets_count"
        elif key == "minimumHealthyTargetsPercentage":
            suggest = "minimum_healthy_targets_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupTargetGroupHealthDnsFailover. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupTargetGroupHealthDnsFailover.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupTargetGroupHealthDnsFailover.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minimum_healthy_targets_count: Optional[str] = None,
                 minimum_healthy_targets_percentage: Optional[str] = None):
        """
        :param str minimum_healthy_targets_count: The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to the maximum number of targets. The default is `off`.
        :param str minimum_healthy_targets_percentage: The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        if minimum_healthy_targets_count is not None:
            pulumi.set(__self__, "minimum_healthy_targets_count", minimum_healthy_targets_count)
        if minimum_healthy_targets_percentage is not None:
            pulumi.set(__self__, "minimum_healthy_targets_percentage", minimum_healthy_targets_percentage)

    @property
    @pulumi.getter(name="minimumHealthyTargetsCount")
    def minimum_healthy_targets_count(self) -> Optional[str]:
        """
        The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to the maximum number of targets. The default is `off`.
        """
        return pulumi.get(self, "minimum_healthy_targets_count")

    @property
    @pulumi.getter(name="minimumHealthyTargetsPercentage")
    def minimum_healthy_targets_percentage(self) -> Optional[str]:
        """
        The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        return pulumi.get(self, "minimum_healthy_targets_percentage")


@pulumi.output_type
class TargetGroupTargetGroupHealthUnhealthyStateRouting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minimumHealthyTargetsCount":
            suggest = "minimum_healthy_targets_count"
        elif key == "minimumHealthyTargetsPercentage":
            suggest = "minimum_healthy_targets_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupTargetGroupHealthUnhealthyStateRouting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupTargetGroupHealthUnhealthyStateRouting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupTargetGroupHealthUnhealthyStateRouting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minimum_healthy_targets_count: Optional[int] = None,
                 minimum_healthy_targets_percentage: Optional[str] = None):
        """
        :param int minimum_healthy_targets_count: The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `1` to the maximum number of targets. The default is `1`.
        :param str minimum_healthy_targets_percentage: The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        if minimum_healthy_targets_count is not None:
            pulumi.set(__self__, "minimum_healthy_targets_count", minimum_healthy_targets_count)
        if minimum_healthy_targets_percentage is not None:
            pulumi.set(__self__, "minimum_healthy_targets_percentage", minimum_healthy_targets_percentage)

    @property
    @pulumi.getter(name="minimumHealthyTargetsCount")
    def minimum_healthy_targets_count(self) -> Optional[int]:
        """
        The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `1` to the maximum number of targets. The default is `1`.
        """
        return pulumi.get(self, "minimum_healthy_targets_count")

    @property
    @pulumi.getter(name="minimumHealthyTargetsPercentage")
    def minimum_healthy_targets_percentage(self) -> Optional[str]:
        """
        The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        return pulumi.get(self, "minimum_healthy_targets_percentage")


@pulumi.output_type
class TargetGroupTargetHealthState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableUnhealthyConnectionTermination":
            suggest = "enable_unhealthy_connection_termination"
        elif key == "unhealthyDrainingInterval":
            suggest = "unhealthy_draining_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupTargetHealthState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupTargetHealthState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupTargetHealthState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_unhealthy_connection_termination: bool,
                 unhealthy_draining_interval: Optional[int] = None):
        """
        :param bool enable_unhealthy_connection_termination: Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
        :param int unhealthy_draining_interval: Indicates the time to wait for in-flight requests to complete when a target becomes unhealthy. The range is `0-360000`. This value has to be set only if `enable_unhealthy_connection_termination` is set to false. Default: `0`.
        """
        pulumi.set(__self__, "enable_unhealthy_connection_termination", enable_unhealthy_connection_termination)
        if unhealthy_draining_interval is not None:
            pulumi.set(__self__, "unhealthy_draining_interval", unhealthy_draining_interval)

    @property
    @pulumi.getter(name="enableUnhealthyConnectionTermination")
    def enable_unhealthy_connection_termination(self) -> bool:
        """
        Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
        """
        return pulumi.get(self, "enable_unhealthy_connection_termination")

    @property
    @pulumi.getter(name="unhealthyDrainingInterval")
    def unhealthy_draining_interval(self) -> Optional[int]:
        """
        Indicates the time to wait for in-flight requests to complete when a target becomes unhealthy. The range is `0-360000`. This value has to be set only if `enable_unhealthy_connection_termination` is set to false. Default: `0`.
        """
        return pulumi.get(self, "unhealthy_draining_interval")


@pulumi.output_type
class GetListenerDefaultActionResult(dict):
    def __init__(__self__, *,
                 authenticate_cognitos: Sequence['outputs.GetListenerDefaultActionAuthenticateCognitoResult'],
                 authenticate_oidcs: Sequence['outputs.GetListenerDefaultActionAuthenticateOidcResult'],
                 fixed_responses: Sequence['outputs.GetListenerDefaultActionFixedResponseResult'],
                 forwards: Sequence['outputs.GetListenerDefaultActionForwardResult'],
                 order: int,
                 redirects: Sequence['outputs.GetListenerDefaultActionRedirectResult'],
                 target_group_arn: str,
                 type: str):
        pulumi.set(__self__, "authenticate_cognitos", authenticate_cognitos)
        pulumi.set(__self__, "authenticate_oidcs", authenticate_oidcs)
        pulumi.set(__self__, "fixed_responses", fixed_responses)
        pulumi.set(__self__, "forwards", forwards)
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "redirects", redirects)
        pulumi.set(__self__, "target_group_arn", target_group_arn)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="authenticateCognitos")
    def authenticate_cognitos(self) -> Sequence['outputs.GetListenerDefaultActionAuthenticateCognitoResult']:
        return pulumi.get(self, "authenticate_cognitos")

    @property
    @pulumi.getter(name="authenticateOidcs")
    def authenticate_oidcs(self) -> Sequence['outputs.GetListenerDefaultActionAuthenticateOidcResult']:
        return pulumi.get(self, "authenticate_oidcs")

    @property
    @pulumi.getter(name="fixedResponses")
    def fixed_responses(self) -> Sequence['outputs.GetListenerDefaultActionFixedResponseResult']:
        return pulumi.get(self, "fixed_responses")

    @property
    @pulumi.getter
    def forwards(self) -> Sequence['outputs.GetListenerDefaultActionForwardResult']:
        return pulumi.get(self, "forwards")

    @property
    @pulumi.getter
    def order(self) -> int:
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def redirects(self) -> Sequence['outputs.GetListenerDefaultActionRedirectResult']:
        return pulumi.get(self, "redirects")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> str:
        return pulumi.get(self, "target_group_arn")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetListenerDefaultActionAuthenticateCognitoResult(dict):
    def __init__(__self__, *,
                 authentication_request_extra_params: Mapping[str, str],
                 on_unauthenticated_request: str,
                 scope: str,
                 session_cookie_name: str,
                 session_timeout: int,
                 user_pool_arn: str,
                 user_pool_client_id: str,
                 user_pool_domain: str):
        pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        pulumi.set(__self__, "session_timeout", session_timeout)
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Mapping[str, str]:
        return pulumi.get(self, "authentication_request_extra_params")

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> str:
        return pulumi.get(self, "on_unauthenticated_request")

    @property
    @pulumi.getter
    def scope(self) -> str:
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> str:
        return pulumi.get(self, "session_cookie_name")

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> int:
        return pulumi.get(self, "session_timeout")

    @property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> str:
        return pulumi.get(self, "user_pool_arn")

    @property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> str:
        return pulumi.get(self, "user_pool_client_id")

    @property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> str:
        return pulumi.get(self, "user_pool_domain")


@pulumi.output_type
class GetListenerDefaultActionAuthenticateOidcResult(dict):
    def __init__(__self__, *,
                 authentication_request_extra_params: Mapping[str, str],
                 authorization_endpoint: str,
                 client_id: str,
                 client_secret: str,
                 issuer: str,
                 on_unauthenticated_request: str,
                 scope: str,
                 session_cookie_name: str,
                 session_timeout: int,
                 token_endpoint: str,
                 user_info_endpoint: str):
        pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        pulumi.set(__self__, "session_timeout", session_timeout)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Mapping[str, str]:
        return pulumi.get(self, "authentication_request_extra_params")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> str:
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> str:
        return pulumi.get(self, "on_unauthenticated_request")

    @property
    @pulumi.getter
    def scope(self) -> str:
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> str:
        return pulumi.get(self, "session_cookie_name")

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> int:
        return pulumi.get(self, "session_timeout")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> str:
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> str:
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class GetListenerDefaultActionFixedResponseResult(dict):
    def __init__(__self__, *,
                 content_type: str,
                 message_body: str,
                 status_code: str):
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "message_body", message_body)
        pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> str:
        return pulumi.get(self, "message_body")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> str:
        return pulumi.get(self, "status_code")


@pulumi.output_type
class GetListenerDefaultActionForwardResult(dict):
    def __init__(__self__, *,
                 stickinesses: Sequence['outputs.GetListenerDefaultActionForwardStickinessResult'],
                 target_groups: Sequence['outputs.GetListenerDefaultActionForwardTargetGroupResult']):
        pulumi.set(__self__, "stickinesses", stickinesses)
        pulumi.set(__self__, "target_groups", target_groups)

    @property
    @pulumi.getter
    def stickinesses(self) -> Sequence['outputs.GetListenerDefaultActionForwardStickinessResult']:
        return pulumi.get(self, "stickinesses")

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Sequence['outputs.GetListenerDefaultActionForwardTargetGroupResult']:
        return pulumi.get(self, "target_groups")


@pulumi.output_type
class GetListenerDefaultActionForwardStickinessResult(dict):
    def __init__(__self__, *,
                 duration: int,
                 enabled: bool):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetListenerDefaultActionForwardTargetGroupResult(dict):
    def __init__(__self__, *,
                 arn: str,
                 weight: int):
        """
        :param str arn: ARN of the listener. Required if `load_balancer_arn` and `port` is not set.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the listener. Required if `load_balancer_arn` and `port` is not set.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def weight(self) -> int:
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetListenerDefaultActionRedirectResult(dict):
    def __init__(__self__, *,
                 host: str,
                 path: str,
                 port: str,
                 protocol: str,
                 query: str,
                 status_code: str):
        """
        :param str port: Port of the listener. Required if `arn` is not set.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        Port of the listener. Required if `arn` is not set.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def query(self) -> str:
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> str:
        return pulumi.get(self, "status_code")


@pulumi.output_type
class GetListenerMutualAuthenticationResult(dict):
    def __init__(__self__, *,
                 ignore_client_certificate_expiry: bool,
                 mode: str,
                 trust_store_arn: str):
        pulumi.set(__self__, "ignore_client_certificate_expiry", ignore_client_certificate_expiry)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "trust_store_arn", trust_store_arn)

    @property
    @pulumi.getter(name="ignoreClientCertificateExpiry")
    def ignore_client_certificate_expiry(self) -> bool:
        return pulumi.get(self, "ignore_client_certificate_expiry")

    @property
    @pulumi.getter
    def mode(self) -> str:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> str:
        return pulumi.get(self, "trust_store_arn")


@pulumi.output_type
class GetListenerRuleActionResult(dict):
    def __init__(__self__, *,
                 order: float,
                 type: str,
                 authenticate_cognito: Optional['outputs.GetListenerRuleActionAuthenticateCognitoResult'] = None,
                 authenticate_oidc: Optional['outputs.GetListenerRuleActionAuthenticateOidcResult'] = None,
                 fixed_response: Optional['outputs.GetListenerRuleActionFixedResponseResult'] = None,
                 forward: Optional['outputs.GetListenerRuleActionForwardResult'] = None,
                 redirect: Optional['outputs.GetListenerRuleActionRedirectResult'] = None):
        """
        :param float order: The evaluation order of the action.
        :param str type: The type of the action, indicates which sub-block will be populated.
        :param 'GetListenerRuleActionAuthenticateCognitoArgs' authenticate_cognito: An action to authenticate using Amazon Cognito.
               Detailed below.
        :param 'GetListenerRuleActionAuthenticateOidcArgs' authenticate_oidc: An action to authenticate using OIDC.
               Detailed below.
        :param 'GetListenerRuleActionFixedResponseArgs' fixed_response: An action to return a fixed response.
               Detailed below.
        :param 'GetListenerRuleActionForwardArgs' forward: An action to forward the request.
               Detailed below.
        :param 'GetListenerRuleActionRedirectArgs' redirect: An action to redirect the request.
               Detailed below.
        """
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "type", type)
        if authenticate_cognito is not None:
            pulumi.set(__self__, "authenticate_cognito", authenticate_cognito)
        if authenticate_oidc is not None:
            pulumi.set(__self__, "authenticate_oidc", authenticate_oidc)
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)

    @property
    @pulumi.getter
    def order(self) -> float:
        """
        The evaluation order of the action.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the action, indicates which sub-block will be populated.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="authenticateCognito")
    def authenticate_cognito(self) -> Optional['outputs.GetListenerRuleActionAuthenticateCognitoResult']:
        """
        An action to authenticate using Amazon Cognito.
        Detailed below.
        """
        return pulumi.get(self, "authenticate_cognito")

    @property
    @pulumi.getter(name="authenticateOidc")
    def authenticate_oidc(self) -> Optional['outputs.GetListenerRuleActionAuthenticateOidcResult']:
        """
        An action to authenticate using OIDC.
        Detailed below.
        """
        return pulumi.get(self, "authenticate_oidc")

    @property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional['outputs.GetListenerRuleActionFixedResponseResult']:
        """
        An action to return a fixed response.
        Detailed below.
        """
        return pulumi.get(self, "fixed_response")

    @property
    @pulumi.getter
    def forward(self) -> Optional['outputs.GetListenerRuleActionForwardResult']:
        """
        An action to forward the request.
        Detailed below.
        """
        return pulumi.get(self, "forward")

    @property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.GetListenerRuleActionRedirectResult']:
        """
        An action to redirect the request.
        Detailed below.
        """
        return pulumi.get(self, "redirect")


@pulumi.output_type
class GetListenerRuleActionAuthenticateCognitoResult(dict):
    def __init__(__self__, *,
                 authentication_request_extra_params: Mapping[str, str],
                 on_unauthenticated_request: str,
                 scope: str,
                 session_cookie_name: str,
                 session_timeout: int,
                 user_pool_arn: str,
                 user_pool_client_id: str,
                 user_pool_domain: str):
        """
        :param Mapping[str, str] authentication_request_extra_params: Set of additional parameters for the request.
               Detailed below.
        :param str on_unauthenticated_request: Behavior when the client is not authenticated.
        :param str scope: Set of user claims requested.
        :param str session_cookie_name: Name of the cookie used to maintain session information.
        :param int session_timeout: Maximum duration of the authentication session in seconds.
        :param str user_pool_arn: ARN of the Cognito user pool.
        :param str user_pool_client_id: ID of the Cognito user pool client.
        :param str user_pool_domain: Domain prefix or fully-qualified domain name of the Cognito user pool.
        """
        pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        pulumi.set(__self__, "session_timeout", session_timeout)
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Mapping[str, str]:
        """
        Set of additional parameters for the request.
        Detailed below.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> str:
        """
        Behavior when the client is not authenticated.
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Set of user claims requested.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> str:
        """
        Name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> int:
        """
        Maximum duration of the authentication session in seconds.
        """
        return pulumi.get(self, "session_timeout")

    @property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> str:
        """
        ARN of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_arn")

    @property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> str:
        """
        ID of the Cognito user pool client.
        """
        return pulumi.get(self, "user_pool_client_id")

    @property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> str:
        """
        Domain prefix or fully-qualified domain name of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_domain")


@pulumi.output_type
class GetListenerRuleActionAuthenticateOidcResult(dict):
    def __init__(__self__, *,
                 authentication_request_extra_params: Mapping[str, str],
                 authorization_endpoint: str,
                 client_id: str,
                 issuer: str,
                 on_unauthenticated_request: str,
                 scope: str,
                 session_cookie_name: str,
                 session_timeout: int,
                 token_endpoint: str,
                 user_info_endpoint: str):
        """
        :param Mapping[str, str] authentication_request_extra_params: Set of additional parameters for the request.
               Detailed below.
        :param str authorization_endpoint: The authorization endpoint of the IdP.
        :param str client_id: OAuth 2.0 client identifier.
        :param str issuer: OIDC issuer identifier of the IdP.
        :param str on_unauthenticated_request: Behavior when the client is not authenticated.
        :param str scope: Set of user claims requested.
        :param str session_cookie_name: Name of the cookie used to maintain session information.
        :param int session_timeout: Maximum duration of the authentication session in seconds.
        :param str token_endpoint: The token endpoint of the IdP.
        :param str user_info_endpoint: The user info endpoint of the IdP.
        """
        pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        pulumi.set(__self__, "session_timeout", session_timeout)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Mapping[str, str]:
        """
        Set of additional parameters for the request.
        Detailed below.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> str:
        """
        The authorization endpoint of the IdP.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        OAuth 2.0 client identifier.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        OIDC issuer identifier of the IdP.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> str:
        """
        Behavior when the client is not authenticated.
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Set of user claims requested.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> str:
        """
        Name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> int:
        """
        Maximum duration of the authentication session in seconds.
        """
        return pulumi.get(self, "session_timeout")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> str:
        """
        The token endpoint of the IdP.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> str:
        """
        The user info endpoint of the IdP.
        """
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class GetListenerRuleActionFixedResponseResult(dict):
    def __init__(__self__, *,
                 content_type: str,
                 message_body: str,
                 status_code: str):
        """
        :param str content_type: Content type of the response.
        :param str message_body: Message body of the response.
        :param str status_code: The HTTP redirect code.
        """
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "message_body", message_body)
        pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Content type of the response.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> str:
        """
        Message body of the response.
        """
        return pulumi.get(self, "message_body")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> str:
        """
        The HTTP redirect code.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class GetListenerRuleActionForwardResult(dict):
    def __init__(__self__, *,
                 stickiness: Optional['outputs.GetListenerRuleActionForwardStickinessResult'] = None,
                 target_groups: Optional[Sequence['outputs.GetListenerRuleActionForwardTargetGroupResult']] = None):
        """
        :param 'GetListenerRuleActionForwardStickinessArgs' stickiness: Target group stickiness for the rule.
               Detailed below.
        :param Sequence['GetListenerRuleActionForwardTargetGroupArgs'] target_groups: Set of target groups for the action.
               Detailed below.
        """
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)
        if target_groups is not None:
            pulumi.set(__self__, "target_groups", target_groups)

    @property
    @pulumi.getter
    def stickiness(self) -> Optional['outputs.GetListenerRuleActionForwardStickinessResult']:
        """
        Target group stickiness for the rule.
        Detailed below.
        """
        return pulumi.get(self, "stickiness")

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Optional[Sequence['outputs.GetListenerRuleActionForwardTargetGroupResult']]:
        """
        Set of target groups for the action.
        Detailed below.
        """
        return pulumi.get(self, "target_groups")


@pulumi.output_type
class GetListenerRuleActionForwardStickinessResult(dict):
    def __init__(__self__, *,
                 duration: float,
                 enabled: bool):
        """
        :param float duration: The time period, in seconds, during which requests from a client should be routed to the same target group.
        :param bool enabled: Indicates whether target group stickiness is enabled.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def duration(self) -> float:
        """
        The time period, in seconds, during which requests from a client should be routed to the same target group.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether target group stickiness is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetListenerRuleActionForwardTargetGroupResult(dict):
    def __init__(__self__, *,
                 arn: str,
                 weight: float):
        """
        :param str arn: ARN of the Listener Rule.
               Either `arn` or `listener_arn` must be set.
        :param float weight: Weight of the target group.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the Listener Rule.
        Either `arn` or `listener_arn` must be set.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def weight(self) -> float:
        """
        Weight of the target group.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetListenerRuleActionRedirectResult(dict):
    def __init__(__self__, *,
                 host: str,
                 path: str,
                 port: str,
                 protocol: str,
                 query: str,
                 status_code: str):
        """
        :param str host: The hostname.
        :param str path: The absolute path, starting with `/`.
        :param str port: The port.
        :param str protocol: The protocol.
        :param str query: The query parameters.
        :param str status_code: The HTTP redirect code.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The hostname.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The absolute path, starting with `/`.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        The port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        The query parameters.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> str:
        """
        The HTTP redirect code.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class GetListenerRuleConditionResult(dict):
    def __init__(__self__, *,
                 host_header: Optional['outputs.GetListenerRuleConditionHostHeaderResult'] = None,
                 http_header: Optional['outputs.GetListenerRuleConditionHttpHeaderResult'] = None,
                 http_request_method: Optional['outputs.GetListenerRuleConditionHttpRequestMethodResult'] = None,
                 path_pattern: Optional['outputs.GetListenerRuleConditionPathPatternResult'] = None,
                 query_string: Optional['outputs.GetListenerRuleConditionQueryStringResult'] = None,
                 source_ip: Optional['outputs.GetListenerRuleConditionSourceIpResult'] = None):
        """
        :param 'GetListenerRuleConditionHostHeaderArgs' host_header: Contains a single attribute `values`, which contains a set of host names.
        :param 'GetListenerRuleConditionHttpHeaderArgs' http_header: HTTP header and values to match.
               Detailed below.
        :param 'GetListenerRuleConditionHttpRequestMethodArgs' http_request_method: Contains a single attribute `values`, which contains a set of HTTP request methods.
        :param 'GetListenerRuleConditionPathPatternArgs' path_pattern: Contains a single attribute `values`, which contains a set of path patterns to compare against the request URL.
        :param 'GetListenerRuleConditionQueryStringArgs' query_string: Query string parameters to match.
               Detailed below.
        :param 'GetListenerRuleConditionSourceIpArgs' source_ip: Contains a single attribute `values`, which contains a set of source IPs in CIDR notation.
        """
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if http_header is not None:
            pulumi.set(__self__, "http_header", http_header)
        if http_request_method is not None:
            pulumi.set(__self__, "http_request_method", http_request_method)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional['outputs.GetListenerRuleConditionHostHeaderResult']:
        """
        Contains a single attribute `values`, which contains a set of host names.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> Optional['outputs.GetListenerRuleConditionHttpHeaderResult']:
        """
        HTTP header and values to match.
        Detailed below.
        """
        return pulumi.get(self, "http_header")

    @property
    @pulumi.getter(name="httpRequestMethod")
    def http_request_method(self) -> Optional['outputs.GetListenerRuleConditionHttpRequestMethodResult']:
        """
        Contains a single attribute `values`, which contains a set of HTTP request methods.
        """
        return pulumi.get(self, "http_request_method")

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional['outputs.GetListenerRuleConditionPathPatternResult']:
        """
        Contains a single attribute `values`, which contains a set of path patterns to compare against the request URL.
        """
        return pulumi.get(self, "path_pattern")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional['outputs.GetListenerRuleConditionQueryStringResult']:
        """
        Query string parameters to match.
        Detailed below.
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional['outputs.GetListenerRuleConditionSourceIpResult']:
        """
        Contains a single attribute `values`, which contains a set of source IPs in CIDR notation.
        """
        return pulumi.get(self, "source_ip")


@pulumi.output_type
class GetListenerRuleConditionHostHeaderResult(dict):
    def __init__(__self__, *,
                 values: Sequence[str]):
        """
        :param Sequence[str] values: Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetListenerRuleConditionHttpHeaderResult(dict):
    def __init__(__self__, *,
                 http_header_name: str,
                 values: Sequence[str]):
        """
        :param str http_header_name: Name of the HTTP header to match.
        :param Sequence[str] values: Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        pulumi.set(__self__, "http_header_name", http_header_name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="httpHeaderName")
    def http_header_name(self) -> str:
        """
        Name of the HTTP header to match.
        """
        return pulumi.get(self, "http_header_name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetListenerRuleConditionHttpRequestMethodResult(dict):
    def __init__(__self__, *,
                 values: Sequence[str]):
        """
        :param Sequence[str] values: Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetListenerRuleConditionPathPatternResult(dict):
    def __init__(__self__, *,
                 values: Sequence[str]):
        """
        :param Sequence[str] values: Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetListenerRuleConditionQueryStringResult(dict):
    def __init__(__self__, *,
                 values: Optional[Sequence['outputs.GetListenerRuleConditionQueryStringValueResult']] = None):
        """
        :param Sequence['GetListenerRuleConditionQueryStringValueArgs'] values: Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.GetListenerRuleConditionQueryStringValueResult']]:
        """
        Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetListenerRuleConditionQueryStringValueResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: Key of query parameter
        :param str value: Value of query parameter
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key of query parameter
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of query parameter
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetListenerRuleConditionSourceIpResult(dict):
    def __init__(__self__, *,
                 values: Sequence[str]):
        """
        :param Sequence[str] values: Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of `key`-`value` pairs indicating the query string parameters to match.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetLoadBalancerAccessLogsResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 enabled: bool,
                 prefix: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetLoadBalancerConnectionLogResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 enabled: bool,
                 prefix: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetLoadBalancerSubnetMappingResult(dict):
    def __init__(__self__, *,
                 allocation_id: str,
                 ipv6_address: str,
                 outpost_id: str,
                 private_ipv4_address: str,
                 subnet_id: str):
        pulumi.set(__self__, "allocation_id", allocation_id)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "outpost_id", outpost_id)
        pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> str:
        return pulumi.get(self, "allocation_id")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="outpostId")
    def outpost_id(self) -> str:
        return pulumi.get(self, "outpost_id")

    @property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> str:
        return pulumi.get(self, "private_ipv4_address")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetTargetGroupHealthCheckResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 healthy_threshold: int,
                 interval: int,
                 matcher: str,
                 path: str,
                 port: str,
                 protocol: str,
                 timeout: int,
                 unhealthy_threshold: int):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "matcher", matcher)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> int:
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter
    def interval(self) -> int:
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def matcher(self) -> str:
        return pulumi.get(self, "matcher")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> str:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> int:
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class GetTargetGroupStickinessResult(dict):
    def __init__(__self__, *,
                 cookie_duration: int,
                 cookie_name: str,
                 enabled: bool,
                 type: str):
        pulumi.set(__self__, "cookie_duration", cookie_duration)
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cookieDuration")
    def cookie_duration(self) -> int:
        return pulumi.get(self, "cookie_duration")

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> str:
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


