# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTrackerResult',
    'AwaitableGetTrackerResult',
    'get_tracker',
    'get_tracker_output',
]

@pulumi.output_type
class GetTrackerResult:
    """
    A collection of values returned by getTracker.
    """
    def __init__(__self__, create_time=None, description=None, id=None, kms_key_id=None, position_filtering=None, tags=None, tracker_arn=None, tracker_name=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if position_filtering and not isinstance(position_filtering, str):
            raise TypeError("Expected argument 'position_filtering' to be a str")
        pulumi.set(__self__, "position_filtering", position_filtering)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tracker_arn and not isinstance(tracker_arn, str):
            raise TypeError("Expected argument 'tracker_arn' to be a str")
        pulumi.set(__self__, "tracker_arn", tracker_arn)
        if tracker_name and not isinstance(tracker_name, str):
            raise TypeError("Expected argument 'tracker_name' to be a str")
        pulumi.set(__self__, "tracker_name", tracker_name)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Timestamp for when the tracker resource was created in ISO 8601 format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional description for the tracker resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        Key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="positionFiltering")
    def position_filtering(self) -> str:
        """
        Position filtering method of the tracker resource.
        """
        return pulumi.get(self, "position_filtering")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Key-value map of resource tags for the tracker.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trackerArn")
    def tracker_arn(self) -> str:
        """
        ARN for the tracker resource. Used when you need to specify a resource across all AWS.
        """
        return pulumi.get(self, "tracker_arn")

    @property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> str:
        return pulumi.get(self, "tracker_name")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Timestamp for when the tracker resource was last updated in ISO 8601 format.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetTrackerResult(GetTrackerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrackerResult(
            create_time=self.create_time,
            description=self.description,
            id=self.id,
            kms_key_id=self.kms_key_id,
            position_filtering=self.position_filtering,
            tags=self.tags,
            tracker_arn=self.tracker_arn,
            tracker_name=self.tracker_name,
            update_time=self.update_time)


def get_tracker(tags: Optional[Mapping[str, str]] = None,
                tracker_name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrackerResult:
    """
    Retrieve information about a Location Service Tracker.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.location.get_tracker(tracker_name="example")
    ```


    :param Mapping[str, str] tags: Key-value map of resource tags for the tracker.
    :param str tracker_name: Name of the tracker resource.
    """
    __args__ = dict()
    __args__['tags'] = tags
    __args__['trackerName'] = tracker_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:location/getTracker:getTracker', __args__, opts=opts, typ=GetTrackerResult).value

    return AwaitableGetTrackerResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        position_filtering=pulumi.get(__ret__, 'position_filtering'),
        tags=pulumi.get(__ret__, 'tags'),
        tracker_arn=pulumi.get(__ret__, 'tracker_arn'),
        tracker_name=pulumi.get(__ret__, 'tracker_name'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_tracker_output(tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                       tracker_name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTrackerResult]:
    """
    Retrieve information about a Location Service Tracker.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.location.get_tracker(tracker_name="example")
    ```


    :param Mapping[str, str] tags: Key-value map of resource tags for the tracker.
    :param str tracker_name: Name of the tracker resource.
    """
    __args__ = dict()
    __args__['tags'] = tags
    __args__['trackerName'] = tracker_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:location/getTracker:getTracker', __args__, opts=opts, typ=GetTrackerResult)
    return __ret__.apply(lambda __response__: GetTrackerResult(
        create_time=pulumi.get(__response__, 'create_time'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        position_filtering=pulumi.get(__response__, 'position_filtering'),
        tags=pulumi.get(__response__, 'tags'),
        tracker_arn=pulumi.get(__response__, 'tracker_arn'),
        tracker_name=pulumi.get(__response__, 'tracker_name'),
        update_time=pulumi.get(__response__, 'update_time')))
