# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTrackerAssociationsResult',
    'AwaitableGetTrackerAssociationsResult',
    'get_tracker_associations',
    'get_tracker_associations_output',
]

@pulumi.output_type
class GetTrackerAssociationsResult:
    """
    A collection of values returned by getTrackerAssociations.
    """
    def __init__(__self__, consumer_arns=None, id=None, tracker_name=None):
        if consumer_arns and not isinstance(consumer_arns, list):
            raise TypeError("Expected argument 'consumer_arns' to be a list")
        pulumi.set(__self__, "consumer_arns", consumer_arns)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tracker_name and not isinstance(tracker_name, str):
            raise TypeError("Expected argument 'tracker_name' to be a str")
        pulumi.set(__self__, "tracker_name", tracker_name)

    @property
    @pulumi.getter(name="consumerArns")
    def consumer_arns(self) -> Sequence[str]:
        """
        List of geofence collection ARNs associated to the tracker resource.
        """
        return pulumi.get(self, "consumer_arns")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> str:
        return pulumi.get(self, "tracker_name")


class AwaitableGetTrackerAssociationsResult(GetTrackerAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrackerAssociationsResult(
            consumer_arns=self.consumer_arns,
            id=self.id,
            tracker_name=self.tracker_name)


def get_tracker_associations(tracker_name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrackerAssociationsResult:
    """
    Retrieve information about Location Service Tracker Associations.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.location.get_tracker_associations(tracker_name="example")
    ```


    :param str tracker_name: Name of the tracker resource associated with a geofence collection.
    """
    __args__ = dict()
    __args__['trackerName'] = tracker_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:location/getTrackerAssociations:getTrackerAssociations', __args__, opts=opts, typ=GetTrackerAssociationsResult).value

    return AwaitableGetTrackerAssociationsResult(
        consumer_arns=pulumi.get(__ret__, 'consumer_arns'),
        id=pulumi.get(__ret__, 'id'),
        tracker_name=pulumi.get(__ret__, 'tracker_name'))
def get_tracker_associations_output(tracker_name: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTrackerAssociationsResult]:
    """
    Retrieve information about Location Service Tracker Associations.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.location.get_tracker_associations(tracker_name="example")
    ```


    :param str tracker_name: Name of the tracker resource associated with a geofence collection.
    """
    __args__ = dict()
    __args__['trackerName'] = tracker_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:location/getTrackerAssociations:getTrackerAssociations', __args__, opts=opts, typ=GetTrackerAssociationsResult)
    return __ret__.apply(lambda __response__: GetTrackerAssociationsResult(
        consumer_arns=pulumi.get(__response__, 'consumer_arns'),
        id=pulumi.get(__response__, 'id'),
        tracker_name=pulumi.get(__response__, 'tracker_name')))
